/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.time.bean.WorkTypeItemRegistAddonBeanInterface;
import jp.mosp.time.bean.WorkTypeItemRegistBeanInterface;
import jp.mosp.time.dao.settings.WorkTypeDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmWorkTypeItemDto;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeUtility;

public class WorkTypeItemRegistBean
extends PlatformBean
implements WorkTypeItemRegistBeanInterface {
    WorkTypeItemDaoInterface dao;
    WorkTypeDaoInterface workTypeDao;
    protected String[] codesWorkTypeItem = new String[]{"WorkStart", "WorkEnd", "WorkTime", "RestTime", "RestStart1", "RestEnd1", "RestStart2", "RestEnd2", "RestStart3", "RestEnd3", "RestStart4", "RestEnd4", "FrontStart", "FrontEnd", "BackStart", "BackEnd", "OverBefore", "OverPer", "OverRest", "HalfRest", "HalfRestStart", "HalfRestEnd", "DirectStart", "DirectEnd", "ExcludeNightRest", "Short1Start", "Short1End", "Short2Start", "Short2End", "AutoBefOverWork"};
    protected static final int LEN_WORK_TYPE_CODE = 10;
    protected List<WorkTypeItemRegistAddonBeanInterface> addonBeans;
    protected static final String CODE_KEY_ADDONS = "WorkTypeItemRegistAddons";

    public WorkTypeItemRegistBean() {
    }

    public WorkTypeItemRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkTypeItemDaoInterface)this.createDao(WorkTypeItemDaoInterface.class);
        this.workTypeDao = (WorkTypeDaoInterface)this.createDao(WorkTypeDaoInterface.class);
        this.addonBeans = this.getAddonBeans();
    }

    public WorkTypeItemDtoInterface getInitDto() {
        TmmWorkTypeItemDto dto = new TmmWorkTypeItemDto();
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            dto = addonBean.getInitDto((WorkTypeItemDtoInterface)dto);
        }
        return dto;
    }

    public void insert(WorkTypeItemDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.insert(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void insert(List<WorkTypeItemDtoInterface> dtoList) throws MospException {
        this.checkItemTimeValidate(dtoList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemDtoInterface dto : dtoList) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkInsert(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.insert(dtoList);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void add(List<WorkTypeItemDtoInterface> dtoList) throws MospException {
        this.checkItemTimeValidate(dtoList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemDtoInterface dto : dtoList) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkAdd(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.add(dtoList);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void update(WorkTypeItemDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (dto.getTmmWorkTypeItemId() == 0L) {
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        } else {
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.update(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void update(List<WorkTypeItemDtoInterface> dtoList) throws MospException {
        this.checkItemTimeValidate(dtoList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemDtoInterface dto : dtoList) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            if (dto.getTmmWorkTypeItemId() == 0L) {
                dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.update(dtoList);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            for (String workTypeItemCode : this.getCodesAdditionalWorkTypeItem()) {
                WorkTypeItemDtoInterface dto = this.dao.findForKey(code, activateDate, workTypeItemCode);
                if (dto == null) {
                    dto = this.dao.findForInfo(code, activateDate, workTypeItemCode);
                    if (dto == null) continue;
                    dto.setActivateDate(activateDate);
                    dto.setInactivateFlag(inactivateFlag);
                    this.validate(dto);
                    this.checkAdd(dto);
                    if (this.mospParams.hasErrorMessage()) continue;
                    dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
                    this.dao.insert((BaseDtoInterface)dto);
                    continue;
                }
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkUpdate(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
                dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
            }
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.update(idArray, activateDate, inactivateFlag);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void delete(String workTypeCode, Date activateDate) throws MospException {
        for (String workTypeItemCode : this.getCodesAdditionalWorkTypeItem()) {
            WorkTypeItemDtoInterface dto = this.dao.findForKey(workTypeCode, activateDate, workTypeItemCode);
            if (dto == null) continue;
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.delete(workTypeCode, activateDate);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public String[] getCodesWorkTypeItem() {
        return CapsuleUtility.getStringArrayClone((String[])this.codesWorkTypeItem);
    }

    public String[] getCodesAdditionalWorkTypeItem() {
        String[][] additionalWorktypeItemArray = this.mospParams.getProperties().getCodeArray("additionalWorkTypeItem", false);
        ArrayList<String> workTypeAdditionalItemList = new ArrayList<String>();
        for (String[] validateAryId : additionalWorktypeItemArray) {
            workTypeAdditionalItemList.add(validateAryId[1]);
        }
        ArrayList<String> workTypeItemList = new ArrayList<String>();
        workTypeItemList.addAll(Arrays.asList(this.codesWorkTypeItem));
        workTypeItemList.addAll(workTypeAdditionalItemList);
        return CapsuleUtility.getStringArrayClone((String[])workTypeItemList.toArray(new String[workTypeItemList.size()]));
    }

    protected void checkItemTimeValidate(List<WorkTypeItemDtoInterface> itemList) throws MospException {
        boolean isShort2Set;
        HashMap<String, Date> map = new HashMap<String, Date>();
        Date defaultTime = DateUtility.getDefaultTime();
        boolean isAutoBeforeOverwork = false;
        boolean isShort1TypePay = false;
        boolean isShort2TypePay = false;
        for (WorkTypeItemDtoInterface dto : itemList) {
            Date targetTime = dto.getWorkTypeItemValue();
            map.put(dto.getWorkTypeItemCode(), targetTime);
            if (dto.getWorkTypeItemCode().equals("AutoBefOverWork") && dto.getPreliminary().equals(String.valueOf(1))) {
                isAutoBeforeOverwork = true;
            }
            if (dto.getWorkTypeItemCode().equals("ExcludeNightRest") && dto.getPreliminary().isEmpty()) {
                dto.setPreliminary(String.valueOf(1));
            }
            if (dto.getWorkTypeItemCode().equals("Short1Start") && dto.getPreliminary().equals("0")) {
                isShort1TypePay = true;
            }
            if (dto.getWorkTypeItemCode().equals("Short2Start") && dto.getPreliminary().equals("0")) {
                isShort2TypePay = true;
            }
            if (targetTime.compareTo(defaultTime) == 0) continue;
            int time = DateUtility.getHour((Date)targetTime, (Date)defaultTime);
            int minute = DateUtility.getMinute((Date)targetTime);
            if (time > 47) {
                this.mospParams.addErrorMessage("PFW0129", new String[]{this.getWorkTypeItemName(dto.getWorkTypeItemCode()), "47"});
            }
            if (minute <= 59) continue;
            this.mospParams.addErrorMessage("PFW0129", new String[]{this.getWorkTypeItemName(dto.getWorkTypeItemCode()), "59"});
        }
        Date startTime = (Date)map.get("WorkStart");
        Date endTime = (Date)map.get("WorkEnd");
        if (startTime.compareTo(DateUtility.addDay((Date)defaultTime, (int)1)) >= 0) {
            String[] rep = new String[]{this.mospParams.getName("StartWork", new String[]{"Moment"}), 24 + this.mospParams.getName("Hour", new String[]{"From", "Ahead", "Of", "Time"})};
            this.mospParams.addErrorMessage("PFW0105", rep);
            return;
        }
        if (endTime.compareTo(startTime) < 0) {
            this.mospParams.addErrorMessage("TMW0236", new String[0]);
            return;
        }
        this.checkRestTimes(map);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date frontStart = (Date)map.get("FrontStart");
        Date frontEnd = (Date)map.get("FrontEnd");
        Date backStart = (Date)map.get("BackStart");
        Date backEnd = (Date)map.get("BackEnd");
        if (frontStart.compareTo(defaultTime) != 0 && backStart.compareTo(defaultTime) != 0) {
            if (DateUtility.isTermContain((Date)backStart, (Date)frontStart, (Date)frontEnd) && !DateUtility.isSame((Date)frontEnd, (Date)backStart)) {
                this.mospParams.addErrorMessage("TMW0238", new String[]{"\u5348\u5f8c\u4f11"});
                return;
            }
            if (DateUtility.isTermContain((Date)frontEnd, (Date)backStart, (Date)backEnd) && !DateUtility.isSame((Date)frontEnd, (Date)backStart)) {
                this.mospParams.addErrorMessage("TMW0238", new String[]{"\u5348\u5f8c\u4f11"});
                return;
            }
        }
        if (frontStart.compareTo(defaultTime) != 0) {
            if (frontEnd.compareTo(frontStart) < 0) {
                this.addInvalidOrderMessage("\u5348\u524d\u4f11\u958b\u59cb\u6642\u523b", "\u5348\u524d\u4f11\u7d42\u4e86\u6642\u523b");
                return;
            }
            if (frontStart.compareTo(startTime) < 0) {
                this.addInvalidOrderMessage("\u59cb\u696d\u6642\u523b", "\u5348\u524d\u4f11\u958b\u59cb\u6642\u523b");
                return;
            }
            if (endTime.compareTo(frontEnd) < 0) {
                this.addInvalidOrderMessage("\u5348\u524d\u4f11\u7d42\u4e86\u6642\u523b", "\u7d42\u696d\u6642\u523b");
                return;
            }
        }
        if (backStart.compareTo(defaultTime) != 0) {
            if (backEnd.compareTo(backStart) < 0) {
                this.addInvalidOrderMessage("\u5348\u5f8c\u4f11\u958b\u59cb\u6642\u523b", "\u5348\u5f8c\u4f11\u7d42\u4e86\u6642\u523b");
                return;
            }
            if (backEnd.compareTo(endTime) < 0) {
                this.addInvalidOrderMessage("\u5348\u5f8c\u4f11\u7d42\u4e86\u6642\u523b", "\u7d42\u696d\u6642\u523b");
                return;
            }
        }
        Date halfRestStart = (Date)map.get("HalfRestStart");
        Date halfRestEnd = (Date)map.get("HalfRestEnd");
        if (halfRestStart.compareTo(defaultTime) != 0 && halfRestEnd.compareTo(defaultTime) != 0 && halfRestEnd.compareTo(halfRestStart) < 0) {
            String[] rep = new String[]{"\u534a\u4f11\u53d6\u5f97\u6642\u4f11\u61a9\u958b\u59cb\u6642\u523b", "\u534a\u4f11\u53d6\u5f97\u6642\u4f11\u61a9\u7d42\u4e86\u6642\u523b"};
            this.mospParams.addErrorMessage("PFW0217", rep);
            return;
        }
        int overPerMinute = TimeUtility.getMinutes((Date)((Date)map.get("OverPer")));
        int overRestMinute = TimeUtility.getMinutes((Date)((Date)map.get("OverRest")));
        if (overPerMinute == 0 && overRestMinute > 0) {
            this.mospParams.addErrorMessage("TMW0310", new String[]{"\u4f11\u61a9\u6642\u9593", "\u6b8b\u696d\u4f11\u61a9"});
            return;
        }
        if (overPerMinute > 0 && overPerMinute <= overRestMinute) {
            this.mospParams.addErrorMessage("TMW0310", new String[]{"\u4f11\u61a9\u6642\u9593", "\u6b8b\u696d\u4f11\u61a9"});
            return;
        }
        Date short1StartTime = (Date)map.get("Short1Start");
        Date short1EndTime = (Date)map.get("Short1End");
        Date short2StartTime = (Date)map.get("Short2Start");
        Date short2EndTime = (Date)map.get("Short2End");
        boolean isShort1Set = short1StartTime != null && short1StartTime.compareTo(defaultTime) != 0 || short1EndTime != null && short1EndTime.compareTo(defaultTime) != 0;
        boolean bl = isShort2Set = short2StartTime != null && short2StartTime.compareTo(defaultTime) != 0 || short2EndTime != null && short2EndTime.compareTo(defaultTime) != 0;
        if (isShort1Set) {
            if (short1StartTime.compareTo(startTime) != 0) {
                TimeMessageUtility.addErrorShort1TimeBoundary((MospParams)this.mospParams);
            }
            if (short1EndTime.after(endTime)) {
                TimeMessageUtility.addErrorShort1OutOfWorkTime((MospParams)this.mospParams);
            }
            if (!short1EndTime.after(short1StartTime)) {
                TimeMessageUtility.addErrorShort1EndBeforeStart((MospParams)this.mospParams);
            }
        }
        if (isShort2Set) {
            if (short2EndTime.compareTo(endTime) != 0) {
                TimeMessageUtility.addErrorShort2TimeBoundary((MospParams)this.mospParams);
            }
            if (short2StartTime.before(startTime)) {
                TimeMessageUtility.addErrorShort2OutOfWorkTime((MospParams)this.mospParams);
            }
            if (!short2EndTime.after(short2StartTime)) {
                TimeMessageUtility.addErrorShort2EndBeforeStart((MospParams)this.mospParams);
            }
        }
        if (isShort1Set && isShort2Set && !isShort1TypePay && isShort2TypePay) {
            TimeMessageUtility.addErrorShortTypePair((MospParams)this.mospParams);
        }
        this.checkAutoBeforeOverWork(isAutoBeforeOverwork, isShort1TypePay, short1StartTime, short1EndTime);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkItemTimeValidate(itemList);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkRestTimes(Map<String, Date> map) throws MospException {
        Date startTime = map.get("WorkStart");
        Date endTime = map.get("WorkEnd");
        Date rest1Start = map.get("RestStart1");
        Date rest1End = map.get("RestEnd1");
        Date rest2Start = map.get("RestStart2");
        Date rest2End = map.get("RestEnd2");
        Date rest3Start = map.get("RestStart3");
        Date rest3End = map.get("RestEnd3");
        Date rest4Start = map.get("RestStart4");
        Date rest4End = map.get("RestEnd4");
        Date[] aryRestStart = new Date[]{rest1Start, rest2Start, rest3Start, rest4Start};
        Date[] aryRestEnd = new Date[]{rest1End, rest2End, rest3End, rest4End};
        Date defaultTime = DateUtility.getDefaultTime();
        Date restStartTime = startTime;
        Date restEndTime = startTime;
        for (int i = 0; i < aryRestStart.length; ++i) {
            if (aryRestStart[i].compareTo(defaultTime) == 0 && aryRestEnd[i].compareTo(defaultTime) == 0) continue;
            if (aryRestStart[i].compareTo(startTime) < 0) {
                this.addInvalidOrderMessage(this.mospParams.getName("StartWork", new String[]{"Moment"}), this.mospParams.getName("RestTime", new String[]{"Time"}) + (i + 1));
            }
            if (aryRestEnd[i].compareTo(endTime) > 0) {
                this.addInvalidOrderMessage(this.mospParams.getName("EndWork", new String[]{"Moment"}), this.mospParams.getName("RestTime", new String[]{"Time"}) + (i + 1));
            }
            if (aryRestStart[i].compareTo(aryRestEnd[i]) > 0) {
                String[] errMes = new String[]{this.mospParams.getName("RestTime", new String[]{"Time"}) + (i + 1), this.mospParams.getName("RestTime", new String[]{"Time"}) + (i + 1)};
                this.mospParams.addErrorMessage("TMW0280", errMes);
                return;
            }
            if (i != aryRestStart.length - 1 && aryRestStart[i + 1].compareTo(defaultTime) != 0 && aryRestEnd[i].compareTo(aryRestStart[i + 1]) > 0) {
                String currentEnd = this.mospParams.getName("RestTime", new String[]{"Time"}) + (i + 1) + this.mospParams.getName("End");
                String nextStart = this.mospParams.getName("RestTime", new String[]{"Time"}) + (i + 2) + this.mospParams.getName("Start");
                this.addInvalidOrderMessage(currentEnd, nextStart);
                return;
            }
            if (DateUtility.isTermContain((Date)aryRestStart[i], (Date)restStartTime, (Date)restEndTime)) {
                String errMes = this.mospParams.getName("RestTime", new String[]{"Time"}) + (i + 1);
                this.mospParams.addErrorMessage("TMW0238", new String[]{errMes});
                return;
            }
            restStartTime = aryRestStart[i];
            restEndTime = aryRestEnd[i];
        }
    }

    protected void checkAutoBeforeOverWork(boolean isAutoBeforeOverwork, boolean isShort1TypePay, Date short1Start, Date short1End) throws MospException {
        if (isAutoBeforeOverwork) {
            return;
        }
        if (short1Start.compareTo(DateUtility.getDefaultTime()) == 0 && short1End.compareTo(DateUtility.getDefaultTime()) == 0) {
            return;
        }
        if (isShort1TypePay) {
            return;
        }
        TimeMessageUtility.addErrorAnotherItemInvalid((MospParams)this.mospParams);
    }

    protected void checkInsert(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getWorkTypeCode(), dto.getWorkTypeItemCode()));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkInsert(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkAdd(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getWorkTypeCode(), dto.getActivateDate(), dto.getWorkTypeItemCode()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkTypeCode(), dto.getWorkTypeItemCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkAdd(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkUpdate(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmWorkTypeItemId(), true))) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkUpdate(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkDelete(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkTypeCode(), dto.getWorkTypeItemCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkDelete(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            WorkTypeDtoInterface dto = (WorkTypeDtoInterface)this.workTypeDao.findForKey(id, false);
            list.add(dto.getWorkTypeCode());
        }
        return list;
    }

    protected void validate(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkLength(dto.getWorkTypeCode(), 10, this.mospParams.getName("Work", new String[]{"Form", "Code"}), null);
        this.checkTypeCode(dto.getWorkTypeCode(), this.mospParams.getName("Work", new String[]{"Form", "Code"}), null);
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.validate(dto);
        }
    }

    protected String getWorkTypeItemName(String worktypeItemCode) {
        String name = "";
        if (worktypeItemCode.equals("WorkStart")) {
            return this.mospParams.getName("StartWork");
        }
        if (worktypeItemCode.equals("WorkEnd")) {
            return this.mospParams.getName("EndWork");
        }
        if (worktypeItemCode.equals("WorkTime")) {
            return this.mospParams.getName("Work", new String[]{"Time"});
        }
        if (worktypeItemCode.equals("RestTime")) {
            return this.mospParams.getName("RestTime", new String[]{"Time"});
        }
        if (worktypeItemCode.equals("RestStart1")) {
            return this.mospParams.getName("RestTime", new String[]{"No1"});
        }
        if (worktypeItemCode.equals("RestEnd1")) {
            return this.mospParams.getName("RestTime", new String[]{"No1"});
        }
        if (worktypeItemCode.equals("RestStart2")) {
            return this.mospParams.getName("RestTime", new String[]{"No2"});
        }
        if (worktypeItemCode.equals("RestEnd2")) {
            return this.mospParams.getName("RestTime", new String[]{"No2"});
        }
        if (worktypeItemCode.equals("RestStart3")) {
            return this.mospParams.getName("RestTime", new String[]{"No3"});
        }
        if (worktypeItemCode.equals("RestEnd3")) {
            return this.mospParams.getName("RestTime", new String[]{"No3"});
        }
        if (worktypeItemCode.equals("RestStart4")) {
            return this.mospParams.getName("RestTime", new String[]{"No4"});
        }
        if (worktypeItemCode.equals("RestEnd4")) {
            return this.mospParams.getName("RestTime", new String[]{"No4"});
        }
        if (worktypeItemCode.equals("FrontStart")) {
            return this.mospParams.getName("AmRest");
        }
        if (worktypeItemCode.equals("FrontEnd")) {
            return this.mospParams.getName("AmRest");
        }
        if (worktypeItemCode.equals("BackStart")) {
            return this.mospParams.getName("PmRest");
        }
        if (worktypeItemCode.equals("BackEnd")) {
            return this.mospParams.getName("PmRest");
        }
        if (worktypeItemCode.equals("OverBefore")) {
            return this.mospParams.getName("RestBeforeOvertimeWork");
        }
        if (worktypeItemCode.equals("OverPer")) {
            return this.mospParams.getName("RestInOvertime");
        }
        if (worktypeItemCode.equals("OverRest")) {
            return this.mospParams.getName("RestInOvertime");
        }
        if (worktypeItemCode.equals("HalfRest")) {
            return this.mospParams.getName("Work", new String[]{"Ahead", "OvertimeWork", "Performance", "Insert"});
        }
        if (worktypeItemCode.equals("HalfRestStart")) {
            return this.mospParams.getName("Work", new String[]{"Ahead", "OvertimeWork", "Performance", "Insert"});
        }
        if (worktypeItemCode.equals("HalfRestEnd")) {
            return this.mospParams.getName("Work", new String[]{"Ahead", "OvertimeWork", "Performance", "Insert"});
        }
        if (worktypeItemCode.equals("DirectStart")) {
            return this.mospParams.getName("DirectStart");
        }
        if (worktypeItemCode.equals("DirectEnd")) {
            return this.mospParams.getName("DirectEnd");
        }
        if (worktypeItemCode.equals("ExcludeNightRest")) {
            return this.mospParams.getName("ExcludeNightRest");
        }
        if (worktypeItemCode.equals("Short1Start")) {
            return this.mospParams.getName("ShortTime", new String[]{"Time", "No1"});
        }
        if (worktypeItemCode.equals("Short1End")) {
            return this.mospParams.getName("ShortTime", new String[]{"Time", "No1"});
        }
        if (worktypeItemCode.equals("Short2Start")) {
            return this.mospParams.getName("ShortTime", new String[]{"Time", "No2"});
        }
        if (worktypeItemCode.equals("Short2End")) {
            return this.mospParams.getName("ShortTime", new String[]{"Time", "No2"});
        }
        if (worktypeItemCode.equals("AutoBefOverWork")) {
            return this.mospParams.getName("Work", new String[]{"Ahead", "OvertimeWork", "Performance", "Insert"});
        }
        return name;
    }

    public Date getDefaultTime(String hour, String minute) throws MospException {
        Date defaultDate = DateUtility.getDefaultTime();
        return TimeUtility.getAttendanceTime((Date)defaultDate, (String)hour, (String)minute, (MospParams)this.mospParams);
    }

    protected List<WorkTypeItemRegistAddonBeanInterface> getAddonBeans() throws MospException {
        ArrayList<WorkTypeItemRegistAddonBeanInterface> addonBeans = new ArrayList<WorkTypeItemRegistAddonBeanInterface>();
        for (String[] addon : this.mospParams.getProperties().getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            WorkTypeItemRegistAddonBeanInterface bean = (WorkTypeItemRegistAddonBeanInterface)this.createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }
}

