/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestSearchBeanInterface;
import jp.mosp.time.dao.settings.WorkTypeChangeRequestDaoInterface;
import jp.mosp.time.dto.settings.RequestListDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestListDtoInterface;
import jp.mosp.time.dto.settings.impl.WorkTypeChangeRequestListDto;

public class WorkTypeChangeRequestSearchBean
extends TimeBean
implements WorkTypeChangeRequestSearchBeanInterface {
    protected WorkTypeChangeRequestDaoInterface dao;
    private WorkflowIntegrateBeanInterface workflowIntegrate;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;
    private String personalId;
    private String workflowStatus;
    private String workTypeCode;
    private Date requestStartDate;
    private Date requestEndDate;

    public WorkTypeChangeRequestSearchBean() {
    }

    public WorkTypeChangeRequestSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkTypeChangeRequestDaoInterface)this.createDao(WorkTypeChangeRequestDaoInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
    }

    public List<WorkTypeChangeRequestListDtoInterface> getSearchList() throws MospException {
        Map param = this.dao.getParamsMap();
        param.put("personalId", this.personalId);
        param.put("workflowStatus", this.workflowStatus);
        param.put("workTypeCode", this.workTypeCode);
        param.put("requestStartDate", this.requestStartDate);
        param.put("requestEndDate", this.requestEndDate);
        List requestList = this.dao.findForSearch(param);
        ArrayList<WorkTypeChangeRequestListDtoInterface> list = new ArrayList<WorkTypeChangeRequestListDtoInterface>();
        for (WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto : requestList) {
            WorkTypeChangeRequestListDto dto = new WorkTypeChangeRequestListDto();
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(workTypeChangeRequestDto.getWorkflow());
            if (workflowDto == null || !this.isStatus(workflowDto)) continue;
            dto.setTmdWorkTypeChangeRequestId(workTypeChangeRequestDto.getTmdWorkTypeChangeRequestId());
            dto.setRequestDate(workTypeChangeRequestDto.getRequestDate());
            dto.setWorkTypeCode(workTypeChangeRequestDto.getWorkTypeCode());
            dto.setRequestReason(workTypeChangeRequestDto.getRequestReason());
            dto.setWorkflow(workTypeChangeRequestDto.getWorkflow());
            this.approvalInfoReference.setWorkflowInfo((RequestListDtoInterface)dto, workflowDto);
            list.add((WorkTypeChangeRequestListDtoInterface)dto);
        }
        return list;
    }

    protected boolean isStatus(WorkflowDtoInterface dto) {
        if (this.workflowStatus.isEmpty()) {
            return true;
        }
        if ("1".equals(this.workflowStatus)) {
            return this.workflowIntegrate.isDraft(dto);
        }
        if ("2".equals(this.workflowStatus)) {
            return "1".equals(dto.getWorkflowStatus()) || "2".equals(dto.getWorkflowStatus());
        }
        if ("3".equals(this.workflowStatus)) {
            return this.workflowIntegrate.isCompleted(dto);
        }
        if ("4".equals(this.workflowStatus)) {
            return "3".equals(dto.getWorkflowStatus()) || "4".equals(dto.getWorkflowStatus());
        }
        return false;
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public void setWorkflowStatus(String workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public void setWorkTypeCode(String workTypeCode) {
        this.workTypeCode = workTypeCode;
    }

    public void setRequestStartDate(Date requestStartDate) {
        this.requestStartDate = this.getDateClone(requestStartDate);
    }

    public void setRequestEndDate(Date requestEndDate) {
        this.requestEndDate = this.getDateClone(requestEndDate);
    }
}

