/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestSearchBeanInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.RequestListDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestListDtoInterface;
import jp.mosp.time.dto.settings.impl.WorkOnHolidayRequestListDto;

public class WorkOnHolidayRequestSearchBean
extends PlatformBean
implements WorkOnHolidayRequestSearchBeanInterface {
    private WorkOnHolidayRequestDaoInterface workOnHolidayRequestDao;
    private SubstituteDaoInterface substituteDao;
    private WorkflowReferenceBeanInterface workflowReference;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;
    String personalId;
    private String substitute;
    private String substituteRange;
    private String workflowStatus;
    private Date requestStartDate;
    private Date requestEndDate;

    public WorkOnHolidayRequestSearchBean() {
    }

    public WorkOnHolidayRequestSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.workOnHolidayRequestDao = (WorkOnHolidayRequestDaoInterface)this.createDao(WorkOnHolidayRequestDaoInterface.class);
        this.substituteDao = (SubstituteDaoInterface)this.createDao(SubstituteDaoInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
    }

    public List<WorkOnHolidayRequestListDtoInterface> getSearchList() throws MospException {
        Map param = this.workOnHolidayRequestDao.getParamsMap();
        param.put("personalId", this.personalId);
        param.put("substitute", this.substitute);
        param.put("substituteRange", this.substituteRange);
        param.put("workflowStatus", this.workflowStatus);
        param.put("requestStartDate", this.requestStartDate);
        param.put("requestEndDate", this.requestEndDate);
        List requestList = this.workOnHolidayRequestDao.findForSearch(param);
        ArrayList<WorkOnHolidayRequestListDtoInterface> list = new ArrayList<WorkOnHolidayRequestListDtoInterface>();
        boolean flag = false;
        for (WorkOnHolidayRequestDtoInterface requestDto : requestList) {
            WorkOnHolidayRequestListDto dto = new WorkOnHolidayRequestListDto();
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow());
            if (workflowDto == null) continue;
            List substituteList = this.substituteDao.findForWorkflow(requestDto.getWorkflow());
            if (!this.substituteRange.isEmpty()) {
                boolean rangeFlag = false;
                for (SubstituteDtoInterface substituteDto : substituteList) {
                    if (!this.substituteRange.equals(String.valueOf(substituteDto.getSubstituteRange()))) continue;
                    rangeFlag = true;
                    break;
                }
                if (!rangeFlag) continue;
            }
            dto.setTmdWorkOnHolidayRequestId(requestDto.getTmdWorkOnHolidayRequestId());
            dto.setRequestDate(requestDto.getRequestDate());
            dto.setWorkTypeCode(requestDto.getWorkTypeCode());
            dto.setStartTime(requestDto.getStartTime());
            dto.setEndTime(requestDto.getEndTime());
            dto.setRequestReason(requestDto.getRequestReason());
            dto.setWorkflow(requestDto.getWorkflow());
            dto.setSubstitute(requestDto.getSubstitute());
            for (SubstituteDtoInterface substituteDto : substituteList) {
                Date substituteDate = substituteDto.getSubstituteDate();
                int substituteRange = substituteDto.getSubstituteRange();
                dto.setSubstituteDate(substituteDate);
                dto.setSubstituteRange(substituteRange);
            }
            this.approvalInfoReference.setWorkflowInfo((RequestListDtoInterface)dto, workflowDto);
            flag = false;
            if ("1".equals(this.workflowStatus)) {
                if ("0".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("2".equals(this.workflowStatus)) {
                if ("1".equals(dto.getState()) || "2".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("3".equals(this.workflowStatus)) {
                if ("9".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("4".equals(this.workflowStatus)) {
                if ("3".equals(dto.getState()) || "4".equals(dto.getState())) {
                    flag = true;
                }
            } else {
                flag = true;
            }
            if (!flag) continue;
            list.add((WorkOnHolidayRequestListDtoInterface)dto);
        }
        return list;
    }

    public void setSubstitute(String substitute) {
        this.substitute = substitute;
    }

    public void setSubstituteRange(String substituteRange) {
        this.substituteRange = substituteRange;
    }

    public void setWorkflowStatus(String workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public void setRequestStartDate(Date requestStartDate) {
        this.requestStartDate = this.getDateClone(requestStartDate);
    }

    public void setRequestEndDate(Date requestEndDate) {
        this.requestEndDate = this.getDateClone(requestEndDate);
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }
}

