/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionRegistBeanInterface;
import jp.mosp.time.dao.settings.TotalTimeEmployeeDaoInterface;
import jp.mosp.time.dto.settings.TotalTimeEmployeeDtoInterface;
import jp.mosp.time.dto.settings.impl.TmtTotalTimeEmployeeDto;

public class TotalTimeEmployeeTransactionRegistBean
extends PlatformBean
implements TotalTimeEmployeeTransactionRegistBeanInterface {
    TotalTimeEmployeeDaoInterface dao;
    CutoffUtilBeanInterface cutoffUtil;

    public TotalTimeEmployeeTransactionRegistBean() {
    }

    public TotalTimeEmployeeTransactionRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (TotalTimeEmployeeDaoInterface)this.createDao(TotalTimeEmployeeDaoInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
    }

    public TotalTimeEmployeeDtoInterface getInitDto() {
        return new TmtTotalTimeEmployeeDto();
    }

    public void draft(String personalId, int calculationYear, int calculationMonth, String cutoffCode, Date calculationDate) throws MospException {
        TotalTimeEmployeeDtoInterface dto = this.dao.findForKey(personalId, calculationYear, calculationMonth);
        if (dto == null) {
            dto = this.getInitDto();
        } else {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmtTotalTimeEmployeeId());
        }
        dto.setPersonalId(personalId);
        dto.setCalculationYear(calculationYear);
        dto.setCalculationMonth(calculationMonth);
        dto.setCutoffCode(cutoffCode);
        dto.setCalculationDate(calculationDate);
        dto.setCutoffState(1);
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmtTotalTimeEmployeeId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void draft(List<String> personalIdList, int calculationYear, int calculationMonth, String cutoffCode) throws MospException {
        TotalTimeEmployeeDtoInterface dto = this.getInitDto();
        dto.setCalculationYear(calculationYear);
        dto.setCalculationMonth(calculationMonth);
        dto.setCutoffCode(cutoffCode);
        dto.setCalculationDate(this.cutoffUtil.getCutoffCalculationDate(cutoffCode, calculationYear, calculationMonth));
        dto.setCutoffState(1);
        for (String personalId : personalIdList) {
            dto.setPersonalId(personalId);
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            TotalTimeEmployeeDtoInterface totalTimeEmployeeDto = this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth());
            if (totalTimeEmployeeDto == null) {
                this.checkInsert(dto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
            } else {
                this.checkUpdate(totalTimeEmployeeDto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                this.logicalDelete((BaseDaoInterface)this.dao, totalTimeEmployeeDto.getTmtTotalTimeEmployeeId());
            }
            dto.setTmtTotalTimeEmployeeId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void draftRelease(List<String> personalIdList, int calculationYear, int calculationMonth, String cutoffCode) throws MospException {
        for (String personalId : personalIdList) {
            TotalTimeEmployeeDtoInterface dto = this.dao.findForKey(personalId, calculationYear, calculationMonth);
            dto.setCutoffState(0);
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmtTotalTimeEmployeeId());
            dto.setTmtTotalTimeEmployeeId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    protected void checkInsert(TotalTimeEmployeeDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth()));
    }

    protected void checkUpdate(TotalTimeEmployeeDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmtTotalTimeEmployeeId());
    }

    public void validate(TotalTimeEmployeeDtoInterface dto) {
    }
}

