/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.PlatformNamingUtility;
import jp.mosp.time.bean.TotalTimeCorrectionRegistBeanInterface;
import jp.mosp.time.dao.settings.TotalTimeCorrectionDaoInterface;
import jp.mosp.time.dto.settings.TotalAbsenceDtoInterface;
import jp.mosp.time.dto.settings.TotalAllowanceDtoInterface;
import jp.mosp.time.dto.settings.TotalLeaveDtoInterface;
import jp.mosp.time.dto.settings.TotalOtherVacationDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeCorrectionDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdTotalTimeCorrectionDto;

public class TotalTimeCorrectionRegistBean
extends PlatformBean
implements TotalTimeCorrectionRegistBeanInterface {
    TotalTimeCorrectionDaoInterface dao;

    public TotalTimeCorrectionRegistBean() {
    }

    public TotalTimeCorrectionRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (TotalTimeCorrectionDaoInterface)this.createDao(TotalTimeCorrectionDaoInterface.class);
    }

    public TotalTimeCorrectionDtoInterface getInitDto() {
        return new TmdTotalTimeCorrectionDto();
    }

    public void insert(TotalTimeCorrectionDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdTotalTimeCorrectionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(TotalTimeCorrectionDtoInterface dto) {
    }

    public void insertTotalTime(TotalTimeCorrectionDtoInterface dto, TotalTimeDataDtoInterface oldDto, TotalTimeDataDtoInterface newDto) throws MospException {
        List list = this.setChangePointTotalTimeDate(oldDto, newDto);
        for (TotalTimeCorrectionDtoInterface correctionDto : list) {
            dto.setCorrectionType(correctionDto.getCorrectionType());
            dto.setCorrectionBefore(correctionDto.getCorrectionBefore());
            dto.setCorrectionAfter(correctionDto.getCorrectionAfter());
            this.insert(dto);
        }
    }

    public void insertAllowance(TotalTimeCorrectionDtoInterface dto, TotalAllowanceDtoInterface oldDto, TotalAllowanceDtoInterface newDto) throws MospException {
        TotalTimeCorrectionDtoInterface correctionDto = this.setChangePointTotalAllowance(dto, oldDto, newDto);
        this.insert(correctionDto);
    }

    public void insertAbsence(TotalTimeCorrectionDtoInterface dto, TotalAbsenceDtoInterface oldDto, TotalAbsenceDtoInterface newDto, boolean isDay, boolean isHour) throws MospException {
        String type;
        String code = newDto.getAbsenceCode();
        if (isDay) {
            type = "81";
            this.setHolidayCorrection(dto, type, oldDto.getTimes(), newDto.getTimes(), code);
            this.insert(dto);
        }
        if (isHour) {
            type = "123";
            this.setHolidayCorrection(dto, type, oldDto.getHours(), newDto.getHours(), code);
            this.insert(dto);
        }
    }

    public void insertLeave(TotalTimeCorrectionDtoInterface dto, TotalLeaveDtoInterface oldDto, TotalLeaveDtoInterface newDto, boolean isDay, boolean isHour) throws MospException {
        String type;
        String code = newDto.getHolidayCode();
        if (isDay) {
            type = "61";
            this.setHolidayCorrection(dto, type, oldDto.getTimes(), newDto.getTimes(), code);
            this.insert(dto);
        }
        if (isHour) {
            type = "121";
            this.setHolidayCorrection(dto, type, oldDto.getHours(), newDto.getHours(), code);
            this.insert(dto);
        }
    }

    public void insertOtherVacation(TotalTimeCorrectionDtoInterface dto, TotalOtherVacationDtoInterface oldDto, TotalOtherVacationDtoInterface newDto, boolean isDay, boolean isHour) throws MospException {
        String type;
        String code = newDto.getHolidayCode();
        if (isDay) {
            type = "71";
            this.setHolidayCorrection(dto, type, oldDto.getTimes(), newDto.getTimes(), code);
            this.insert(dto);
        }
        if (isHour) {
            type = "122";
            this.setHolidayCorrection(dto, type, oldDto.getHours(), newDto.getHours(), code);
            this.insert(dto);
        }
    }

    public void delete(List<String> personalIdList, int calculationYear, int calculationMonth) throws MospException {
        for (String personalId : personalIdList) {
            List list = this.dao.findForHistory(personalId, calculationYear, calculationMonth);
            for (TotalTimeCorrectionDtoInterface dto : list) {
                this.validate(dto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                this.checkDelete(dto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalTimeCorrectionId());
            }
        }
    }

    protected List<TotalTimeCorrectionDtoInterface> setChangePointTotalTimeDate(TotalTimeDataDtoInterface oldDto, TotalTimeDataDtoInterface newDto) {
        ArrayList<TotalTimeCorrectionDtoInterface> list = new ArrayList<TotalTimeCorrectionDtoInterface>();
        if (oldDto.getWorkTime() != newDto.getWorkTime()) {
            list.add(this.getTotalTimeCorrectionDto("1", (Object)oldDto.getWorkTime(), (Object)newDto.getWorkTime()));
        }
        if (oldDto.getSpecificWorkTime() != newDto.getSpecificWorkTime()) {
            list.add(this.getTotalTimeCorrectionDto("2", (Object)oldDto.getSpecificWorkTime(), (Object)newDto.getSpecificWorkTime()));
        }
        if (oldDto.getShortUnpaid() != newDto.getShortUnpaid()) {
            list.add(this.getTotalTimeCorrectionDto("120", (Object)oldDto.getShortUnpaid(), (Object)newDto.getShortUnpaid()));
        }
        if (oldDto.getTimesWorkDate() != newDto.getTimesWorkDate()) {
            list.add(this.getTotalTimeCorrectionDto("3", (Object)oldDto.getTimesWorkDate(), (Object)newDto.getTimesWorkDate()));
        }
        if (oldDto.getTimesWork() != newDto.getTimesWork()) {
            list.add(this.getTotalTimeCorrectionDto("4", (Object)oldDto.getTimesWork(), (Object)newDto.getTimesWork()));
        }
        if (oldDto.getLegalWorkOnHoliday() != newDto.getLegalWorkOnHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("5", (Object)oldDto.getLegalWorkOnHoliday(), (Object)newDto.getLegalWorkOnHoliday()));
        }
        if (oldDto.getSpecificWorkOnHoliday() != newDto.getSpecificWorkOnHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("6", (Object)oldDto.getSpecificWorkOnHoliday(), (Object)newDto.getSpecificWorkOnHoliday()));
        }
        if (oldDto.getDirectStart() != newDto.getDirectStart()) {
            list.add(this.getTotalTimeCorrectionDto("7", (Object)oldDto.getDirectStart(), (Object)newDto.getDirectStart()));
        }
        if (oldDto.getDirectEnd() != newDto.getDirectEnd()) {
            list.add(this.getTotalTimeCorrectionDto("8", (Object)oldDto.getDirectEnd(), (Object)newDto.getDirectEnd()));
        }
        if (oldDto.getRestTime() != newDto.getRestTime()) {
            list.add(this.getTotalTimeCorrectionDto("9", (Object)oldDto.getRestTime(), (Object)newDto.getRestTime()));
        }
        if (oldDto.getRestLateNight() != newDto.getRestLateNight()) {
            list.add(this.getTotalTimeCorrectionDto("10", (Object)oldDto.getRestLateNight(), (Object)newDto.getRestLateNight()));
        }
        if (oldDto.getRestWorkOnSpecificHoliday() != newDto.getRestWorkOnSpecificHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("11", (Object)oldDto.getRestWorkOnSpecificHoliday(), (Object)newDto.getRestWorkOnSpecificHoliday()));
        }
        if (oldDto.getRestWorkOnHoliday() != newDto.getRestWorkOnHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("12", (Object)oldDto.getRestWorkOnHoliday(), (Object)newDto.getRestWorkOnHoliday()));
        }
        if (oldDto.getPublicTime() != newDto.getPublicTime()) {
            list.add(this.getTotalTimeCorrectionDto("13", (Object)oldDto.getPublicTime(), (Object)newDto.getPublicTime()));
        }
        if (oldDto.getPrivateTime() != newDto.getPrivateTime()) {
            list.add(this.getTotalTimeCorrectionDto("14", (Object)oldDto.getPrivateTime(), (Object)newDto.getPrivateTime()));
        }
        if (oldDto.getTimesOvertime() != newDto.getTimesOvertime()) {
            list.add(this.getTotalTimeCorrectionDto("15", (Object)oldDto.getTimesOvertime(), (Object)newDto.getTimesOvertime()));
        }
        if (oldDto.getOvertime() != newDto.getOvertime()) {
            list.add(this.getTotalTimeCorrectionDto("108", (Object)oldDto.getOvertime(), (Object)newDto.getOvertime()));
        }
        if (oldDto.getOvertimeIn() != newDto.getOvertimeIn()) {
            list.add(this.getTotalTimeCorrectionDto("16", (Object)oldDto.getOvertimeIn(), (Object)newDto.getOvertimeIn()));
        }
        if (oldDto.getOvertimeOut() != newDto.getOvertimeOut()) {
            list.add(this.getTotalTimeCorrectionDto("17", (Object)oldDto.getOvertimeOut(), (Object)newDto.getOvertimeOut()));
        }
        if (oldDto.getLateNight() != newDto.getLateNight()) {
            list.add(this.getTotalTimeCorrectionDto("18", (Object)oldDto.getLateNight(), (Object)newDto.getLateNight()));
        }
        if (oldDto.getWorkOnSpecificHoliday() != newDto.getWorkOnSpecificHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("19", (Object)oldDto.getWorkOnSpecificHoliday(), (Object)newDto.getWorkOnSpecificHoliday()));
        }
        if (oldDto.getWorkOnHoliday() != newDto.getWorkOnHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("20", (Object)oldDto.getWorkOnHoliday(), (Object)newDto.getWorkOnHoliday()));
        }
        if (oldDto.getDecreaseTime() != newDto.getDecreaseTime()) {
            list.add(this.getTotalTimeCorrectionDto("21", (Object)oldDto.getDecreaseTime(), (Object)newDto.getDecreaseTime()));
        }
        if (oldDto.getFortyFiveHourOvertime() != newDto.getFortyFiveHourOvertime()) {
            list.add(this.getTotalTimeCorrectionDto("22", (Object)oldDto.getFortyFiveHourOvertime(), (Object)newDto.getFortyFiveHourOvertime()));
        }
        if (oldDto.getLateDays() != newDto.getLateDays()) {
            list.add(this.getTotalTimeCorrectionDto("101", (Object)oldDto.getLateDays(), (Object)newDto.getLateDays()));
        }
        if (oldDto.getLateThirtyMinutesOrMore() != newDto.getLateThirtyMinutesOrMore()) {
            list.add(this.getTotalTimeCorrectionDto("110", (Object)oldDto.getLateThirtyMinutesOrMore(), (Object)newDto.getLateThirtyMinutesOrMore()));
        }
        if (oldDto.getLateLessThanThirtyMinutes() != newDto.getLateLessThanThirtyMinutes()) {
            list.add(this.getTotalTimeCorrectionDto("111", (Object)oldDto.getLateLessThanThirtyMinutes(), (Object)newDto.getLateLessThanThirtyMinutes()));
        }
        if (oldDto.getLateTime() != newDto.getLateTime()) {
            list.add(this.getTotalTimeCorrectionDto("27", (Object)oldDto.getLateTime(), (Object)newDto.getLateTime()));
        }
        if (oldDto.getLateThirtyMinutesOrMoreTime() != newDto.getLateThirtyMinutesOrMoreTime()) {
            list.add(this.getTotalTimeCorrectionDto("112", (Object)oldDto.getLateThirtyMinutesOrMoreTime(), (Object)newDto.getLateThirtyMinutesOrMoreTime()));
        }
        if (oldDto.getLateLessThanThirtyMinutesTime() != newDto.getLateLessThanThirtyMinutesTime()) {
            list.add(this.getTotalTimeCorrectionDto("113", (Object)oldDto.getLateLessThanThirtyMinutesTime(), (Object)newDto.getLateLessThanThirtyMinutesTime()));
        }
        if (oldDto.getTimesLate() != newDto.getTimesLate()) {
            list.add(this.getTotalTimeCorrectionDto("23", (Object)oldDto.getTimesLate(), (Object)newDto.getTimesLate()));
        }
        if (oldDto.getLeaveEarlyDays() != newDto.getLeaveEarlyDays()) {
            list.add(this.getTotalTimeCorrectionDto("102", (Object)oldDto.getLeaveEarlyDays(), (Object)newDto.getLeaveEarlyDays()));
        }
        if (oldDto.getLeaveEarlyThirtyMinutesOrMore() != newDto.getLeaveEarlyThirtyMinutesOrMore()) {
            list.add(this.getTotalTimeCorrectionDto("114", (Object)oldDto.getLeaveEarlyThirtyMinutesOrMore(), (Object)newDto.getLeaveEarlyThirtyMinutesOrMore()));
        }
        if (oldDto.getLeaveEarlyLessThanThirtyMinutes() != newDto.getLeaveEarlyLessThanThirtyMinutes()) {
            list.add(this.getTotalTimeCorrectionDto("115", (Object)oldDto.getLeaveEarlyLessThanThirtyMinutes(), (Object)newDto.getLeaveEarlyLessThanThirtyMinutes()));
        }
        if (oldDto.getLeaveEarlyTime() != newDto.getLeaveEarlyTime()) {
            list.add(this.getTotalTimeCorrectionDto("35", (Object)oldDto.getLeaveEarlyTime(), (Object)newDto.getLeaveEarlyTime()));
        }
        if (oldDto.getLeaveEarlyThirtyMinutesOrMoreTime() != newDto.getLeaveEarlyThirtyMinutesOrMoreTime()) {
            list.add(this.getTotalTimeCorrectionDto("116", (Object)oldDto.getLeaveEarlyThirtyMinutesOrMoreTime(), (Object)newDto.getLeaveEarlyThirtyMinutesOrMoreTime()));
        }
        if (oldDto.getLeaveEarlyLessThanThirtyMinutesTime() != newDto.getLeaveEarlyLessThanThirtyMinutesTime()) {
            list.add(this.getTotalTimeCorrectionDto("117", (Object)oldDto.getLeaveEarlyLessThanThirtyMinutesTime(), (Object)newDto.getLeaveEarlyLessThanThirtyMinutesTime()));
        }
        if (oldDto.getTimesLeaveEarly() != newDto.getTimesLeaveEarly()) {
            list.add(this.getTotalTimeCorrectionDto("31", (Object)oldDto.getTimesLeaveEarly(), (Object)newDto.getTimesLeaveEarly()));
        }
        if (oldDto.getTimesHoliday() != newDto.getTimesHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("39", (Object)oldDto.getTimesHoliday(), (Object)newDto.getTimesHoliday()));
        }
        if (oldDto.getTimesLegalHoliday() != newDto.getTimesLegalHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("40", (Object)oldDto.getTimesLegalHoliday(), (Object)newDto.getTimesLegalHoliday()));
        }
        if (oldDto.getTimesSpecificHoliday() != newDto.getTimesSpecificHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("41", (Object)oldDto.getTimesSpecificHoliday(), (Object)newDto.getTimesSpecificHoliday()));
        }
        if (oldDto.getTimesPaidHoliday() != newDto.getTimesPaidHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("42", (Object)oldDto.getTimesPaidHoliday(), (Object)newDto.getTimesPaidHoliday()));
        }
        if (oldDto.getPaidHolidayHour() != newDto.getPaidHolidayHour()) {
            list.add(this.getTotalTimeCorrectionDto("43", (Object)oldDto.getPaidHolidayHour(), (Object)newDto.getPaidHolidayHour()));
        }
        if (oldDto.getTimesStockHoliday() != newDto.getTimesStockHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("44", (Object)oldDto.getTimesStockHoliday(), (Object)newDto.getTimesStockHoliday()));
        }
        if (oldDto.getTimesCompensation() != newDto.getTimesCompensation()) {
            list.add(this.getTotalTimeCorrectionDto("45", (Object)oldDto.getTimesCompensation(), (Object)newDto.getTimesCompensation()));
        }
        if (oldDto.getTimesLegalCompensation() != newDto.getTimesLegalCompensation()) {
            list.add(this.getTotalTimeCorrectionDto("46", (Object)oldDto.getTimesLegalCompensation(), (Object)newDto.getTimesLegalCompensation()));
        }
        if (oldDto.getTimesSpecificCompensation() != newDto.getTimesSpecificCompensation()) {
            list.add(this.getTotalTimeCorrectionDto("47", (Object)oldDto.getTimesSpecificCompensation(), (Object)newDto.getTimesSpecificCompensation()));
        }
        if (oldDto.getTimesLateCompensation() != newDto.getTimesLateCompensation()) {
            list.add(this.getTotalTimeCorrectionDto("48", (Object)oldDto.getTimesLateCompensation(), (Object)newDto.getTimesLateCompensation()));
        }
        if (oldDto.getTimesHolidaySubstitute() != newDto.getTimesHolidaySubstitute()) {
            list.add(this.getTotalTimeCorrectionDto("49", (Object)oldDto.getTimesHolidaySubstitute(), (Object)newDto.getTimesHolidaySubstitute()));
        }
        if (oldDto.getTimesLegalHolidaySubstitute() != newDto.getTimesLegalHolidaySubstitute()) {
            list.add(this.getTotalTimeCorrectionDto("50", (Object)oldDto.getTimesLegalHolidaySubstitute(), (Object)newDto.getTimesLegalHolidaySubstitute()));
        }
        if (oldDto.getTimesSpecificHolidaySubstitute() != newDto.getTimesSpecificHolidaySubstitute()) {
            list.add(this.getTotalTimeCorrectionDto("51", (Object)oldDto.getTimesSpecificHolidaySubstitute(), (Object)newDto.getTimesSpecificHolidaySubstitute()));
        }
        if (oldDto.getTotalSpecialHoliday() != newDto.getTotalSpecialHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("52", (Object)oldDto.getTotalSpecialHoliday(), (Object)newDto.getTotalSpecialHoliday()));
        }
        if (oldDto.getTotalOtherHoliday() != newDto.getTotalOtherHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("53", (Object)oldDto.getTotalOtherHoliday(), (Object)newDto.getTotalOtherHoliday()));
        }
        if (oldDto.getTotalAbsence() != newDto.getTotalAbsence()) {
            list.add(this.getTotalTimeCorrectionDto("54", (Object)oldDto.getTotalAbsence(), (Object)newDto.getTotalAbsence()));
        }
        if (oldDto.getTotalAllowance() != newDto.getTotalAllowance()) {
            list.add(this.getTotalTimeCorrectionDto("55", (Object)oldDto.getTotalAllowance(), (Object)newDto.getTotalAllowance()));
        }
        if (oldDto.getSixtyHourOvertime() != newDto.getSixtyHourOvertime()) {
            list.add(this.getTotalTimeCorrectionDto("56", (Object)oldDto.getSixtyHourOvertime(), (Object)newDto.getSixtyHourOvertime()));
        }
        if (oldDto.getWeekDayOvertime() != newDto.getWeekDayOvertime()) {
            list.add(this.getTotalTimeCorrectionDto("57", (Object)oldDto.getWeekDayOvertime(), (Object)newDto.getWeekDayOvertime()));
        }
        if (oldDto.getSpecificOvertime() != newDto.getSpecificOvertime()) {
            list.add(this.getTotalTimeCorrectionDto("58", (Object)oldDto.getSpecificOvertime(), (Object)newDto.getSpecificOvertime()));
        }
        if (oldDto.getTimesAlternative() != newDto.getTimesAlternative()) {
            list.add(this.getTotalTimeCorrectionDto("59", (Object)oldDto.getTimesAlternative(), (Object)newDto.getTimesAlternative()));
        }
        if (oldDto.getLegalCompensationUnused() != newDto.getLegalCompensationUnused()) {
            list.add(this.getTotalTimeCorrectionDto("103", (Object)oldDto.getLegalCompensationUnused(), (Object)newDto.getLegalCompensationUnused()));
        }
        if (oldDto.getSpecificCompensationUnused() != newDto.getSpecificCompensationUnused()) {
            list.add(this.getTotalTimeCorrectionDto("104", (Object)oldDto.getSpecificCompensationUnused(), (Object)newDto.getSpecificCompensationUnused()));
        }
        if (oldDto.getLateCompensationUnused() != newDto.getLateCompensationUnused()) {
            list.add(this.getTotalTimeCorrectionDto("105", (Object)oldDto.getLateCompensationUnused(), (Object)newDto.getLateCompensationUnused()));
        }
        if (oldDto.getTimesAchievement() != newDto.getTimesAchievement()) {
            list.add(this.getTotalTimeCorrectionDto("106", (Object)oldDto.getTimesAchievement(), (Object)newDto.getTimesAchievement()));
        }
        if (oldDto.getTimesTotalWorkDate() != newDto.getTimesTotalWorkDate()) {
            list.add(this.getTotalTimeCorrectionDto("107", (Object)oldDto.getTimesTotalWorkDate(), (Object)newDto.getTimesTotalWorkDate()));
        }
        if (oldDto.getTimesWorkingHoliday() != newDto.getTimesWorkingHoliday()) {
            list.add(this.getTotalTimeCorrectionDto("109", (Object)oldDto.getTimesWorkingHoliday(), (Object)newDto.getTimesWorkingHoliday()));
        }
        return list;
    }

    protected TotalTimeCorrectionDtoInterface setChangePointTotalAllowance(TotalTimeCorrectionDtoInterface dto, TotalAllowanceDtoInterface oldDto, TotalAllowanceDtoInterface newDto) {
        if (newDto.getTimes() != oldDto.getTimes()) {
            if (newDto.getAllowanceCode().equals("1")) {
                dto.setCorrectionType("91");
            }
            if (newDto.getAllowanceCode().equals("2")) {
                dto.setCorrectionType("92");
            }
            if (newDto.getAllowanceCode().equals("3")) {
                dto.setCorrectionType("93");
            }
            if (newDto.getAllowanceCode().equals("4")) {
                dto.setCorrectionType("94");
            }
            if (newDto.getAllowanceCode().equals("5")) {
                dto.setCorrectionType("95");
            }
            if (newDto.getAllowanceCode().equals("6")) {
                dto.setCorrectionType("96");
            }
            if (newDto.getAllowanceCode().equals("7")) {
                dto.setCorrectionType("97");
            }
            if (newDto.getAllowanceCode().equals("8")) {
                dto.setCorrectionType("98");
            }
            if (newDto.getAllowanceCode().equals("9")) {
                dto.setCorrectionType("99");
            }
            if (newDto.getAllowanceCode().equals("10")) {
                dto.setCorrectionType("100");
            }
            dto.setCorrectionBefore(String.valueOf(oldDto.getTimes()));
            dto.setCorrectionAfter(String.valueOf(newDto.getTimes()));
        }
        return dto;
    }

    protected void validate(TotalTimeCorrectionDtoInterface dto) {
    }

    protected void checkDelete(TotalTimeCorrectionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdTotalTimeCorrectionId());
    }

    private TotalTimeCorrectionDtoInterface getTotalTimeCorrectionDto(String type, Object before, Object after) {
        TotalTimeCorrectionDtoInterface dto = this.getInitDto();
        dto.setCorrectionType(type);
        dto.setCorrectionBefore(String.valueOf(before));
        dto.setCorrectionAfter(String.valueOf(after));
        return dto;
    }

    protected void setHolidayCorrection(TotalTimeCorrectionDtoInterface dto, String type, double beforeTime, double afterTime, String code) {
        String[] strs = new String[]{type, code};
        dto.setCorrectionType(MospUtility.concat((Object)",", (String[])strs));
        dto.setCorrectionBefore(String.valueOf(beforeTime));
        dto.setCorrectionAfter(String.valueOf(afterTime));
    }

    protected void setHolidayCorrection(TotalTimeCorrectionDtoInterface dto, String type, int beforeTime, int afterTime, String code) {
        String[] strs = new String[]{type, code};
        dto.setCorrectionType(MospUtility.concat((Object)",", (String[])strs));
        dto.setCorrectionBefore(this.getStringHolidayHours(beforeTime));
        dto.setCorrectionAfter(this.getStringHolidayHours(afterTime));
    }

    protected String getStringHolidayHours(int hours) {
        StringBuilder sb = new StringBuilder();
        sb.append(hours);
        sb.append(PlatformNamingUtility.time((MospParams)this.mospParams));
        return sb.toString();
    }
}

