/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalAbsenceRegistBeanInterface;
import jp.mosp.time.bean.TotalLeaveRegistBeanInterface;
import jp.mosp.time.bean.TotalOtherVacationRegistBeanInterface;
import jp.mosp.time.bean.TotalTimeCalcBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionRegistBeanInterface;
import jp.mosp.time.bean.TotalTimeEntityReferenceBeanInterface;
import jp.mosp.time.bean.TotalTimeReferenceBeanInterface;
import jp.mosp.time.bean.TotalTimeRegistBeanInterface;
import jp.mosp.time.bean.TotalTimeTransactionRegistBeanInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.CutoffErrorListDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.TotalAbsenceDtoInterface;
import jp.mosp.time.dto.settings.TotalLeaveDtoInterface;
import jp.mosp.time.dto.settings.TotalOtherVacationDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.RequestDetectEntityInterface;
import jp.mosp.time.entity.TotalTimeEntityInterface;

public class TotalTimeCalcBean
extends TimeBean
implements TotalTimeCalcBeanInterface {
    public static final int PREDETERMINED_OVERTIME_WORK = 40;
    public static final int LEGAL_OVERTIME_WORK = 45;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected TotalLeaveRegistBeanInterface totalLeaveRegist;
    protected TotalOtherVacationRegistBeanInterface totalOtherVacationRegist;
    protected TotalAbsenceRegistBeanInterface totalAbsenceRegist;
    protected TotalTimeReferenceBeanInterface totalTimeRefer;
    protected TotalTimeRegistBeanInterface totalTimeRegist;
    protected TotalTimeTransactionRegistBeanInterface totalTransRegist;
    protected TotalTimeEmployeeTransactionRegistBeanInterface employeeTransRegist;
    protected AttendanceTransactionRegistBeanInterface attendanceTransactionRegist;
    protected TotalTimeEntityReferenceBeanInterface totalTimeEntityRefer;
    protected PlatformMasterBeanInterface platformMaster;
    protected TimeMasterBeanInterface timeMaster;

    public TotalTimeCalcBean() {
    }

    public TotalTimeCalcBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.totalLeaveRegist = (TotalLeaveRegistBeanInterface)this.createBean(TotalLeaveRegistBeanInterface.class);
        this.totalOtherVacationRegist = (TotalOtherVacationRegistBeanInterface)this.createBean(TotalOtherVacationRegistBeanInterface.class);
        this.totalAbsenceRegist = (TotalAbsenceRegistBeanInterface)this.createBean(TotalAbsenceRegistBeanInterface.class);
        this.totalTimeRefer = (TotalTimeReferenceBeanInterface)this.createBean(TotalTimeReferenceBeanInterface.class);
        this.totalTimeRegist = (TotalTimeRegistBeanInterface)this.createBean(TotalTimeRegistBeanInterface.class);
        this.totalTransRegist = (TotalTimeTransactionRegistBeanInterface)this.createBean(TotalTimeTransactionRegistBeanInterface.class);
        this.employeeTransRegist = (TotalTimeEmployeeTransactionRegistBeanInterface)this.createBean(TotalTimeEmployeeTransactionRegistBeanInterface.class);
        this.attendanceTransactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBean(AttendanceTransactionRegistBeanInterface.class);
        this.totalTimeEntityRefer = (TotalTimeEntityReferenceBeanInterface)this.createBean(TotalTimeEntityReferenceBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBean(PlatformMasterBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBean(TimeMasterBeanInterface.class);
        this.totalTimeEntityRefer.setPlatformMasterBean(this.platformMaster);
        this.totalTimeEntityRefer.setTimeMasterBean(this.timeMaster);
    }

    public List<CutoffErrorListDtoInterface> tightening(int targetYear, int targetMonth, String cutoffCode) throws MospException {
        ArrayList<CutoffErrorListDtoInterface> errorList = new ArrayList<CutoffErrorListDtoInterface>();
        ArrayList<TotalTimeEntityInterface> entityList = new ArrayList<TotalTimeEntityInterface>();
        Set personalIdSet = this.cutoffUtil.getCutoffPersonalIdSet(cutoffCode, targetYear, targetMonth);
        if (personalIdSet.isEmpty()) {
            PlatformMessageUtility.addErrorEmployeeNotExist((MospParams)this.mospParams);
            return errorList;
        }
        for (String personalId : personalIdSet) {
            if (!this.cutoffUtil.isNotTighten(personalId, targetYear, targetMonth)) continue;
            TotalTimeEntityInterface entity = this.getTotalTimeEntity(personalId, targetYear, targetMonth, cutoffCode);
            entityList.add(entity);
            this.removeUnusedRequests(entity, false);
            errorList.addAll(this.check(entity));
        }
        if (!errorList.isEmpty()) {
            return errorList;
        }
        for (TotalTimeEntityInterface entity : entityList) {
            this.removeUnusedRequests(entity, true);
            entity.total();
            this.doAdditionalLogic(new Object[]{"Add_TotalTimeCalcBean_Total", entity});
        }
        for (TotalTimeEntityInterface entity : entityList) {
            this.tightening(entity);
        }
        this.tightenCutoff(targetYear, targetMonth, cutoffCode);
        return errorList;
    }

    public List<CutoffErrorListDtoInterface> tightening(String[] aryPersonalId, int targetYear, int targetMonth, String cutoffCode) throws MospException {
        ArrayList<CutoffErrorListDtoInterface> errorList = new ArrayList<CutoffErrorListDtoInterface>();
        ArrayList<TotalTimeEntityInterface> entityList = new ArrayList<TotalTimeEntityInterface>();
        for (String personalId : aryPersonalId) {
            if (!this.cutoffUtil.isNotTighten(personalId, targetYear, targetMonth)) continue;
            TotalTimeEntityInterface entity = this.getTotalTimeEntity(personalId, targetYear, targetMonth, cutoffCode);
            entityList.add(entity);
            this.removeUnusedRequests(entity, false);
            errorList.addAll(this.check(entity));
        }
        if (!errorList.isEmpty()) {
            return errorList;
        }
        for (TotalTimeEntityInterface entity : entityList) {
            this.removeUnusedRequests(entity, true);
            entity.total();
            this.doAdditionalLogic(new Object[]{"Add_TotalTimeCalcBean_Total", entity});
        }
        for (TotalTimeEntityInterface entity : entityList) {
            this.tightening(entity);
        }
        if (this.isAllTightened(targetYear, targetMonth, cutoffCode)) {
            this.tightenCutoff(targetYear, targetMonth, cutoffCode);
        }
        return errorList;
    }

    public List<CutoffErrorListDtoInterface> tightening(String personalId, int targetYear, int targetMonth) throws MospException {
        if (!this.cutoffUtil.isNotTighten(personalId, targetYear, targetMonth)) {
            return Collections.emptyList();
        }
        TotalTimeEntityInterface entity = this.getTotalTimeEntity(personalId, targetYear, targetMonth);
        this.removeUnusedRequests(entity, false);
        List errorList = this.check(entity);
        if (!errorList.isEmpty()) {
            return errorList;
        }
        this.removeUnusedRequests(entity, true);
        entity.total();
        this.doAdditionalLogic(new Object[]{"Add_TotalTimeCalcBean_Total", entity});
        this.tightening(entity);
        return errorList;
    }

    public TotalTimeDataDtoInterface calc(String personalId, int targetYear, int targetMonth, String cutoffCode) throws MospException {
        TotalTimeEntityInterface entity = this.getTotalTimeEntity(personalId, targetYear, targetMonth, cutoffCode);
        this.removeUnusedRequests(entity, true);
        TotalTimeDataDtoInterface dto = this.calc(entity);
        return dto;
    }

    public TotalTimeDataDtoInterface calc(String personalId, int targetYear, int targetMonth, boolean isCompleted) throws MospException {
        TotalTimeEntityInterface entity = this.getTotalTimeEntity(personalId, targetYear, targetMonth);
        this.removeUnusedRequests(entity, isCompleted);
        TotalTimeDataDtoInterface dto = this.calc(entity);
        return dto;
    }

    protected TotalTimeEntityInterface getTotalTimeEntity(String personalId, int targetYear, int targetMonth) throws MospException {
        HumanDtoInterface humanDto = this.platformMaster.getHuman(personalId, targetYear, targetMonth);
        ApplicationEntity applicationEntity = this.timeMaster.getApplicationEntity(humanDto, targetYear, targetMonth);
        CutoffDtoInterface cutoffDto = applicationEntity.getCutoffDto();
        return this.totalTimeEntityRefer.getTotalTimeEntity(personalId, targetYear, targetMonth, cutoffDto);
    }

    protected TotalTimeEntityInterface getTotalTimeEntity(String personalId, int targetYear, int targetMonth, String cutoffCode) throws MospException {
        CutoffDtoInterface cutoffDto = this.timeMaster.getCutoff(cutoffCode, targetYear, targetMonth);
        return this.totalTimeEntityRefer.getTotalTimeEntity(personalId, targetYear, targetMonth, cutoffDto);
    }

    protected List<CutoffErrorListDtoInterface> check(TotalTimeEntityInterface entity) throws MospException {
        String personalId = entity.getPersonalId();
        int targetYear = entity.getCalculationYear();
        int targetMonth = entity.getCalculationMonth();
        String cutoffCode = entity.getCutoffCode();
        HumanDtoInterface humanDto = this.platformMaster.getHuman(personalId, targetYear, targetMonth);
        CutoffDtoInterface cutoffDto = this.timeMaster.getCutoff(cutoffCode, targetYear, targetMonth);
        int noApproval = cutoffDto == null ? 0 : cutoffDto.getNoApproval();
        RequestDetectEntityInterface detectEntity = this.totalTimeEntityRefer.getRequestDetectEntity(entity);
        boolean isImmediately = false;
        if (noApproval == 0) {
            // empty if block
        }
        if (noApproval == 1 || noApproval == 2) {
            detectEntity.isApprovableExist(isImmediately);
            detectEntity.isAppliableExist(isImmediately);
            detectEntity.isOvertimeNotAppliedExist(isImmediately);
        }
        if (noApproval == 3) {
            detectEntity.isApprovableExist(isImmediately);
            detectEntity.isAppliableExist(isImmediately);
        }
        return detectEntity.getCutoffErrorList(this.mospParams, humanDto);
    }

    protected TotalTimeDataDtoInterface calc(TotalTimeEntityInterface entity) throws MospException {
        int targetMonth;
        int targetYear;
        String personalId = entity.getPersonalId();
        if (!this.cutoffUtil.isNotTighten(personalId, targetYear = entity.getCalculationYear(), targetMonth = entity.getCalculationMonth())) {
            return this.totalTimeRefer.findForKey(personalId, targetYear, targetMonth);
        }
        entity.total();
        this.doAdditionalLogic(new Object[]{"Add_TotalTimeCalcBean_Total", entity});
        return this.getTotalTimeData(entity);
    }

    protected void tightening(TotalTimeEntityInterface entity) throws MospException {
        String personalId = entity.getPersonalId();
        entity.total();
        this.doAdditionalLogic(new Object[]{"Add_TotalTimeCalcBean_Total", entity});
        this.totalTimeRegist.regist(this.getTotalTimeData(entity));
        this.registVacation(entity);
        this.attendanceTransactionRegist.regist(personalId, entity.getAttendanceTransactionMap());
        int targetYear = entity.getCalculationYear();
        int targetMonth = entity.getCalculationMonth();
        String cutoffCode = entity.getCutoffCode();
        Date calculationDate = this.cutoffUtil.getCutoffCalculationDate(cutoffCode, targetYear, targetMonth);
        this.employeeTransRegist.draft(personalId, targetYear, targetMonth, cutoffCode, calculationDate);
    }

    protected boolean isAllTightened(int targetYear, int targetMonth, String cutoffCode) throws MospException {
        Set personalIdSet = this.cutoffUtil.getCutoffPersonalIdSet(cutoffCode, targetYear, targetMonth);
        for (String personalId : personalIdSet) {
            if (!this.cutoffUtil.isNotTighten(personalId, targetYear, targetMonth)) continue;
            return false;
        }
        return true;
    }

    protected void tightenCutoff(int targetYear, int targetMonth, String cutoffCode) throws MospException {
        TotalTimeDtoInterface dto = this.totalTransRegist.getInitDto();
        dto.setCalculationYear(targetYear);
        dto.setCalculationMonth(targetMonth);
        dto.setCutoffCode(cutoffCode);
        dto.setCalculationDate(this.cutoffUtil.getCutoffCalculationDate(cutoffCode, targetYear, targetMonth));
        dto.setCutoffState(1);
        this.totalTransRegist.draft(dto);
    }

    protected void registVacation(TotalTimeEntityInterface entity) throws MospException {
        String personalId = entity.getPersonalId();
        int targetYear = entity.getCalculationYear();
        int targetMonth = entity.getCalculationMonth();
        this.totalLeaveRegist.delete(personalId, targetYear, targetMonth);
        Map specialHolidayDays = entity.getSpecialHolidayDays();
        Map specialHolidayHours = entity.getSpecialHolidayHours();
        for (Map.Entry entry : specialHolidayDays.entrySet()) {
            String holidayCode = (String)entry.getKey();
            TotalLeaveDtoInterface dto = this.totalLeaveRegist.getInitDto();
            dto.setPersonalId(personalId);
            dto.setCalculationYear(targetYear);
            dto.setCalculationMonth(targetMonth);
            dto.setHolidayCode(holidayCode);
            dto.setTimes((double)((Float)entry.getValue()).floatValue());
            dto.setHours(((Integer)specialHolidayHours.get(holidayCode)).intValue());
            this.totalLeaveRegist.insert(dto);
        }
        this.totalOtherVacationRegist.delete(personalId, targetYear, targetMonth);
        Map otherHolidayMap = entity.getOtherHolidayDays();
        Map otherHolidayHours = entity.getOtherHolidayHours();
        for (Map.Entry entry : otherHolidayMap.entrySet()) {
            String holidayCode = (String)entry.getKey();
            TotalOtherVacationDtoInterface dto = this.totalOtherVacationRegist.getInitDto();
            dto.setPersonalId(personalId);
            dto.setCalculationYear(targetYear);
            dto.setCalculationMonth(targetMonth);
            dto.setHolidayCode(holidayCode);
            dto.setTimes((double)((Float)entry.getValue()).floatValue());
            dto.setHours(((Integer)otherHolidayHours.get(holidayCode)).intValue());
            this.totalOtherVacationRegist.insert(dto);
        }
        this.totalAbsenceRegist.delete(personalId, targetYear, targetMonth);
        Map absenceMap = entity.getAbsenceDays();
        Map absenceHours = entity.getAbsenceHours();
        for (Map.Entry entry : absenceMap.entrySet()) {
            String holidayCode = (String)entry.getKey();
            TotalAbsenceDtoInterface dto = this.totalAbsenceRegist.getInitDto();
            dto.setPersonalId(personalId);
            dto.setCalculationYear(targetYear);
            dto.setCalculationMonth(targetMonth);
            dto.setAbsenceCode(holidayCode);
            dto.setTimes((double)((Float)entry.getValue()).floatValue());
            dto.setHours(((Integer)absenceHours.get(holidayCode)).intValue());
            this.totalAbsenceRegist.insert(dto);
        }
    }

    protected void removeUnusedRequests(TotalTimeEntityInterface entity, boolean isCompleted) {
        ArrayList<AttendanceDtoInterface> attendanceList = new ArrayList<AttendanceDtoInterface>();
        ArrayList<AttendanceDtoInterface> holidayRequestList = new ArrayList<AttendanceDtoInterface>();
        ArrayList<AttendanceDtoInterface> workOnHolidayRequestList = new ArrayList<AttendanceDtoInterface>();
        ArrayList<AttendanceDtoInterface> overtimeRequestList = new ArrayList<AttendanceDtoInterface>();
        ArrayList<AttendanceDtoInterface> workTypeChangeRequestList = new ArrayList<AttendanceDtoInterface>();
        ArrayList<AttendanceDtoInterface> differenceRequestList = new ArrayList<AttendanceDtoInterface>();
        ArrayList<AttendanceDtoInterface> substitubeList = new ArrayList<AttendanceDtoInterface>();
        ArrayList<AttendanceDtoInterface> subHolidayRequestList = new ArrayList<AttendanceDtoInterface>();
        for (AttendanceDtoInterface dto : entity.getAttendanceList()) {
            if (!this.isWorkflowNeeded(entity.getWorkflowDto(dto.getWorkflow()), isCompleted)) continue;
            attendanceList.add(dto);
        }
        for (AttendanceDtoInterface dto : entity.getHolidayRequestList()) {
            if (!this.isWorkflowNeeded(entity.getWorkflowDto(dto.getWorkflow()), isCompleted)) continue;
            holidayRequestList.add(dto);
        }
        for (AttendanceDtoInterface dto : entity.getWorkOnHolidayRequestList()) {
            if (!this.isWorkflowNeeded(entity.getWorkflowDto(dto.getWorkflow()), isCompleted)) continue;
            workOnHolidayRequestList.add(dto);
        }
        for (AttendanceDtoInterface dto : entity.getOvertimeRequestList()) {
            if (!this.isWorkflowNeeded(entity.getWorkflowDto(dto.getWorkflow()), isCompleted)) continue;
            overtimeRequestList.add(dto);
        }
        for (AttendanceDtoInterface dto : entity.getWorkTypeChangeRequestList()) {
            if (!this.isWorkflowNeeded(entity.getWorkflowDto(dto.getWorkflow()), isCompleted)) continue;
            workTypeChangeRequestList.add(dto);
        }
        for (AttendanceDtoInterface dto : entity.getDifferenceRequestList()) {
            if (!this.isWorkflowNeeded(entity.getWorkflowDto(dto.getWorkflow()), isCompleted)) continue;
            differenceRequestList.add(dto);
        }
        for (AttendanceDtoInterface dto : entity.getSubstitubeList()) {
            if (!this.isWorkflowNeeded(entity.getWorkflowDto(dto.getWorkflow()), isCompleted)) continue;
            substitubeList.add(dto);
        }
        for (AttendanceDtoInterface dto : entity.getSubHolidayRequestList()) {
            if (!this.isWorkflowNeeded(entity.getWorkflowDto(dto.getWorkflow()), isCompleted)) continue;
            subHolidayRequestList.add(dto);
        }
        entity.setAttendanceList(attendanceList);
        entity.setHolidayRequestList(holidayRequestList);
        entity.setWorkOnHolidayRequestList(workOnHolidayRequestList);
        entity.setOvertimeRequestList(overtimeRequestList);
        entity.setWorkTypeChangeRequestList(workTypeChangeRequestList);
        entity.setDifferenceRequestList(differenceRequestList);
        entity.setSubstitubeList(substitubeList);
        entity.setSubHolidayRequestList(subHolidayRequestList);
    }

    protected boolean isWorkflowNeeded(WorkflowDtoInterface dto, boolean isCompleted) {
        if (isCompleted) {
            return WorkflowUtility.isCompleted((WorkflowDtoInterface)dto);
        }
        return WorkflowUtility.isApplied((WorkflowDtoInterface)dto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)dto);
    }

    protected TotalTimeDataDtoInterface getTotalTimeData(TotalTimeEntityInterface entity) throws MospException {
        String personalId = entity.getPersonalId();
        int targetYear = entity.getCalculationYear();
        int targetMonth = entity.getCalculationMonth();
        String cutoffCode = entity.getCutoffCode();
        Date calculationDate = this.cutoffUtil.getCutoffCalculationDate(cutoffCode, targetYear, targetMonth);
        TotalTimeDataDtoInterface dto = this.totalTimeRegist.getInitDto();
        dto.setPersonalId(personalId);
        dto.setCalculationYear(targetYear);
        dto.setCalculationMonth(targetMonth);
        dto.setCalculationDate(calculationDate);
        dto.setWorkTime(entity.getWorkTime());
        dto.setTimesWorkDate(entity.getTimesWorkDate());
        dto.setTimesWork(entity.getTimesWork());
        dto.setLegalWorkOnHoliday(entity.getLegalWorkOnHoliday());
        dto.setSpecificWorkOnHoliday(entity.getSpecificWorkOnHoliday());
        dto.setTimesAchievement(entity.getTimesAchievement());
        dto.setTimesTotalWorkDate(entity.getTimesTotalWorkDate());
        dto.setDirectStart(entity.getDirectStart());
        dto.setDirectEnd(entity.getDirectEnd());
        dto.setRestTime(entity.getRestTime());
        dto.setRestLateNight(entity.getRestLateNight());
        dto.setRestWorkOnSpecificHoliday(entity.getRestWorkOnSpecificHoliday());
        dto.setRestWorkOnHoliday(entity.getRestWorkOnHoliday());
        dto.setPublicTime(entity.getPublicTime());
        dto.setPrivateTime(entity.getPrivateTime());
        dto.setMinutelyHolidayATime(entity.getMinutelyHolidayATime());
        dto.setMinutelyHolidayBTime(entity.getMinutelyHolidayBTime());
        dto.setOvertimeIn(entity.getOvertimeIn());
        dto.setOvertimeOut(entity.getOvertimeOut());
        dto.setOvertime(entity.getOvertime());
        dto.setLateNight(entity.getLateNight());
        dto.setNightWorkWithinPrescribedWork(entity.getNightWorkWithinPrescribedWork());
        dto.setNightOvertimeWork(entity.getNightOvertimeWork());
        dto.setNightWorkOnHoliday(entity.getNightWorkOnHoliday());
        dto.setWorkOnSpecificHoliday(entity.getWorkOnSpecificHoliday());
        dto.setWorkOnHoliday(entity.getWorkOnHoliday());
        dto.setDecreaseTime(entity.getDecreaseTime());
        dto.setFortyFiveHourOvertime(entity.getFortyFiveHourOvertime());
        dto.setTimesOvertime(entity.getTimesOvertime());
        dto.setTimesWorkingHoliday(entity.getTimesWorkingHoliday());
        dto.setLateDays(entity.getLateDays());
        dto.setLateThirtyMinutesOrMore(entity.getLateThirtyMinutesOrMore());
        dto.setLateLessThanThirtyMinutes(entity.getLateLessThanThirtyMinutes());
        dto.setLateTime(entity.getLateTime());
        dto.setLateThirtyMinutesOrMoreTime(entity.getLateThirtyMinutesOrMoreTime());
        dto.setLateLessThanThirtyMinutesTime(entity.getLateLessThanThirtyMinutesTime());
        dto.setTimesLate(entity.getTimesLate());
        dto.setLeaveEarlyDays(entity.getLeaveEarlyDays());
        dto.setLeaveEarlyThirtyMinutesOrMore(entity.getLeaveEarlyThirtyMinutesOrMore());
        dto.setLeaveEarlyLessThanThirtyMinutes(entity.getLeaveEarlyLessThanThirtyMinutes());
        dto.setLeaveEarlyTime(entity.getLeaveEarlyTime());
        dto.setLeaveEarlyThirtyMinutesOrMoreTime(entity.getLeaveEarlyThirtyMinutesOrMoreTime());
        dto.setLeaveEarlyLessThanThirtyMinutesTime(entity.getLeaveEarlyLessThanThirtyMinutesTime());
        dto.setTimesLeaveEarly(entity.getTimesLeaveEarly());
        dto.setTimesHoliday(entity.getTimesHoliday());
        dto.setTimesLegalHoliday(entity.getTimesLegalHoliday());
        dto.setTimesSpecificHoliday(entity.getTimesSpecificHoliday());
        dto.setTimesPaidHoliday(entity.getTimesPaidHoliday());
        dto.setPaidHolidayHour(entity.getPaidHolidayHour());
        dto.setTimesStockHoliday(entity.getTimesStockHoliday());
        dto.setTimesCompensation(entity.getTimesCompensation());
        dto.setTimesLegalCompensation(entity.getTimesLegalCompensation());
        dto.setTimesSpecificCompensation(entity.getTimesSpecificCompensation());
        dto.setTimesLateCompensation(entity.getTimesLateCompensation());
        dto.setTimesHolidaySubstitute(entity.getTimesHolidaySubstitute());
        dto.setTimesLegalHolidaySubstitute(entity.getTimesLegalHolidaySubstitute());
        dto.setTimesSpecificHolidaySubstitute(entity.getTimesSpecificHolidaySubstitute());
        dto.setTotalSpecialHoliday(entity.getTotalSpecialHoliday());
        dto.setSpecialHolidayHour(entity.getSpecialHolidayHour());
        dto.setTotalOtherHoliday(entity.getTotalOtherHoliday());
        dto.setOtherHolidayHour(entity.getOtherHolidayHour());
        dto.setTotalAbsence(entity.getTotalAbsence());
        dto.setAbsenceHour(entity.getAbsenceHour());
        dto.setTotalAllowance(entity.getTotalAllowance());
        dto.setSixtyHourOvertime(entity.getSixtyHourOvertime());
        dto.setWeekDayOvertime(entity.getWorkdayOvertimeOut());
        dto.setSpecificOvertime(entity.getPrescribedOvertimeOut());
        dto.setTimesAlternative(entity.getTimesAlternative());
        dto.setLegalCompensationOccurred(entity.getLegalCompensationOccurred());
        dto.setSpecificCompensationOccurred(entity.getSpecificCompensationOccurred());
        dto.setLateCompensationOccurred(entity.getLateCompensationOccurred());
        dto.setLegalCompensationUnused(entity.getLegalCompensationUnused());
        dto.setSpecificCompensationUnused(entity.getSpecificCompensationUnused());
        dto.setLateCompensationUnused(entity.getLateCompensationUnused());
        dto.setStatutoryHolidayWorkTimeIn(entity.getStatutoryHolidayWorkTimeIn());
        dto.setStatutoryHolidayWorkTimeOut(entity.getStatutoryHolidayWorkTimeOut());
        dto.setPrescribedHolidayWorkTimeIn(entity.getPrescribedHolidayWorkTimeIn());
        dto.setPrescribedHolidayWorkTimeOut(entity.getPrescribedHolidayWorkTimeOut());
        dto.setContractWorkTime(entity.getContractWorkTime());
        dto.setShortUnpaid(entity.getShortUnpaid());
        dto.setWeeklyOverFortyHourWorkTime(entity.getWeeklyOverFortyHourWorkTime());
        dto.setOvertimeInNoWeeklyForty(entity.getOvertimeInNoWeeklyForty());
        dto.setOvertimeOutNoWeeklyForty(entity.getOvertimeOutNoWeeklyForty());
        dto.setWeekDayOvertimeTotal(entity.getWorkdayOvertimeIn() + entity.getWorkdayOvertimeOut());
        dto.setWeekDayOvertimeInNoWeeklyForty(entity.getWeekDayOvertimeInNoWeeklyForty());
        dto.setWeekDayOvertimeOutNoWeeklyForty(entity.getWeekDayOvertimeOutNoWeeklyForty());
        dto.setWeekDayOvertimeIn(entity.getWorkdayOvertimeIn());
        dto.setPrescribedHolidayOvertimeIn(entity.getPrescribedHolidayOvertimeIn());
        dto.setGeneralIntItem1(entity.getGeneralIntItem1());
        dto.setGeneralIntItem2(entity.getGeneralIntItem2());
        dto.setGeneralIntItem3(entity.getGeneralIntItem3());
        dto.setGeneralIntItem4(entity.getGeneralIntItem4());
        dto.setGeneralIntItem5(entity.getGeneralIntItem5());
        dto.setGeneralDoubleItem1(entity.getGeneralDoubleItem1());
        dto.setGeneralDoubleItem2(entity.getGeneralDoubleItem2());
        dto.setGeneralDoubleItem3(entity.getGeneralDoubleItem3());
        dto.setGeneralDoubleItem4(entity.getGeneralDoubleItem4());
        dto.setGeneralDoubleItem5(entity.getGeneralDoubleItem5());
        dto.setGeneralValues(entity.getGeneralValues());
        dto.setSpecificWorkTime(entity.getWorkTime() - entity.getOvertime() - entity.getWorkOnHoliday());
        this.round(dto, this.getTimeSettingDtoForRound(entity));
        this.doAdditionalLogic(new Object[]{"Add_TotalTimeCalcBean_GetTotalTimeData", entity, dto});
        return dto;
    }

    protected void round(TotalTimeDataDtoInterface dto, TimeSettingDtoInterface setDto) {
        if (setDto == null) {
            return;
        }
        dto.setWorkTime(this.roundMonthlyWork(dto.getWorkTime(), setDto));
        dto.setRestTime(this.getRoundMinute(dto.getRestTime(), setDto.getRoundMonthlyRest(), setDto.getRoundMonthlyRestUnit()));
        dto.setRestLateNight(this.getRoundMinute(dto.getRestLateNight(), setDto.getRoundMonthlyRest(), setDto.getRoundMonthlyRestUnit()));
        dto.setRestWorkOnSpecificHoliday(this.getRoundMinute(dto.getRestWorkOnSpecificHoliday(), setDto.getRoundMonthlyRest(), setDto.getRoundMonthlyRestUnit()));
        dto.setRestWorkOnHoliday(this.getRoundMinute(dto.getRestWorkOnHoliday(), setDto.getRoundMonthlyRest(), setDto.getRoundMonthlyRestUnit()));
        dto.setPublicTime(this.getRoundMinute(dto.getPublicTime(), setDto.getRoundMonthlyPublic(), setDto.getRoundMonthlyPublicTime()));
        dto.setPrivateTime(this.getRoundMinute(dto.getPrivateTime(), setDto.getRoundMonthlyPrivate(), setDto.getRoundMonthlyPrivateTime()));
        dto.setOvertimeIn(this.roundMonthlyWork(dto.getOvertimeIn(), setDto));
        dto.setOvertimeOut(this.roundMonthlyWork(dto.getOvertimeOut(), setDto));
        dto.setOvertime(dto.getOvertimeIn() + dto.getOvertimeOut());
        dto.setLateNight(this.roundMonthlyWork(dto.getLateNight(), setDto));
        dto.setNightWorkWithinPrescribedWork(this.roundMonthlyWork(dto.getNightWorkWithinPrescribedWork(), setDto));
        dto.setNightOvertimeWork(this.roundMonthlyWork(dto.getNightOvertimeWork(), setDto));
        dto.setNightWorkOnHoliday(this.roundMonthlyWork(dto.getNightWorkOnHoliday(), setDto));
        dto.setWorkOnSpecificHoliday(this.roundMonthlyWork(dto.getWorkOnSpecificHoliday(), setDto));
        dto.setWorkOnHoliday(this.roundMonthlyWork(dto.getWorkOnHoliday(), setDto));
        dto.setDecreaseTime(this.getRoundMinute(dto.getDecreaseTime(), setDto.getRoundMonthlyDecrease(), setDto.getRoundMonthlyDecreaseTime()));
        dto.setFortyFiveHourOvertime(this.roundMonthlyWork(dto.getFortyFiveHourOvertime(), setDto));
        dto.setLateTime(this.getRoundMinute(dto.getLateTime(), setDto.getRoundMonthlyLate(), setDto.getRoundMonthlyLateUnit()));
        dto.setLateThirtyMinutesOrMoreTime(this.getRoundMinute(dto.getLateThirtyMinutesOrMoreTime(), setDto.getRoundMonthlyLate(), setDto.getRoundMonthlyLateUnit()));
        dto.setLateLessThanThirtyMinutesTime(this.getRoundMinute(dto.getLateLessThanThirtyMinutesTime(), setDto.getRoundMonthlyLate(), setDto.getRoundMonthlyLateUnit()));
        dto.setLeaveEarlyTime(this.getRoundMinute(dto.getLeaveEarlyTime(), setDto.getRoundMonthlyEarly(), setDto.getRoundMonthlyEarlyUnit()));
        dto.setLeaveEarlyThirtyMinutesOrMoreTime(this.getRoundMinute(dto.getLeaveEarlyThirtyMinutesOrMoreTime(), setDto.getRoundMonthlyEarly(), setDto.getRoundMonthlyEarlyUnit()));
        dto.setLeaveEarlyLessThanThirtyMinutesTime(this.getRoundMinute(dto.getLeaveEarlyLessThanThirtyMinutesTime(), setDto.getRoundMonthlyEarly(), setDto.getRoundMonthlyEarlyUnit()));
        dto.setSixtyHourOvertime(this.roundMonthlyWork(dto.getSixtyHourOvertime(), setDto));
        dto.setWeekDayOvertime(this.roundMonthlyWork(dto.getWeekDayOvertime(), setDto));
        dto.setSpecificOvertime(this.roundMonthlyWork(dto.getSpecificOvertime(), setDto));
        dto.setStatutoryHolidayWorkTimeIn(this.roundMonthlyWork(dto.getStatutoryHolidayWorkTimeIn(), setDto));
        dto.setStatutoryHolidayWorkTimeOut(this.roundMonthlyWork(dto.getStatutoryHolidayWorkTimeOut(), setDto));
        dto.setPrescribedHolidayWorkTimeIn(this.roundMonthlyWork(dto.getPrescribedHolidayWorkTimeIn(), setDto));
        dto.setPrescribedHolidayWorkTimeOut(this.roundMonthlyWork(dto.getPrescribedHolidayWorkTimeOut(), setDto));
        dto.setSpecificWorkTime(this.roundMonthlyWork(dto.getWorkTime() - dto.getOvertimeIn() - dto.getOvertimeOut() - dto.getWorkOnHoliday(), setDto));
        dto.setContractWorkTime(this.roundMonthlyWork(dto.getContractWorkTime(), setDto));
        dto.setShortUnpaid(this.getRoundMinute(dto.getShortUnpaid(), setDto.getRoundMonthlyShortUnpaid(), setDto.getRoundMonthlyShortUnpaidUnit()));
        dto.setWeeklyOverFortyHourWorkTime(this.roundMonthlyWork(dto.getWeeklyOverFortyHourWorkTime(), setDto));
        dto.setOvertimeInNoWeeklyForty(this.roundMonthlyWork(dto.getOvertimeInNoWeeklyForty(), setDto));
        dto.setOvertimeOutNoWeeklyForty(this.roundMonthlyWork(dto.getOvertimeOutNoWeeklyForty(), setDto));
        dto.setWeekDayOvertimeTotal(dto.getWeekDayOvertimeIn() + dto.getWeekDayOvertime());
        dto.setWeekDayOvertimeInNoWeeklyForty(this.roundMonthlyWork(dto.getWeekDayOvertimeInNoWeeklyForty(), setDto));
        dto.setWeekDayOvertimeOutNoWeeklyForty(this.roundMonthlyWork(dto.getWeekDayOvertimeOutNoWeeklyForty(), setDto));
        dto.setWeekDayOvertimeIn(this.roundMonthlyWork(dto.getWeekDayOvertimeIn(), setDto));
        dto.setGeneralIntItem1(this.roundMonthlyWork(dto.getGeneralIntItem1(), setDto));
        dto.setGeneralIntItem2(this.roundMonthlyWork(dto.getGeneralIntItem2(), setDto));
        dto.setGeneralIntItem3(this.roundMonthlyWork(dto.getGeneralIntItem3(), setDto));
        dto.setGeneralIntItem4(this.roundMonthlyWork(dto.getGeneralIntItem4(), setDto));
        dto.setGeneralIntItem5(this.roundMonthlyWork(dto.getGeneralIntItem5(), setDto));
    }

    protected TimeSettingDtoInterface getTimeSettingDtoForRound(TotalTimeEntityInterface entity) {
        Map map = entity.getTimeSettingMap();
        ArrayList targetDateList = new ArrayList(map.keySet());
        Collections.sort(targetDateList);
        Collections.reverse(targetDateList);
        for (Date targetDate : targetDateList) {
            TimeSettingDtoInterface dto = (TimeSettingDtoInterface)map.get(targetDate);
            if (dto == null) continue;
            return dto;
        }
        return null;
    }

    protected int roundMonthlyWork(int time, TimeSettingDtoInterface dto) {
        return this.getRoundMinute(time, dto.getRoundMonthlyWork(), dto.getRoundMonthlyWorkUnit());
    }
}

