/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.time.bean.TimeSettingRegistBeanInterface;
import jp.mosp.time.dao.settings.ApplicationDaoInterface;
import jp.mosp.time.dao.settings.TimeSettingDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmTimeSettingDto;

public class TimeSettingRegistBean
extends PlatformBean
implements TimeSettingRegistBeanInterface {
    protected TimeSettingDaoInterface dao;

    public TimeSettingRegistBean() {
    }

    public TimeSettingRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (TimeSettingDaoInterface)this.createDao(TimeSettingDaoInterface.class);
    }

    public TimeSettingDtoInterface getInitDto() {
        return new TmmTimeSettingDto();
    }

    public void insert(TimeSettingDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmTimeSettingId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(TimeSettingDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmTimeSettingId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            TimeSettingDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setTmmTimeSettingId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmTimeSettingId());
            dto.setTmmTimeSettingId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void update(TimeSettingDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmTimeSettingId());
        dto.setTmmTimeSettingId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(long recordId) throws MospException {
        TimeSettingDtoInterface dto = (TimeSettingDtoInterface)this.dao.findForKey(recordId, true);
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, recordId);
    }

    protected void checkInsert(TimeSettingDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getWorkSettingCode()));
    }

    protected void checkAdd(TimeSettingDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getWorkSettingCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkSettingCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List appList = this.getApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getWorkSettingCode(), appList);
    }

    protected void checkUpdate(TimeSettingDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmTimeSettingId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmTimeSettingId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkSettingCode());
        List appList = this.getApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getWorkSettingCode(), appList);
    }

    protected void checkDelete(TimeSettingDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDtoInterface)dto);
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkSettingCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List appList = this.getApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getWorkSettingCode(), appList);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            TimeSettingDtoInterface dto = (TimeSettingDtoInterface)this.dao.findForKey(id, false);
            this.checkExclusive((BaseDtoInterface)dto);
            list.add(dto.getWorkSettingCode());
        }
        return list;
    }

    protected void checkCodeIsUsed(String code, List<ApplicationDtoInterface> list) {
        String codeAdded = "";
        for (ApplicationDtoInterface dto : list) {
            if (!code.equals(dto.getWorkSettingCode()) || !this.isDtoActivate((BaseDtoInterface)dto) || codeAdded.equals(dto.getApplicationCode())) continue;
            this.addCodeIsUsedMessage(code, dto);
            codeAdded = dto.getApplicationCode();
        }
    }

    protected void validate(TimeSettingDtoInterface dto) {
    }

    protected void addCodeIsUsedMessage(String code, ApplicationDtoInterface dto) {
        String columnName = this.mospParams.getProperties().getName("WorkManage") + this.mospParams.getProperties().getName("Set");
        String[] aryRep = new String[]{code, dto.getApplicationCode(), columnName};
        this.mospParams.addErrorMessage("TMW0226", aryRep);
    }

    protected List<ApplicationDtoInterface> getApplicationListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        ApplicationDaoInterface appDao = (ApplicationDaoInterface)this.createDao(ApplicationDaoInterface.class);
        List appList = appDao.findForActivateDate(dto.getActivateDate());
        appList.addAll(appDao.findForCheckTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return appList;
    }
}

