/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dao.settings.LimitStandardDaoInterface;
import jp.mosp.time.dao.settings.TimeSettingDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;

public class TimeSettingReferenceBean
extends TimeBean
implements TimeSettingReferenceBeanInterface {
    private TimeSettingDaoInterface dao;
    private LimitStandardDaoInterface limitStandardDao;
    private ApplicationReferenceBeanInterface applicationReference;

    public TimeSettingReferenceBean() {
    }

    public TimeSettingReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (TimeSettingDaoInterface)this.createDao(TimeSettingDaoInterface.class);
        this.limitStandardDao = (LimitStandardDaoInterface)this.createDao(LimitStandardDaoInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
    }

    public TimeSettingDtoInterface getTimeSettingInfo(String workSettingCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(workSettingCode, targetDate);
    }

    public List<TimeSettingDtoInterface> getTimeSettingHistory(String timeSettingCode) throws MospException {
        return this.dao.findForHistory(timeSettingCode);
    }

    public String getTimeSettingAbbr(String workSettingCode, Date targetDate) throws MospException {
        TimeSettingDtoInterface dto = this.getTimeSettingInfo(workSettingCode, targetDate);
        if (dto == null) {
            return workSettingCode;
        }
        return dto.getWorkSettingAbbr();
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(targetDate, needBlank, true, true);
    }

    public TimeSettingDtoInterface findForKey(String workSettingCode, Date activateDate) throws MospException {
        return this.dao.findForKey(workSettingCode, activateDate);
    }

    protected String[][] getSelectArray(Date targetDate, boolean needBlank, boolean isName, boolean viewCode) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (TimeSettingDtoInterface dto : list) {
            array[idx][0] = dto.getWorkSettingCode();
            if (isName && viewCode) {
                array[idx++][1] = this.getCodedName(dto.getWorkSettingCode(), dto.getWorkSettingName(), length);
                continue;
            }
            if (isName) {
                array[idx++][1] = dto.getWorkSettingName();
                continue;
            }
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getWorkSettingCode(), dto.getWorkSettingAbbr(), length);
                continue;
            }
            array[idx++][1] = dto.getWorkSettingAbbr();
        }
        return array;
    }

    protected int getMaxCodeLength(List<TimeSettingDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (TimeSettingDtoInterface dto : list) {
            if (dto.getWorkSettingCode().length() <= length) continue;
            length = dto.getWorkSettingCode().length();
        }
        return length;
    }

    public List<String> getWorkSettingCode(String cutoffcode, Date activateDate) throws MospException {
        ArrayList<String> workSettingCodeList = new ArrayList<String>();
        List list = this.dao.findForInfoList(cutoffcode, activateDate);
        if (list.isEmpty()) {
            return workSettingCodeList;
        }
        for (int i = 0; i < list.size(); ++i) {
            workSettingCodeList.add(((TimeSettingDtoInterface)list.get(i)).getWorkSettingCode());
        }
        return workSettingCodeList;
    }

    public int getGeneralWorkTime(String workSettingCode, Date targetDate) throws MospException {
        TimeSettingDtoInterface dto = this.getTimeSettingInfo(workSettingCode, targetDate);
        if (dto == null) {
            return 480;
        }
        return DateUtility.getHour((Date)dto.getGeneralWorkTime()) * 60 + DateUtility.getMinute((Date)dto.getGeneralWorkTime());
    }

    public int getGeneralWorkHour(String workSettingCode, Date targetDate) throws MospException {
        TimeSettingDtoInterface dto = this.getTimeSettingInfo(workSettingCode, targetDate);
        if (dto == null) {
            return 8;
        }
        int hour = DateUtility.getHour((Date)dto.getGeneralWorkTime());
        if (DateUtility.getMinute((Date)dto.getGeneralWorkTime()) == 0) {
            return hour;
        }
        return hour + 1;
    }

    public void chkExistTimeSetting(TimeSettingDtoInterface dto, Date targetDate) {
        if (dto != null) {
            return;
        }
        String stringDate = this.getStringDate(targetDate);
        if (stringDate == null || stringDate.isEmpty()) {
            stringDate = this.getStringDate(this.getSystemDate());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("WorkManage"));
        sb.append(this.mospParams.getName("Set"));
        sb.append(this.mospParams.getName("Information"));
        this.mospParams.addErrorMessage("TMW0246", new String[]{stringDate, sb.toString()});
    }

    public Integer getBeforeOvertimeFlag(String personalId, Date targetDate) throws MospException {
        ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(personalId, targetDate);
        this.applicationReference.chkExistApplication(applicationDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        TimeSettingDtoInterface dto = this.dao.findForInfo(applicationDto.getWorkSettingCode(), targetDate);
        this.chkExistTimeSetting(dto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        return dto.getBeforeOvertimeFlag();
    }

    public String[][] getSelectArray(Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(targetDate, needBlank, false, false);
    }

    public boolean isProspectsMonth(int targetMonth, String prospectsMonths) {
        String[] aryMonths;
        if (prospectsMonths == null) {
            return false;
        }
        for (String month : aryMonths = MospUtility.split((String)prospectsMonths, (String)",")) {
            if (!month.equals(String.valueOf(targetMonth))) continue;
            return true;
        }
        return false;
    }

    public boolean isProspectsMonth(Date targetDate, String prospectsMonths) {
        int targetMonth = DateUtility.getMonth((Date)targetDate);
        return this.isProspectsMonth(targetMonth, prospectsMonths);
    }

    public String getPerformanceInputModeString() {
        return this.mospParams.getName("Performance", new String[]{"Input", "Medium"});
    }

    public TimeSettingEntityInterface getEntity(String workSettingCode, Date targetDate) throws MospException {
        return this.getEntity(this.dao.findForInfo(workSettingCode, targetDate));
    }

    public TimeSettingEntityInterface getEntityForKey(String workSettingCode, Date activateDate) throws MospException {
        return this.getEntity(this.dao.findForKey(workSettingCode, activateDate));
    }

    public TimeSettingEntityInterface getEntity(TimeSettingDtoInterface dto) throws MospException {
        TimeSettingEntityInterface entity = (TimeSettingEntityInterface)this.createObject(TimeSettingEntityInterface.class);
        entity.setTimeSettingDto(dto);
        if (!entity.isExist()) {
            return entity;
        }
        String workSettingCode = dto.getWorkSettingCode();
        Date activateDate = dto.getActivateDate();
        entity.setLimitStandardDtos(this.getLimitStandards(workSettingCode, activateDate));
        return entity;
    }

    protected Map<String, LimitStandardDtoInterface> getLimitStandards(String workSettingCode, Date activateDate) throws MospException {
        HashMap<String, LimitStandardDtoInterface> limits = new HashMap<String, LimitStandardDtoInterface>();
        if (MospUtility.isEmpty((String[])new String[]{workSettingCode}) || activateDate == null) {
            return limits;
        }
        for (LimitStandardDtoInterface limit : this.limitStandardDao.findForSearch(workSettingCode, activateDate)) {
            limits.put(limit.getTerm(), limit);
        }
        return limits;
    }
}

