/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.TimeRecordBeanInterface;
import jp.mosp.time.bean.TimeRecordReferenceBeanInterface;
import jp.mosp.time.bean.TimeRecordRegistBeanInterface;
import jp.mosp.time.bean.impl.AttendanceListRegistBean;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.TimeRecordDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.entity.WorkTypeEntity;
import jp.mosp.time.utils.AttendanceUtility;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeUtility;

public class TimeRecordBean
extends AttendanceListRegistBean
implements TimeRecordBeanInterface {
    protected static final int MAX_REST_TIMES = 6;
    protected TimeRecordReferenceBeanInterface timeRecordReference;
    protected TimeRecordRegistBeanInterface timeRecordRegist;
    protected RequestUtilBeanInterface requestUtil;
    protected AttendanceTransactionRegistBeanInterface transactionRegist;

    public void initBean() throws MospException {
        super.initBean();
        this.timeRecordReference = (TimeRecordReferenceBeanInterface)this.createBean(TimeRecordReferenceBeanInterface.class);
        this.timeRecordRegist = (TimeRecordRegistBeanInterface)this.createBean(TimeRecordRegistBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        this.transactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBean(AttendanceTransactionRegistBeanInterface.class);
    }

    public Date recordStartWork(String personalId, Date recordTime) throws MospException {
        this.recordPortalTime(personalId, recordTime, recordTime, "StartWork");
        this.personalId = personalId;
        this.targetDate = DateUtility.getDate((Date)recordTime);
        AttendanceDtoInterface dto = this.attendanceReference.findForKey(this.personalId, this.targetDate, 1);
        if (dto != null) {
            this.mospParams.addErrorMessage("TMW0301", new String[]{DateUtility.getStringDate((Date)this.targetDate), this.mospParams.getName("WorkManage"), this.mospParams.getName("RecordTime")});
            return null;
        }
        ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
        RequestEntity requestEntity = this.requestUtil.getRequestEntity(personalId, this.targetDate);
        WorkTypeEntity workTypeEntity = this.workTypeReference.getWorkTypeEntity(requestEntity.getWorkType(), this.targetDate);
        if (!workTypeEntity.isWorkTypeForWork()) {
            this.addNotWorkDateErrorMessage(this.targetDate);
            return null;
        }
        Date startTime = AttendanceUtility.getStartTime((ApplicationEntity)applicationEntity, (RequestEntity)requestEntity, (WorkTypeEntity)workTypeEntity, (Date)recordTime);
        dto = this.getAttendanceDto(startTime, startTime, null, false, false, false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setDirectStartEnd(dto, workTypeEntity);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.checkTimeExist(dto);
        this.attendanceRegist.checkValidate(dto);
        this.attendanceRegist.checkDraft(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.draft(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List restList = this.registRest(startTime, workTypeEntity.getEndTime(requestEntity));
        for (RestDtoInterface restDto : restList) {
            this.restRegist.regist(restDto);
        }
        this.attendanceRegist.regist(dto);
        return recordTime;
    }

    public Date recordEndWork(String personalId, Date recordTime) throws MospException {
        this.personalId = personalId;
        AttendanceDtoInterface dto = this.setTargetDate(TimeMessageUtility.getNameEndWork((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.recordPortalTime(personalId, this.targetDate, recordTime, "EndWork");
        this.checkRestEnd();
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.apply(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
        RequestEntity requestEntity = this.requestUtil.getRequestEntity(personalId, this.targetDate);
        WorkTypeEntity workTypeEntity = this.workTypeReference.getWorkTypeEntity(dto.getWorkTypeCode(), this.targetDate);
        Date endTime = this.getEndTime(applicationEntity, requestEntity, workTypeEntity, recordTime);
        dto = this.getAttendanceDto(dto.getStartTime(), dto.getActualStartTime(), endTime, false, true, false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setDirectStartEnd(dto, workTypeEntity);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.checkTimeExist(dto);
        this.attendanceRegist.checkValidate(dto);
        this.attendanceRegist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.regist(dto);
        this.transactionRegist.regist(dto);
        this.registSubHoliday(dto);
        this.afterApplyAttendance(dto);
        return recordTime;
    }

    protected Date getEndTime(ApplicationEntity applicationEntity, RequestEntity requestEntity, WorkTypeEntity workTypeEntity, Date recordTime) throws MospException {
        Date scheduledTime = workTypeEntity.getEndTime(requestEntity);
        if (workTypeEntity.isDirectEnd()) {
            return scheduledTime;
        }
        if (recordTime.before(scheduledTime)) {
            if (applicationEntity.useScheduledTime()) {
                return applicationEntity.getRoundedEndTime(recordTime);
            }
            return applicationEntity.getRoundedActualEndTime(recordTime);
        }
        if (applicationEntity.useScheduledTime()) {
            return applicationEntity.getRoundedEndTime(recordTime);
        }
        return applicationEntity.getRoundedActualEndTime(recordTime);
    }

    public Date recordStartRest(String personalId, Date recordTime) throws MospException {
        this.personalId = personalId;
        this.setTargetDate(TimeMessageUtility.getNameStartRest((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List list = this.restDao.findForList(this.personalId, this.targetDate, 1);
        List publicList = this.goOutReference.getPublicGoOutList(personalId, this.targetDate);
        List privateList = this.goOutReference.getPrivateGoOutList(personalId, this.targetDate);
        for (GoOutDtoInterface goOutDto : publicList) {
            if (!this.checkRestDuplication(recordTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Official", new String[]{"GoingOut"}));
            sb.append(goOutDto.getTimesGoOut());
            this.addStartRestDuplicationErrorMessage(DateUtility.getStringDateAndDay((Date)recordTime), sb.toString());
            return null;
        }
        for (GoOutDtoInterface goOutDto : privateList) {
            if (!this.checkRestDuplication(recordTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
            this.addStartRestDuplicationErrorMessage(DateUtility.getStringDateAndDay((Date)recordTime), this.mospParams.getName("PrivateGoingOut" + goOutDto.getTimesGoOut()));
            return null;
        }
        Date restDefaultTime = this.targetDate;
        RestDtoInterface dto = null;
        ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
        for (RestDtoInterface restDto : list) {
            if (this.checkRestDuplication(recordTime, restDto.getRestStart(), restDto.getRestEnd())) {
                this.addStartRestDuplicationErrorMessage(DateUtility.getStringDateAndDay((Date)recordTime), this.mospParams.getName("Rest" + restDto.getRest()));
                return null;
            }
            if (restDefaultTime.equals(restDto.getRestStart())) {
                dto = restDto;
                dto.setRestStart(applicationEntity.getRoundedRestStartTime(recordTime));
                break;
            }
            if (!restDefaultTime.equals(restDto.getRestEnd())) continue;
            TimeMessageUtility.addErrorStartRestAlreadyRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        if (dto == null && list.size() < 6) {
            dto = this.restRegist.getInitDto();
            dto.setPersonalId(this.personalId);
            dto.setWorkDate(this.targetDate);
            dto.setTimesWork(1);
            dto.setRest(list.size() + 1);
            dto.setRestStart(applicationEntity.getRoundedRestStartTime(recordTime));
            dto.setRestEnd(restDefaultTime);
            dto.setRestTime(0);
        }
        if (dto == null) {
            TimeMessageUtility.addErrorRestOverLimit((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        this.restRegist.regist(dto);
        return recordTime;
    }

    public Date recordEndRest(String personalId, Date recordTime) throws MospException {
        this.personalId = personalId;
        this.setTargetDate(TimeMessageUtility.getNameEndRest((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setTimeDtos(false, false);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List list = this.restDao.findForList(this.personalId, this.targetDate, 1);
        List publicList = this.goOutReference.getPublicGoOutList(personalId, this.targetDate);
        List privateList = this.goOutReference.getPrivateGoOutList(personalId, this.targetDate);
        for (GoOutDtoInterface goOutDto : publicList) {
            if (!this.checkRestDuplication(recordTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Official", new String[]{"GoingOut"}));
            sb.append(goOutDto.getTimesGoOut());
            this.addEndRestDuplicationErrorMessage(DateUtility.getStringDateAndDay((Date)recordTime), sb.toString());
            return null;
        }
        for (GoOutDtoInterface goOutDto : privateList) {
            if (!this.checkRestDuplication(recordTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
            this.addEndRestDuplicationErrorMessage(DateUtility.getStringDateAndDay((Date)recordTime), this.mospParams.getName("PrivateGoingOut" + goOutDto.getTimesGoOut()));
            return null;
        }
        Date restDefaultTime = this.targetDate;
        ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
        RestDtoInterface dto = null;
        for (RestDtoInterface restDto : list) {
            if (this.checkRestDuplication(recordTime, restDto.getRestStart(), restDto.getRestEnd())) {
                this.addEndRestDuplicationErrorMessage(DateUtility.getStringDateAndDay((Date)recordTime), this.mospParams.getName("Rest" + restDto.getRest()));
                return null;
            }
            if (restDefaultTime.equals(restDto.getRestStart()) || !restDefaultTime.equals(restDto.getRestEnd())) continue;
            dto = restDto;
            dto.setRestEnd(applicationEntity.getRoundedRestEndTime(recordTime));
            dto.setRestTime(this.restRegist.getCalcRestTime(dto.getRestStart(), dto.getRestEnd(), this.timeSettingDto));
            break;
        }
        if (dto == null) {
            TimeMessageUtility.addErrorStartRestNotRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        this.restRegist.regist(dto);
        return recordTime;
    }

    public Date recordRegularEnd(String personalId, Date recordTime) throws MospException {
        WorkTypeEntity workTypeEntity;
        this.personalId = personalId;
        AttendanceDtoInterface dto = this.setTargetDate(TimeMessageUtility.getNameRegularEnd((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.recordPortalTime(personalId, this.targetDate, recordTime, "EndWork");
        this.checkRestEnd();
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.applyAndApprove(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        RequestEntity requestEntity = this.requestUtil.getRequestEntity(personalId, this.targetDate);
        if (this.isLate(requestEntity, workTypeEntity = this.workTypeReference.getWorkTypeEntity(dto.getWorkTypeCode(), this.targetDate), dto.getStartTime()) || this.isLeaveEarly(requestEntity, workTypeEntity, recordTime)) {
            ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
            Date targetTime = applicationEntity.getRoundedEndTime(recordTime);
            this.mospParams.addGeneralParam("prmTargetPersonalId", (Object)personalId);
            this.mospParams.addGeneralParam("prmTargetDate", (Object)this.targetDate);
            this.mospParams.addGeneralParam("prmTargetTime", (Object)targetTime);
            this.mospParams.setNextCommand("TM1206");
            TimeMessageUtility.addErrorSelfApproveFailed((MospParams)this.mospParams);
            return null;
        }
        Date endTime = workTypeEntity.getEndTime(requestEntity);
        if (requestEntity.getWorkOnHolidayStartTime(false) != null) {
            ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
            endTime = this.getEndTime(applicationEntity, requestEntity, workTypeEntity, recordTime);
        }
        dto = this.getAttendanceDto(dto.getStartTime(), dto.getActualStartTime(), endTime, false, true, false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setDirectStartEnd(dto, workTypeEntity);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.checkTimeExist(dto);
        this.attendanceRegist.checkValidate(dto);
        this.attendanceRegist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.regist(dto);
        this.transactionRegist.regist(dto);
        this.registSubHoliday(dto);
        this.afterApplyAttendance(dto);
        return recordTime;
    }

    protected boolean isLate(RequestEntity requestEntity, WorkTypeEntity workTypeEntity, Date startTime) throws MospException {
        Date short1EndTime;
        Date scheduledStartTime = workTypeEntity.getStartTime(requestEntity);
        boolean isLate = scheduledStartTime.before(startTime);
        if (requestEntity.isAttendanceDirectStart()) {
            isLate = false;
        }
        if (workTypeEntity.isDirectStart()) {
            isLate = false;
        }
        if (requestEntity.getWorkOnHolidayStartTime(false) != null) {
            isLate = false;
        }
        if (workTypeEntity.isShort1TimeSet() && workTypeEntity.isShort1TypePay() && !startTime.after(short1EndTime = TimeUtility.getDateTime((Date)this.targetDate, (Date)workTypeEntity.getShort1EndTime()))) {
            isLate = false;
        }
        return isLate;
    }

    protected boolean isLeaveEarly(RequestEntity requestEntity, WorkTypeEntity workTypeEntity, Date endTime) throws MospException {
        Date short2StartTime;
        Date scheduledEndTime = workTypeEntity.getEndTime(requestEntity);
        boolean isLeaveEarly = scheduledEndTime.after(endTime);
        if (requestEntity.isAttendanceDirectEnd()) {
            isLeaveEarly = false;
        }
        if (workTypeEntity.isDirectEnd()) {
            isLeaveEarly = false;
        }
        if (requestEntity.getWorkOnHolidayStartTime(false) != null) {
            isLeaveEarly = false;
        }
        if (workTypeEntity.isShort2TimeSet() && workTypeEntity.isShort2TypePay() && !endTime.before(short2StartTime = TimeUtility.getDateTime((Date)this.targetDate, (Date)workTypeEntity.getShort2StartTime()))) {
            isLeaveEarly = false;
        }
        return isLeaveEarly;
    }

    public void recordOverEnd(String personalId, Date recordTime) throws MospException {
        this.personalId = personalId;
        AttendanceDtoInterface dto = this.setTargetDate(TimeMessageUtility.getNameOverEnd((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.recordPortalTime(personalId, this.targetDate, recordTime, "EndWork");
        ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
        Date targetTime = applicationEntity.getRoundedEndTime(recordTime);
        this.mospParams.addGeneralParam("prmTargetPersonalId", (Object)personalId);
        this.mospParams.addGeneralParam("prmTargetDate", (Object)this.targetDate);
        this.mospParams.addGeneralParam("prmTargetTime", (Object)targetTime);
        if (dto != null && dto.getWorkTypeCode() != null) {
            WorkTypeEntity workTypeEntity = this.workTypeReference.getWorkTypeEntity(dto.getWorkTypeCode(), this.targetDate);
            if (workTypeEntity.isDirectStart()) {
                this.mospParams.addGeneralParam("transferredDirectStart", (Object)"1");
            }
            if (workTypeEntity.isDirectEnd()) {
                this.mospParams.addGeneralParam("transferredDirectEnd", (Object)"1");
            }
        }
        this.mospParams.setNextCommand("TM1206");
    }

    public Date recordRegularWork(String personalId, Date recordTime) throws MospException {
        this.recordPortalTime(personalId, recordTime, recordTime, "StartWork");
        this.personalId = personalId;
        this.targetDate = DateUtility.getDate((Date)recordTime);
        AttendanceDtoInterface dto = this.attendanceReference.findForKey(this.personalId, this.targetDate, 1);
        if (dto != null) {
            TimeMessageUtility.addErrorStartWorkAlreadyRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        RequestEntity requestEntity = this.requestUtil.getRequestEntity(personalId, this.targetDate);
        WorkTypeEntity workTypeEntity = this.workTypeReference.getWorkTypeEntity(requestEntity.getWorkType(), this.targetDate);
        if (!workTypeEntity.isWorkTypeForWork()) {
            this.addNotWorkDateErrorMessage(this.targetDate);
            return null;
        }
        Date startTime = workTypeEntity.getStartTime(requestEntity);
        Date endTime = workTypeEntity.getEndTime(requestEntity);
        dto = this.getAttendanceDto(startTime, startTime, endTime, false, true, false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setDirectStartEnd(dto, workTypeEntity);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.checkTimeExist(dto);
        this.attendanceRegist.checkValidate(dto);
        this.attendanceRegist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.applyAndApprove(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List restList = this.registRest(startTime, endTime);
        for (RestDtoInterface restDto : restList) {
            this.restRegist.regist(restDto);
        }
        this.attendanceRegist.regist(dto);
        this.transactionRegist.regist(dto);
        this.registSubHoliday(dto);
        return recordTime;
    }

    public Date recordStartWork() throws MospException {
        return this.recordStartWork(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordEndWork() throws MospException {
        return this.recordEndWork(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordStartRest() throws MospException {
        return this.recordStartRest(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordEndRest() throws MospException {
        return this.recordEndRest(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordRegularEnd() throws MospException {
        return this.recordRegularEnd(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public void recordOverEnd() throws MospException {
        this.recordOverEnd(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordRegularWork() throws MospException {
        return this.recordRegularWork(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    protected AttendanceDtoInterface setTargetDate(String process) throws MospException {
        Date recordDate = this.getSystemDate();
        AttendanceDtoInterface dto = this.attendanceReference.findForKey(this.personalId, recordDate, 1);
        if (dto == null) {
            Date beforeDate = this.addDay(recordDate, -1);
            dto = this.attendanceReference.findForKey(this.personalId, beforeDate, 1);
            if (dto != null && dto.getEndTime() == null) {
                this.targetDate = beforeDate;
            } else {
                TimeMessageUtility.addErrorStratWorkNotRecorded((MospParams)this.mospParams, (Date)recordDate, (String)process);
            }
        } else if (dto.getEndTime() != null) {
            TimeMessageUtility.addErrorEndWorkAlreadyRecorded((MospParams)this.mospParams, (Date)recordDate);
        } else {
            this.targetDate = recordDate;
        }
        return dto;
    }

    protected void setDirectStartEnd(AttendanceDtoInterface dto, WorkTypeEntity workTypeEntity) throws MospException {
        if (workTypeEntity.isDirectStart()) {
            dto.setDirectStart(this.getInteger("1").intValue());
        }
        if (workTypeEntity.isDirectEnd()) {
            dto.setDirectEnd(this.getInteger("1").intValue());
        }
    }

    protected boolean checkRestDuplication(Date recordTime, Date startTime, Date endTime) throws MospException {
        Date defaultTime = this.targetDate;
        return !defaultTime.equals(startTime) && !defaultTime.equals(endTime) && !recordTime.before(startTime) && recordTime.before(endTime);
    }

    protected void addStartRestDuplicationErrorMessage(String stringTagetDate, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("RestTime"));
        sb.append(this.mospParams.getName("Into"));
        String[] rep = new String[]{stringTagetDate, sb.toString(), name};
        this.mospParams.addErrorMessage("TMW0312", rep);
    }

    protected void addEndRestDuplicationErrorMessage(String stringTagetDate, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("RestTime"));
        sb.append(this.mospParams.getName("Return"));
        String[] rep = new String[]{stringTagetDate, sb.toString(), name};
        this.mospParams.addErrorMessage("TMW0312", rep);
    }

    protected void recordPortalTime(String personalId, Date workDate, Date recordTime, String recordType) throws MospException {
        if (this.timeRecordReference.findForKey(personalId, workDate, 1, recordType) != null) {
            return;
        }
        TimeRecordDtoInterface dto = this.timeRecordRegist.getInitDto();
        dto.setPersonalId(personalId);
        dto.setWorkDate(workDate);
        dto.setTimesWork(1);
        dto.setRecordType(recordType);
        dto.setRecordTime(recordTime);
        this.timeRecordRegist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.timeRecordRegist.commit();
    }

    protected void checkRestEnd() throws MospException {
        List list = this.restDao.findForList(this.personalId, this.targetDate, 1);
        for (RestDtoInterface restDto : list) {
            if (this.targetDate.equals(restDto.getRestStart()) || !this.targetDate.equals(restDto.getRestEnd())) continue;
            TimeMessageUtility.addErrorEndRestNotRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return;
        }
    }

    protected void applyAndApprove(AttendanceDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto = this.workflowRegist.getInitDto();
        if (dto.getWorkflow() != 0L) {
            workflowDto = this.workflow.getLatestWorkflowInfo(dto.getWorkflow());
        }
        workflowDto.setApproverId("SELF_APPRO");
        workflowDto.setFunctionCode("1");
        workflowDto = this.workflowRegist.appli(workflowDto, this.personalId, this.targetDate, 1, null);
        if (workflowDto == null) {
            return;
        }
        dto.setWorkflow(workflowDto.getWorkflow());
    }
}

