/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.ExtraHumanDeleteBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.utils.TimeUtility;

public class TimeHumanDeleteBean
extends TimeBean
implements ExtraHumanDeleteBeanInterface {
    private WorkflowReferenceBeanInterface workflowReference;
    private ApplicationReferenceBeanInterface applicationReference;
    private PaidHolidayTransactionReferenceBeanInterface paidHolidayTransaction;
    private HolidayInfoReferenceBeanInterface holidayInfoReference;
    private TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployeeReference;

    public TimeHumanDeleteBean() {
    }

    public TimeHumanDeleteBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.paidHolidayTransaction = (PaidHolidayTransactionReferenceBeanInterface)this.createBean(PaidHolidayTransactionReferenceBeanInterface.class);
        this.holidayInfoReference = (HolidayInfoReferenceBeanInterface)this.createBean(HolidayInfoReferenceBeanInterface.class);
        this.totalTimeEmployeeReference = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBean(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
    }

    public Set<String> getTargetTable() {
        HashSet<String> lockTableSet = new HashSet<String>();
        return lockTableSet;
    }

    public void humanDelete(HumanDtoInterface dto, boolean isAllDelete) {
    }

    public void checkDelete(List<HumanDtoInterface> list, int deleateIndex, int deleteCase) throws MospException {
        switch (deleteCase) {
            case 1: {
                HumanDtoInterface deleateHumanDto = list.get(deleateIndex);
                Date endDate = null;
                this.checkWorkflow(deleateHumanDto, endDate);
                this.checkCutoff(deleateHumanDto, endDate);
                this.checkExist(deleateHumanDto, endDate);
                break;
            }
            case 2: {
                HumanDtoInterface humanDto = list.get(deleateIndex);
                HumanDtoInterface afterHumanDto = list.get(deleateIndex + 1);
                Date endDate = DateUtility.addDay((Date)afterHumanDto.getActivateDate(), (int)-1);
                this.checkWorkflow(humanDto, endDate);
                this.checkCutoff(humanDto, endDate);
                this.checkExist(humanDto, endDate);
                break;
            }
        }
    }

    protected void checkWorkflow(HumanDtoInterface deleteHumanDto, Date endDate) throws MospException {
        Date startDate = deleteHumanDto.getActivateDate();
        List list = this.workflowReference.getPersonalList(deleteHumanDto.getPersonalId(), startDate, endDate, TimeUtility.getTimeFunctionSet());
        if (!list.isEmpty()) {
            this.addDeleteTimeErrorMessage(this.mospParams.getName("WorkManage"), this.mospParams.getName("Application"));
            return;
        }
    }

    protected void checkExist(HumanDtoInterface deleteHumanDto, Date endDate) throws MospException {
        this.checkApplication(deleteHumanDto, endDate);
        this.checkPaidHoliday(deleteHumanDto, endDate);
        this.checkSpecialHoliday(deleteHumanDto, endDate);
        this.checkOtherHoliday(deleteHumanDto, endDate);
    }

    protected void checkCutoff(HumanDtoInterface deleteHumanDto, Date endDate) throws MospException {
        Date startDate = deleteHumanDto.getActivateDate();
        if (this.totalTimeEmployeeReference.getCutoffTermState(deleteHumanDto.getPersonalId(), startDate, endDate)) {
            this.addDeleteTimeErrorMessage(this.mospParams.getName("WorkManage") + this.mospParams.getName("Total"), this.mospParams.getName("Information"));
        }
    }

    protected void checkApplication(HumanDtoInterface deleteDto, Date endDate) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        if (this.applicationReference.hasPersonalApplication(deleteDto.getPersonalId(), startDate, endDate)) {
            this.addDeleteErrorMessage(deleteDto.getEmployeeCode(), this.mospParams.getName("Set") + this.mospParams.getName("Apply"));
        }
    }

    protected void checkPaidHoliday(HumanDtoInterface deleteDto, Date endDate) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        if (this.paidHolidayTransaction.hasPersonalApplication(deleteDto.getPersonalId(), startDate, endDate)) {
            this.addDeleteErrorMessage(deleteDto.getEmployeeCode(), this.mospParams.getName("PaidHoliday"));
        }
    }

    protected void checkSpecialHoliday(HumanDtoInterface deleteDto, Date endDate) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        if (this.holidayInfoReference.hasPersonalApplication(deleteDto.getPersonalId(), startDate, endDate, 2)) {
            this.addDeleteErrorMessage(deleteDto.getEmployeeCode(), this.mospParams.getName("Specially") + this.mospParams.getName("Vacation"));
        }
    }

    protected void checkOtherHoliday(HumanDtoInterface deleteDto, Date endDate) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        if (this.holidayInfoReference.hasPersonalApplication(deleteDto.getPersonalId(), startDate, endDate, 3)) {
            this.addDeleteErrorMessage(deleteDto.getEmployeeCode(), this.mospParams.getName("Others") + this.mospParams.getName("Vacation"));
        }
    }

    protected void addDeleteTimeErrorMessage(String errorTargetName, String activeName) {
        this.mospParams.addErrorMessage("TMW0217", new String[]{errorTargetName, activeName});
    }

    protected void addDeleteErrorMessage(String employeeCode, String errorTargetName) {
        this.mospParams.addErrorMessage("PFW9118", new String[]{employeeCode, errorTargetName});
    }
}

