/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;

public class SubstituteReferenceBean
extends TimeBean
implements SubstituteReferenceBeanInterface {
    protected SubstituteDaoInterface dao;
    protected WorkflowIntegrateBeanInterface workflow;

    public SubstituteReferenceBean() {
    }

    public SubstituteReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (SubstituteDaoInterface)this.createDao(SubstituteDaoInterface.class);
        this.workflow = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
    }

    public SubstituteDtoInterface getSubstituteDto(String personalId, Date workDate) throws MospException {
        List list = this.dao.findForWorkDate(personalId, workDate);
        for (SubstituteDtoInterface dto : list) {
            if (this.workflow.isWithDrawn(dto.getWorkflow())) continue;
            return dto;
        }
        return null;
    }

    public List<SubstituteDtoInterface> getSubstituteList(String personalId, Date substituteDate) throws MospException {
        return this.dao.findForList(personalId, substituteDate);
    }

    public List<SubstituteDtoInterface> getSubstituteList(long workflow) throws MospException {
        return this.dao.findForWorkflow(workflow);
    }

    public List<SubstituteDtoInterface> getSubstituteList(String personalId, Date firstDate, Date lastDate) throws MospException {
        return this.dao.findForTerm(personalId, firstDate, lastDate);
    }

    public void chkBasicInfo(String personalId, Date targetDate) throws MospException {
        this.initial(personalId, targetDate, "4");
    }

    public Date getSubstituteDate(long workflow) throws MospException {
        List list = this.getSubstituteList(workflow);
        if (list.isEmpty()) {
            return null;
        }
        return ((SubstituteDtoInterface)list.get(0)).getSubstituteDate();
    }
}

