/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.impl.HumanSubordinateBean;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.HolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.SubordinateFiscalSearchBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeCalcBeanInterface;
import jp.mosp.time.bean.TotalTimeReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.SubordinateFiscalListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.impl.SubordinateFiscalListDto;
import jp.mosp.time.utils.TimeUtility;

public class SubordinateFiscalSearchBean
extends HumanSubordinateBean
implements SubordinateFiscalSearchBeanInterface {
    protected TotalTimeCalcBeanInterface totalTimeCalc;
    protected TotalTimeReferenceBeanInterface totalTimeRefer;
    protected PaidHolidayInfoReferenceBeanInterface paidHolidayInfo;
    protected StockHolidayInfoReferenceBeanInterface stockHolidayInfo;
    protected HolidayRequestReferenceBeanInterface holidayRequestRefer;
    protected AttendanceReferenceBeanInterface attendanceRefer;
    protected HolidayDataReferenceBeanInterface holidayDataRefer;
    protected TimeMasterBeanInterface timeMaster;
    protected int displayYear;
    protected int targetYear;
    protected int targetMonth;
    protected String humanType;

    public SubordinateFiscalSearchBean() {
    }

    public void initBean() throws MospException {
        super.initBean();
        this.totalTimeCalc = (TotalTimeCalcBeanInterface)this.createBean(TotalTimeCalcBeanInterface.class);
        this.paidHolidayInfo = (PaidHolidayInfoReferenceBeanInterface)this.createBean(PaidHolidayInfoReferenceBeanInterface.class);
        this.stockHolidayInfo = (StockHolidayInfoReferenceBeanInterface)this.createBean(StockHolidayInfoReferenceBeanInterface.class);
        this.holidayRequestRefer = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.totalTimeRefer = (TotalTimeReferenceBeanInterface)this.createBean(TotalTimeReferenceBeanInterface.class);
        this.attendanceRefer = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.holidayDataRefer = (HolidayDataReferenceBeanInterface)this.createBean(HolidayDataReferenceBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBean(TimeMasterBeanInterface.class);
        this.paidHolidayInfo.setTimeMasterBean(this.timeMaster);
    }

    public SubordinateFiscalSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public List<SubordinateFiscalListDtoInterface> getSubordinateFiscalList() throws MospException {
        return this.subordinateFiscalList(this.getHumanSubordinates(this.humanType, 1));
    }

    public List<SubordinateFiscalListDtoInterface> subordinateFiscalList(List<HumanDtoInterface> humanList) throws MospException {
        ArrayList<SubordinateFiscalListDtoInterface> subordinateFiscalList = new ArrayList<SubordinateFiscalListDtoInterface>();
        Date firstDate = MonthUtility.getFiscalYearFirstDate((int)this.displayYear, (MospParams)this.mospParams);
        Date lastDate = MonthUtility.getFiscalYearLastDate((int)this.displayYear, (MospParams)this.mospParams);
        Date searchEndDate = this.getEndTargetDate(firstDate, lastDate);
        ArrayList errorMessageList = new ArrayList(this.mospParams.getErrorMessageList());
        for (HumanDtoInterface humanDto : humanList) {
            Date applicationTargetDate;
            ApplicationDtoInterface applicationDto = this.timeMaster.getApplication(humanDto, applicationTargetDate = MonthUtility.getYearMonthTermLastDate((int)this.targetYear, (int)this.targetMonth, (MospParams)this.mospParams));
            if (applicationDto == null) continue;
            String personalId = humanDto.getPersonalId();
            SubordinateFiscalListDto dto = new SubordinateFiscalListDto();
            List attendanceList = this.attendanceRefer.getAttendanceList(humanDto.getPersonalId(), firstDate, lastDate);
            Map totalMap = this.totalTimeRefer.findFiscalMap(personalId, firstDate, lastDate);
            if (!attendanceList.isEmpty() || totalMap != null && !totalMap.isEmpty()) {
                this.setOverTime((SubordinateFiscalListDtoInterface)dto, totalMap, personalId, firstDate);
            } else {
                dto.setOverTime(0);
            }
            this.setPaidHoliday((SubordinateFiscalListDtoInterface)dto, humanDto, this.displayYear, searchEndDate);
            this.setStockHoliday((SubordinateFiscalListDtoInterface)dto, humanDto, this.displayYear, searchEndDate);
            this.setHoliday((SubordinateFiscalListDtoInterface)dto, humanDto, applicationTargetDate, firstDate, lastDate);
            this.setHuman((SubordinateFiscalListDtoInterface)dto, humanDto);
            subordinateFiscalList.add((SubordinateFiscalListDtoInterface)dto);
        }
        this.mospParams.getErrorMessageList().clear();
        this.mospParams.getErrorMessageList().addAll(errorMessageList);
        return subordinateFiscalList;
    }

    protected void setOverTime(SubordinateFiscalListDtoInterface dto, Map<Integer, TotalTimeDataDtoInterface> totalMap, String personalId, Date firstDate) throws MospException {
        int overTime = 0;
        for (int i = 0; i < 12; ++i) {
            Date targetDate = DateUtility.addMonth((Date)firstDate, (int)i);
            int year = DateUtility.getYear((Date)targetDate);
            int month = DateUtility.getMonth((Date)targetDate);
            TotalTimeDataDtoInterface totalTimeDto = totalMap.get(month);
            if (totalTimeDto == null) {
                totalTimeDto = this.totalTimeCalc.calc(personalId, year, month, false);
            }
            overTime += totalTimeDto.getOvertime();
        }
        dto.setOverTime(overTime);
    }

    protected void setPaidHoliday(SubordinateFiscalListDtoInterface dto, HumanDtoInterface humanDto, int displayYear, Date targetDate) throws MospException {
        double paidHolidayDays = 0.0;
        int paidHolidayTime = 0;
        double paidHolidayRestDays = 0.0;
        int paidHolidayRestTime = 0;
        Map map = this.paidHolidayInfo.getSubordinateFiscalPaidHolidayInfo(humanDto, displayYear, targetDate);
        int generalWorkHour = (Integer)map.get("generalWorkHour");
        paidHolidayDays = (Double)map.get("currentGiveDay") + (Double)map.get("formerRestDay");
        if (generalWorkHour > 0) {
            for (paidHolidayTime = (Integer)map.get("currentGiveTime") + (Integer)map.get("formerRestTime"); paidHolidayTime < 0 && paidHolidayDays >= 1.0; paidHolidayDays -= 1.0, paidHolidayTime += generalWorkHour) {
            }
        }
        double termUseHolidayRequestDay = (Double)map.get("termUseHolidayRequestDay");
        int termUseHolidayRequestTime = (Integer)map.get("termUseHolidayRequestTime");
        paidHolidayRestDays = paidHolidayDays - termUseHolidayRequestDay;
        if (generalWorkHour > 0) {
            for (paidHolidayRestTime = paidHolidayTime - termUseHolidayRequestTime; paidHolidayRestTime < 0 && paidHolidayRestDays >= 1.0; paidHolidayRestDays -= 1.0, paidHolidayRestTime += generalWorkHour) {
            }
        }
        dto.setPaidHolidayDays(paidHolidayDays);
        dto.setPaidHolidayTime(paidHolidayTime);
        dto.setPaidHolidayRestDays(paidHolidayRestDays);
        dto.setPaidHolidayRestTime(paidHolidayRestTime);
    }

    protected void setStockHoliday(SubordinateFiscalListDtoInterface dto, HumanDtoInterface humanDto, int displayYear, Date targetDate) throws MospException {
        double stockHolidayDays = 0.0;
        double stockHolidayRestDays = 0.0;
        Map map = this.stockHolidayInfo.getSubordinateFiscalStockHolidayInfo(humanDto, displayYear, targetDate);
        stockHolidayDays = (Double)map.get("currentGiveDay") + (Double)map.get("formerRestDay");
        double termUseHolidayRequestDay = (Double)map.get("termUseHolidayRequestDay");
        stockHolidayRestDays = stockHolidayDays - termUseHolidayRequestDay;
        dto.setStockHolidayDays(stockHolidayDays);
        dto.setStockHolidayRestDays(stockHolidayRestDays);
    }

    protected void setHoliday(SubordinateFiscalListDtoInterface dto, HumanDtoInterface humanDto, Date targetDate, Date firstDate, Date lastDate) throws MospException {
        String personalId = humanDto.getPersonalId();
        int hoursPerDay = this.timeMaster.getPaidHolidayHoursPerDay(humanDto, targetDate);
        String holidayCode = this.mospParams.getApplicationProperty("SeasonHolidayCode");
        int holidayType = 2;
        double currentDays = 0.0;
        int currentHours = 0;
        HashSet<Date> acquisitionDates = new HashSet<Date>();
        List list = this.holidayDataRefer.getActiveListForTerm(personalId, firstDate, lastDate, holidayType, holidayCode);
        for (HolidayDataDtoInterface holidayDataDto : list) {
            currentDays += TimeUtility.getCurrentDays((HolidayDataDtoInterface)holidayDataDto);
            currentHours += TimeUtility.getCurrentHours((HolidayDataDtoInterface)holidayDataDto);
            acquisitionDates.add(holidayDataDto.getActivateDate());
        }
        AbstractMap.SimpleEntry uses = this.holidayRequestRefer.getHolidayUses(personalId, firstDate, lastDate, holidayType, holidayCode, acquisitionDates);
        double useDays = (Double)uses.getKey();
        int useHours = (Integer)uses.getValue();
        AbstractMap.SimpleEntry remains = TimeUtility.getHolidayRemains((double)currentDays, (int)currentHours, (double)useDays, (int)useHours, (int)hoursPerDay);
        dto.setSeasonHolidayDays(currentDays);
        dto.setSeasonHolidayRestDays(((Double)remains.getKey()).doubleValue());
        dto.setSeasonHolidayRestHours(((Integer)remains.getValue()).intValue());
    }

    public void setHuman(SubordinateFiscalListDtoInterface dto, HumanDtoInterface humanDto) {
        if (humanDto == null) {
            return;
        }
        dto.setPersonalId(humanDto.getPersonalId());
        dto.setEmployeeCode(humanDto.getEmployeeCode());
        dto.setLastName(humanDto.getLastName());
        dto.setFirstName(humanDto.getFirstName());
        dto.setSectionCode(humanDto.getSectionCode());
    }

    protected Date getEndTargetDate(Date startDate, Date endDate) {
        if (DateUtility.isTermContain((Date)this.getSystemDate(), (Date)startDate, (Date)endDate)) {
            return this.getSystemDate();
        }
        if (this.getSystemDate().compareTo(startDate) < 0) {
            return startDate;
        }
        if (this.getSystemDate().compareTo(endDate) > 0) {
            return endDate;
        }
        return this.getSystemDate();
    }

    public void setDisplayYear(int displayYear) {
        this.displayYear = displayYear;
    }

    public void setTargetYear(int targetYear) {
        this.targetYear = targetYear;
    }

    public void setTargetMonth(int targetMonth) {
        this.targetMonth = targetMonth;
    }

    public void setHumanType(String humanType) {
        this.humanType = humanType;
    }
}

