/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.TimeApprovalBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdSubHolidayRequestDto;

public class SubHolidayRequestRegistBean
extends TimeBean
implements SubHolidayRequestRegistBeanInterface {
    protected SubHolidayRequestDaoInterface dao;
    protected SubHolidayRequestReferenceBeanInterface subHolidayReference;
    protected WorkflowDaoInterface workflowDao;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    private WorkflowRegistBeanInterface workflowRegist;
    private WorkflowCommentRegistBeanInterface workflowCommentRegist;
    protected AttendanceRegistBeanInterface attendanceRegist;
    protected TimeApprovalBeanInterface timeApproval;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;
    private CutoffUtilBeanInterface cutoffUtil;
    protected RequestUtilBeanInterface requestUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;
    private SubHolidayDaoInterface subHolidayDao;
    private AttendanceDaoInterface attendanceDao;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected AttendanceTransactionRegistBeanInterface attendanceTransactionRegist;
    WorkTypeChangeRequestReferenceBeanInterface workTypeChangeReference;

    public SubHolidayRequestRegistBean() {
    }

    public SubHolidayRequestRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (SubHolidayRequestDaoInterface)this.createDao(SubHolidayRequestDaoInterface.class);
        this.subHolidayReference = (SubHolidayRequestReferenceBeanInterface)this.createBean(SubHolidayRequestReferenceBeanInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDao(WorkflowDaoInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBean(WorkflowCommentRegistBeanInterface.class);
        this.subHolidayDao = (SubHolidayDaoInterface)this.createDao(SubHolidayDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDao(AttendanceDaoInterface.class);
        this.attendanceRegist = (AttendanceRegistBeanInterface)this.createBean(AttendanceRegistBeanInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.attendanceTransactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBean(AttendanceTransactionRegistBeanInterface.class);
        this.workTypeChangeReference = (WorkTypeChangeRequestReferenceBeanInterface)this.createBean(WorkTypeChangeRequestReferenceBeanInterface.class);
    }

    public SubHolidayRequestDtoInterface getInitDto() {
        return new TmdSubHolidayRequestDto();
    }

    public void insert(SubHolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdSubHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public boolean update(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return false;
        }
        boolean containsHalfHoliday = false;
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            SubHolidayRequestDtoInterface dto = (SubHolidayRequestDtoInterface)baseDto;
            this.checkAppli(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(dto.getWorkflow());
            this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
            if (workflowDto == null) continue;
            this.deleteAttendance(dto);
            this.draftAttendance(dto);
            this.attendanceTransactionRegist.regist(dto);
            containsHalfHoliday = true;
        }
        return containsHalfHoliday;
    }

    public void regist(SubHolidayRequestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getTmdSubHolidayRequestId(), false) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
    }

    public void add(SubHolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdSubHolidayRequestId());
        dto.setTmdSubHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(SubHolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdSubHolidayRequestId());
    }

    public void withdrawn(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            SubHolidayRequestDtoInterface dto = (SubHolidayRequestDtoInterface)baseDto;
            this.checkWithdrawn(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ((workflowDto = this.workflowRegist.withdrawn(workflowDto)) == null) continue;
            this.workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
        }
    }

    protected void checkInsert(SubHolidayRequestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate(), dto.getHolidayRange()));
    }

    protected void checkAdd(SubHolidayRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdSubHolidayRequestId());
    }

    public void validate(SubHolidayRequestDtoInterface dto) throws MospException {
        this.subHolidayReference.chkBasicInfo(dto.getPersonalId(), dto.getRequestDate());
    }

    public void checkSetRequestDate(SubHolidayRequestDtoInterface dto) throws MospException {
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSuspended(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTemporaryClosingFinal(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        localRequestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        this.checkWorkType(dto, localRequestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDuplicate(dto, localRequestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto);
    }

    public void checkDraft(SubHolidayRequestDtoInterface dto) throws MospException {
        this.checkSetRequestDate(dto);
    }

    public void checkAppli(SubHolidayRequestDtoInterface dto) throws MospException {
        this.checkDraft(dto);
        this.checkDay(dto);
        this.checkWorkTypeChange(dto);
    }

    public void checkCancelAppli(SubHolidayRequestDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        if (this.approvalInfoReference.isExistAttendanceTargetDate(dto.getPersonalId(), dto.getRequestDate())) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("WorkManage"));
        }
    }

    public void checkWithdrawn(SubHolidayRequestDtoInterface dto) {
    }

    public void checkApproval(SubHolidayRequestDtoInterface dto) throws MospException {
        this.checkAppli(dto);
    }

    public void checkCancelApproval(SubHolidayRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    public void checkCancel(SubHolidayRequestDtoInterface dto) {
    }

    protected void checkDuplicate(SubHolidayRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        int holidayRange;
        boolean subHolidayRangeAm = false;
        boolean subHolidayRangePm = false;
        boolean holidayRangeAm = false;
        boolean holidayRangePm = false;
        boolean holidayRangeTime = false;
        boolean substituteRangeAm = false;
        boolean substituteRangePm = false;
        List list = this.dao.findForList(dto.getPersonalId(), dto.getRequestDate());
        for (SubHolidayRequestDtoInterface subHolidayRequestDto : list) {
            long workflow = subHolidayRequestDto.getWorkflow();
            if (this.workflowIntegrate.isWithDrawn(workflow) || dto.getWorkflow() == workflow) continue;
            int subHolidayRange = subHolidayRequestDto.getHolidayRange();
            if (subHolidayRange == 1) {
                this.addSubHolidayTargetDateSubHolidayRequestErrorMessage();
                return;
            }
            if (subHolidayRange == 2) {
                subHolidayRangeAm = true;
                continue;
            }
            if (subHolidayRange != 3) continue;
            subHolidayRangePm = true;
        }
        if (subHolidayRangeAm && subHolidayRangePm) {
            this.addSubHolidayTargetDateSubHolidayRequestErrorMessage();
            return;
        }
        if (dto.getHolidayRange() == 1) {
            if (subHolidayRangeAm || subHolidayRangePm) {
                this.addSubHolidayTargetDateSubHolidayRequestErrorMessage();
                return;
            }
        } else if (dto.getHolidayRange() == 2) {
            if (subHolidayRangeAm) {
                this.addSubHolidayTargetDateSubHolidayRequestErrorMessage();
                return;
            }
        } else if (dto.getHolidayRange() == 3 && subHolidayRangePm) {
            this.addSubHolidayTargetDateSubHolidayRequestErrorMessage();
            return;
        }
        if ((holidayRange = localRequestUtil.checkHolidayRangeHoliday(localRequestUtil.getHolidayList(false))) == 1 || holidayRange == 5) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Vacation"));
            return;
        }
        if (holidayRange == 2) {
            holidayRangeAm = true;
        } else if (holidayRange == 3) {
            holidayRangePm = true;
        } else if (holidayRange == 4) {
            holidayRangeTime = true;
        }
        int substituteRange = localRequestUtil.checkHolidayRangeSubstitute(localRequestUtil.getSubstituteList(false));
        if (substituteRange == 1 || substituteRange == 5) {
            this.addSubstituteErrorMessage(dto.getRequestDate());
            return;
        }
        if (substituteRange == 2) {
            substituteRangeAm = true;
        } else if (substituteRange == 3) {
            substituteRangePm = true;
        }
        if ((subHolidayRangeAm || holidayRangeAm || substituteRangeAm) && (subHolidayRangePm || holidayRangePm || substituteRangePm)) {
            this.addSubHolidayTargetDateSubHolidayRequestErrorMessage();
            return;
        }
        if (dto.getHolidayRange() == 1) {
            if (holidayRangeAm || holidayRangePm) {
                this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Vacation"));
                return;
            }
            if (holidayRangeTime) {
                this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("HolidayTime"));
                return;
            }
        } else if (dto.getHolidayRange() == 2) {
            if (holidayRangeAm) {
                this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Vacation"));
                return;
            }
            if (holidayRangeTime) {
                this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("HolidayTime"));
                return;
            }
        } else if (dto.getHolidayRange() == 3) {
            if (holidayRangePm) {
                this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Vacation"));
                return;
            }
            if (holidayRangeTime) {
                this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("HolidayTime"));
                return;
            }
        }
        if (dto.getHolidayRange() == 1) {
            if (substituteRangeAm || substituteRangePm) {
                this.addSubstituteErrorMessage(dto.getRequestDate());
                return;
            }
        } else if (dto.getHolidayRange() == 2) {
            if (substituteRangeAm) {
                this.addSubstituteErrorMessage(dto.getRequestDate());
                return;
            }
        } else if (dto.getHolidayRange() == 3 && substituteRangePm) {
            this.addSubstituteErrorMessage(dto.getRequestDate());
            return;
        }
        int range = dto.getHolidayRange();
        if (dto.getHolidayRange() == 2) {
            if (subHolidayRangePm || holidayRangePm || substituteRangePm) {
                range = 1;
            }
        } else if (dto.getHolidayRange() == 3 && (subHolidayRangeAm || holidayRangeAm || substituteRangeAm)) {
            range = 1;
        }
        this.checkOvertimeWorkRequest(dto, localRequestUtil, range);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSubstituteWorkRequest(localRequestUtil, range);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeChangeRequest(localRequestUtil, range);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDifferenceRequest(localRequestUtil, range);
    }

    protected void checkOvertimeWorkRequest(SubHolidayRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil, int holidayRange) throws MospException {
        if (holidayRange != 1) {
            return;
        }
        if (localRequestUtil.getOverTimeList(false).isEmpty()) {
            return;
        }
        this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("OvertimeWork"));
    }

    protected void checkSubstituteWorkRequest(RequestUtilBeanInterface localRequestUtil, int holidayRange) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = localRequestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null) {
            return;
        }
        int substitute = workOnHolidayRequestDto.getSubstitute();
        if (substitute == 2) {
            return;
        }
        if (substitute == 1) {
            return;
        }
        if (substitute == 5) {
            return;
        }
        this.addOthersRequestErrorMessage(workOnHolidayRequestDto.getRequestDate(), this.mospParams.getName("HalfDay", new String[]{"Transfer", "GoingWork"}));
    }

    protected void checkWorkTypeChangeRequest(RequestUtilBeanInterface localRequestUtil, int holidayRange) throws MospException {
        if (holidayRange != 1) {
            return;
        }
        WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = localRequestUtil.getWorkTypeChangeDto(false);
        if (workTypeChangeRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(workTypeChangeRequestDto.getRequestDate(), this.mospParams.getName("Work", new String[]{"Form", "Change"}));
    }

    protected void checkDifferenceRequest(RequestUtilBeanInterface localRequestUtil, int holidayRange) throws MospException {
        if (holidayRange != 1 && holidayRange != 2) {
            return;
        }
        DifferenceRequestDtoInterface differenceRequestDto = localRequestUtil.getDifferenceDto(false);
        if (differenceRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(differenceRequestDto.getRequestDate(), this.mospParams.getName("TimeDifference", new String[]{"GoingWork"}));
    }

    public void checkRequest(SubHolidayRequestDtoInterface dto) throws MospException {
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getRequestDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(false);
            if (workOnHolidayRequestDto != null && workOnHolidayRequestDto.getSubstitute() == 2) {
                this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("WorkingHoliday"));
                return;
            }
            if (this.requestUtil.getWorkOnHolidayDto(true) == null) {
                this.addSubHolidayTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
                return;
            }
        }
        if (this.requestUtil.checkHolidayRangeSubstitute(this.requestUtil.getSubstituteList(false)) == 1) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Transfer") + this.mospParams.getName("GoingWork"));
            return;
        }
        int holidayRange = this.requestUtil.checkHolidayRangeHoliday(this.requestUtil.getHolidayList(false));
        if (holidayRange == 4) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("HolidayTime"));
            return;
        }
        if (holidayRange == 1 || holidayRange == 5 || dto.getHolidayRange() == 1 && (holidayRange == 1 || holidayRange == 2 || holidayRange == 3 || holidayRange == 5) || dto.getHolidayRange() == 2 && holidayRange == 2 || dto.getHolidayRange() == 3 && holidayRange == 3) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Vacation"));
            return;
        }
        if (dto.getHolidayRange() == 1 && !this.requestUtil.getOverTimeList(false).isEmpty()) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("OvertimeWork"));
            return;
        }
        if (dto.getHolidayRange() == 1 && this.requestUtil.getWorkTypeChangeDto(false) != null) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Work", new String[]{"Form", "Change"}));
            return;
        }
        if ((dto.getHolidayRange() == 1 || dto.getHolidayRange() == 2) && this.requestUtil.getDifferenceDto(false) != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("TimeDifference"));
            sb.append(this.mospParams.getName("GoingWork"));
            this.addOthersRequestErrorMessage(dto.getRequestDate(), sb.toString());
        }
    }

    @Deprecated
    protected void checkAttendance(RequestUtilBeanInterface localRequestUtil) throws MospException {
        AttendanceDtoInterface attendanceDto = localRequestUtil.getApplicatedAttendance();
        if (attendanceDto == null) {
            return;
        }
        this.addSubHolidayTargetWorkDateAttendanceRequestErrorMessage(attendanceDto.getWorkDate());
    }

    public void checkAttendance(SubHolidayRequestDtoInterface dto) throws MospException {
        AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(dto.getPersonalId(), dto.getRequestDate(), 1);
        if (attendanceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow());
        if (workflowDto == null) {
            return;
        }
        if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if (WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        this.addSubHolidayTargetWorkDateAttendanceRequestErrorMessage(dto.getRequestDate());
    }

    public void checkDay(SubHolidayRequestDtoInterface dto) throws MospException {
        SubHolidayDtoInterface subHolidayDto = this.subHolidayDao.findForKey(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), dto.getWorkDateSubHolidayType());
        double subHolidayDays = subHolidayDto.getSubHolidayDays();
        List list = this.dao.findForList(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), dto.getWorkDateSubHolidayType());
        for (SubHolidayRequestDtoInterface requestDto : list) {
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(requestDto.getWorkflow());
            if (workflowDto == null || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus()) || dto.getWorkflow() == workflowDto.getWorkflow()) continue;
            int holidayRange = requestDto.getHolidayRange();
            if (holidayRange == 1) {
                subHolidayDays -= 1.0;
                continue;
            }
            if (holidayRange != 2 && holidayRange != 3) continue;
            subHolidayDays -= 0.5;
        }
        int holidayRange = dto.getHolidayRange();
        String errorMes1 = "";
        if (holidayRange == 1) {
            if (subHolidayDays < 1.0) {
                errorMes1 = "1";
                this.mospParams.addErrorMessage("TMW0252", new String[]{errorMes1});
            }
        } else if ((holidayRange == 2 || holidayRange == 3) && subHolidayDays < 0.5) {
            errorMes1 = "0.5";
            this.mospParams.addErrorMessage("TMW0252", new String[]{errorMes1});
        }
    }

    protected void checkEntered(SubHolidayRequestDtoInterface dto) throws MospException {
        if (!this.isEntered(dto.getPersonalId(), dto.getRequestDate())) {
            PlatformMessageUtility.addErrorEmployeeNotJoin((MospParams)this.mospParams);
        }
    }

    protected void checkRetired(SubHolidayRequestDtoInterface dto) throws MospException {
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getRequestDate())) {
            this.addEmployeeRetiredMessage();
        }
    }

    protected void checkSuspended(SubHolidayRequestDtoInterface dto) throws MospException {
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getRequestDate())) {
            this.addEmployeeSuspendedMessage();
        }
    }

    public void checkTemporaryClosingFinal(SubHolidayRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestDate(), this.getCompensatoryHolidayDay());
    }

    protected void checkWorkType(SubHolidayRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getRequestDate(), localRequestUtil);
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            this.addSubHolidayTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
            return;
        }
        if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
            this.addSubHolidayTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
            return;
        }
        if ("work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("WorkingHoliday"));
        }
    }

    public void deleteAttendance(SubHolidayRequestDtoInterface dto) throws MospException {
        boolean holidayPm;
        int range = dto.getHolidayRange();
        boolean holidayAm = range == 2;
        boolean bl = holidayPm = range == 3;
        if (range == 1) {
            this.attendanceRegist.delete(dto.getPersonalId(), dto.getRequestDate());
            return;
        }
        if (holidayAm || holidayPm) {
            this.requestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
            List list = this.requestUtil.getSubHolidayList(false);
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : list) {
                if ((!holidayAm || subHolidayRequestDto.getHolidayRange() != 3) && (!holidayPm || subHolidayRequestDto.getHolidayRange() != 2)) continue;
                this.attendanceRegist.delete(dto.getPersonalId(), dto.getRequestDate());
                return;
            }
            List holidayRequestList = this.requestUtil.getHolidayList(false);
            for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
                if ((!holidayAm || holidayRequestDto.getHolidayRange() != 3) && (!holidayPm || holidayRequestDto.getHolidayRange() != 2)) continue;
                this.attendanceRegist.delete(dto.getPersonalId(), dto.getRequestDate());
                break;
            }
            List substituteList = this.requestUtil.getSubstituteList(false);
            for (SubstituteDtoInterface substituteDto : substituteList) {
                if ((!holidayAm || substituteDto.getHolidayRange() != 3) && (!holidayPm || substituteDto.getHolidayRange() != 2)) continue;
                this.attendanceRegist.delete(dto.getPersonalId(), dto.getRequestDate());
                break;
            }
        }
    }

    public void draftAttendance(SubHolidayRequestDtoInterface dto) throws MospException {
        if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) {
            return;
        }
        this.timeApproval = (TimeApprovalBeanInterface)this.createBean(TimeApprovalBeanInterface.class);
        boolean deleteRest = false;
        int holidayRange = dto.getHolidayRange();
        if (holidayRange == 2 || holidayRange == 3) {
            deleteRest = true;
        }
        this.timeApproval.reDraft(dto.getPersonalId(), dto.getRequestDate(), deleteRest, false, false);
    }

    protected void checkWorkTypeChange(SubHolidayRequestDtoInterface dto) throws MospException {
        WorkTypeChangeRequestDtoInterface workTypeChangeDto = this.workTypeChangeReference.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate());
        if (workTypeChangeDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(workTypeChangeDto.getWorkflow());
        if (this.workflowIntegrate.isCompleted(workflowDto.getWorkflow()) || this.workflowIntegrate.isWithDrawn(workflowDto.getWorkflow()) || this.workflowIntegrate.isDraft(workflowDto.getWorkflow())) {
            return;
        }
        String requestName = this.mospParams.getName("Work", new String[]{"Form", "Change"});
        this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(dto.getRequestDate()), requestName});
    }

    protected void addSubstituteErrorMessage(Date date) {
        this.addOthersRequestErrorMessage(date, this.mospParams.getName("Transfer", new String[]{"Holiday"}));
    }

    protected String getCompensatoryHolidayDay() {
        return this.mospParams.getName("CompensatoryHoliday") + this.mospParams.getName("Day");
    }
}

