/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayDataRegistBeanInterface;
import jp.mosp.time.bean.StockHolidayInfoReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.StockHolidayDaoInterface;
import jp.mosp.time.dao.settings.StockHolidayDataDaoInterface;
import jp.mosp.time.dao.settings.StockHolidayTransactionDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayTransactionDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class StockHolidayInfoReferenceBean
extends PlatformBean
implements StockHolidayInfoReferenceBeanInterface {
    private ApplicationReferenceBeanInterface application;
    private StockHolidayDaoInterface stockHolidayDao;
    private StockHolidayDataDaoInterface stockHolidayDataDao;
    private StockHolidayTransactionDaoInterface stockHolidayTransactionDao;
    private StockHolidayDataRegistBeanInterface stockHolidayDataRegist;
    private HolidayRequestDaoInterface holidayRequestDao;
    private HolidayRequestReferenceBeanInterface holidayRequest;
    private WorkflowIntegrateBeanInterface workflowIntegrate;

    public StockHolidayInfoReferenceBean() {
    }

    public StockHolidayInfoReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.application = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.stockHolidayDao = (StockHolidayDaoInterface)this.createDao(StockHolidayDaoInterface.class);
        this.stockHolidayDataDao = (StockHolidayDataDaoInterface)this.createDao(StockHolidayDataDaoInterface.class);
        this.stockHolidayTransactionDao = (StockHolidayTransactionDaoInterface)this.createDao(StockHolidayTransactionDaoInterface.class);
        this.stockHolidayDataRegist = (StockHolidayDataRegistBeanInterface)this.createBean(StockHolidayDataRegistBeanInterface.class);
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
    }

    public List<StockHolidayDataDtoInterface> getStockHolidayCalcInfo(String personalId, Date targetDate) throws MospException {
        ArrayList<StockHolidayDataDtoInterface> list = new ArrayList<StockHolidayDataDtoInterface>();
        List stockHolidayDataDtoList = this.stockHolidayDataDao.findForInfoList(personalId, targetDate);
        for (StockHolidayDataDtoInterface stockHolidayDataDto : stockHolidayDataDtoList) {
            Date activateDate = stockHolidayDataDto.getActivateDate();
            Date acquisitionDate = stockHolidayDataDto.getAcquisitionDate();
            List stockHolidayTransactionDtoList = this.stockHolidayTransactionDao.findForList(personalId, acquisitionDate, activateDate, targetDate);
            for (StockHolidayTransactionDtoInterface stockHolidayTransactionDto : stockHolidayTransactionDtoList) {
                stockHolidayDataDto.setGivingDay(stockHolidayDataDto.getGivingDay() + stockHolidayTransactionDto.getGivingDay());
                stockHolidayDataDto.setCancelDay(stockHolidayDataDto.getCancelDay() + stockHolidayTransactionDto.getCancelDay());
            }
            Map map = this.holidayRequest.getApprovedDayHour(personalId, acquisitionDate, 1, Integer.toString(2), activateDate, targetDate);
            stockHolidayDataDto.setUseDay(stockHolidayDataDto.getUseDay() + (Double)map.get("approvedDay"));
            stockHolidayDataDto.setActivateDate(targetDate);
            list.add(stockHolidayDataDto);
        }
        return list;
    }

    public List<StockHolidayDataDtoInterface> getStockHolidayPossibleRequestForRequest(String personalId, Date targetDate) throws MospException {
        ArrayList<StockHolidayDataDtoInterface> list = new ArrayList<StockHolidayDataDtoInterface>();
        List stockHolidayDataDtoList = this.stockHolidayDataDao.findForInfoList(personalId, targetDate);
        for (StockHolidayDataDtoInterface stockHolidayDataDto : stockHolidayDataDtoList) {
            Date activateDate = stockHolidayDataDto.getActivateDate();
            Date acquisitionDate = stockHolidayDataDto.getAcquisitionDate();
            List stockHolidayTransactionDtoList = this.stockHolidayTransactionDao.findForList(personalId, acquisitionDate, activateDate, targetDate);
            for (StockHolidayTransactionDtoInterface stockHolidayTransactionDto : stockHolidayTransactionDtoList) {
                stockHolidayDataDto.setGivingDay(stockHolidayDataDto.getGivingDay() + stockHolidayTransactionDto.getGivingDay());
                stockHolidayDataDto.setCancelDay(stockHolidayDataDto.getCancelDay() + stockHolidayTransactionDto.getCancelDay());
            }
            double requestDay = 0.0;
            List holidayRequestList = this.holidayRequestDao.findForRequestList(personalId, acquisitionDate, 1, Integer.toString(2), activateDate, stockHolidayDataDto.getLimitDate());
            for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
                if (this.workflowIntegrate.isFirstReverted(holidayRequestDto.getWorkflow())) continue;
                requestDay += holidayRequestDto.getUseDay();
            }
            stockHolidayDataDto.setUseDay(stockHolidayDataDto.getUseDay() + requestDay);
            list.add(stockHolidayDataDto);
        }
        return list;
    }

    public List<StockHolidayDataDtoInterface> getStockHolidayPossibleRequest(String personalId, Date targetDate) throws MospException {
        ArrayList<StockHolidayDataDtoInterface> list = new ArrayList<StockHolidayDataDtoInterface>();
        List stockHolidayDataDtoList = this.stockHolidayDataDao.findForInfoList(personalId, targetDate);
        for (StockHolidayDataDtoInterface stockHolidayDataDto : stockHolidayDataDtoList) {
            Date activateDate = stockHolidayDataDto.getActivateDate();
            Date acquisitionDate = stockHolidayDataDto.getAcquisitionDate();
            List stockHolidayTransactionDtoList = this.stockHolidayTransactionDao.findForList(personalId, acquisitionDate, activateDate, targetDate);
            for (StockHolidayTransactionDtoInterface stockHolidayTransactionDto : stockHolidayTransactionDtoList) {
                stockHolidayDataDto.setGivingDay(stockHolidayDataDto.getGivingDay() + stockHolidayTransactionDto.getGivingDay());
                stockHolidayDataDto.setCancelDay(stockHolidayDataDto.getCancelDay() + stockHolidayTransactionDto.getCancelDay());
            }
            Map map = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, 1, Integer.toString(2), activateDate, stockHolidayDataDto.getLimitDate());
            stockHolidayDataDto.setUseDay(stockHolidayDataDto.getUseDay() + (Double)map.get("requestDay"));
            list.add(stockHolidayDataDto);
        }
        return list;
    }

    public Double getRemainDay(String personalId, Date targetDate) throws MospException {
        List stockHolidayDataDtoList = this.stockHolidayDataDao.findForInfoList(personalId, targetDate);
        if (stockHolidayDataDtoList.isEmpty()) {
            return null;
        }
        double stockDate = 0.0;
        for (StockHolidayDataDtoInterface stockHolidayDataDto : stockHolidayDataDtoList) {
            Date activateDate = stockHolidayDataDto.getActivateDate();
            Date acquisitionDate = stockHolidayDataDto.getAcquisitionDate();
            stockDate += stockHolidayDataDto.getHoldDay();
            List stockHolidayTransactionDtoList = this.stockHolidayTransactionDao.findForList(personalId, acquisitionDate, activateDate, targetDate);
            for (StockHolidayTransactionDtoInterface stockHolidayTransactionDto : stockHolidayTransactionDtoList) {
                stockDate += stockHolidayTransactionDto.getGivingDay();
                stockDate -= stockHolidayTransactionDto.getCancelDay();
            }
            Map map = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, 1, Integer.toString(2), activateDate, stockHolidayDataDto.getLimitDate());
            stockDate -= ((Double)map.get("requestDay")).doubleValue();
        }
        return stockDate;
    }

    public double getStockPaidInfo(String personalId, Date startDate, Date endDate) throws MospException {
        double stockDate = 0.0;
        List stockHolidayDataDtoList = this.stockHolidayDataDao.findForInfoList(personalId, startDate);
        for (StockHolidayDataDtoInterface stockHolidayDataDto : stockHolidayDataDtoList) {
            Date acquisitionDate = stockHolidayDataDto.getAcquisitionDate();
            stockDate += stockHolidayDataDto.getHoldDay();
            List stockHolidayTransactionDtoList = this.stockHolidayTransactionDao.findForList(personalId, acquisitionDate, startDate, endDate);
            for (StockHolidayTransactionDtoInterface stockHolidayTransactionDto : stockHolidayTransactionDtoList) {
                stockDate += stockHolidayTransactionDto.getGivingDay();
                stockDate -= stockHolidayTransactionDto.getCancelDay();
            }
        }
        return stockDate;
    }

    public double getRemainDay(String personalId, Date startDate, Date endDate) throws MospException {
        double stockDate = 0.0;
        List stockHolidayDataDtoList = this.stockHolidayDataDao.findForInfoList(personalId, startDate);
        for (StockHolidayDataDtoInterface stockHolidayDataDto : stockHolidayDataDtoList) {
            Date activateDate = stockHolidayDataDto.getActivateDate();
            Date acquisitionDate = stockHolidayDataDto.getAcquisitionDate();
            stockDate += stockHolidayDataDto.getHoldDay();
            List stockHolidayTransactionDtoList = this.stockHolidayTransactionDao.findForList(personalId, acquisitionDate, startDate, endDate);
            for (StockHolidayTransactionDtoInterface stockHolidayTransactionDto : stockHolidayTransactionDtoList) {
                stockDate += stockHolidayTransactionDto.getGivingDay();
                stockDate -= stockHolidayTransactionDto.getCancelDay();
            }
            Map map = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, 1, Integer.toString(2), activateDate, stockHolidayDataDto.getLimitDate());
            stockDate -= ((Double)map.get("requestDay")).doubleValue();
        }
        return stockDate;
    }

    public List<StockHolidayDataDtoInterface> getStockHolidayNextMonthInfo(String personalId, Date activateDate, List<StockHolidayDataDtoInterface> list) {
        ArrayList<StockHolidayDataDtoInterface> stockHolidayDataList = new ArrayList<StockHolidayDataDtoInterface>();
        for (StockHolidayDataDtoInterface dto : list) {
            if (dto.getLimitDate().compareTo(activateDate) < 0) continue;
            dto.setActivateDate(activateDate);
            dto.setHoldDay(dto.getHoldDay() + dto.getGivingDay() - dto.getCancelDay() - dto.getUseDay());
            dto.setGivingDay(0.0);
            dto.setCancelDay(0.0);
            dto.setUseDay(0.0);
            stockHolidayDataList.add(dto);
        }
        return stockHolidayDataList;
    }

    public StockHolidayDataDtoInterface getNewStockHolidayInfo(String personalId, Date activateDate, double day) throws MospException {
        ApplicationDtoInterface applicationDto = this.application.findForPerson(personalId, activateDate);
        if (applicationDto == null) {
            return null;
        }
        StockHolidayDtoInterface stockHolidayDto = this.stockHolidayDao.findForInfo(applicationDto.getPaidHolidayCode(), applicationDto.getActivateDate());
        if (stockHolidayDto == null) {
            return null;
        }
        StockHolidayDataDtoInterface dto = this.stockHolidayDataRegist.getInitDto();
        dto.setPersonalId(personalId);
        dto.setActivateDate(activateDate);
        dto.setAcquisitionDate(activateDate);
        dto.setLimitDate(DateUtility.addMonth((Date)activateDate, (int)stockHolidayDto.getStockLimitDate()));
        int stockYearAmount = stockHolidayDto.getStockYearAmount();
        if (day <= (double)stockYearAmount) {
            dto.setHoldDay(day);
        } else {
            dto.setHoldDay((double)stockYearAmount);
        }
        dto.setGivingDay(0.0);
        dto.setCancelDay(0.0);
        dto.setUseDay(0.0);
        double totalAmount = 0.0;
        List list = this.stockHolidayDataDao.findForList(personalId, activateDate);
        for (StockHolidayDataDtoInterface stockHolidayDataDto : list) {
            totalAmount += stockHolidayDataDto.getHoldDay();
        }
        if (totalAmount >= (double)stockHolidayDto.getStockTotalAmount()) {
            dto.setHoldDay(0.0);
        } else if (totalAmount + dto.getHoldDay() > (double)stockHolidayDto.getStockTotalAmount()) {
            dto.setHoldDay((double)stockHolidayDto.getStockTotalAmount() - totalAmount);
        }
        return dto;
    }

    public Map<String, Object> getSubordinateFiscalStockHolidayInfo(HumanDtoInterface humanDto, int displayYear, Date targetDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currentGiveDay", 0.0);
        map.put("formerRestDay", 0.0);
        map.put("termUseHolidayRequestDay", 0.0);
        double currentGiveDay = 0.0;
        double formerRestDay = 0.0;
        double termUseHolidayRequestDay = 0.0;
        double currentHoldDay = 0.0;
        double formerHoldDay = 0.0;
        double currentGivingDay = 0.0;
        double formerGivingDay = 0.0;
        double currentCancelDay = 0.0;
        double formerCancelDay = 0.0;
        double formerUseDay = 0.0;
        String personalId = humanDto.getPersonalId();
        Date fiscalFirstDate = MonthUtility.getFiscalYearFirstDate((int)displayYear, (MospParams)this.mospParams);
        Date fiscalLastDate = MonthUtility.getFiscalYearLastDate((int)displayYear, (MospParams)this.mospParams);
        Date lastDate = DateUtility.addDay((Date)fiscalFirstDate, (int)-1);
        List stockHolidayDataDtoList = this.stockHolidayDataDao.findForInfoAllList(personalId, lastDate);
        for (StockHolidayDataDtoInterface stockHolidayDataDto : stockHolidayDataDtoList) {
            boolean isCurrent;
            Date acquisitionDate = stockHolidayDataDto.getAcquisitionDate();
            if (acquisitionDate.compareTo(targetDate) > 0) continue;
            double restDays = stockHolidayDataDto.getHoldDay();
            boolean bl = isCurrent = acquisitionDate.compareTo(lastDate) > 0;
            if (isCurrent) {
                currentHoldDay += stockHolidayDataDto.getHoldDay();
            } else {
                formerHoldDay += stockHolidayDataDto.getHoldDay();
            }
            List requestList = this.holidayRequest.getUsePaidHolidayDataList(personalId, acquisitionDate);
            List stockHolidayTransactionDtoList = this.stockHolidayTransactionDao.findForList(personalId, acquisitionDate, stockHolidayDataDto.getActivateDate(), targetDate);
            for (StockHolidayTransactionDtoInterface stockHolidayTransactionDto : stockHolidayTransactionDtoList) {
                if (isCurrent) {
                    currentGivingDay += stockHolidayTransactionDto.getGivingDay();
                    currentCancelDay += stockHolidayTransactionDto.getCancelDay();
                } else {
                    formerGivingDay += stockHolidayTransactionDto.getGivingDay();
                    formerCancelDay += stockHolidayTransactionDto.getCancelDay();
                }
                restDays += stockHolidayTransactionDto.getGivingDay();
                restDays -= stockHolidayTransactionDto.getCancelDay();
            }
            for (HolidayRequestDtoInterface requestDto : requestList) {
                Date requestDate;
                if (!TimeUtility.isStockHolidayRequest((HolidayRequestDtoInterface)requestDto) || (requestDate = requestDto.getRequestStartDate()).compareTo(fiscalLastDate) > 0) continue;
                if (requestDate.compareTo(lastDate) > 0) {
                    termUseHolidayRequestDay += requestDto.getUseDay();
                } else {
                    formerUseDay += requestDto.getUseDay();
                }
                restDays -= requestDto.getUseDay();
            }
            if (targetDate.compareTo(stockHolidayDataDto.getLimitDate()) <= 0) continue;
            termUseHolidayRequestDay += restDays;
        }
        currentGiveDay = currentHoldDay + currentGivingDay - currentCancelDay;
        formerRestDay = formerHoldDay + formerGivingDay - formerCancelDay - formerUseDay;
        map.put("currentGiveDay", currentGiveDay);
        map.put("formerRestDay", formerRestDay);
        map.put("termUseHolidayRequestDay", termUseHolidayRequestDay);
        return map;
    }
}

