/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.time.bean.StockHolidayDataRegistBeanInterface;
import jp.mosp.time.dao.settings.StockHolidayDataDaoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdStockHolidayDto;

public class StockHolidayDataRegistBean
extends PlatformBean
implements StockHolidayDataRegistBeanInterface {
    StockHolidayDataDaoInterface dao;

    public StockHolidayDataRegistBean() {
    }

    public StockHolidayDataRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (StockHolidayDataDaoInterface)this.createDao(StockHolidayDataDaoInterface.class);
    }

    public StockHolidayDataDtoInterface getInitDto() {
        return new TmdStockHolidayDto();
    }

    public void insert(StockHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        StockHolidayDataDtoInterface stockHolidayDataDto = this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (stockHolidayDataDto != null) {
            this.validate(stockHolidayDataDto);
            this.checkUpdate(stockHolidayDataDto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, stockHolidayDataDto.getTmdStockHolidayId());
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdStockHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(StockHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdStockHolidayId());
        dto.setTmdStockHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(StockHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdStockHolidayId());
    }

    public void delete(String personalId, Date activateDate) throws MospException {
        List list = this.dao.findForList(personalId, activateDate);
        for (StockHolidayDataDtoInterface dto : list) {
            this.checkDelete((StockHolidayDataDtoInterface)this.dao.findForKey(dto.getTmdStockHolidayId(), true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdStockHolidayId());
        }
    }

    protected void checkInsert(StockHolidayDataDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate()));
    }

    protected void checkUpdate(StockHolidayDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdStockHolidayId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmdStockHolidayId(), true))) {
            return;
        }
    }

    protected void checkDelete(StockHolidayDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdStockHolidayId());
    }

    protected void validate(StockHolidayDataDtoInterface dto) {
        String employeeCode = MospUtility.getCodeName((String)"employee_code", (String[][])this.mospParams.getProperties().getCodeArray("import_tmd_stock_holiday", false));
        String activateDate = MospUtility.getCodeName((String)"activate_date", (String[][])this.mospParams.getProperties().getCodeArray("import_tmd_stock_holiday", false));
        String acquisitionDate = MospUtility.getCodeName((String)"acquisition_date", (String[][])this.mospParams.getProperties().getCodeArray("import_tmd_stock_holiday", false));
        String limitDate = MospUtility.getCodeName((String)"limit_date", (String[][])this.mospParams.getProperties().getCodeArray("import_tmd_stock_holiday", false));
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getPersonalId(), (String[])new String[]{employeeCode});
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)this.getStringDate(dto.getActivateDate()), (String[])new String[]{activateDate});
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)this.getStringDate(dto.getAcquisitionDate()), (String[])new String[]{acquisitionDate});
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)this.getStringDate(dto.getAcquisitionDate()), (String[])new String[]{limitDate});
    }
}

