/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.impl.ScheduleDateReferenceBean;
import jp.mosp.time.bean.impl.ScheduleReferenceBean;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;

public class ScheduleUtilBean
extends TimeApplicationBean
implements ScheduleUtilBeanInterface {
    protected ScheduleDateReferenceBean scheduleDateReference;
    protected ScheduleReferenceBean scheduleReference;
    protected SubstituteReferenceBeanInterface substituteReference;

    public ScheduleUtilBean() {
    }

    protected ScheduleUtilBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.scheduleDateReference = (ScheduleDateReferenceBean)this.createBean(ScheduleDateReferenceBean.class);
        this.scheduleReference = (ScheduleReferenceBean)this.createBean(ScheduleReferenceBean.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBean(SubstituteReferenceBeanInterface.class);
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate) throws MospException {
        this.setApplicationSettings(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return "";
        }
        return this.getScheduledWorkTypeCode(targetDate);
    }

    public String getScheduledWorkTypeCode(ApplicationDtoInterface dto, Date targetDate) throws MospException {
        this.applicationDto = dto;
        this.applicationRefer.chkExistApplication(this.applicationDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return "";
        }
        return this.getScheduledWorkTypeCode(targetDate);
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate, boolean useRequest) throws MospException {
        if (!useRequest) {
            return this.getScheduledWorkTypeCode(personalId, targetDate);
        }
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, targetDate);
        return this.getScheduledWorkTypeCode(personalId, targetDate, requestUtil);
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate, RequestUtilBeanInterface requestUtil) throws MospException {
        DifferenceRequestDtoInterface differenceRequestDto = requestUtil.getDifferenceDto(true);
        if (differenceRequestDto != null) {
            return differenceRequestDto.getDifferenceType();
        }
        WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = requestUtil.getWorkTypeChangeDto(true);
        if (workTypeChangeRequestDto != null) {
            return workTypeChangeRequestDto.getWorkTypeCode();
        }
        Date date = targetDate;
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null) {
            List list = requestUtil.getSubstituteList(true);
            for (SubstituteDtoInterface dto : list) {
                if (dto.getSubstituteRange() != 1) continue;
                return dto.getSubstituteType();
            }
        } else {
            int substitute = workOnHolidayRequestDto.getSubstitute();
            if (substitute == 1 || substitute == 3 || substitute == 4) {
                List list = this.substituteReference.getSubstituteList(workOnHolidayRequestDto.getWorkflow());
                if (list.isEmpty()) {
                    return "";
                }
                date = ((SubstituteDtoInterface)list.get(0)).getSubstituteDate();
            } else {
                if (substitute == 5) {
                    return workOnHolidayRequestDto.getWorkTypeCode();
                }
                if (substitute == 2) {
                    if ("legal_holiday".equals(workOnHolidayRequestDto.getWorkOnHolidayType())) {
                        return "work_on_legal";
                    }
                    if ("prescribed_holiday".equals(workOnHolidayRequestDto.getWorkOnHolidayType())) {
                        return "work_on_prescribed";
                    }
                    return "";
                }
                return "";
            }
        }
        if (!this.hasApplicationSettings(personalId, date)) {
            return "";
        }
        ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(this.applicationDto.getScheduleCode(), date);
        if (scheduleDto == null) {
            return "";
        }
        ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleDto.getScheduleCode(), date);
        if (scheduleDateDto == null || scheduleDateDto.getWorkTypeCode() == null) {
            return "";
        }
        return scheduleDateDto.getWorkTypeCode();
    }

    protected String getScheduledWorkTypeCode(Date targetDate) throws MospException {
        int targetYear = MonthUtility.getFiscalYear((Date)targetDate, (MospParams)this.mospParams);
        Date targetYearDate = MonthUtility.getYearDate((int)targetYear, (MospParams)this.mospParams);
        ScheduleDtoInterface scheduleDto = this.scheduleReference.findForKey(this.applicationDto.getScheduleCode(), targetYearDate);
        this.scheduleReference.chkExistSchedule(scheduleDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return "";
        }
        ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.findForKey(scheduleDto.getScheduleCode(), targetDate);
        this.scheduleDateReference.chkExistScheduleDate(scheduleDateDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return "";
        }
        if (scheduleDateDto.getWorkTypeCode() == null || scheduleDateDto.getWorkTypeCode().isEmpty()) {
            this.addWorkTypeNotExistErrorMessage(targetDate);
            return "";
        }
        return scheduleDateDto.getWorkTypeCode();
    }
}

