/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.ScheduleReferenceTotalBeanInterface;
import jp.mosp.time.dao.settings.ScheduleDateDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;

public class ScheduleReferenceTotalBean
extends PlatformBean
implements ScheduleReferenceTotalBeanInterface {
    ScheduleDateDaoInterface scheduleDateDao;
    WorkTypeItemDaoInterface workTypeItemDao;

    public ScheduleReferenceTotalBean() {
    }

    public ScheduleReferenceTotalBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.scheduleDateDao = (ScheduleDateDaoInterface)this.createDao(ScheduleDateDaoInterface.class);
        this.workTypeItemDao = (WorkTypeItemDaoInterface)this.createDao(WorkTypeItemDaoInterface.class);
    }

    public int getTimesLegalHolidayViews(String scheduleCode, Date startDate, Date endDate) throws MospException {
        List scheduleDateDto = this.scheduleDateDao.findForList(scheduleCode, startDate, endDate);
        int timesLegalHolidayViews = 0;
        for (int i = 0; i < scheduleDateDto.size(); ++i) {
            if (!((ScheduleDateDtoInterface)scheduleDateDto.get(i)).getWorkTypeCode().equals("legal_holiday")) continue;
            ++timesLegalHolidayViews;
        }
        return timesLegalHolidayViews;
    }

    public int getTimesSpecificHolidayViews(String scheduleCode, Date startDate, Date endDate) throws MospException {
        List scheduleDateDto = this.scheduleDateDao.findForList(scheduleCode, startDate, endDate);
        int timesSpecificHolidayViews = 0;
        for (int i = 0; i < scheduleDateDto.size(); ++i) {
            if (!((ScheduleDateDtoInterface)scheduleDateDto.get(i)).getWorkTypeCode().equals("prescribed_holiday")) continue;
            ++timesSpecificHolidayViews;
        }
        return timesSpecificHolidayViews;
    }

    public int getTimesWorkViews(String scheduleCode, Date startDate, Date endDate) throws MospException {
        List scheduleDateDto = this.scheduleDateDao.findForList(scheduleCode, startDate, endDate);
        int timesWorkViews = 0;
        for (int i = 0; i < scheduleDateDto.size(); ++i) {
            if (((ScheduleDateDtoInterface)scheduleDateDto.get(i)).getWorkTypeCode().equals("legal_holiday") || ((ScheduleDateDtoInterface)scheduleDateDto.get(i)).getWorkTypeCode().equals("prescribed_holiday")) continue;
            ++timesWorkViews;
        }
        return timesWorkViews;
    }

    public int getTotalRestTime(String scheduleCode, Date startDate, Date endDate) throws MospException {
        List scheduleDateDto = this.scheduleDateDao.findForList(scheduleCode, startDate, endDate);
        int totalRestTime = 0;
        for (int i = 0; i < scheduleDateDto.size(); ++i) {
            WorkTypeItemDtoInterface workTypeItemDto = this.workTypeItemDao.findForKey(((ScheduleDateDtoInterface)scheduleDateDto.get(i)).getWorkTypeCode(), ((ScheduleDateDtoInterface)scheduleDateDto.get(i)).getActivateDate(), "RestTime");
            if (workTypeItemDto.getWorkTypeItemValue() == null) continue;
            totalRestTime = totalRestTime + DateUtility.getHour((Date)workTypeItemDto.getWorkTypeItemValue()) * 60 + DateUtility.getMinute((Date)workTypeItemDto.getWorkTypeItemValue());
        }
        return totalRestTime;
    }

    public int getTotalWorkTime(String scheduleCode, Date startDate, Date endDate) throws MospException {
        List scheduleDateDto = this.scheduleDateDao.findForList(scheduleCode, startDate, endDate);
        int totalRestTime = 0;
        for (int i = 0; i < scheduleDateDto.size(); ++i) {
            WorkTypeItemDtoInterface workTypeItemDto = this.workTypeItemDao.findForKey(((ScheduleDateDtoInterface)scheduleDateDto.get(i)).getWorkTypeCode(), ((ScheduleDateDtoInterface)scheduleDateDto.get(i)).getActivateDate(), "WorkTime");
            if (workTypeItemDto.getWorkTypeItemValue() == null) continue;
            totalRestTime = totalRestTime + DateUtility.getHour((Date)workTypeItemDto.getWorkTypeItemValue()) * 60 + DateUtility.getMinute((Date)workTypeItemDto.getWorkTypeItemValue());
        }
        return totalRestTime;
    }
}

