/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.dao.settings.ScheduleDaoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;

public class ScheduleReferenceBean
extends PlatformBean
implements ScheduleReferenceBeanInterface {
    private ScheduleDaoInterface dao;

    public ScheduleReferenceBean() {
    }

    public ScheduleReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (ScheduleDaoInterface)this.createDao(ScheduleDaoInterface.class);
    }

    public ScheduleDtoInterface getScheduleInfo(String scheduleCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(scheduleCode, targetDate);
    }

    public List<ScheduleDtoInterface> getScheduleHistory(String scheduleCode) throws MospException {
        return this.dao.findForHistory(scheduleCode);
    }

    public String getScheduleAbbr(String scheduleCode, Date targetDate) throws MospException {
        ScheduleDtoInterface dto = this.getScheduleInfo(scheduleCode, targetDate);
        if (dto == null) {
            return scheduleCode;
        }
        return dto.getScheduleAbbr();
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(targetDate, needBlank, true, true);
    }

    public ScheduleDtoInterface findForKey(String scheduleCode, Date activateDate) throws MospException {
        return this.dao.findForKey(scheduleCode, activateDate);
    }

    protected String[][] getSelectArray(Date targetDate, boolean needBlank, boolean isName, boolean viewCode) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (ScheduleDtoInterface dto : list) {
            array[idx][0] = dto.getScheduleCode();
            if (isName && viewCode) {
                array[idx++][1] = this.getCodedName(dto.getScheduleCode(), dto.getScheduleName(), length);
                continue;
            }
            if (isName) {
                array[idx++][1] = dto.getScheduleName();
                continue;
            }
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getScheduleCode(), dto.getScheduleAbbr(), length);
                continue;
            }
            array[idx++][1] = dto.getScheduleAbbr();
        }
        return array;
    }

    protected int getMaxCodeLength(List<ScheduleDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (ScheduleDtoInterface dto : list) {
            if (dto.getScheduleCode().length() <= length) continue;
            length = dto.getScheduleCode().length();
        }
        return length;
    }

    public void chkExistSchedule(ScheduleDtoInterface dto, Date targetDate) {
        if (dto == null) {
            String errorMes1 = DateUtility.getStringDate((Date)targetDate);
            String errorMes2 = this.mospParams.getName("Calendar", new String[]{"Set", "Information"});
            this.mospParams.addErrorMessage("TMW0246", new String[]{errorMes1, errorMes2});
        }
    }

    public String[][] getSelectArray(Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(targetDate, needBlank, false, false);
    }
}

