/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.entity.RequestEntityInterface;

public class RequestUtilBean
extends TimeBean
implements RequestUtilBeanInterface {
    HolidayRequestReferenceBeanInterface holidayRequestRefer;
    OvertimeRequestReferenceBeanInterface overtimeRequestRefer;
    WorkOnHolidayRequestReferenceBeanInterface workOnHolidayRefer;
    SubstituteReferenceBeanInterface substituteRefer;
    SubHolidayRequestReferenceBeanInterface subHolidayRequestRefer;
    DifferenceRequestReferenceBeanInterface differenceRequestRefer;
    WorkTypeChangeRequestReferenceBeanInterface workTypeChangeRequestRefer;
    AttendanceReferenceBeanInterface attendanceReference;
    WorkflowReferenceBeanInterface workflowReference;
    WorkflowIntegrateBeanInterface workflowIntegrate;
    ScheduleUtilBeanInterface scheduleUtil;
    protected List<HolidayRequestDtoInterface> holidayRequestList;
    protected List<OvertimeRequestDtoInterface> overTimeRequestList;
    protected List<SubstituteDtoInterface> substituteList;
    protected List<SubHolidayRequestDtoInterface> subHolidayRequestList;
    protected WorkOnHolidayRequestDtoInterface workOnHolidayDto;
    protected DifferenceRequestDtoInterface differenceDto;
    protected WorkTypeChangeRequestDtoInterface workTypeChangeDto;
    protected AttendanceDtoInterface attendanceDto;
    protected Map<Long, WorkflowDtoInterface> workflowMap;
    protected String substitutedWorkTypeCode;
    protected String scheduledWorkTypeCode;
    protected static final int CODE_HOLIDAY_RANGE_AM_PM = 5;

    public RequestUtilBean() {
    }

    protected RequestUtilBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.holidayRequestRefer = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.workOnHolidayRefer = (WorkOnHolidayRequestReferenceBeanInterface)this.createBean(WorkOnHolidayRequestReferenceBeanInterface.class);
        this.substituteRefer = (SubstituteReferenceBeanInterface)this.createBean(SubstituteReferenceBeanInterface.class);
        this.overtimeRequestRefer = (OvertimeRequestReferenceBeanInterface)this.createBean(OvertimeRequestReferenceBeanInterface.class);
        this.differenceRequestRefer = (DifferenceRequestReferenceBeanInterface)this.createBean(DifferenceRequestReferenceBeanInterface.class);
        this.workTypeChangeRequestRefer = (WorkTypeChangeRequestReferenceBeanInterface)this.createBean(WorkTypeChangeRequestReferenceBeanInterface.class);
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.subHolidayRequestRefer = (SubHolidayRequestReferenceBeanInterface)this.createBean(SubHolidayRequestReferenceBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
    }

    public void setRequests(String personalId, Date targetDate) throws MospException {
        this.holidayRequestList = this.holidayRequestRefer.getHolidayRequestList(personalId, targetDate);
        this.workOnHolidayDto = this.workOnHolidayRefer.findForSubstitute(personalId, targetDate, 1);
        this.substituteList = this.substituteRefer.getSubstituteList(personalId, targetDate);
        this.overTimeRequestList = this.overtimeRequestRefer.getOvertimeRequestList(personalId, targetDate, targetDate);
        this.subHolidayRequestList = this.subHolidayRequestRefer.getSubHolidayRequestList(personalId, targetDate);
        this.differenceDto = this.differenceRequestRefer.findForKeyOnWorkflow(personalId, targetDate);
        this.workTypeChangeDto = this.workTypeChangeRequestRefer.findForKeyOnWorkflow(personalId, targetDate);
        this.attendanceDto = this.attendanceReference.findForKey(personalId, targetDate, 1);
        this.workflowMap = new HashMap();
    }

    public List<SubstituteDtoInterface> getSubstituteList(boolean status) throws MospException {
        ArrayList<SubstituteDtoInterface> completedSubstitute = new ArrayList<SubstituteDtoInterface>();
        if (this.substituteList == null || this.substituteList.isEmpty()) {
            return completedSubstitute;
        }
        for (SubstituteDtoInterface substituteDto : this.substituteList) {
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(substituteDto.getWorkflow());
            if (workflowDto == null) continue;
            if (status && "9".equals(workflowDto.getWorkflowStatus())) {
                completedSubstitute.add(substituteDto);
            }
            if (status || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus())) continue;
            completedSubstitute.add(substituteDto);
        }
        return completedSubstitute;
    }

    public List<OvertimeRequestDtoInterface> getOverTimeList(boolean status) throws MospException {
        ArrayList<OvertimeRequestDtoInterface> completedOvertime = new ArrayList<OvertimeRequestDtoInterface>();
        if (this.overTimeRequestList == null || this.overTimeRequestList.isEmpty()) {
            return completedOvertime;
        }
        for (OvertimeRequestDtoInterface overtimeDto : this.overTimeRequestList) {
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(overtimeDto.getWorkflow());
            if (workflowDto == null) continue;
            if (status && "9".equals(workflowDto.getWorkflowStatus())) {
                completedOvertime.add(overtimeDto);
            }
            if (status || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus())) continue;
            completedOvertime.add(overtimeDto);
        }
        return completedOvertime;
    }

    public List<SubHolidayRequestDtoInterface> getSubHolidayList(boolean status) throws MospException {
        ArrayList<SubHolidayRequestDtoInterface> completedsubHoliday = new ArrayList<SubHolidayRequestDtoInterface>();
        if (this.subHolidayRequestList == null || this.subHolidayRequestList.isEmpty()) {
            return completedsubHoliday;
        }
        for (SubHolidayRequestDtoInterface subHolidayDto : this.subHolidayRequestList) {
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(subHolidayDto.getWorkflow());
            if (workflowDto == null) continue;
            if (status && "9".equals(workflowDto.getWorkflowStatus())) {
                completedsubHoliday.add(subHolidayDto);
            }
            if (status || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus())) continue;
            completedsubHoliday.add(subHolidayDto);
        }
        return completedsubHoliday;
    }

    public List<HolidayRequestDtoInterface> getHolidayList(boolean status) throws MospException {
        ArrayList<HolidayRequestDtoInterface> completedHoliday = new ArrayList<HolidayRequestDtoInterface>();
        if (this.holidayRequestList == null || this.holidayRequestList.isEmpty()) {
            return completedHoliday;
        }
        for (HolidayRequestDtoInterface holidayDto : this.holidayRequestList) {
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(holidayDto.getWorkflow());
            if (workflowDto == null) continue;
            if (status && "9".equals(workflowDto.getWorkflowStatus())) {
                completedHoliday.add(holidayDto);
            }
            if (status || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus())) continue;
            completedHoliday.add(holidayDto);
        }
        return completedHoliday;
    }

    public DifferenceRequestDtoInterface getDifferenceDto(boolean status) throws MospException {
        if (this.differenceDto == null) {
            return null;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(this.differenceDto.getWorkflow());
        if (workflowDto == null) {
            return null;
        }
        if (status && "9".equals(workflowDto.getWorkflowStatus())) {
            return this.differenceDto;
        }
        if (!(status || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus()))) {
            return this.differenceDto;
        }
        return null;
    }

    public WorkTypeChangeRequestDtoInterface getWorkTypeChangeDto(boolean status) throws MospException {
        if (this.workTypeChangeDto == null) {
            return null;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(this.workTypeChangeDto.getWorkflow());
        if (workflowDto == null) {
            return null;
        }
        if (status && this.workflowIntegrate.isCompleted(workflowDto)) {
            return this.workTypeChangeDto;
        }
        if (!(status || this.workflowIntegrate.isDraft(workflowDto) || this.workflowIntegrate.isWithDrawn(workflowDto))) {
            return this.workTypeChangeDto;
        }
        return null;
    }

    public WorkOnHolidayRequestDtoInterface getWorkOnHolidayDto(boolean status) throws MospException {
        if (this.workOnHolidayDto == null) {
            return null;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(this.workOnHolidayDto.getWorkflow());
        if (workflowDto == null) {
            return null;
        }
        if (status && "9".equals(workflowDto.getWorkflowStatus())) {
            return this.workOnHolidayDto;
        }
        if (!(status || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus()))) {
            return this.workOnHolidayDto;
        }
        return null;
    }

    public AttendanceDtoInterface getDraftAttendance() throws MospException {
        if (this.attendanceDto == null) {
            return null;
        }
        if (this.workflowIntegrate.isDraft(this.attendanceDto.getWorkflow())) {
            return this.attendanceDto;
        }
        return null;
    }

    public AttendanceDtoInterface getFirstRevertedAttendance() throws MospException {
        if (this.attendanceDto == null) {
            return null;
        }
        if (this.workflowIntegrate.isFirstReverted(this.attendanceDto.getWorkflow())) {
            return this.attendanceDto;
        }
        return null;
    }

    public AttendanceDtoInterface getApplicatedAttendance() throws MospException {
        if (this.attendanceDto == null) {
            return null;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(this.attendanceDto.getWorkflow());
        if (this.workflowIntegrate.isWithDrawn(workflowDto)) {
            return null;
        }
        if (this.workflowIntegrate.isDraft(workflowDto)) {
            return null;
        }
        if (this.workflowIntegrate.isFirstReverted(workflowDto)) {
            return null;
        }
        return this.attendanceDto;
    }

    public HolidayRequestDtoInterface getCompletedHolidayRangeAll() throws MospException {
        List getCompletedHolidayList = this.getHolidayList(true);
        if (getCompletedHolidayList.isEmpty()) {
            return null;
        }
        for (HolidayRequestDtoInterface holidayDto : getCompletedHolidayList) {
            if (holidayDto.getHolidayRange() != 1) continue;
            return holidayDto;
        }
        return null;
    }

    public SubHolidayRequestDtoInterface getCompletedSubHolidayRangeAll() throws MospException {
        List getCompletedSubHolidayList = this.getSubHolidayList(true);
        if (getCompletedSubHolidayList.isEmpty()) {
            return null;
        }
        for (SubHolidayRequestDtoInterface subHolidayDto : getCompletedSubHolidayList) {
            if (subHolidayDto.getHolidayRange() != 1) continue;
            return subHolidayDto;
        }
        return null;
    }

    public SubstituteDtoInterface getCompletedSubstituteRangeAll() throws MospException {
        List getCompletedSubstituteList = this.getSubstituteList(true);
        if (getCompletedSubstituteList.isEmpty()) {
            return null;
        }
        for (SubstituteDtoInterface substituteDto : getCompletedSubstituteList) {
            if (this.getWorkOnHolidayDto(true) != null || substituteDto.getSubstituteRange() != 1) continue;
            return substituteDto;
        }
        return null;
    }

    public boolean isHolidayAllDay(boolean status) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto;
        List statusSubHolidayList;
        int rangeSubHoliday;
        List statusSubstituteList;
        int rangeSubstitute;
        boolean amFlag = false;
        boolean pmFlag = false;
        List statusHolidayList = this.getHolidayList(status);
        int rangeHoliday = this.checkHolidayRangeHoliday(statusHolidayList);
        if (rangeHoliday != 0) {
            if (rangeHoliday == 1 || rangeHoliday == 5) {
                return true;
            }
            if (rangeHoliday == 2) {
                amFlag = true;
            }
            if (rangeHoliday == 3) {
                pmFlag = true;
            }
        }
        if ((rangeSubstitute = this.checkHolidayRangeSubstitute(statusSubstituteList = this.getSubstituteList(status))) != 0) {
            if (rangeSubstitute == 1 || rangeSubstitute == 5) {
                return true;
            }
            if (rangeSubstitute == 2) {
                amFlag = true;
            }
            if (rangeSubstitute == 3) {
                pmFlag = true;
            }
        }
        if ((rangeSubHoliday = this.checkHolidayRangeSubHoliday(statusSubHolidayList = this.getSubHolidayList(status))) == 1 || rangeSubHoliday == 5) {
            return true;
        }
        if (rangeSubHoliday == 2) {
            amFlag = true;
        }
        if (rangeSubHoliday == 3) {
            pmFlag = true;
        }
        if ((workOnHolidayRequestDto = this.getWorkOnHolidayDto(status)) != null) {
            int substitute = workOnHolidayRequestDto.getSubstitute();
            if (substitute == 2) {
                return false;
            }
            if (substitute == 3) {
                pmFlag = true;
            }
            if (substitute == 4) {
                amFlag = true;
            }
        }
        return amFlag && pmFlag;
    }

    public int checkHolidayRangeHoliday(List<HolidayRequestDtoInterface> holidayRequestList) {
        int range = 0;
        if (holidayRequestList.isEmpty()) {
            return range;
        }
        for (HolidayRequestDtoInterface HolidayDto : holidayRequestList) {
            if (HolidayDto.getHolidayRange() == 1) {
                return 1;
            }
            if (HolidayDto.getHolidayRange() == 2) {
                if (range == 3) {
                    return 5;
                }
                range = 2;
                continue;
            }
            if (HolidayDto.getHolidayRange() == 3) {
                if (range == 2) {
                    return 5;
                }
                range = 3;
            }
            if (HolidayDto.getHolidayRange() != 4) continue;
            return 4;
        }
        return range;
    }

    public int checkHolidayRangeSubstitute(List<SubstituteDtoInterface> substituteList) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayDto;
        int range = 0;
        if (substituteList.isEmpty()) {
            return range;
        }
        for (SubstituteDtoInterface substituteDto : substituteList) {
            if (substituteDto.getSubstituteRange() == 1) {
                range = 1;
                break;
            }
            if (substituteDto.getSubstituteRange() == 2) {
                if (range == 3) {
                    range = 5;
                    break;
                }
                range = 2;
                continue;
            }
            if (substituteDto.getSubstituteRange() != 3) continue;
            if (range == 2) {
                range = 5;
                break;
            }
            range = 3;
        }
        if ((workOnHolidayDto = this.getWorkOnHolidayDto(true)) == null) {
            return range;
        }
        int poneRange = workOnHolidayDto.getSubstitute();
        if (poneRange == 1 || poneRange == 2 || poneRange == 5) {
            return 0;
        }
        if (poneRange == 3) {
            switch (range) {
                case 1: 
                case 5: {
                    range = 3;
                    break;
                }
                case 2: {
                    range = 0;
                    break;
                }
            }
        }
        if (poneRange == 4) {
            switch (range) {
                case 1: 
                case 5: {
                    range = 2;
                    break;
                }
                case 3: {
                    range = 0;
                    break;
                }
            }
        }
        return range;
    }

    public int checkHolidayRangeSubHoliday(List<SubHolidayRequestDtoInterface> subHolidayList) {
        int range = 0;
        if (subHolidayList.isEmpty()) {
            return range;
        }
        for (SubHolidayRequestDtoInterface subHolidayDto : subHolidayList) {
            if (subHolidayDto.getHolidayRange() == 1) {
                return 1;
            }
            if (subHolidayDto.getHolidayRange() == 2) {
                if (range == 3) {
                    return 5;
                }
                range = 2;
                continue;
            }
            if (subHolidayDto.getHolidayRange() != 3) continue;
            if (range == 2) {
                return 5;
            }
            range = 3;
        }
        return range;
    }

    public RequestEntity getRequestEntity(String personalId, Date targetDate) throws MospException {
        RequestEntity requestEntity = (RequestEntity)this.createObject(RequestEntityInterface.class);
        requestEntity.setPersonalId(personalId);
        requestEntity.setTargetDate(targetDate);
        this.setRequests(personalId, targetDate);
        requestEntity.setHolidayRequestList(this.holidayRequestList);
        requestEntity.setWorkOnHolidayRequestDto(this.workOnHolidayDto);
        requestEntity.setSubstituteList(this.substituteList);
        requestEntity.setOverTimeRequestList(this.overTimeRequestList);
        requestEntity.setSubHolidayRequestList(this.subHolidayRequestList);
        requestEntity.setDifferenceRequestDto(this.differenceDto);
        requestEntity.setWorkTypeChangeRequestDto(this.workTypeChangeDto);
        requestEntity.setAttendanceDto(this.attendanceDto);
        requestEntity.setWorkflowMap(this.getWorkflowMap());
        requestEntity.setScheduledWorkTypeCode(this.getScheduledWorkTypeCode(personalId, targetDate));
        requestEntity.setSubstitutedWorkTypeCode(this.getSubstitutedWorkTypeCode());
        return requestEntity;
    }

    protected String getScheduledWorkTypeCode(String personalId, Date targetDate) throws MospException {
        if (this.scheduledWorkTypeCode != null) {
            return this.scheduledWorkTypeCode;
        }
        this.scheduledWorkTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate);
        return this.scheduledWorkTypeCode;
    }

    protected String getSubstitutedWorkTypeCode() throws MospException {
        Date workDate;
        if (this.substitutedWorkTypeCode != null) {
            return this.substitutedWorkTypeCode;
        }
        this.substitutedWorkTypeCode = "";
        if (this.workOnHolidayDto == null) {
            return this.substitutedWorkTypeCode;
        }
        int substitute = this.workOnHolidayDto.getSubstitute();
        String workOnHolidayType = this.workOnHolidayDto.getWorkOnHolidayType();
        if (substitute == 2) {
            if (workOnHolidayType.equals("legal_holiday")) {
                this.substitutedWorkTypeCode = "work_on_legal";
                return this.substitutedWorkTypeCode;
            }
            if (workOnHolidayType.equals("prescribed_holiday")) {
                this.substitutedWorkTypeCode = "work_on_prescribed";
                return this.substitutedWorkTypeCode;
            }
        }
        if (substitute == 5) {
            this.substitutedWorkTypeCode = this.workOnHolidayDto.getWorkTypeCode();
            return this.substitutedWorkTypeCode;
        }
        String personalId = this.workOnHolidayDto.getPersonalId();
        SubstituteDtoInterface substituteDto = this.substituteRefer.getSubstituteDto(personalId, workDate = this.workOnHolidayDto.getRequestDate());
        if (substituteDto != null) {
            Date substituteDate = substituteDto.getSubstituteDate();
            this.substitutedWorkTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, substituteDate);
            return this.substitutedWorkTypeCode;
        }
        return this.substitutedWorkTypeCode;
    }

    protected Map<Long, WorkflowDtoInterface> getWorkflowMap() throws MospException {
        long workflow;
        if (this.workflowMap != null && !this.workflowMap.isEmpty()) {
            return this.workflowMap;
        }
        this.workflowMap = new HashMap();
        for (HolidayRequestDtoInterface dto : this.holidayRequestList) {
            workflow = dto.getWorkflow();
            this.workflowMap.put(workflow, this.workflowReference.getLatestWorkflowInfo(workflow));
        }
        if (this.workOnHolidayDto != null) {
            long workflow2 = this.workOnHolidayDto.getWorkflow();
            this.workflowMap.put(workflow2, this.workflowReference.getLatestWorkflowInfo(workflow2));
        }
        for (HolidayRequestDtoInterface dto : this.substituteList) {
            workflow = dto.getWorkflow();
            this.workflowMap.put(workflow, this.workflowReference.getLatestWorkflowInfo(workflow));
        }
        for (HolidayRequestDtoInterface dto : this.overTimeRequestList) {
            workflow = dto.getWorkflow();
            this.workflowMap.put(workflow, this.workflowReference.getLatestWorkflowInfo(workflow));
        }
        for (HolidayRequestDtoInterface dto : this.subHolidayRequestList) {
            workflow = dto.getWorkflow();
            this.workflowMap.put(workflow, this.workflowReference.getLatestWorkflowInfo(workflow));
        }
        if (this.differenceDto != null) {
            long workflow3 = this.differenceDto.getWorkflow();
            this.workflowMap.put(workflow3, this.workflowReference.getLatestWorkflowInfo(workflow3));
        }
        if (this.workTypeChangeDto != null) {
            long workflow4 = this.workTypeChangeDto.getWorkflow();
            this.workflowMap.put(workflow4, this.workflowReference.getLatestWorkflowInfo(workflow4));
        }
        if (this.attendanceDto != null) {
            long workflow5 = this.attendanceDto.getWorkflow();
            this.workflowMap.put(workflow5, this.workflowReference.getLatestWorkflowInfo(workflow5));
        }
        return this.workflowMap;
    }
}

