/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionRegistBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dao.settings.PaidHolidayDataDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayTransactionDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.impl.TmtPaidHolidayTransactionDto;

public class PaidHolidayTransactionRegistBean
extends PlatformBean
implements PaidHolidayTransactionRegistBeanInterface {
    private PaidHolidayTransactionDaoInterface dao;
    private PaidHolidayDataDaoInterface paidHolidayDataDao;
    HolidayRequestReferenceBeanInterface holidayRequest;
    private ApplicationReferenceBeanInterface application;
    private TimeSettingReferenceBeanInterface timeSetting;

    public PaidHolidayTransactionRegistBean() {
    }

    public PaidHolidayTransactionRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (PaidHolidayTransactionDaoInterface)this.createDao(PaidHolidayTransactionDaoInterface.class);
        this.paidHolidayDataDao = (PaidHolidayDataDaoInterface)this.createDao(PaidHolidayDataDaoInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.application = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.timeSetting = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
    }

    public PaidHolidayTransactionDtoInterface getInitDto() {
        return new TmtPaidHolidayTransactionDto();
    }

    public void insert(PaidHolidayTransactionDtoInterface dto) throws MospException {
        this.validate(dto);
        this.checkOverlapping(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmtPaidHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(PaidHolidayTransactionDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmtPaidHolidayId());
        dto.setTmtPaidHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(PaidHolidayTransactionDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate()));
        this.checkRemain(dto);
    }

    protected void checkUpdate(PaidHolidayTransactionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmtPaidHolidayId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmtPaidHolidayId(), true))) {
            return;
        }
        this.checkRemain(dto);
    }

    protected void validate(PaidHolidayTransactionDtoInterface dto) {
    }

    protected void checkRemain(PaidHolidayTransactionDtoInterface dto) throws MospException {
        int generalWorkHour = 8;
        ApplicationDtoInterface applicationDto = this.application.findForPerson(dto.getPersonalId(), dto.getActivateDate());
        if (applicationDto != null) {
            generalWorkHour = this.timeSetting.getGeneralWorkHour(applicationDto.getWorkSettingCode(), dto.getActivateDate());
        }
        double holdDay = 0.0;
        int holdHour = 0;
        double givingDay = 0.0;
        int givingHour = 0;
        double cancelDay = 0.0;
        int cancelHour = 0;
        double requestDay = 0.0;
        int requestHour = 0;
        double day = 0.0;
        int hour = 0;
        PaidHolidayDataDtoInterface paidHolidayDataDto = this.paidHolidayDataDao.findForInfo(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (paidHolidayDataDto != null) {
            holdDay = paidHolidayDataDto.getHoldDay();
            holdHour = paidHolidayDataDto.getHoldHour();
        }
        List paidHolidayTransactionDtoList = this.dao.findForList(dto.getPersonalId(), dto.getAcquisitionDate(), null, null);
        for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionDtoList) {
            if (paidHolidayTransactionDto.getActivateDate().equals(dto.getActivateDate())) continue;
            givingDay += paidHolidayTransactionDto.getGivingDay();
            givingHour += paidHolidayTransactionDto.getGivingHour();
            cancelDay += paidHolidayTransactionDto.getCancelDay();
            cancelHour += paidHolidayTransactionDto.getCancelHour();
        }
        if (paidHolidayDataDto != null) {
            Map map = this.holidayRequest.getRequestDayHour(dto.getPersonalId(), dto.getAcquisitionDate(), 1, Integer.toString(2), paidHolidayDataDto.getActivateDate(), dto.getAcquisitionDate());
            requestDay = (Double)map.get("requestDay");
            requestHour = (Integer)map.get("requestHour");
        }
        day = holdDay + givingDay - cancelDay - requestDay + dto.getGivingDay() - dto.getCancelDay();
        for (hour = holdHour + givingHour - cancelHour - requestHour + dto.getGivingHour() - dto.getCancelHour(); hour < 0; hour += generalWorkHour) {
            day -= 1.0;
        }
        if (day < 0.0) {
            String[] aryMeassage = new String[]{this.mospParams.getName("Remainder") + this.mospParams.getName("Num")};
            this.mospParams.addMessage("TMW0271", aryMeassage);
        }
    }

    public void checkOverlapping(PaidHolidayTransactionDtoInterface dto) throws MospException {
        PaidHolidayTransactionDtoInterface paidHoliday = this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (paidHoliday != null) {
            this.mospParams.addErrorMessage("TMW0263", new String[]{DateUtility.getStringDate((Date)dto.getActivateDate()), this.getHumanInfo(dto.getPersonalId(), dto.getActivateDate()).getEmployeeCode()});
        }
    }
}

