/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestSearchBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestListDtoInterface;
import jp.mosp.time.dto.settings.RequestListDtoInterface;
import jp.mosp.time.dto.settings.impl.OvertimeRequestListDto;

public class OvertimeRequestSearchBean
extends PlatformBean
implements OvertimeRequestSearchBeanInterface {
    private OvertimeRequestDaoInterface overtimeRequestDao;
    private AttendanceDaoInterface attendanceDao;
    private WorkflowReferenceBeanInterface workflowReference;
    private String personalId;
    private String workflowStatus;
    private String scheduleOver;
    private String overtimeType;
    private Date requestStartDate;
    private Date requestEndDate;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;

    public OvertimeRequestSearchBean() {
    }

    public OvertimeRequestSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.overtimeRequestDao = (OvertimeRequestDaoInterface)this.createDao(OvertimeRequestDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDao(AttendanceDaoInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
    }

    public List<OvertimeRequestListDtoInterface> getSearchList() throws MospException {
        Map param = this.overtimeRequestDao.getParamsMap();
        param.put("personalId", this.personalId);
        param.put("workflowStatus", this.workflowStatus);
        param.put("scheduleOver", this.scheduleOver);
        param.put("overtimeType", this.overtimeType);
        param.put("requestStartDate", this.requestStartDate);
        param.put("requestEndDate", this.requestEndDate);
        List requestList = this.overtimeRequestDao.findForSearch(param);
        ArrayList<OvertimeRequestListDtoInterface> list = new ArrayList<OvertimeRequestListDtoInterface>();
        boolean flag = false;
        for (OvertimeRequestDtoInterface requestDto : requestList) {
            OvertimeRequestListDto dto = new OvertimeRequestListDto();
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow());
            if (workflowDto == null) continue;
            dto.setTmdOvertimeRequestId(requestDto.getTmdOvertimeRequestId());
            AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(requestDto.getPersonalId(), requestDto.getRequestDate(), 1);
            if (this.scheduleOver.equals("")) {
                if (attendanceDto == null || !workflowDto.getWorkflowStatus().equals("9")) {
                    dto.setResultsTime(this.mospParams.getName("Hyphen"));
                } else if (requestDto.getOvertimeType() == 1) {
                    dto.setResultsTime(this.getTimeDotFormat(attendanceDto.getOvertimeBefore()));
                } else {
                    dto.setResultsTime(this.getTimeDotFormat(attendanceDto.getOvertimeAfter()));
                }
            } else if (this.scheduleOver.equals("1")) {
                if (attendanceDto == null || !workflowDto.getWorkflowStatus().equals("9")) continue;
                if (requestDto.getOvertimeType() == 1) {
                    if (requestDto.getRequestTime() >= attendanceDto.getOvertimeBefore()) continue;
                    dto.setResultsTime(this.getTimeDotFormat(attendanceDto.getOvertimeBefore()));
                } else {
                    if (requestDto.getRequestTime() >= attendanceDto.getOvertimeAfter()) continue;
                    dto.setResultsTime(this.getTimeDotFormat(attendanceDto.getOvertimeAfter()));
                }
            } else if (this.scheduleOver.equals("2")) {
                if (attendanceDto == null || !workflowDto.getWorkflowStatus().equals("9")) {
                    dto.setResultsTime(this.mospParams.getName("Hyphen"));
                } else if (requestDto.getOvertimeType() == 1) {
                    if (requestDto.getRequestTime() <= attendanceDto.getOvertimeBefore()) continue;
                    dto.setResultsTime(this.getTimeDotFormat(attendanceDto.getOvertimeBefore()));
                } else {
                    if (requestDto.getRequestTime() <= attendanceDto.getOvertimeAfter()) continue;
                    dto.setResultsTime(this.getTimeDotFormat(attendanceDto.getOvertimeAfter()));
                }
            }
            dto.setRequestDate(requestDto.getRequestDate());
            dto.setOvertimeType(requestDto.getOvertimeType());
            dto.setRequestTime(requestDto.getRequestTime());
            dto.setRequestReason(requestDto.getRequestReason());
            this.approvalInfoReference.setWorkflowInfo((RequestListDtoInterface)dto, workflowDto);
            dto.setWorkflow(requestDto.getWorkflow());
            flag = false;
            if ("1".equals(this.workflowStatus)) {
                if ("0".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("2".equals(this.workflowStatus)) {
                if ("1".equals(dto.getState()) || "2".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("3".equals(this.workflowStatus)) {
                if ("9".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("4".equals(this.workflowStatus)) {
                if ("3".equals(dto.getState()) || "4".equals(dto.getState())) {
                    flag = true;
                }
            } else {
                flag = true;
            }
            if (!flag) continue;
            list.add((OvertimeRequestListDtoInterface)dto);
        }
        return list;
    }

    protected int convIntegerTimeToIntegerHour(int time) {
        return time / 60;
    }

    protected int convIntegerTimeToIntegerMinute(int time) {
        return time % 60;
    }

    protected String convIntegerTimeToStringMinute(int time) {
        int minute = this.convIntegerTimeToIntegerMinute(time);
        StringBuffer sb = new StringBuffer();
        if (minute < 10) {
            sb.append(0);
        }
        sb.append(minute);
        return sb.toString();
    }

    protected String getTimeDotFormat(int time) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.convIntegerTimeToIntegerHour(time));
        sb.append(this.mospParams.getName("Dot"));
        sb.append(this.convIntegerTimeToStringMinute(time));
        return sb.toString();
    }

    public void setWorkflowStatus(String workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public void setScheduleOver(String scheduleOver) {
        this.scheduleOver = scheduleOver;
    }

    public void setOvertimeType(String overtimeType) {
        this.overtimeType = overtimeType;
    }

    public void setRequestStartDate(Date requestStartDate) {
        this.requestStartDate = CapsuleUtility.getDateClone((Date)requestStartDate);
    }

    public void setRequestEndDate(Date requestEndDate) {
        this.requestEndDate = CapsuleUtility.getDateClone((Date)requestEndDate);
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }
}

