/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PlatformNamingUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.OvertimeInfoReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class OvertimeInfoReferenceBean
extends TimeApplicationBean
implements OvertimeInfoReferenceBeanInterface {
    public static final int WEEK_CALCULATE_DAY = -7;
    protected AttendanceDaoInterface attendanceDao;
    protected OvertimeRequestDaoInterface overtimeRequestDao;
    protected WorkflowDaoInterface workflowDao;

    public OvertimeInfoReferenceBean() {
    }

    public OvertimeInfoReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.attendanceDao = (AttendanceDaoInterface)this.createDao(AttendanceDaoInterface.class);
        this.overtimeRequestDao = (OvertimeRequestDaoInterface)this.createDao(OvertimeRequestDaoInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDao(WorkflowDaoInterface.class);
    }

    public String getStringPossibleTime1Week(String personalId) throws MospException {
        Date targetDate = this.getSystemDate();
        this.setCutoffSettings(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return this.getNoLimitString();
        }
        TimeSettingEntityInterface entity = this.timeSettingRefer.getEntity(this.timeSettingDto);
        if (!entity.isOneWeekExist()) {
            return this.getNoLimitString();
        }
        int time = this.getPossibleTime1Week(personalId, targetDate, entity);
        return TimeUtility.getStringJpTime((MospParams)this.mospParams, (int)time);
    }

    public String getStringPossibleTime1Month(String personalId) throws MospException {
        Date targetDate = this.getSystemDate();
        this.setCutoffSettings(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return this.getNoLimitString();
        }
        TimeSettingEntityInterface entity = this.timeSettingRefer.getEntity(this.timeSettingDto);
        if (!entity.isOneMonthExist()) {
            return this.getNoLimitString();
        }
        int time = this.getPossibleTime1Month(personalId, targetDate, this.cutoffDto, entity);
        return TimeUtility.getStringJpTime((MospParams)this.mospParams, (int)time);
    }

    protected int getPossibleTime1Week(String personalId, Date targetDate, TimeSettingEntityInterface entity) throws MospException {
        Date startDate = this.getDateClone(targetDate);
        int difference = DateUtility.getDayOfWeek((Date)startDate) - entity.getStartWeek();
        if (difference >= 0) {
            while (difference != 0) {
                startDate = DateUtility.addDay((Date)startDate, (int)-1);
                --difference;
            }
        } else {
            while (difference != 0) {
                startDate = DateUtility.addDay((Date)startDate, (int)1);
                ++difference;
            }
            startDate = DateUtility.addDay((Date)startDate, (int)-7);
        }
        Date endDate = DateUtility.addDay((Date)startDate, (int)6);
        List attendanceList = this.attendanceDao.findForList(personalId, startDate, endDate);
        boolean requestFlag = true;
        int overTimeOut = 0;
        int requestTime = 0;
        Date indexDate = startDate;
        while (!indexDate.after(endDate)) {
            for (AttendanceDtoInterface attendanceDto : attendanceList) {
                WorkflowDtoInterface workflowDto;
                if (!indexDate.equals(attendanceDto.getWorkDate()) || (workflowDto = this.workflowDao.findForKey(attendanceDto.getWorkflow())) == null || "0".equals(workflowDto.getWorkflowStatus())) continue;
                overTimeOut += attendanceDto.getOvertimeOut();
                requestFlag = false;
                break;
            }
            if (requestFlag) {
                List list = this.overtimeRequestDao.findForList(personalId, indexDate);
                for (OvertimeRequestDtoInterface requestDto : list) {
                    WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(requestDto.getWorkflow());
                    if (workflowDto == null || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus())) continue;
                    requestTime += requestDto.getRequestTime();
                }
            }
            requestFlag = true;
            indexDate = DateUtility.addDay((Date)indexDate, (int)1);
        }
        return entity.getOneWeekLimit() - overTimeOut - requestTime;
    }

    protected int getPossibleTime1Month(String personalId, Date targetDate, CutoffDtoInterface cutoffDto, TimeSettingEntityInterface entity) throws MospException {
        Date cutoffMonth = TimeUtility.getCutoffMonth((int)cutoffDto.getCutoffDate(), (Date)targetDate);
        int year = DateUtility.getYear((Date)cutoffMonth);
        int month = DateUtility.getMonth((Date)cutoffMonth);
        Date firstDate = TimeUtility.getCutoffFirstDate((int)cutoffDto.getCutoffDate(), (int)year, (int)month);
        Date lastDate = TimeUtility.getCutoffLastDate((int)cutoffDto.getCutoffDate(), (int)year, (int)month);
        List attendanceList = this.attendanceDao.findForList(personalId, firstDate, lastDate);
        boolean requestFlag = true;
        int overTimeOut = 0;
        int requestTime = 0;
        Date indexDate = firstDate;
        while (!indexDate.after(lastDate)) {
            for (AttendanceDtoInterface attendanceDto : attendanceList) {
                WorkflowDtoInterface workflowDto;
                if (!indexDate.equals(attendanceDto.getWorkDate()) || (workflowDto = this.workflowDao.findForKey(attendanceDto.getWorkflow())) == null || "0".equals(workflowDto.getWorkflowStatus())) continue;
                overTimeOut += attendanceDto.getOvertimeOut();
                requestFlag = false;
                break;
            }
            if (requestFlag) {
                List list = this.overtimeRequestDao.findForList(personalId, indexDate);
                for (OvertimeRequestDtoInterface requestDto : list) {
                    WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(requestDto.getWorkflow());
                    if (workflowDto == null || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus())) continue;
                    requestTime += requestDto.getRequestTime();
                }
            }
            requestFlag = true;
            indexDate = DateUtility.addDay((Date)indexDate, (int)1);
        }
        return entity.getOneMonthLimit() - overTimeOut - requestTime;
    }

    protected String getNoLimitString() {
        return PlatformNamingUtility.hyphen((MospParams)this.mospParams);
    }
}

