/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.StockHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.TimeApprovalBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdHolidayRequestDto;
import jp.mosp.time.entity.WorkTypeEntity;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class HolidayRequestRegistBean
extends TimeApplicationBean
implements HolidayRequestRegistBeanInterface {
    protected HolidayRequestDaoInterface dao;
    protected HolidayRequestReferenceBeanInterface holidayRequestReference;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkflowCommentRegistBeanInterface workflowCommentRegist;
    protected AttendanceRegistBeanInterface attendanceRegist;
    protected TimeApprovalBeanInterface timeApproval;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected RequestUtilBeanInterface requestUtil;
    protected PaidHolidayInfoReferenceBeanInterface paidHolidayInfoReference;
    protected StockHolidayInfoReferenceBeanInterface stockHolidayInfoReference;
    protected HolidayDataDaoInterface holidayDataDao;
    protected HolidayReferenceBeanInterface holidayReference;
    protected HolidayInfoReferenceBeanInterface holidayInfoReference;
    protected WorkTypeItemDaoInterface workTypeItemDao;
    protected SubstituteDaoInterface substituteDao;
    protected AttendanceReferenceBeanInterface attendanceReference;
    protected WorkTypeItemReferenceBeanInterface workTypeItemReference;
    protected SubstituteReferenceBeanInterface substituteReference;
    protected WorkTypeChangeRequestReferenceBeanInterface workTypeChangeReference;
    protected DifferenceRequestReferenceBeanInterface differenceRequestReference;

    public HolidayRequestRegistBean() {
    }

    public HolidayRequestRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.holidayRequestReference = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBean(WorkflowCommentRegistBeanInterface.class);
        this.attendanceRegist = (AttendanceRegistBeanInterface)this.createBean(AttendanceRegistBeanInterface.class);
        this.holidayDataDao = (HolidayDataDaoInterface)this.createDao(HolidayDataDaoInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        this.paidHolidayInfoReference = (PaidHolidayInfoReferenceBeanInterface)this.createBean(PaidHolidayInfoReferenceBeanInterface.class);
        this.stockHolidayInfoReference = (StockHolidayInfoReferenceBeanInterface)this.createBean(StockHolidayInfoReferenceBeanInterface.class);
        this.holidayReference = (HolidayReferenceBeanInterface)this.createBean(HolidayReferenceBeanInterface.class);
        this.holidayInfoReference = (HolidayInfoReferenceBeanInterface)this.createBean(HolidayInfoReferenceBeanInterface.class);
        this.workTypeItemDao = (WorkTypeItemDaoInterface)this.createDao(WorkTypeItemDaoInterface.class);
        this.substituteDao = (SubstituteDaoInterface)this.createDao(SubstituteDaoInterface.class);
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.workTypeItemReference = (WorkTypeItemReferenceBeanInterface)this.createBean(WorkTypeItemReferenceBeanInterface.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBean(SubstituteReferenceBeanInterface.class);
        this.workTypeChangeReference = (WorkTypeChangeRequestReferenceBeanInterface)this.createBean(WorkTypeChangeRequestReferenceBeanInterface.class);
        this.differenceRequestReference = (DifferenceRequestReferenceBeanInterface)this.createBean(DifferenceRequestReferenceBeanInterface.class);
    }

    public HolidayRequestDtoInterface getInitDto() {
        return new TmdHolidayRequestDto();
    }

    public void insert(HolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(HolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdHolidayRequestId());
        dto.setTmdHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(HolidayRequestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getTmdHolidayRequestId(), false) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
    }

    public void add(HolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdHolidayRequestId());
        dto.setTmdHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(HolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdHolidayRequestId());
    }

    public void withdrawn(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)baseDto;
            this.checkWithdrawn(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ((workflowDto = this.workflowRegist.withdrawn(workflowDto)) == null) continue;
            this.workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
        }
    }

    protected void checkInsert(HolidayRequestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestStartDate(), dto.getHolidayType1(), dto.getHolidayType2(), dto.getHolidayRange(), dto.getStartTime()));
    }

    protected void checkUpdate(HolidayRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdHolidayRequestId());
    }

    protected void checkAdd(HolidayRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdHolidayRequestId());
    }

    public void validate(HolidayRequestDtoInterface dto) throws MospException {
        this.holidayRequestReference.chkBasicInfo(dto.getPersonalId(), dto.getRequestStartDate());
    }

    public void checkSetRequestDate(HolidayRequestDtoInterface dto) throws MospException {
        this.checkPeriod(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List list = TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
        this.checkSuspended(dto, list);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTemporaryClosingFinal(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDailyForSetRequestDate(dto, list);
    }

    public void checkDraft(HolidayRequestDtoInterface dto) throws MospException {
        this.checkForRequest(dto, Boolean.valueOf(false));
        this.checkHolidayRemains(dto, false);
    }

    public void checkAppli(HolidayRequestDtoInterface dto) throws MospException {
        this.checkForRequest(dto, Boolean.valueOf(false));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayRemains(dto, false);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequired(dto);
        this.checkWorkTypeChange(dto);
        this.checkDifference(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTimeHoliday(dto);
    }

    public void checkApproval(HolidayRequestDtoInterface dto) throws MospException {
        this.checkForRequest(dto, Boolean.valueOf(true));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayRemains(dto, true);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeChange(dto);
        this.checkDifference(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTimeHoliday(dto);
    }

    protected void checkForRequest(HolidayRequestDtoInterface dto, Boolean isCompleted) throws MospException {
        this.checkPeriod(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List list = TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
        this.checkSuspended(dto, list);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTemporaryClosingFinal(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkPaidHolidayMaster(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTimeHolidayLimit(dto, isCompleted);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayMaster(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkLimitDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDailyForDraft(dto, list);
    }

    protected void checkTimeHolidayLimit(HolidayRequestDtoInterface dto, Boolean isCompleted) throws MospException {
        Date requestDate;
        if (this.doAdditionalLogic(new Object[]{"Add_HolidayRequestRegistBean_CheckTimeHolidayLimit", dto, isCompleted})) {
            return;
        }
        if (!TimeUtility.isPaidHolidayRequest((HolidayRequestDtoInterface)dto)) {
            return;
        }
        if (!TimeUtility.isHourlyHoliday((HolidayRequestDtoInterface)dto)) {
            return;
        }
        String personalId = dto.getPersonalId();
        if (this.hasPaidHolidaySettings(personalId, requestDate = dto.getRequestStartDate()) && this.paidHolidayDto.getTimelyPaidHolidayFlag() != 0) {
            String mes1 = this.mospParams.getName("Time", new String[]{"Unit", "Acquisition"});
            String mes2 = this.mospParams.getName("HolidayTime");
            String mes3 = this.mospParams.getName("PaidVacation", new String[]{"Set"});
            this.mospParams.addErrorMessage("TMW0262", new String[]{mes1, mes2, mes3});
            return;
        }
        int[] limit = this.paidHolidayInfoReference.getHolidayTimeUnitLimit(personalId, requestDate, isCompleted.booleanValue(), dto);
        if (limit[0] <= 0 && limit[1] <= 0) {
            this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("HolidayTime", new String[]{"Of", "Years"}), this.mospParams.getName("Time"));
            return;
        }
        Map timeHoliday = this.holidayRequestReference.getTimeHolidayStatusTimesMap(personalId, requestDate, dto);
        if (timeHoliday.isEmpty()) {
            return;
        }
        int holidayTimes = (Integer)timeHoliday.get(this.mospParams.getName("Finish")) + (Integer)timeHoliday.get(this.mospParams.getName("Register")) + (Integer)timeHoliday.get(this.mospParams.getName("Back"));
        if (!timeHoliday.isEmpty() && holidayTimes >= this.getPrescribedWorkHour(dto)) {
            this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("HolidayTime", new String[]{"Of", "No1", "Day"}), this.mospParams.getName("Time"));
        }
    }

    public void checkCancelAppli(HolidayRequestDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        if (dto.getRequestStartDate().equals(dto.getRequestEndDate()) && this.approvalInfoReference.isExistAttendanceTargetDate(dto.getPersonalId(), dto.getRequestStartDate())) {
            this.addOthersRequestErrorMessage(dto.getRequestStartDate(), this.mospParams.getName("WorkManage"));
        }
    }

    public void checkWithdrawn(HolidayRequestDtoInterface dto) {
    }

    public void checkCancelApproval(HolidayRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    public void checkCancel(HolidayRequestDtoInterface dto) {
    }

    protected void checkDailyForSetRequestDate(HolidayRequestDtoInterface dto, List<Date> list) throws MospException {
        for (Date date : list) {
            this.checkDailyForSetRequestDate(dto, date);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkDailyForSetRequestDate(HolidayRequestDtoInterface dto, Date date) throws MospException {
        RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        localRequestUtil.setRequests(dto.getPersonalId(), date);
        String workTypeCode = this.getScheduledWorkTypeCode(dto, date, localRequestUtil);
        this.checkWorkType(dto, date, workTypeCode);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) {
            return;
        }
        this.checkDuplicate(dto, date, localRequestUtil, false);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto, date);
    }

    protected void checkDailyForDraft(HolidayRequestDtoInterface dto, List<Date> list) throws MospException {
        for (Date date : list) {
            this.checkDailyForDraft(dto, date);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkDailyForDraft(HolidayRequestDtoInterface dto, Date date) throws MospException {
        RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        localRequestUtil.setRequests(dto.getPersonalId(), date);
        String workTypeCode = this.getScheduledWorkTypeCode(dto, date, localRequestUtil);
        this.checkWorkType(dto, date, workTypeCode);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) {
            return;
        }
        this.checkDuplicate(dto, date, localRequestUtil, true);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkShortTime(dto, localRequestUtil, workTypeCode, date);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto, date);
    }

    protected void checkDuplicate(HolidayRequestDtoInterface dto, Date targetDate, RequestUtilBeanInterface localRequestUtil, boolean isDraft) throws MospException {
        int subHolidayRange;
        boolean holidayRangeAm = false;
        boolean holidayRangePm = false;
        boolean holidayRangeTime = false;
        boolean subHolidayRangeAm = false;
        boolean subHolidayRangePm = false;
        boolean substituteRangeAm = false;
        boolean substituteRangePm = false;
        List list = this.dao.findForTermOnWorkflow(dto.getPersonalId(), targetDate, targetDate);
        for (HolidayRequestDtoInterface holidayRequestDto : list) {
            long workflow = holidayRequestDto.getWorkflow();
            if (this.workflowIntegrate.isWithDrawn(workflow) || dto.getWorkflow() == workflow) continue;
            int holidayRange = holidayRequestDto.getHolidayRange();
            if (holidayRange == 1) {
                this.addHolidayOverlapRange1ErrorMessage();
                return;
            }
            if (holidayRange == 2) {
                holidayRangeAm = true;
                continue;
            }
            if (holidayRange == 3) {
                holidayRangePm = true;
                continue;
            }
            if (holidayRange != 4) continue;
            holidayRangeTime = true;
            if (!isDraft || dto.getHolidayRange() != 4 || !this.checkDuplicationTimeZone(holidayRequestDto.getStartTime(), holidayRequestDto.getEndTime(), dto.getStartTime(), dto.getEndTime())) continue;
            this.addDuplicateTermMessage();
            return;
        }
        if (holidayRangeAm && holidayRangePm) {
            this.addHolidayOverlapRange1ErrorMessage();
            return;
        }
        if (isDraft) {
            int holidayRange = dto.getHolidayRange();
            if (holidayRange == 1) {
                if (holidayRangeAm || holidayRangePm || holidayRangeTime) {
                    this.addHolidayOverlapRange1ErrorMessage();
                    return;
                }
            } else if (holidayRange == 2) {
                if (holidayRangeAm) {
                    this.addHolidayOverlapRange2ErrorMessage();
                    return;
                }
                if (holidayRangeTime) {
                    TimeMessageUtility.addErrorHalfAndHourlyHoliday((MospParams)this.mospParams);
                    return;
                }
            } else if (holidayRange == 3) {
                if (holidayRangePm) {
                    this.addHolidayOverlapRange2ErrorMessage();
                    return;
                }
                if (holidayRangeTime) {
                    TimeMessageUtility.addErrorHalfAndHourlyHoliday((MospParams)this.mospParams);
                    return;
                }
            } else if (holidayRange == 4 && (holidayRangeAm || holidayRangePm)) {
                TimeMessageUtility.addErrorHalfAndHourlyHoliday((MospParams)this.mospParams);
                return;
            }
        } else if (!dto.getRequestStartDate().equals(dto.getRequestEndDate()) && (holidayRangeAm || holidayRangePm || holidayRangeTime)) {
            this.addHolidayOverlapRange1ErrorMessage();
            return;
        }
        if ((subHolidayRange = localRequestUtil.checkHolidayRangeSubHoliday(localRequestUtil.getSubHolidayList(false))) == 1 || subHolidayRange == 5) {
            this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
            return;
        }
        if (subHolidayRange == 2) {
            subHolidayRangeAm = true;
        } else if (subHolidayRange == 3) {
            subHolidayRangePm = true;
        }
        int substituteRange = localRequestUtil.checkHolidayRangeSubstitute(localRequestUtil.getSubstituteList(false));
        if (substituteRange == 1 || substituteRange == 5) {
            this.addSubstituteErrorMessage(targetDate);
            return;
        }
        if (substituteRange == 2) {
            substituteRangeAm = true;
        } else if (substituteRange == 3) {
            substituteRangePm = true;
        }
        if ((holidayRangeAm || subHolidayRangeAm || substituteRangeAm) && (holidayRangePm || subHolidayRangePm || substituteRangePm)) {
            this.addHolidayOverlapRange1ErrorMessage();
            return;
        }
        if (isDraft) {
            int holidayRange = dto.getHolidayRange();
            if (holidayRange == 1) {
                if (subHolidayRangeAm || subHolidayRangePm) {
                    this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
                    return;
                }
            } else if (holidayRange == 2) {
                if (subHolidayRangeAm) {
                    this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
                    return;
                }
            } else if (holidayRange == 3) {
                if (subHolidayRangePm) {
                    this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
                    return;
                }
            } else if (holidayRange == 4 && (subHolidayRangeAm || subHolidayRangePm)) {
                this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
                return;
            }
        } else if (!dto.getRequestStartDate().equals(dto.getRequestEndDate()) && (subHolidayRangeAm || subHolidayRangePm)) {
            this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
            return;
        }
        if (isDraft) {
            int holidayRange = dto.getHolidayRange();
            if (holidayRange == 1) {
                if (substituteRangeAm || substituteRangePm) {
                    this.addSubstituteErrorMessage(targetDate);
                    return;
                }
            } else if (holidayRange == 2) {
                if (substituteRangeAm) {
                    this.addSubstituteErrorMessage(targetDate);
                    return;
                }
            } else if (holidayRange == 3) {
                if (substituteRangePm) {
                    this.addSubstituteErrorMessage(targetDate);
                    return;
                }
            } else if (holidayRange == 4 && (substituteRangeAm || substituteRangePm)) {
                this.addSubstituteErrorMessage(targetDate);
                return;
            }
        } else if (!dto.getRequestStartDate().equals(dto.getRequestEndDate()) && (substituteRangeAm || substituteRangePm)) {
            this.addSubstituteErrorMessage(targetDate);
            return;
        }
        int holidayRange = 1;
        if (isDraft) {
            holidayRange = dto.getHolidayRange();
            if (dto.getHolidayRange() == 2) {
                if (holidayRangePm || subHolidayRangePm || substituteRangePm) {
                    holidayRange = 1;
                }
            } else if (dto.getHolidayRange() == 3 && (holidayRangeAm || subHolidayRangeAm || substituteRangeAm)) {
                holidayRange = 1;
            }
        } else if (dto.getRequestStartDate().equals(dto.getRequestEndDate())) {
            return;
        }
        this.checkOvertimeWorkRequest(localRequestUtil, targetDate, holidayRange);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSubstituteWorkRequest(localRequestUtil, targetDate, holidayRange);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeChangeRequest(localRequestUtil, holidayRange);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDifferenceRequest(localRequestUtil, holidayRange);
    }

    protected void checkShortTime(HolidayRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil, String workTypeCode, Date date) throws MospException {
        DifferenceRequestDtoInterface differenceRequestDto = localRequestUtil.getDifferenceDto(true);
        if (differenceRequestDto != null) {
            return;
        }
        WorkTypeEntity workTypeEntity = this.workTypeReference.getWorkTypeEntity(workTypeCode, date);
        if (workTypeEntity == null) {
            return;
        }
        boolean isShort1TimeSet = workTypeEntity.isShort1TimeSet();
        Date short1StartTime = null;
        Date short1EndTime = null;
        if (isShort1TimeSet) {
            short1StartTime = this.getTime(workTypeEntity.getShort1StartTime(), date);
            short1EndTime = this.getTime(workTypeEntity.getShort1EndTime(), date);
        }
        boolean isShort2TimeSet = workTypeEntity.isShort2TimeSet();
        Date short2StartTime = null;
        Date short2EndTime = null;
        if (isShort2TimeSet) {
            short2StartTime = this.getTime(workTypeEntity.getShort2StartTime(), date);
            short2EndTime = this.getTime(workTypeEntity.getShort2EndTime(), date);
        }
        if (!isShort1TimeSet && !isShort2TimeSet) {
            return;
        }
        if (dto.getHolidayRange() != 4) {
            return;
        }
        if (isShort1TimeSet && this.checkDuplicationTimeZone(dto.getStartTime(), dto.getEndTime(), short1StartTime, short1EndTime)) {
            this.mospParams.addErrorMessage("TMW0320", new String[]{DateUtility.getStringTime((Date)short1StartTime), DateUtility.getStringTime((Date)short1EndTime)});
            return;
        }
        if (isShort2TimeSet && this.checkDuplicationTimeZone(dto.getStartTime(), dto.getEndTime(), short2StartTime, short2EndTime)) {
            this.mospParams.addErrorMessage("TMW0320", new String[]{DateUtility.getStringTime((Date)short2StartTime), DateUtility.getStringTime((Date)short2EndTime)});
        }
    }

    protected void checkOvertimeWorkRequest(RequestUtilBeanInterface localRequestUtil, Date date, int holidayRange) throws MospException {
        if (holidayRange != 1) {
            return;
        }
        if (localRequestUtil.getOverTimeList(false).isEmpty()) {
            return;
        }
        this.addOthersRequestErrorMessage(date, this.mospParams.getName("OvertimeWork"));
    }

    protected void checkSubstituteWorkRequest(RequestUtilBeanInterface localRequestUtil, Date date, int holidayRange) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = localRequestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null) {
            return;
        }
        int substitute = workOnHolidayRequestDto.getSubstitute();
        if (substitute == 2) {
            return;
        }
        if (substitute == 1) {
            return;
        }
        if (substitute == 5) {
            return;
        }
        this.addOthersRequestErrorMessage(date, this.mospParams.getName("HalfDay", new String[]{"Transfer", "GoingWork"}));
    }

    protected void checkWorkTypeChangeRequest(RequestUtilBeanInterface localRequestUtil, int holidayRange) throws MospException {
        if (holidayRange != 1) {
            return;
        }
        WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = localRequestUtil.getWorkTypeChangeDto(false);
        if (workTypeChangeRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(workTypeChangeRequestDto.getRequestDate(), this.mospParams.getName("Work", new String[]{"Form", "Change"}));
    }

    protected void checkDifferenceRequest(RequestUtilBeanInterface localRequestUtil, int holidayRange) throws MospException {
        if (holidayRange != 1 && holidayRange != 2) {
            return;
        }
        DifferenceRequestDtoInterface differenceRequestDto = localRequestUtil.getDifferenceDto(false);
        if (differenceRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(differenceRequestDto.getRequestDate(), this.mospParams.getName("TimeDifference", new String[]{"GoingWork"}));
    }

    public void checkAttendance(HolidayRequestDtoInterface dto, Date date) throws MospException {
        AttendanceDtoInterface attendanceDto = this.attendanceReference.findForKey(dto.getPersonalId(), date, 1);
        if (attendanceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow());
        if (workflowDto == null) {
            return;
        }
        if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if (WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        this.addHolidayTargetWorkDateAttendanceRequestErrorMessage(date);
    }

    protected void checkRequired(HolidayRequestDtoInterface dto) throws MospException {
        if (dto.getHolidayType1() == 1) {
            if (!this.holidayRequestReference.isPaidHolidayReasonRequired()) {
                return;
            }
        } else if (dto.getHolidayType1() == 2 || dto.getHolidayType1() == 3 || dto.getHolidayType1() == 4) {
            HolidayDtoInterface holidayDto = this.holidayReference.getHolidayInfo(dto.getHolidayType2(), dto.getRequestStartDate(), dto.getHolidayType1());
            if (holidayDto == null) {
                return;
            }
            if (holidayDto.getReasonType() == 0) {
                return;
            }
        }
        if (dto.getRequestReason().isEmpty()) {
            this.addHolidayRequestReasonErrorMessage();
        }
    }

    public void checkLimitDate(HolidayRequestDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        int holidayType = dto.getHolidayType1();
        if (holidayType != 2 && holidayType != 3) {
            return;
        }
        HolidayDataDtoInterface holidayDataDto = this.holidayDataDao.findForKey(dto.getPersonalId(), dto.getHolidayAcquisitionDate(), dto.getHolidayType2(), dto.getHolidayType1());
        if (holidayDataDto == null) {
            return;
        }
        if (holidayDataDto.getHolidayLimitDate().before(dto.getRequestEndDate())) {
            this.addHolidayLimitDateErrorMessage();
        }
    }

    protected void checkHolidayRemains(HolidayRequestDtoInterface dto, boolean isApproval) throws MospException {
        int hours;
        String personalId = dto.getPersonalId();
        Date startDate = dto.getRequestStartDate();
        Date endDate = dto.getRequestEndDate();
        int holidayType = dto.getHolidayType1();
        String holidayCode = dto.getHolidayType2();
        int holidayRange = dto.getHolidayRange();
        if (holidayType != 2 && holidayType != 3) {
            return;
        }
        HolidayDtoInterface holidayDto = this.holidayReference.getHolidayInfo(holidayCode, startDate, holidayType);
        if (holidayDto == null || holidayDto.getNoLimit() == this.getInteger("1").intValue()) {
            return;
        }
        this.setPaidHolidaySettings(personalId, startDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        int hoursPerDay = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        HolidayDataDtoInterface holidayData = this.holidayInfoReference.getHolidayPossibleRequestForRequest(personalId, startDate, holidayCode, holidayType);
        double days = this.getHolidayRequestDays(personalId, startDate, endDate, holidayRange);
        int n = hours = TimeUtility.isHourlyHoliday((HolidayRequestDtoInterface)dto) ? 1 : 0;
        if (isApproval) {
            days = 0.0;
            hours = 0;
        }
        if (!TimeUtility.isHolidayRemain((HolidayDataDtoInterface)holidayData, (double)days, (int)hours, (int)hoursPerDay)) {
            StringBuilder sb = new StringBuilder();
            sb.append(holidayDto.getHolidayAbbr());
            sb.append(TimeNamingUtility.getVacation((MospParams)this.mospParams));
            this.addHolidayNumDaysExcessErrorMessage(sb.toString(), this.mospParams.getName("Time"));
        }
    }

    public void deleteAttendance(HolidayRequestDtoInterface dto) throws MospException {
        int range = dto.getHolidayRange();
        boolean holidayAm = range == 2;
        boolean holidayPm = range == 3;
        List dateList = TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
        block0: for (Date date : dateList) {
            RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
            localRequestUtil.setRequests(dto.getPersonalId(), date);
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = localRequestUtil.getWorkOnHolidayDto(false);
            if (workOnHolidayRequestDto != null && workOnHolidayRequestDto.getSubstitute() == 2) continue;
            if (range == 1) {
                this.attendanceRegist.delete(dto.getPersonalId(), date);
                continue;
            }
            if (!holidayAm && !holidayPm) continue;
            List list = localRequestUtil.getHolidayList(false);
            for (HolidayRequestDtoInterface holidayRequestDto : list) {
                if ((!holidayAm || holidayRequestDto.getHolidayRange() != 3) && (!holidayPm || holidayRequestDto.getHolidayRange() != 2)) continue;
                this.attendanceRegist.delete(dto.getPersonalId(), date);
                break;
            }
            List subHolidayRequestList = localRequestUtil.getSubHolidayList(false);
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : subHolidayRequestList) {
                if ((!holidayAm || subHolidayRequestDto.getHolidayRange() != 3) && (!holidayPm || subHolidayRequestDto.getHolidayRange() != 2)) continue;
                this.attendanceRegist.delete(dto.getPersonalId(), date);
                break;
            }
            List substituteList = localRequestUtil.getSubstituteList(false);
            for (SubstituteDtoInterface substituteDto : substituteList) {
                if ((!holidayAm || substituteDto.getHolidayRange() != 3) && (!holidayPm || substituteDto.getHolidayRange() != 2)) continue;
                this.attendanceRegist.delete(dto.getPersonalId(), date);
                continue block0;
            }
        }
    }

    public void draftAttendance(HolidayRequestDtoInterface dto) throws MospException {
        if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) {
            return;
        }
        this.timeApproval = (TimeApprovalBeanInterface)this.createBean(TimeApprovalBeanInterface.class);
        boolean deleteRest = false;
        int holidayRange = dto.getHolidayRange();
        if (holidayRange == 2 || holidayRange == 3) {
            deleteRest = true;
        }
        this.timeApproval.reDraft(dto.getPersonalId(), dto.getRequestStartDate(), deleteRest, false, false);
    }

    protected void checkPeriod(HolidayRequestDtoInterface dto) {
        if (dto.getRequestStartDate().after(dto.getRequestEndDate())) {
            this.addHolidayRequestDateErrorMessage();
        }
    }

    protected void checkEntered(HolidayRequestDtoInterface dto) throws MospException {
        if (!this.isEntered(dto.getPersonalId(), dto.getRequestStartDate())) {
            PlatformMessageUtility.addErrorEmployeeNotJoin((MospParams)this.mospParams);
        }
    }

    protected void checkRetired(HolidayRequestDtoInterface dto) throws MospException {
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getRequestEndDate())) {
            this.addEmployeeRetiredMessage();
        }
    }

    protected void checkSuspended(HolidayRequestDtoInterface dto, List<Date> list) throws MospException {
        this.checkSuspended(dto.getPersonalId(), list);
    }

    protected void checkSuspended(String personalId, List<Date> list) throws MospException {
        for (Date date : list) {
            this.checkSuspended(personalId, date);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkSuspended(String personalId, Date date) throws MospException {
        if (this.suspensionReference.isSuspended(personalId, date)) {
            this.addEmployeeSuspendedMessage();
        }
    }

    public void checkTemporaryClosingFinal(HolidayRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestStartDate(), TimeNamingUtility.holidayDate((MospParams)this.mospParams));
    }

    protected void checkPaidHolidayMaster(HolidayRequestDtoInterface dto) throws MospException {
        if (dto.getHolidayType1() != 1) {
            return;
        }
        if (!Integer.toString(1).equals(dto.getHolidayType2())) {
            return;
        }
        if (dto.getHolidayRange() != 4) {
            return;
        }
        this.setPaidHolidaySettings(dto.getPersonalId(), dto.getRequestStartDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (this.paidHolidayDto.getTimelyPaidHolidayFlag() != 0) {
            this.mospParams.addErrorMessage("TMW0262", new String[]{this.mospParams.getName("Time", new String[]{"Unit", "Acquisition"}), this.mospParams.getName("HolidayTime"), this.mospParams.getName("PaidVacation", new String[]{"Set"})});
            return;
        }
        if (DateUtility.getMinute((Date)dto.getStartTime()) % this.paidHolidayDto.getAppliTimeInterval() == 0) {
            return;
        }
        this.addStartTimeErrorMessage();
    }

    protected void checkHolidayMaster(HolidayRequestDtoInterface dto) throws MospException {
        int holidayType1 = dto.getHolidayType1();
        if (holidayType1 != 2 && holidayType1 != 3 && holidayType1 != 4) {
            return;
        }
        HolidayDtoInterface holidayDto = this.holidayReference.getHolidayInfo(dto.getHolidayType2(), dto.getRequestStartDate(), holidayType1);
        if (holidayDto == null || holidayDto.getInactivateFlag() == 1) {
            this.addHolidayNotExistErrorMessage();
            return;
        }
        if (dto.getHolidayRange() == 4 && PlatformUtility.isInactivate((int)holidayDto.getTimelyHolidayFlag())) {
            TimeMessageUtility.addErrorHourlyHolidayInvalid((MospParams)this.mospParams, (String)holidayDto.getHolidayName());
            return;
        }
        this.checkHalfHoliday(dto, holidayDto);
    }

    protected void checkHalfHoliday(HolidayRequestDtoInterface dto, HolidayDtoInterface holidayDto) throws MospException {
        int holidayType1 = dto.getHolidayType1();
        if (holidayType1 != 2 && holidayType1 != 3 && holidayType1 != 4) {
            return;
        }
        int holidayRange = dto.getHolidayRange();
        if (holidayRange != 2 && holidayRange != 3) {
            return;
        }
        if (holidayDto.getHalfHolidayRequest() == 0) {
            return;
        }
        TimeMessageUtility.addErrorHalfHolidayInvalid((MospParams)this.mospParams, (String)holidayDto.getHolidayName());
    }

    public void checkWorkType(HolidayRequestDtoInterface dto, Date targetDate, String workTypeCode) throws MospException {
        this.checkWorkType(dto.getRequestStartDate(), dto.getRequestEndDate(), targetDate, workTypeCode);
    }

    public void checkWorkType(Date startDate, Date endDate, Date targetDate, String workTypeCode) {
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            this.addHolidayTargetWorkDateHolidayErrorMessage(targetDate);
            return;
        }
        if ((TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) && (targetDate.equals(startDate) || targetDate.equals(endDate))) {
            this.addHolidayTargetWorkDateHolidayErrorMessage(targetDate);
        }
    }

    public void setHolidayRequest(HolidayRequestDtoInterface dto) throws MospException {
        int holidayType1 = dto.getHolidayType1();
        if (holidayType1 == 1) {
            if (Integer.toString(1).equals(dto.getHolidayType2())) {
                this.setPaidLeave(dto);
            } else if (Integer.toString(2).equals(dto.getHolidayType2())) {
                this.setStockLeave(dto);
            }
        } else if (holidayType1 == 2 || holidayType1 == 3 || holidayType1 == 4) {
            this.setLeave(dto);
        }
    }

    protected void setHolidayRequest(HolidayRequestDtoInterface dto, Date holidayAcquisitionDate, double useDay, int useHour) {
        dto.setHolidayAcquisitionDate(holidayAcquisitionDate);
        dto.setUseDay(useDay);
        dto.setUseHour(useHour);
    }

    protected void setPaidLeave(HolidayRequestDtoInterface dto) throws MospException {
        if (dto.getHolidayType1() != 1) {
            return;
        }
        if (!Integer.toString(1).equals(dto.getHolidayType2())) {
            return;
        }
        double useDay = 0.0;
        int useHour = 0;
        int holidayRange = dto.getHolidayRange();
        if (holidayRange == 1) {
            useDay = 1.0;
        } else if (holidayRange == 2 || holidayRange == 3) {
            useDay = 0.5;
        } else if (holidayRange == 4) {
            useHour = 1;
        } else {
            this.mospParams.addErrorMessage("TMW0305", new String[0]);
            return;
        }
        List list = this.paidHolidayInfoReference.getPaidHolidayPossibleRequestForRequestList(dto.getPersonalId(), dto.getRequestStartDate());
        if (holidayRange == 1) {
            boolean isHalfPaidLeave = false;
            for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
                double holdDay = paidHolidayDataDto.getHoldDay();
                if (holdDay >= 1.0) {
                    if (!isHalfPaidLeave) break;
                    this.addPaidLeaveForPreviousFiscalYearErrorMessage();
                    return;
                }
                if (!TimeUtility.isHolidayTimesHalf((double)holdDay)) continue;
                isHalfPaidLeave = true;
            }
        }
        Date holidayAcquisitionDate = null;
        if (holidayRange == 1 || holidayRange == 2 || holidayRange == 3) {
            for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
                if (!(paidHolidayDataDto.getHoldDay() >= useDay)) continue;
                holidayAcquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                break;
            }
            if (holidayAcquisitionDate == null) {
                this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("Salaried", new String[]{"Vacation"}), this.mospParams.getName("Day"));
                return;
            }
        } else if (holidayRange == 4) {
            for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
                if (paidHolidayDataDto.getHoldHour() < 1 && !(paidHolidayDataDto.getHoldDay() >= 1.0)) continue;
                holidayAcquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                break;
            }
            if (holidayAcquisitionDate == null) {
                this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("Salaried", new String[]{"Vacation"}), this.mospParams.getName("Time"));
            }
        }
        this.setHolidayRequest(dto, holidayAcquisitionDate, useDay, useHour);
    }

    protected void setStockLeave(HolidayRequestDtoInterface dto) throws MospException {
        if (dto.getHolidayType1() != 1) {
            return;
        }
        if (!Integer.toString(2).equals(dto.getHolidayType2())) {
            return;
        }
        double useDay = 0.0;
        int holidayRange = dto.getHolidayRange();
        if (holidayRange == 1) {
            useDay = 1.0;
        } else if (holidayRange == 2 || holidayRange == 3) {
            useDay = 0.5;
        } else {
            this.mospParams.addErrorMessage("TMW0305", new String[0]);
            return;
        }
        List list = this.stockHolidayInfoReference.getStockHolidayPossibleRequestForRequest(dto.getPersonalId(), dto.getRequestStartDate());
        Date holidayAcquisitionDate = null;
        for (StockHolidayDataDtoInterface stockHolidayDataDto : list) {
            if (!(stockHolidayDataDto.getHoldDay() + stockHolidayDataDto.getGivingDay() - stockHolidayDataDto.getCancelDay() - stockHolidayDataDto.getUseDay() >= useDay)) continue;
            holidayAcquisitionDate = stockHolidayDataDto.getAcquisitionDate();
            break;
        }
        if (holidayAcquisitionDate == null) {
            this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("Stock", new String[]{"Vacation"}), this.mospParams.getName("Day"));
            return;
        }
        this.setHolidayRequest(dto, holidayAcquisitionDate, useDay, 0);
    }

    protected void setLeave(HolidayRequestDtoInterface dto) throws MospException {
        int holidayType1 = dto.getHolidayType1();
        if (holidayType1 != 2 && holidayType1 != 3 && holidayType1 != 4) {
            return;
        }
        HolidayDtoInterface holidayDto = this.holidayReference.getHolidayInfo(dto.getHolidayType2(), dto.getRequestStartDate(), holidayType1);
        if (holidayDto == null || holidayDto.getInactivateFlag() == 1) {
            this.addHolidayNotExistErrorMessage();
            return;
        }
        Date holidayAcquisitionDate = dto.getRequestStartDate();
        HolidayDataDtoInterface holidayDataDto = null;
        if (holidayType1 == 2 || holidayType1 == 3) {
            holidayDataDto = this.holidayInfoReference.getHolidayPossibleRequestForRequest(dto.getPersonalId(), dto.getRequestStartDate(), dto.getHolidayType2(), holidayType1);
            if (holidayDataDto == null) {
                this.addHolidayNotGiveErrorMessage(holidayDto.getHolidayName());
                return;
            }
            holidayAcquisitionDate = holidayDataDto.getActivateDate();
        }
        double useDay = 0.0;
        int useHour = 0;
        int holidayRange = dto.getHolidayRange();
        if (holidayRange == 1 || holidayRange == 2 || holidayRange == 3) {
            useDay = this.getHolidayRequestDays(dto, holidayDto, holidayDataDto);
        } else if (holidayRange == 4) {
            useHour = 1;
        } else {
            this.mospParams.addErrorMessage("TMW0305", new String[0]);
            return;
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.setHolidayRequest(dto, holidayAcquisitionDate, useDay, useHour);
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate) throws MospException {
        return this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate, true);
    }

    protected String getScheduledWorkTypeCode(HolidayRequestDtoInterface dto, Date targetDate, RequestUtilBeanInterface localRequestUtil) throws MospException {
        return this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), targetDate, localRequestUtil);
    }

    protected double getHolidayRequestDays(HolidayRequestDtoInterface dto, HolidayDtoInterface holidayDto, HolidayDataDtoInterface holidayDataDto) throws MospException {
        return this.getHolidayRequestDays(dto.getPersonalId(), dto.getRequestStartDate(), dto.getRequestEndDate(), dto.getHolidayRange(), holidayDto, holidayDataDto);
    }

    public double getHolidayRequestDays(String personalId, Date startDate, Date endDate, int holidayRange, HolidayDtoInterface holidayDto, HolidayDataDtoInterface holidayDataDto) throws MospException {
        double holidayRequestDays = this.getHolidayRequestDays(personalId, startDate, endDate, holidayRange);
        if (holidayDto.getHolidayType() == 4) {
            return holidayRequestDays;
        }
        if (holidayDto.getContinuousAcquisition() == 0) {
            if (holidayRequestDays <= holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()) {
                return holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay();
            }
            this.addHolidayNumDaysExcessErrorMessage(holidayDto.getHolidayName(), this.mospParams.getName("Day"));
            return 0.0;
        }
        if (holidayDto.getContinuousAcquisition() == 1) {
            if (holidayRequestDays <= holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()) {
                return holidayRequestDays;
            }
            this.addHolidayNumDaysExcessErrorMessage(holidayDto.getHolidayName(), this.mospParams.getName("Day"));
            return 0.0;
        }
        if (holidayDto.getContinuousAcquisition() == 2) {
            if (holidayDto.getNoLimit() == 1) {
                return holidayRequestDays;
            }
            if (holidayRequestDays <= holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()) {
                return holidayRequestDays;
            }
            this.addHolidayNumDaysExcessErrorMessage(holidayDto.getHolidayName(), this.mospParams.getName("Day"));
            return 0.0;
        }
        return 0.0;
    }

    protected double getHolidayRequestDays(String personalId, Date startDate, Date endDate, int holidayRange) throws MospException {
        int count = 0;
        List dateList = TimeUtility.getDateList((Date)startDate, (Date)endDate);
        for (Date date : dateList) {
            String workTypeCode = this.getScheduledWorkTypeCode(personalId, date);
            this.checkWorkType(startDate, endDate, date, workTypeCode);
            if (this.mospParams.hasErrorMessage()) {
                return 0.0;
            }
            if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
            ++count;
        }
        if (holidayRange == 1) {
            return count;
        }
        if (holidayRange == 2 || holidayRange == 3) {
            return (float)count * 0.5f;
        }
        return 0.0;
    }

    protected int getPrescribedWorkHour(HolidayRequestDtoInterface dto) throws MospException {
        if (dto.getHolidayRange() != 4) {
            return 0;
        }
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getRequestStartDate());
        DifferenceRequestDtoInterface differenceRequestDto = this.requestUtil.getDifferenceDto(true);
        if (differenceRequestDto != null) {
            DifferenceRequestReferenceBeanInterface differenceRequestReference = (DifferenceRequestReferenceBeanInterface)this.createBean(DifferenceRequestReferenceBeanInterface.class, dto.getRequestStartDate());
            return differenceRequestReference.getDifferenceWorkTime(false, false) / 60;
        }
        AttendanceDtoInterface attendanceDto = this.requestUtil.getApplicatedAttendance();
        if (attendanceDto == null) {
            attendanceDto = this.requestUtil.getFirstRevertedAttendance();
        }
        if (attendanceDto == null) {
            attendanceDto = this.requestUtil.getDraftAttendance();
        }
        String workTypeCode = "";
        if (attendanceDto == null) {
            Date targetDate = dto.getRequestStartDate();
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(true);
            if (workOnHolidayRequestDto != null && workOnHolidayRequestDto.getSubstitute() == 1) {
                List list = this.substituteDao.findForWorkflow(workOnHolidayRequestDto.getWorkflow());
                Iterator i$ = list.iterator();
                if (i$.hasNext()) {
                    SubstituteDtoInterface substituteDto = (SubstituteDtoInterface)i$.next();
                    targetDate = substituteDto.getSubstituteDate();
                }
                workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), targetDate);
            } else {
                workTypeCode = workOnHolidayRequestDto != null && workOnHolidayRequestDto.getSubstitute() == 5 ? workOnHolidayRequestDto.getWorkTypeCode() : this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), targetDate);
            }
        } else {
            workTypeCode = attendanceDto.getWorkTypeCode();
        }
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            return 0;
        }
        WorkTypeItemDtoInterface workTypeItemDto = this.workTypeItemDao.findForInfo(workTypeCode, dto.getRequestStartDate(), "WorkTime");
        if (workTypeItemDto == null) {
            return 0;
        }
        return DateUtility.getHour((Date)workTypeItemDto.getWorkTypeItemValue(), (Date)DateUtility.getDefaultTime());
    }

    protected void checkTimeHoliday(HolidayRequestDtoInterface dto) throws MospException {
        WorkTypeItemDtoInterface workEndDto;
        WorkTypeItemDtoInterface workStartDto;
        WorkTypeDtoInterface workTypeDto;
        if (this.doAdditionalLogic(new Object[]{"Add_HolidayRequestRegistBean_CheckTimeHoliday", dto})) {
            return;
        }
        if (dto.getHolidayRange() != 4) {
            return;
        }
        Date targetStartTime = null;
        Date targetEndTime = null;
        Date defaultDate = DateUtility.getDefaultTime();
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getRequestStartDate());
        AttendanceDtoInterface attendanceDraftDto = this.requestUtil.getDraftAttendance();
        DifferenceRequestDtoInterface differenceDto = this.requestUtil.getDifferenceDto(true);
        WorkTypeChangeRequestDtoInterface workTypeChangeDto = this.requestUtil.getWorkTypeChangeDto(true);
        WorkOnHolidayRequestDtoInterface workOnHolidayDto = this.requestUtil.getWorkOnHolidayDto(true);
        if (differenceDto != null) {
            targetStartTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)differenceDto.getRequestStart(), (Date)dto.getRequestStartDate()), (String)DateUtility.getStringMinute((Date)differenceDto.getRequestStart()));
            targetEndTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)differenceDto.getRequestEnd(), (Date)dto.getRequestStartDate()), (String)DateUtility.getStringMinute((Date)differenceDto.getRequestEnd()));
        } else if (workTypeChangeDto != null) {
            workTypeDto = this.workTypeReference.findForInfo(workTypeChangeDto.getWorkTypeCode(), dto.getRequestStartDate());
            workStartDto = this.workTypeItemReference.findForKey(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkStart");
            workEndDto = this.workTypeItemReference.findForKey(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkEnd");
            targetStartTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workStartDto.getWorkTypeItemValue()), (String)DateUtility.getStringMinute((Date)workStartDto.getWorkTypeItemValue()));
            targetEndTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workEndDto.getWorkTypeItemValue(), (Date)defaultDate), (String)DateUtility.getStringMinute((Date)workEndDto.getWorkTypeItemValue()));
        } else if (workOnHolidayDto != null) {
            if (workOnHolidayDto.getSubstitute() == 2 || workOnHolidayDto.getSubstitute() == 3 || workOnHolidayDto.getSubstitute() == 4) {
                this.addHolidayTargetWorkDateHolidayErrorMessage(dto.getRequestStartDate());
                return;
            }
            String workTypeCode = workOnHolidayDto.getWorkTypeCode();
            if (workTypeCode == null || workTypeCode.isEmpty()) {
                SubstituteDtoInterface substituteDto = this.substituteReference.getSubstituteDto(dto.getPersonalId(), dto.getRequestStartDate());
                if (substituteDto == null) {
                    this.addHolidayTargetWorkDateHolidayErrorMessage(dto.getRequestStartDate());
                    return;
                }
                workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), substituteDto.getSubstituteDate());
            }
            WorkTypeDtoInterface workTypeDto2 = this.workTypeReference.findForInfo(workTypeCode, dto.getRequestStartDate());
            WorkTypeItemDtoInterface workStartDto2 = this.workTypeItemReference.findForKey(workTypeDto2.getWorkTypeCode(), workTypeDto2.getActivateDate(), "WorkStart");
            WorkTypeItemDtoInterface workEndDto2 = this.workTypeItemReference.findForKey(workTypeDto2.getWorkTypeCode(), workTypeDto2.getActivateDate(), "WorkEnd");
            targetStartTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workStartDto2.getWorkTypeItemValue()), (String)DateUtility.getStringMinute((Date)workStartDto2.getWorkTypeItemValue()));
            targetEndTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workEndDto2.getWorkTypeItemValue(), (Date)defaultDate), (String)DateUtility.getStringMinute((Date)workEndDto2.getWorkTypeItemValue()));
        } else if (attendanceDraftDto != null) {
            if (this.differenceRequestReference.isDifferenceTypeA(attendanceDraftDto.getWorkTypeCode()) || this.differenceRequestReference.isDifferenceTypeB(attendanceDraftDto.getWorkTypeCode()) || this.differenceRequestReference.isDifferenceTypeC(attendanceDraftDto.getWorkTypeCode()) || this.differenceRequestReference.isDifferenceTypeD(attendanceDraftDto.getWorkTypeCode()) || this.differenceRequestReference.isDifferenceTypeS(attendanceDraftDto.getWorkTypeCode())) {
                workTypeDto = this.workTypeReference.findForInfo(attendanceDraftDto.getWorkTypeCode(), dto.getRequestStartDate());
                if (workTypeDto == null) {
                    String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getRequestStartDate());
                    WorkTypeDtoInterface workType = this.workTypeReference.findForInfo(workTypeCode, dto.getRequestStartDate());
                    WorkTypeItemDtoInterface workStartDto3 = this.workTypeItemReference.findForKey(workType.getWorkTypeCode(), workType.getActivateDate(), "WorkStart");
                    WorkTypeItemDtoInterface workEndDto3 = this.workTypeItemReference.findForKey(workType.getWorkTypeCode(), workType.getActivateDate(), "WorkEnd");
                    targetStartTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workStartDto3.getWorkTypeItemValue()), (String)DateUtility.getStringMinute((Date)workStartDto3.getWorkTypeItemValue()));
                    targetEndTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workEndDto3.getWorkTypeItemValue(), (Date)defaultDate), (String)DateUtility.getStringMinute((Date)workEndDto3.getWorkTypeItemValue()));
                } else {
                    workStartDto = this.workTypeItemReference.findForKey(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkStart");
                    workEndDto = this.workTypeItemReference.findForKey(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkEnd");
                    targetStartTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workStartDto.getWorkTypeItemValue()), (String)DateUtility.getStringMinute((Date)workStartDto.getWorkTypeItemValue()));
                    targetEndTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workEndDto.getWorkTypeItemValue(), (Date)defaultDate), (String)DateUtility.getStringMinute((Date)workEndDto.getWorkTypeItemValue()));
                }
            } else {
                workTypeDto = this.workTypeReference.findForInfo(attendanceDraftDto.getWorkTypeCode(), dto.getRequestStartDate());
                workStartDto = this.workTypeItemReference.findForKey(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkStart");
                workEndDto = this.workTypeItemReference.findForKey(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkEnd");
                targetStartTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workStartDto.getWorkTypeItemValue()), (String)DateUtility.getStringMinute((Date)workStartDto.getWorkTypeItemValue()));
                targetEndTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workEndDto.getWorkTypeItemValue(), (Date)defaultDate), (String)DateUtility.getStringMinute((Date)workEndDto.getWorkTypeItemValue()));
            }
        } else {
            this.checkTimeHolidayCalendar(dto);
            return;
        }
        Date requestStartTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)dto.getStartTime(), (Date)dto.getRequestStartDate()), (String)DateUtility.getStringMinute((Date)dto.getStartTime()));
        Date requestEndTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)dto.getEndTime(), (Date)dto.getRequestStartDate()), (String)DateUtility.getStringMinute((Date)dto.getEndTime()));
        if (!DateUtility.isTermContain((Date)requestStartTime, (Date)targetStartTime, (Date)targetEndTime) || !DateUtility.isTermContain((Date)requestEndTime, (Date)targetStartTime, (Date)targetEndTime)) {
            String workStartHour = DateUtility.getStringHourH((Date)targetStartTime, (Date)defaultDate);
            String workStartMinute = DateUtility.getStringMinute((Date)targetStartTime);
            String workEndHour = DateUtility.getStringHourH((Date)targetEndTime, (Date)defaultDate);
            String workEndMinute = DateUtility.getStringMinute((Date)targetEndTime);
            this.mospParams.addErrorMessage("TMW0340", new String[]{this.mospParams.getName("HolidayTime"), workStartHour, workStartMinute, workEndHour, workEndMinute});
        }
    }

    protected void checkWorkTypeChange(HolidayRequestDtoInterface dto) throws MospException {
        WorkTypeChangeRequestDtoInterface workTypeChangeDto = this.workTypeChangeReference.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestStartDate());
        if (workTypeChangeDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(workTypeChangeDto.getWorkflow());
        if (this.workflowIntegrate.isCompleted(workflowDto.getWorkflow()) || this.workflowIntegrate.isWithDrawn(workflowDto.getWorkflow()) || this.workflowIntegrate.isDraft(workflowDto.getWorkflow())) {
            return;
        }
        String requestName = this.mospParams.getName("Work", new String[]{"Form", "Change"});
        this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(dto.getRequestStartDate()), requestName});
    }

    protected void checkDifference(HolidayRequestDtoInterface dto) throws MospException {
        if (dto.getHolidayRange() != 4) {
            return;
        }
        DifferenceRequestDtoInterface differenceDto = this.differenceRequestReference.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestStartDate());
        if (differenceDto == null) {
            return;
        }
        WorkflowDtoInterface differenceWorkflow = this.workflowIntegrate.getLatestWorkflowInfo(differenceDto.getWorkflow());
        if (!(WorkflowUtility.isWithDrawn((WorkflowDtoInterface)differenceWorkflow) || WorkflowUtility.isDraft((WorkflowDtoInterface)differenceWorkflow) || WorkflowUtility.isCompleted((WorkflowDtoInterface)differenceWorkflow))) {
            String requestName = this.mospParams.getName("TimeDifference", new String[]{"GoingWork", "Application"});
            this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(dto.getRequestStartDate()), requestName});
        }
    }

    protected void checkTimeHolidayCalendar(HolidayRequestDtoInterface dto) throws MospException {
        Date targetStartTime = null;
        Date targetEndTime = null;
        Date defaultDate = DateUtility.getDefaultTime();
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getRequestStartDate());
        WorkTypeDtoInterface workTypeDto = this.workTypeReference.findForInfo(workTypeCode, dto.getRequestStartDate());
        WorkTypeItemDtoInterface workStartDto = this.workTypeItemReference.findForKey(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkStart");
        WorkTypeItemDtoInterface workEndDto = this.workTypeItemReference.findForKey(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkEnd");
        targetStartTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workStartDto.getWorkTypeItemValue(), (Date)defaultDate), (String)DateUtility.getStringMinute((Date)workStartDto.getWorkTypeItemValue()));
        targetEndTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)workEndDto.getWorkTypeItemValue(), (Date)defaultDate), (String)DateUtility.getStringMinute((Date)workEndDto.getWorkTypeItemValue()));
        this.checkTimeHolidayAddMessage(dto, targetStartTime, targetEndTime, defaultDate);
    }

    protected void checkTimeHolidayAddMessage(HolidayRequestDtoInterface dto, Date targetStartTime, Date targetEndTime, Date defaultDate) throws MospException {
        Date requestStartTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)dto.getStartTime(), (Date)dto.getRequestStartDate()), (String)DateUtility.getStringMinute((Date)dto.getStartTime()));
        Date requestEndTime = TimeUtility.getDefaultTime((String)DateUtility.getStringHour((Date)dto.getEndTime(), (Date)dto.getRequestStartDate()), (String)DateUtility.getStringMinute((Date)dto.getEndTime()));
        if (!DateUtility.isTermContain((Date)requestStartTime, (Date)targetStartTime, (Date)targetEndTime) || !DateUtility.isTermContain((Date)requestEndTime, (Date)targetStartTime, (Date)targetEndTime)) {
            String workStartHour = DateUtility.getStringHourH((Date)targetStartTime, (Date)defaultDate);
            String workStartMinute = DateUtility.getStringMinute((Date)targetStartTime);
            String workEndHour = DateUtility.getStringHourH((Date)targetEndTime, (Date)defaultDate);
            String workEndMinute = DateUtility.getStringMinute((Date)targetEndTime);
            this.mospParams.addErrorMessage("TMW0340", new String[]{this.mospParams.getName("HolidayTime"), workStartHour, workStartMinute, workEndHour, workEndMinute});
        }
    }

    protected void addPaidLeaveForPreviousFiscalYearErrorMessage() {
        this.mospParams.addErrorMessage("TMW0317", new String[0]);
    }

    protected void addSubstituteErrorMessage(Date date) {
        this.addOthersRequestErrorMessage(date, this.mospParams.getName("Transfer", new String[]{"Holiday"}));
    }

    protected void addStartTimeErrorMessage() {
        this.mospParams.addErrorMessage("PFW0101", new String[]{this.mospParams.getName("Time", new String[]{"Rest", "Application", "Time"})});
    }

    protected void addDuplicateTermMessage() {
        this.mospParams.addErrorMessage("PFW0218", new String[]{this.mospParams.getName("HolidayTime")});
    }
}

