/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.entity.HolidayRequestEntityInterface;

public class HolidayRequestReferenceBean
extends TimeBean
implements HolidayRequestReferenceBeanInterface {
    protected HolidayRequestDaoInterface dao;
    protected WorkflowDaoInterface workflowDao;
    protected WorkflowIntegrateBeanInterface workflowIntegerBean;

    public HolidayRequestReferenceBean() {
    }

    public HolidayRequestReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDao(WorkflowDaoInterface.class);
        this.workflowIntegerBean = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestList(String personalId, Date requestDate) throws MospException {
        return this.dao.findForList(personalId, requestDate);
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestListOnWorkflow(String personalId, Date requestDate) throws MospException {
        ArrayList<HolidayRequestDtoInterface> newList = new ArrayList<HolidayRequestDtoInterface>();
        List list = this.dao.findForList(personalId, requestDate);
        for (HolidayRequestDtoInterface dto : list) {
            if (this.workflowIntegerBean.isWithDrawn(dto.getWorkflow())) continue;
            newList.add(dto);
        }
        return newList;
    }

    public HolidayRequestDtoInterface findForKeyOnWorkflow(String personalId, Date requestStartDate, int holidayType1, String holidayType2, int holidayRange, Date startTime) throws MospException {
        return this.dao.findForKeyOnWorkflow(personalId, requestStartDate, holidayType1, holidayType2, holidayRange, startTime);
    }

    public HolidayRequestDtoInterface findForEndTimeKeyOnWorkflow(String personalId, Date requestStartDate, int holidayType1, String holidayType2, int holidayRange, Date endTime) throws MospException {
        return this.dao.findForEndTimeKeyOnWorkflow(personalId, requestStartDate, holidayType1, holidayType2, holidayRange, endTime);
    }

    public HolidayRequestDtoInterface findForKey(long id) throws MospException {
        BaseDto dto = this.findForKey((BaseDaoInterface)this.dao, id, false);
        if (dto != null) {
            return (HolidayRequestDtoInterface)dto;
        }
        return null;
    }

    public HolidayRequestDtoInterface findForWorkflow(long workflow) throws MospException {
        return this.dao.findForWorkflow(workflow);
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestList(String personalId, Date firstDate, Date lastDate) throws MospException {
        return this.dao.findForTerm(personalId, firstDate, lastDate);
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestListOnWorkflow(String personalId, Date firstDate, Date lastDate) throws MospException {
        return this.dao.findForTermOnWorkflow(personalId, firstDate, lastDate);
    }

    public Map<String, Object> getApprovedDayHour(String personalId, Date acquisitionDate, int holidayType1, String holidayType2, Date requestStartDate, Date requestEndDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        double approvedDay = 0.0;
        int approvedHour = 0;
        Date countDate = requestStartDate;
        while (!countDate.after(requestEndDate)) {
            List list = this.dao.findForApprovedList(personalId, acquisitionDate, holidayType1, holidayType2, countDate);
            for (HolidayRequestDtoInterface dto : list) {
                int holidayRange = dto.getHolidayRange();
                if (holidayRange == 1) {
                    approvedDay += 1.0;
                }
                if (holidayRange == 2 || holidayRange == 3) {
                    approvedDay += 0.5;
                }
                if (holidayRange != 4) continue;
                approvedHour += dto.getUseHour();
            }
            countDate = this.addDay(countDate, 1);
        }
        map.put("approvedDay", approvedDay);
        map.put("approvedHour", approvedHour);
        return map;
    }

    public Map<String, Object> getApprovedPaidHolidayReqeust(String personalId, Date acquisitionDate, Date requestStartDate, Date requestEndDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        double approvedDay = 0.0;
        int approvedHour = 0;
        List list = this.dao.findForApprovedList(personalId, acquisitionDate, 1, Integer.toString(1), requestStartDate, requestEndDate);
        for (HolidayRequestDtoInterface dto : list) {
            int holidayRange = dto.getHolidayRange();
            if (holidayRange == 1) {
                approvedDay += 1.0;
            }
            if (holidayRange == 2 || holidayRange == 3) {
                approvedDay += 0.5;
            }
            if (holidayRange != 4) continue;
            approvedHour += dto.getUseHour();
        }
        map.put("approvedDay", approvedDay);
        map.put("approvedHour", approvedHour);
        return map;
    }

    public Map<String, Object> getRequestDayHour(String personalId, Date acquisitionDate, int holidayType1, String holidayType2, Date requestStartDate, Date requestEndDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        double requestDay = 0.0;
        int requestHour = 0;
        List list = this.dao.findForRequestList(personalId, acquisitionDate, holidayType1, holidayType2, requestStartDate, requestEndDate);
        for (HolidayRequestDtoInterface dto : list) {
            requestDay += dto.getUseDay();
            requestHour += dto.getUseHour();
        }
        map.put("requestDay", requestDay);
        map.put("requestHour", requestHour);
        return map;
    }

    public AbstractMap.SimpleEntry<Double, Integer> getHolidayUses(String personalId, Date firstDate, Date lastDate, int holidayType1, String holidayType2, Collection<Date> acquisitionDates) throws MospException {
        double useDays = 0.0;
        int useHours = 0;
        List list = this.getHolidayRequestListOnWorkflow(personalId, firstDate, lastDate);
        for (HolidayRequestDtoInterface dto : list) {
            if (dto.getHolidayType1() != holidayType1 || !MospUtility.isEqual((Object)holidayType2, (Object)dto.getHolidayType2()) || !acquisitionDates.contains(dto.getHolidayAcquisitionDate())) continue;
            useDays += dto.getUseDay();
            useHours += dto.getUseHour();
        }
        return new AbstractMap.SimpleEntry<Double, Integer>(useDays, useHours);
    }

    public boolean isPaidHolidayReasonRequired() {
        return this.mospParams.getApplicationPropertyBool("PaidHolidayReasonRequired");
    }

    public void chkBasicInfo(String personalId, Date targetDate) throws MospException {
        this.initial(personalId, targetDate, "3");
    }

    public Map<String, Integer> getTimeHolidayStatusTimesMap(String personalId, Date acquisitionDate, HolidayRequestDtoInterface holidayRequestDto) throws MospException {
        HashMap<String, Integer> timeHolidayMap = new HashMap<String, Integer>();
        int draft = 0;
        int approval = 0;
        int complete = 0;
        int revert = 0;
        List holidayList = this.getHolidayRequestListOnWorkflow(personalId, acquisitionDate);
        if (holidayList.isEmpty()) {
            return timeHolidayMap;
        }
        for (HolidayRequestDtoInterface dto : holidayList) {
            if (dto.getHolidayRange() != 4 || this.workflowIntegerBean.isWithDrawn(dto.getWorkflow()) || holidayRequestDto != null && holidayRequestDto.getTmdHolidayRequestId() == dto.getTmdHolidayRequestId()) continue;
            if (this.workflowIntegerBean.isDraft(dto.getWorkflow())) {
                ++draft;
                continue;
            }
            if (this.workflowIntegerBean.isCompleted(dto.getWorkflow())) {
                ++complete;
                continue;
            }
            if (this.workflowIntegerBean.isFirstReverted(dto.getWorkflow())) {
                ++revert;
                continue;
            }
            ++approval;
        }
        timeHolidayMap.put(this.mospParams.getName("Under"), draft);
        timeHolidayMap.put(this.mospParams.getName("Register"), approval);
        timeHolidayMap.put(this.mospParams.getName("Finish"), complete);
        timeHolidayMap.put(this.mospParams.getName("Back"), revert);
        return timeHolidayMap;
    }

    public List<HolidayRequestDtoInterface> getUsePaidHolidayDataList(String personalId, Date acquisitionDate) throws MospException {
        List list = this.dao.findForAcquisitionList(personalId, acquisitionDate);
        ArrayList<HolidayRequestDtoInterface> holidayList = new ArrayList<HolidayRequestDtoInterface>();
        for (HolidayRequestDtoInterface dto : list) {
            if (this.workflowIntegerBean.isDraft(dto.getWorkflow()) || this.workflowIntegerBean.isWithDrawn(dto.getWorkflow()) || this.workflowIntegerBean.isFirstReverted(dto.getWorkflow())) continue;
            holidayList.add(dto);
        }
        return holidayList;
    }

    public HolidayRequestEntityInterface getHolidayRequestEntity(String personalId, Date firstDate, Date lastDate) throws MospException {
        HolidayRequestEntityInterface entity = (HolidayRequestEntityInterface)this.createObject(HolidayRequestEntityInterface.class);
        List holidayList = this.dao.findForTerm(personalId, firstDate, lastDate);
        entity.setHolidays(holidayList);
        entity.setWorkflows(this.workflowDao.findForInKey(WorkflowUtility.getWorkflowSet((Collection)holidayList)));
        return entity;
    }
}

