/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.file.ImportBeanInterface;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.HolidayRequestRegistBeanInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class HolidayRequestImportBean
extends PlatformFileBean
implements ImportBeanInterface {
    protected HolidayRequestRegistBeanInterface holidayRequestRegist;
    protected AttendanceTransactionRegistBeanInterface attendanceTransactionRegist;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkflowRegistBeanInterface workflowRegist;

    public HolidayRequestImportBean() {
    }

    public HolidayRequestImportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.holidayRequestRegist = (HolidayRequestRegistBeanInterface)this.createBean(HolidayRequestRegistBeanInterface.class);
        this.attendanceTransactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBean(AttendanceTransactionRegistBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        this.convertEmployeeCodeIntoPersonalId(fieldList, dataList, "request_start_date", this.getNameActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        return this.importFile(fieldList, dataList);
    }

    protected int importFile(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        int count = 0;
        for (String[] data : dataList) {
            count += this.importData(fieldList, data);
        }
        return count;
    }

    protected int importData(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        this.checkDate(fieldList, data);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        int holidayRange = this.getIntegerFieldValue("holiday_range", fieldList, data);
        int holidayType1 = this.getIntegerFieldValue("holiday_type1", fieldList, data);
        if (holidayType1 == 1) {
            String holidayType2 = this.getFieldValue("holiday_type2", fieldList, data);
            if (Integer.toString(1).equals(holidayType2)) {
                if (holidayRange == 1 || holidayRange == 2 || holidayRange == 3) {
                    return this.paidLeaveImport(fieldList, data);
                }
                if (holidayRange == 4) {
                    return this.paidLeaveByTheHourImport(fieldList, data);
                }
                return 0;
            }
            if (Integer.toString(2).equals(holidayType2)) {
                return this.stockLeaveImport(fieldList, data);
            }
            return 0;
        }
        if (holidayType1 == 2 || holidayType1 == 3 || holidayType1 == 4) {
            if (holidayRange == 1 || holidayRange == 2 || holidayRange == 3) {
                return this.leaveImport(fieldList, data);
            }
            if (holidayRange == 4) {
                return this.leaveByTheHourImport(fieldList, data);
            }
            return 0;
        }
        return 0;
    }

    protected void importData(HolidayRequestDtoInterface dto) throws MospException {
        this.holidayRequestRegist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = this.workflowRegist.getInitDto();
            workflowDto.setFunctionCode("3");
        }
        this.workflowRegist.setSelfApproval(workflowDto);
        workflowDto = this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestStartDate(), 1, null);
        if (workflowDto != null) {
            dto.setWorkflow(workflowDto.getWorkflow());
            this.holidayRequestRegist.regist(dto);
            this.holidayRequestRegist.deleteAttendance(dto);
            this.holidayRequestRegist.draftAttendance(dto);
            this.attendanceTransactionRegist.regist(dto);
        }
    }

    protected int paidLeaveImport(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        String personalId = this.getFieldValue("personal_id", fieldList, data);
        Date requestStartDate = this.getDateFieldValue("request_start_date", fieldList, data);
        Date requestEndDate = this.getDateFieldValue("request_end_date", fieldList, data);
        if (requestEndDate == null) {
            requestEndDate = requestStartDate;
        }
        int count = 0;
        List dateList = TimeUtility.getDateList((Date)requestStartDate, (Date)requestEndDate);
        for (Date date : dateList) {
            String workTypeCode = this.holidayRequestRegist.getScheduledWorkTypeCode(personalId, date);
            this.holidayRequestRegist.checkWorkType(requestStartDate, requestEndDate, date, workTypeCode);
            if (this.mospParams.hasErrorMessage()) {
                return count;
            }
            if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
            HolidayRequestDtoInterface dto = this.getHolidayRequestDto(fieldList, data, date, date, date, date);
            this.holidayRequestRegist.setHolidayRequest(dto);
            this.importData(dto);
            if (this.mospParams.hasErrorMessage()) {
                return count;
            }
            ++count;
        }
        return count;
    }

    protected int paidLeaveByTheHourImport(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        String personalId = this.getFieldValue("personal_id", fieldList, data);
        Date startTime = this.getTimestampFieldValue("start_time", fieldList, data);
        if (startTime == null) {
            this.addRequiredErrorMessage(this.mospParams.getProperties().getCodeItemName("import_tmd_holiday_request", "start_time"), null);
            return 0;
        }
        Date endTime = DateUtility.addHour((Date)startTime, (int)1);
        Date date = DateUtility.getDate((int)DateUtility.getYear((Date)startTime), (int)DateUtility.getMonth((Date)startTime), (int)DateUtility.getDay((Date)startTime));
        String workTypeCode = this.holidayRequestRegist.getScheduledWorkTypeCode(personalId, date);
        this.holidayRequestRegist.checkWorkType(date, date, date, workTypeCode);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) {
            return 0;
        }
        HolidayRequestDtoInterface dto = this.getHolidayRequestDto(fieldList, data, date, date, startTime, endTime);
        this.holidayRequestRegist.setHolidayRequest(dto);
        this.importData(dto);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        return 1;
    }

    protected int stockLeaveImport(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        String personalId = this.getFieldValue("personal_id", fieldList, data);
        Date requestStartDate = this.getDateFieldValue("request_start_date", fieldList, data);
        Date requestEndDate = this.getDateFieldValue("request_end_date", fieldList, data);
        if (requestEndDate == null) {
            requestEndDate = requestStartDate;
        }
        int count = 0;
        List dateList = TimeUtility.getDateList((Date)requestStartDate, (Date)requestEndDate);
        for (Date date : dateList) {
            String workTypeCode = this.holidayRequestRegist.getScheduledWorkTypeCode(personalId, date);
            this.holidayRequestRegist.checkWorkType(requestStartDate, requestEndDate, date, workTypeCode);
            if (this.mospParams.hasErrorMessage()) {
                return count;
            }
            if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
            HolidayRequestDtoInterface dto = this.getHolidayRequestDto(fieldList, data, date, date, date, date);
            this.holidayRequestRegist.setHolidayRequest(dto);
            this.importData(dto);
            if (this.mospParams.hasErrorMessage()) {
                return count;
            }
            ++count;
        }
        return count;
    }

    protected int leaveImport(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        int holidayRange = this.getIntegerFieldValue("holiday_range", fieldList, data);
        Date requestStartDate = this.getDateFieldValue("request_start_date", fieldList, data);
        Date requestEndDate = this.getDateFieldValue("request_end_date", fieldList, data);
        if (requestEndDate == null) {
            requestEndDate = requestStartDate;
        }
        if (holidayRange == 2 || holidayRange == 3) {
            requestEndDate = requestStartDate;
        }
        HolidayRequestDtoInterface dto = this.getHolidayRequestDto(fieldList, data, requestStartDate, requestEndDate, requestStartDate, requestStartDate);
        this.holidayRequestRegist.setHolidayRequest(dto);
        this.importData(dto);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        return 1;
    }

    protected int leaveByTheHourImport(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        Date startTime = this.getTimestampFieldValue("start_time", fieldList, data);
        if (startTime == null) {
            this.addRequiredErrorMessage(this.mospParams.getProperties().getCodeItemName("import_tmd_holiday_request", "start_time"), null);
            return 0;
        }
        Date endTime = DateUtility.addHour((Date)startTime, (int)1);
        Date date = DateUtility.getDate((int)DateUtility.getYear((Date)startTime), (int)DateUtility.getMonth((Date)startTime), (int)DateUtility.getDay((Date)startTime));
        HolidayRequestDtoInterface dto = this.getHolidayRequestDto(fieldList, data, date, date, startTime, endTime);
        this.holidayRequestRegist.setHolidayRequest(dto);
        this.importData(dto);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        return 1;
    }

    protected HolidayRequestDtoInterface getHolidayRequestDto(List<ImportFieldDtoInterface> fieldList, String[] data, Date requestStartDate, Date requestEndDate, Date startTime, Date endTime) {
        HolidayRequestDtoInterface dto = this.holidayRequestRegist.getInitDto();
        dto.setPersonalId(this.getFieldValue("personal_id", fieldList, data));
        dto.setRequestStartDate(requestStartDate);
        dto.setRequestEndDate(requestEndDate);
        dto.setHolidayType1(this.getIntegerFieldValue("holiday_type1", fieldList, data));
        dto.setHolidayType2(this.getFieldValue("holiday_type2", fieldList, data));
        dto.setHolidayRange(this.getIntegerFieldValue("holiday_range", fieldList, data));
        dto.setStartTime(startTime);
        dto.setEndTime(endTime);
        dto.setRequestReason(this.getFieldValue("request_reason", fieldList, data));
        return dto;
    }

    protected Date getTimestampFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        String date = this.getFieldValue(fieldName, fieldList, data);
        if (date == null || date.isEmpty()) {
            return null;
        }
        return this.getTimestamp(date);
    }

    protected Date getTimestamp(String date) {
        return DateUtility.getDate((String)date, (String)"yyyy/MM/dd HH:mm");
    }

    protected void checkDate(List<ImportFieldDtoInterface> fieldList, String[] data) {
        Date requestStartDate = this.getDateFieldValue("request_start_date", fieldList, data);
        Date requestEndDate = this.getDateFieldValue("request_end_date", fieldList, data);
        if (requestStartDate == null) {
            this.addDateErrorMessage();
            return;
        }
        if (this.checkDateOrder(requestStartDate, requestEndDate, true)) {
            return;
        }
        this.addInvalidOrderMessage(this.mospParams.getName("Vacation", new String[]{"Start", "Day"}), this.mospParams.getName("Vacation", new String[]{"End", "Day"}));
    }

    protected void addDateErrorMessage() {
        this.mospParams.addMessage("PFW0101", new String[]{this.mospParams.getName("Period")});
    }

    protected void addHolidayTypeErrorMessage() {
        this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Vacation", new String[]{"Classification"})});
    }

    protected void addHolidayNotGrantErrorMessage(String holidayName) {
        this.mospParams.addErrorMessage("TMW0259", new String[]{holidayName});
    }
}

