/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.HolidayRegistBeanInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmHolidayDto;

public class HolidayRegistBean
extends PlatformBean
implements HolidayRegistBeanInterface {
    HolidayDaoInterface dao;
    HolidayRequestDaoInterface requestDao;
    HumanDaoInterface humanDao;
    WorkflowIntegrateBeanInterface workflow;

    public HolidayRegistBean() {
    }

    public HolidayRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (HolidayDaoInterface)this.createDao(HolidayDaoInterface.class);
        this.requestDao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.humanDao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        this.workflow = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
    }

    public HolidayDtoInterface getInitDto() {
        return new TmmHolidayDto();
    }

    public void insert(HolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        this.checkRegister(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(HolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        this.checkRegister(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(HolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        this.checkRegister(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmHolidayId());
        dto.setTmmHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String[] codeType : this.getCodeList(idArray)) {
            HolidayDtoInterface dto = this.dao.findForKey(codeType[0], activateDate, Integer.parseInt(codeType[1]));
            if (dto == null) {
                dto = this.dao.findForInfo(codeType[0], activateDate, Integer.parseInt(codeType[1]));
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(codeType[0]);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setTmmHolidayId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmHolidayId());
            dto.setTmmHolidayId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkDelete((HolidayDtoInterface)this.dao.findForKey(id, true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void checkInsert(HolidayDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getHolidayCode(), dto.getHolidayType()));
    }

    protected void checkAdd(HolidayDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getHolidayCode(), dto.getHolidayType());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List holidayListList = this.getHolidayDataListForCheck(dto.getHolidayCode(), dto.getHolidayType(), (PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getHolidayCode(), dto.getHolidayType(), dto.getActivateDate(), holidayListList);
        Date lastDate = this.getEffectiveLastDate(dto.getActivateDate(), list);
        this.checkRequestHoliday(dto, lastDate);
    }

    protected void checkUpdate(HolidayDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmHolidayId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmHolidayId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getHolidayCode(), dto.getHolidayType());
        List holidayListList = this.getHolidayDataListForCheck(dto.getHolidayCode(), dto.getHolidayType(), (PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getHolidayCode(), dto.getHolidayType(), dto.getActivateDate(), holidayListList);
        Date lastDate = this.getEffectiveLastDate(dto.getActivateDate(), list);
        this.checkRequestHoliday(dto, lastDate);
    }

    protected void checkDelete(HolidayDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmHolidayId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getHolidayCode(), dto.getHolidayType());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List holidayListList = this.getHolidayDataListForCheck(dto.getHolidayCode(), dto.getHolidayType(), (PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getHolidayCode(), dto.getHolidayType(), dto.getActivateDate(), holidayListList);
        Date lastDate = this.getEffectiveLastDate(dto.getActivateDate(), list);
        this.checkRequestHoliday(dto, lastDate);
    }

    protected List<String[]> getCodeList(long[] idArray) throws MospException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (long id : idArray) {
            String[] strAry = new String[2];
            HolidayDtoInterface dto = (HolidayDtoInterface)this.dao.findForKey(id, false);
            strAry[0] = dto.getHolidayCode();
            strAry[1] = String.valueOf(dto.getHolidayType());
            list.add(strAry);
        }
        return list;
    }

    protected void validate(HolidayDtoInterface dto) {
    }

    protected void checkCodeIsUsed(String code, int holidayType, Date activateDate, List<HolidayDataDtoInterface> list) throws MospException {
        for (HolidayDataDtoInterface dto : list) {
            if (!code.equals(dto.getHolidayCode()) || holidayType != dto.getHolidayType()) continue;
            this.addCodeIsUsedMessage(code, activateDate, dto);
            break;
        }
    }

    protected void checkRequestHoliday(HolidayDtoInterface dto, Date lastDate) throws MospException {
        List requestList = this.requestDao.findForRequestList(dto.getHolidayType(), dto.getHolidayCode(), dto.getActivateDate(), lastDate);
        for (HolidayRequestDtoInterface requestDto : requestList) {
            if (this.workflow.isWithDrawn(requestDto.getWorkflow())) continue;
            HumanDtoInterface humanDto = this.humanDao.findForInfo(requestDto.getPersonalId(), dto.getActivateDate());
            if (humanDto == null) {
                humanDto = this.humanDao.findForInfo(requestDto.getPersonalId(), DateUtility.getSystemDate());
            }
            this.mospParams.addErrorMessage("TMW0269", new String[]{dto.getHolidayCode(), humanDto.getEmployeeCode(), this.mospParams.getName("Vacation") + this.mospParams.getName("Application"), this.mospParams.getName("Vacation") + this.mospParams.getName("Application")});
        }
    }

    protected void addCodeIsUsedMessage(String code, Date activateDate, HolidayDataDtoInterface dto) throws MospException {
        HumanDtoInterface humanDto = this.humanDao.findForInfo(dto.getPersonalId(), activateDate);
        if (humanDto == null) {
            humanDto = this.humanDao.findForInfo(dto.getPersonalId(), DateUtility.getSystemDate());
        }
        this.mospParams.addErrorMessage("TMW0269", new String[]{code, humanDto.getEmployeeCode(), this.mospParams.getName("Giving"), this.mospParams.getName("Vacation") + this.mospParams.getName("Giving") + this.mospParams.getName("Information")});
    }

    protected List<HolidayDataDtoInterface> getHolidayDataListForCheck(String code, int holidayType, PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        HolidayDataDaoInterface holidayDataDao = (HolidayDataDaoInterface)this.createDao(HolidayDataDaoInterface.class);
        return holidayDataDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list), code, holidayType);
    }

    protected void checkRegister(HolidayDtoInterface dto) {
        this.checkHolidayGiving(dto);
        this.checkHolidayLimit(dto);
    }

    protected void checkHolidayGiving(HolidayDtoInterface dto) {
        if (0 == dto.getNoLimit() && 0 == Double.compare(dto.getHolidayGiving(), 0.0)) {
            String mes1 = this.mospParams.getName("Standard", new String[]{"Giving", "Days"});
            String mes2 = mes1 + this.mospParams.getName("Is", new String[]{"No0", "Dot", "No5", "Over"});
            this.mospParams.addErrorMessage("TMW0270", new String[]{mes1, mes2});
        }
    }

    protected void checkHolidayLimit(HolidayDtoInterface dto) {
        if (0 == dto.getNoLimit() && 0 == dto.getHolidayLimitDay() && 0 == dto.getHolidayLimitMonth()) {
            String mes1 = this.mospParams.getName("Acquisition", new String[]{"TimeLimit"});
            String mes2 = mes1 + this.mospParams.getName("Is", new String[]{"No1", "Day", "Over"});
            this.mospParams.addErrorMessage("TMW0270", new String[]{mes1, mes2});
        }
    }
}

