/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;

public class HolidayReferenceBean
extends PlatformBean
implements HolidayReferenceBeanInterface {
    private HolidayDaoInterface dao;

    public HolidayReferenceBean() {
    }

    public HolidayReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (HolidayDaoInterface)this.createDao(HolidayDaoInterface.class);
    }

    public HolidayDtoInterface getHolidayInfo(String holidayCode, Date targetDate, int holidayType) throws MospException {
        return this.dao.findForInfo(holidayCode, targetDate, holidayType);
    }

    public List<HolidayDtoInterface> getHolidayHistory(String holidayCode, int holidayType) throws MospException {
        return this.dao.findForHistory(holidayCode, holidayType);
    }

    public List<HolidayDtoInterface> getHolidayList(Date targetDate, int holidayType) throws MospException {
        return this.dao.findForActivateDate(targetDate, holidayType);
    }

    public String[][] getSelectArray(Date targetDate, int holidayType, boolean needBlank) throws MospException {
        List list = this.dao.findForActivateDate(targetDate, holidayType);
        if (list.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (HolidayDtoInterface dto : list) {
            array[idx][0] = dto.getHolidayCode();
            array[idx][1] = dto.getHolidayAbbr();
            ++idx;
        }
        return array;
    }

    public String[][] getSelectArray(Date targetDate, int holidayType, boolean needBlank, Set<String> set) throws MospException {
        ArrayList<HolidayDtoInterface> holidayList = new ArrayList<HolidayDtoInterface>();
        List list = this.dao.findForActivateDate(targetDate, holidayType);
        if (list.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        for (String string : set) {
            for (HolidayDtoInterface holidayDto : list) {
                if (!string.equals(holidayDto.getHolidayCode())) continue;
                holidayList.add(holidayDto);
            }
        }
        if (holidayList.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(holidayList.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (HolidayDtoInterface dto : holidayList) {
            array[idx][0] = dto.getHolidayCode();
            array[idx][1] = dto.getHolidayAbbr();
            ++idx;
        }
        return array;
    }

    public String[][] getExportArray(Date targetDate) throws MospException {
        List specialList = this.dao.findForExport(targetDate, 2);
        List otherList = this.dao.findForExport(targetDate, 3);
        List absenceList = this.dao.findForExport(targetDate, 4);
        if (specialList.isEmpty() && otherList.isEmpty() && absenceList.isEmpty()) {
            return this.prepareSelectArray(0, false);
        }
        String comma = this.mospParams.getName("Comma");
        String frontParentheses = this.mospParams.getName("FrontParentheses");
        String backParentheses = this.mospParams.getName("BackParentheses");
        String allHoliday = frontParentheses + this.mospParams.getName("AllTime") + backParentheses;
        String halfHoliday = frontParentheses + this.mospParams.getName("HalfTime") + backParentheses;
        String hourHoliday = frontParentheses + this.mospParams.getName("HourTime") + backParentheses;
        String[][] array = this.prepareSelectArray((specialList.size() + otherList.size() + absenceList.size()) * 3, false);
        for (int i = 0; i < array.length; i += 3) {
            StringBuffer sb;
            HolidayDtoInterface dto;
            if (i / 3 < specialList.size()) {
                dto = (HolidayDtoInterface)specialList.get(i / 3);
                sb = new StringBuffer();
                sb.append(2);
                sb.append(comma);
                sb.append(dto.getHolidayCode());
                sb.append(comma);
                array[i][0] = sb.toString() + "all";
                array[i][1] = dto.getHolidayAbbr() + allHoliday;
                array[i + 1][0] = sb.toString() + "half";
                array[i + 1][1] = dto.getHolidayAbbr() + halfHoliday;
                array[i + 2][0] = sb.toString() + "hour";
                array[i + 2][1] = dto.getHolidayAbbr() + hourHoliday;
                continue;
            }
            if (i / 3 < specialList.size() + otherList.size()) {
                dto = (HolidayDtoInterface)otherList.get(i / 3 - specialList.size());
                sb = new StringBuffer();
                sb.append(3);
                sb.append(comma);
                sb.append(dto.getHolidayCode());
                sb.append(comma);
                array[i][0] = sb.toString() + "all";
                array[i][1] = dto.getHolidayAbbr() + allHoliday;
                array[i + 1][0] = sb.toString() + "half";
                array[i + 1][1] = dto.getHolidayAbbr() + halfHoliday;
                array[i + 2][0] = sb.toString() + "hour";
                array[i + 2][1] = dto.getHolidayAbbr() + hourHoliday;
                continue;
            }
            if (i / 3 >= specialList.size() + otherList.size() + absenceList.size()) continue;
            dto = (HolidayDtoInterface)absenceList.get(i / 3 - specialList.size() - otherList.size());
            sb = new StringBuffer();
            sb.append(4);
            sb.append(comma);
            sb.append(dto.getHolidayCode());
            sb.append(comma);
            array[i][0] = sb.toString() + "all";
            array[i][1] = dto.getHolidayAbbr() + allHoliday;
            array[i + 1][0] = sb.toString() + "half";
            array[i + 1][1] = dto.getHolidayAbbr() + halfHoliday;
            array[i + 2][0] = sb.toString() + "hour";
            array[i + 2][1] = dto.getHolidayAbbr() + hourHoliday;
        }
        return array;
    }

    public HolidayDtoInterface findForKey(String holidayCode, Date activateDate, int holidayType) throws MospException {
        return this.dao.findForKey(holidayCode, activateDate, holidayType);
    }

    public String getHolidayAbbr(String holidayCode, Date targetDate, int holidayType) throws MospException {
        HolidayDtoInterface dto = this.dao.findForInfo(holidayCode, targetDate, holidayType);
        if (dto == null) {
            return holidayCode;
        }
        return dto.getHolidayAbbr();
    }

    public String getHolidayType1NameForHolidayRequest(int type1, String type2) {
        if (type1 == 1) {
            if (Integer.toString(1).equals(type2)) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Salaried"));
                sb.append(this.mospParams.getName("Vacation"));
                return sb.toString();
            }
            if (Integer.toString(2).equals(type2)) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Stock"));
                sb.append(this.mospParams.getName("Vacation"));
                return sb.toString();
            }
        } else {
            if (type1 == 2) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Specially"));
                return sb.toString();
            }
            if (type1 == 3) {
                return this.mospParams.getName("Others");
            }
            if (type1 == 4) {
                return this.mospParams.getName("Absence");
            }
        }
        return "";
    }

    public boolean isTimelyHoliday(Date activateDate) throws MospException {
        Set set = this.dao.findForActivateDate(activateDate);
        for (HolidayDtoInterface dto : set) {
            if (dto.getTimelyHolidayFlag() != 0) continue;
            return true;
        }
        return false;
    }
}

