/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.HolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class HolidayInfoReferenceBean
extends TimeApplicationBean
implements HolidayInfoReferenceBeanInterface {
    private HolidayDataDaoInterface dao;
    private HolidayDaoInterface holidayDao;
    private HolidayRequestDaoInterface holidayRequestDao;
    protected HolidayDataReferenceBeanInterface refer;
    private HolidayRequestReferenceBeanInterface holidayRequest;
    private WorkflowIntegrateBeanInterface workflowIntegrate;
    protected TimeMasterBeanInterface timeMaster;

    public HolidayInfoReferenceBean() {
    }

    public HolidayInfoReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HolidayDataDaoInterface)this.createDao(HolidayDataDaoInterface.class);
        this.holidayDao = (HolidayDaoInterface)this.createDao(HolidayDaoInterface.class);
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.refer = (HolidayDataReferenceBeanInterface)this.createBean(HolidayDataReferenceBeanInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBean(TimeMasterBeanInterface.class);
    }

    public List<HolidayDataDtoInterface> getHolidayPossibleRequestListForRequest(String personalId, Date targetDate, int holidayType) throws MospException {
        ArrayList<HolidayDataDtoInterface> list = new ArrayList<HolidayDataDtoInterface>();
        List holidayDataList = this.dao.findForInfoList(personalId, targetDate, String.valueOf(0), holidayType);
        int generalWorkHour = 0;
        if (this.hasPaidHolidaySettings(personalId, targetDate)) {
            generalWorkHour = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        }
        for (HolidayDataDtoInterface dto : holidayDataList) {
            AbstractMap.SimpleEntry remains;
            int cancelHour;
            HolidayDtoInterface holidayDto = this.holidayDao.findForInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            if (holidayDto == null || holidayDto.getInactivateFlag() == 1) continue;
            if (holidayDto.getNoLimit() == 1) {
                list.add(dto);
                continue;
            }
            double requestDay = 0.0;
            int requestHour = 0;
            List holidayRequestList = this.holidayRequestDao.findForRequestList(personalId, dto.getActivateDate(), holidayType, dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayLimitDate());
            for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
                if (this.workflowIntegrate.isFirstReverted(holidayRequestDto.getWorkflow())) continue;
                requestDay += holidayRequestDto.getUseDay();
                requestHour += holidayRequestDto.getUseHour();
            }
            double cancelDay = dto.getCancelDay() + requestDay;
            if (generalWorkHour > 0) {
                for (cancelHour = dto.getCancelHour() + requestHour; cancelHour < 0 && cancelDay >= 1.0; cancelDay -= 1.0, cancelHour += generalWorkHour) {
                }
            }
            if ((Double)(remains = TimeUtility.getHolidayRemains((HolidayDataDtoInterface)dto, (double)cancelDay, (int)cancelHour, (int)generalWorkHour)).getKey() <= 0.0 && (Integer)remains.getValue() <= 0) continue;
            dto.setCancelDay(cancelDay);
            dto.setCancelHour(cancelHour);
            list.add(dto);
        }
        return list;
    }

    public List<HolidayDataDtoInterface> getHolidayPossibleRequestList(String personalId, Date targetDate, int holidayType) throws MospException {
        ArrayList<HolidayDataDtoInterface> list = new ArrayList<HolidayDataDtoInterface>();
        List holidayDataList = this.dao.findForInfoList(personalId, targetDate, String.valueOf(0), holidayType);
        int generalWorkHour = 0;
        if (this.hasPaidHolidaySettings(personalId, targetDate)) {
            generalWorkHour = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        }
        for (HolidayDataDtoInterface dto : holidayDataList) {
            int remainHour;
            HolidayDtoInterface holidayDto = this.holidayDao.findForInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            if (holidayDto == null || holidayDto.getInactivateFlag() == 1) continue;
            if (holidayDto.getNoLimit() == 1) {
                list.add(dto);
                continue;
            }
            Map map = this.holidayRequest.getRequestDayHour(personalId, dto.getActivateDate(), holidayType, dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayLimitDate());
            double requestDay = (Double)map.get("requestDay");
            int requestHour = (Integer)map.get("requestHour");
            double remainDay = dto.getGivingDay() - dto.getCancelDay() - requestDay;
            if (generalWorkHour > 0) {
                for (remainHour = dto.getGivingHour() - dto.getCancelHour() - requestHour; remainHour < 0 && remainDay >= 1.0; remainDay -= 1.0, remainHour += generalWorkHour) {
                }
            }
            if (!(remainDay > 0.0) && remainHour <= 0) continue;
            dto.setGivingDay(remainDay);
            dto.setGivingHour(remainHour);
            dto.setCancelDay(dto.getCancelDay() + requestDay);
            dto.setCancelHour(dto.getCancelHour() + requestHour);
            list.add(dto);
        }
        return list;
    }

    public HolidayDataDtoInterface getHolidayPossibleRequestForRequest(String personalId, Date targetDate, String holidayCode, int holidayType) throws MospException {
        HolidayDataDtoInterface holidayDataDto = null;
        List list = this.dao.findForEarliestList(personalId, targetDate, holidayCode, holidayType);
        int generalWorkHour = 0;
        if (this.hasPaidHolidaySettings(personalId, targetDate)) {
            generalWorkHour = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        }
        for (HolidayDataDtoInterface dto : list) {
            int cancelHour;
            HolidayDtoInterface holidayDto = this.holidayDao.findForInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            if (holidayDto == null || holidayDto.getInactivateFlag() == 1) continue;
            if (holidayDto.getNoLimit() == 1) {
                return dto;
            }
            double requestDay = 0.0;
            int requestHour = 0;
            List holidayRequestList = this.holidayRequestDao.findForRequestList(personalId, dto.getActivateDate(), holidayType, holidayCode, dto.getActivateDate(), dto.getHolidayLimitDate());
            for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
                if (this.workflowIntegrate.isFirstReverted(holidayRequestDto.getWorkflow())) continue;
                requestDay += holidayRequestDto.getUseDay();
                requestHour += holidayRequestDto.getUseHour();
            }
            double cancelDay = dto.getCancelDay() + requestDay;
            if (generalWorkHour > 0) {
                for (cancelHour = dto.getCancelHour() + requestHour; cancelHour < 0 && cancelDay >= 1.0; cancelDay -= 1.0, cancelHour += generalWorkHour) {
                }
            }
            dto.setCancelDay(cancelDay);
            dto.setCancelHour(cancelHour);
            if (dto.getGivingDay() - dto.getCancelDay() > 0.0) {
                return dto;
            }
            holidayDataDto = dto;
        }
        return holidayDataDto;
    }

    public boolean hasPersonalApplication(String personalId, Date startDate, Date endDate, int holidayType) throws MospException {
        List list = this.dao.findPersonTerm(personalId, startDate, endDate, holidayType);
        return !list.isEmpty();
    }

    public Map<HolidayDataDtoInterface, AbstractMap.SimpleEntry<Double, Integer>> getHolidayRemains(HumanDtoInterface humanDto, Date targetDate, int holidayType) throws MospException {
        HashMap<HolidayDataDtoInterface, AbstractMap.SimpleEntry<Double, Integer>> remains = new HashMap<HolidayDataDtoInterface, AbstractMap.SimpleEntry<Double, Integer>>();
        String personalId = humanDto.getPersonalId();
        int hoursPerDay = this.timeMaster.getPaidHolidayHoursPerDay(humanDto, targetDate);
        List list = this.refer.getActiveList(personalId, targetDate, holidayType);
        for (HolidayDataDtoInterface dto : list) {
            remains.put(dto, this.getHolidayRemains(dto, targetDate, hoursPerDay));
        }
        return remains;
    }

    protected AbstractMap.SimpleEntry<Double, Integer> getHolidayRemains(HolidayDataDtoInterface dto, Date targetDate, int hoursPerDay) throws MospException {
        if (TimeUtility.isUnlimited((HolidayDataDtoInterface)dto)) {
            return new AbstractMap.SimpleEntry<Double, Integer>(0.0, 0);
        }
        String personalId = dto.getPersonalId();
        Date acquisitionDate = dto.getActivateDate();
        int holidayType = dto.getHolidayType();
        String holidayCode = dto.getHolidayCode();
        Map map = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, holidayType, holidayCode, acquisitionDate, targetDate);
        double days = (Double)map.get("requestDay");
        int hours = (Integer)map.get("requestHour");
        return TimeUtility.getHolidayRemains((HolidayDataDtoInterface)dto, (double)days, (int)hours, (int)hoursPerDay);
    }
}

