/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.HolidayHistorySearchBeanInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayHistoryListDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayHistoryListDto;

public class HolidayHistorySearchBean
extends PlatformBean
implements HolidayHistorySearchBeanInterface {
    private HumanSearchBeanInterface humanSearch;
    private HolidayDataDaoInterface holidayDataDao;
    private Date activateDate;
    private String employeeCode;
    private String employeeName;
    private String workPlaceCode;
    private String employmentCode;
    private String sectionCode;
    private String positionCode;
    private String inactivateFlag;

    public HolidayHistorySearchBean() {
    }

    public HolidayHistorySearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.holidayDataDao = (HolidayDataDaoInterface)this.createDao(HolidayDataDaoInterface.class);
    }

    public List<HolidayHistoryListDtoInterface> getSearchList(int holidayType) throws MospException {
        this.humanSearch.setTargetDate(this.activateDate);
        this.humanSearch.setEmployeeCode(this.employeeCode);
        this.humanSearch.setEmployeeCodeType("forward");
        this.humanSearch.setEmployeeName(this.employeeName);
        this.humanSearch.setWorkPlaceCode(this.workPlaceCode);
        this.humanSearch.setEmploymentContractCode(this.employmentCode);
        this.humanSearch.setPositionCode(this.positionCode);
        this.humanSearch.setSectionCode(this.sectionCode);
        this.humanSearch.setStateType("presence");
        List list = this.humanSearch.search();
        ArrayList<HolidayHistoryListDtoInterface> holidayHistoryList = new ArrayList<HolidayHistoryListDtoInterface>();
        for (HumanDtoInterface dto : list) {
            List holidayDataDtoList = this.holidayDataDao.findForInfoList(dto.getPersonalId(), this.activateDate, this.inactivateFlag, holidayType);
            for (HolidayDataDtoInterface holidayDataDto : holidayDataDtoList) {
                HolidayHistoryListDto holidayHistoryListDto = new HolidayHistoryListDto();
                holidayHistoryListDto.setEmployeeCode(dto.getEmployeeCode());
                holidayHistoryListDto.setLastName(dto.getLastName());
                holidayHistoryListDto.setFirstName(dto.getFirstName());
                holidayHistoryListDto.setSectionCode(dto.getSectionCode());
                holidayHistoryListDto.setActivateDate(holidayDataDto.getActivateDate());
                holidayHistoryListDto.setHolidayCode(holidayDataDto.getHolidayCode());
                holidayHistoryListDto.setHolidayGiving(holidayDataDto.getGivingDay());
                holidayHistoryListDto.setHolidayLimit(holidayDataDto.getHolidayLimitDate());
                holidayHistoryListDto.setInactivateFlag(holidayDataDto.getInactivateFlag());
                holidayHistoryList.add((HolidayHistoryListDtoInterface)holidayHistoryListDto);
            }
        }
        return holidayHistoryList;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public void setInactivateFlag(String inactivateFlag) {
        this.inactivateFlag = inactivateFlag;
    }
}

