/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.GoOutRegistBeanInterface;
import jp.mosp.time.dao.settings.GoOutDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdGoOutDto;
import jp.mosp.time.utils.TimeUtility;

public class GoOutRegistBean
extends PlatformBean
implements GoOutRegistBeanInterface {
    GoOutDaoInterface dao;

    public GoOutRegistBean() {
    }

    public GoOutRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (GoOutDaoInterface)this.createDao(GoOutDaoInterface.class);
    }

    public GoOutDtoInterface getInitDto() {
        return new TmdGoOutDto();
    }

    public void regist(GoOutDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), dto.getGoOutType(), dto.getTimesGoOut()) == null) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    public void insert(GoOutDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdGoOutId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(GoOutDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
        dto.setTmdGoOutId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(GoOutDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPersonalId(), dto.getWorkDate(), dto.getGoOutType(), dto.getTimesGoOut(), dto.getGoOutStart(), dto.getGoOutEnd()));
    }

    protected void checkUpdate(GoOutDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
    }

    protected void validate(GoOutDtoInterface dto) {
    }

    public void delete(String personalId, Date workDate, int timesWork) throws MospException {
        List list = this.dao.findForList(personalId, workDate, timesWork);
        for (GoOutDtoInterface dto : list) {
            this.checkDelete((GoOutDtoInterface)this.dao.findForKey(dto.getTmdGoOutId(), true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
        }
    }

    protected void checkDelete(GoOutDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
    }

    public void delete(String personalId, Date workDate, int timesWork, int goOutType, int timesGoOut) throws MospException {
        GoOutDtoInterface dto = this.dao.findForKey(personalId, workDate, timesWork, goOutType, timesGoOut);
        this.checkDelete((GoOutDtoInterface)this.dao.findForKey(dto.getTmdGoOutId(), true));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
    }

    public int getCalcPrivateGoOutTime(Date goOutStart, Date goOutEnd, TimeSettingDtoInterface timeSettingDto) {
        if (goOutStart == null || goOutEnd == null || timeSettingDto == null) {
            return 0;
        }
        Date roundGoOutStart = TimeUtility.getRoundMinute((Date)goOutStart, (int)timeSettingDto.getRoundDailyPrivateStart(), (int)timeSettingDto.getRoundDailyPrivateStartUnit());
        Date roundGoOutEnd = TimeUtility.getRoundMinute((Date)goOutEnd, (int)timeSettingDto.getRoundDailyPrivateEnd(), (int)timeSettingDto.getRoundDailyPrivateEndUnit());
        return TimeUtility.getDifferenceMinutes((Date)roundGoOutStart, (Date)roundGoOutEnd);
    }

    public int getCalcPublicGoOutTime(Date goOutStart, Date goOutEnd, TimeSettingDtoInterface timeSettingDto) {
        if (goOutStart == null || goOutEnd == null || timeSettingDto == null) {
            return 0;
        }
        Date roundGoOutStart = TimeUtility.getRoundMinute((Date)goOutStart, (int)timeSettingDto.getRoundDailyPublicStart(), (int)timeSettingDto.getRoundDailyPublicStartUnit());
        Date roundGoOutEnd = TimeUtility.getRoundMinute((Date)goOutEnd, (int)timeSettingDto.getRoundDailyPublicEnd(), (int)timeSettingDto.getRoundDailyPublicEndUnit());
        return TimeUtility.getDifferenceMinutes((Date)roundGoOutStart, (Date)roundGoOutEnd);
    }

    public int getCalcMinutelyHolidayAGoOutTime(Date goOutStart, Date goOutEnd, TimeSettingDtoInterface timeSettingDto) {
        if (goOutStart == null || goOutEnd == null || timeSettingDto == null) {
            return 0;
        }
        return TimeUtility.getDifferenceMinutes((Date)goOutStart, (Date)goOutEnd);
    }

    public int getCalcMinutelyHolidayBGoOutTime(Date goOutStart, Date goOutEnd, TimeSettingDtoInterface timeSettingDto) {
        if (goOutStart == null || goOutEnd == null || timeSettingDto == null) {
            return 0;
        }
        return TimeUtility.getDifferenceMinutes((Date)goOutStart, (Date)goOutEnd);
    }

    public void setGoOutStartEnd(Date goOutStartTime, Date goOutEndTime, AttendanceDtoInterface attendanceDto, GoOutDtoInterface goOutDto) throws MospException {
        if (this.doAdditionalLogic(new Object[]{"Add_GoOutRegistBean_SetGoOutStartEnd", goOutStartTime, goOutEndTime, attendanceDto, goOutDto})) {
            return;
        }
        Date workStartTime = attendanceDto.getStartTime();
        Date workEndTime = attendanceDto.getEndTime();
        if (goOutStartTime != null && goOutEndTime != null) {
            if (workStartTime != null && workStartTime.after(goOutStartTime)) {
                goOutStartTime = workStartTime;
            }
            if (workEndTime != null && workEndTime.before(goOutEndTime)) {
                goOutEndTime = workEndTime;
            }
            if (goOutEndTime.before(goOutStartTime)) {
                goOutEndTime = goOutStartTime;
            }
            if (!goOutStartTime.equals(goOutEndTime)) {
                goOutDto.setGoOutStart(goOutStartTime);
                goOutDto.setGoOutEnd(goOutEndTime);
            }
        }
    }
}

