/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.ExportTableReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.bean.TimeRecordReferenceBeanInterface;
import jp.mosp.time.bean.impl.HolidayRequestReferenceBean;
import jp.mosp.time.dao.settings.ExportDataDaoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.TimeRecordDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.utils.TimeUtility;

public class ExportTableReferenceBean
extends PlatformBean
implements ExportTableReferenceBeanInterface {
    protected String exportCode;
    protected int startYear;
    protected int startMonth;
    protected int endYear;
    protected int endMonth;
    protected String cutoffCode;
    protected String workPlaceCode;
    protected String employmentCode;
    protected String sectionCode;
    protected String positionCode;
    protected int ckbNeedLowerSection;
    private ExportDaoInterface exportDao;
    private ExportFieldDaoInterface exportFieldDao;
    private ExportDataDaoInterface exportDataDao;
    private CutoffUtilBeanInterface cutoffUtil;
    private AttendanceListReferenceBeanInterface attendanceList;
    private TimeRecordReferenceBeanInterface timeRecord;
    protected HumanSearchBeanInterface humanSearch;
    protected SectionReferenceBeanInterface section;
    protected HolidayRequestReferenceBean holidayRequestReference;
    protected PaidHolidayDataReferenceBeanInterface paidHolidayDataReference;
    protected WorkflowReferenceBeanInterface workflowReference;
    protected PaidHolidayTransactionReferenceBeanInterface paidHolidayTransactionReference;
    RetirementReferenceBeanInterface retirementReference;
    protected static final String APP_EXPORT_TIME_FORMAT = "ExportTimeFormat";
    protected static final int addPrevious = -1;

    public ExportTableReferenceBean() {
    }

    public ExportTableReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.exportDao = (ExportDaoInterface)this.createDao(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
        this.exportDataDao = (ExportDataDaoInterface)this.createDao(ExportDataDaoInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.attendanceList = (AttendanceListReferenceBeanInterface)this.createBean(AttendanceListReferenceBeanInterface.class);
        this.timeRecord = (TimeRecordReferenceBeanInterface)this.createBean(TimeRecordReferenceBeanInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.section = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
        this.holidayRequestReference = (HolidayRequestReferenceBean)this.createBean(HolidayRequestReferenceBean.class);
        this.paidHolidayDataReference = (PaidHolidayDataReferenceBeanInterface)this.createBean(PaidHolidayDataReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
        this.paidHolidayTransactionReference = (PaidHolidayTransactionReferenceBeanInterface)this.createBean(PaidHolidayTransactionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
    }

    public List<String[]> export() throws MospException {
        ExportDtoInterface exportDto = this.exportDao.findForKey(this.exportCode);
        if (exportDto == null) {
            return null;
        }
        List exportFieldDtoList = this.exportFieldDao.findForList(this.exportCode);
        if (exportFieldDtoList.isEmpty()) {
            return null;
        }
        int format = this.getExportTimeFormat();
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (exportDto.getHeader() == 1) {
            ArrayList<String> headerList = new ArrayList<String>();
            for (ExportFieldDtoInterface exportFieldDto : exportFieldDtoList) {
                headerList.add(this.mospParams.getProperties().getCodeItemName(exportDto.getExportTable(), exportFieldDto.getFieldName()));
            }
            list.add(headerList.toArray(new String[0]));
        }
        java.util.Date startDate = this.cutoffUtil.getCutoffFirstDate(this.cutoffCode, this.startYear, this.startMonth);
        java.util.Date endDate = this.cutoffUtil.getCutoffLastDate(this.cutoffCode, this.endYear, this.endMonth);
        java.util.Date firstTargetDate = MonthUtility.getYearMonthTargetDate((int)this.startYear, (int)this.startMonth, (MospParams)this.mospParams);
        ResultSet rs = null;
        boolean isAttendance = "export_tmd_attendance".equals(exportDto.getExportTable());
        boolean isTotalTime = "export_tmd_total_time".equals(exportDto.getExportTable());
        boolean isPaidHoliday = "export_tmd_paid_holiday".equals(exportDto.getExportTable());
        boolean isStockHoliday = "export_tmd_stock_holiday".equals(exportDto.getExportTable());
        boolean isHolidayData = "export_tmd_holiday".equals(exportDto.getExportTable());
        boolean isAttendanceBook = "export_tmd_attendance_book".equals(exportDto.getExportTable());
        if (isAttendance) {
            rs = this.exportDataDao.findForAttendance(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        if (isTotalTime) {
            rs = this.exportDataDao.findForTotalTime(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        if (isPaidHoliday) {
            rs = this.exportDataDao.findForPaidHoliday(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        if (isStockHoliday) {
            rs = this.exportDataDao.findForStockHoliday(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        if (isHolidayData) {
            rs = this.exportDataDao.findForHolidayData(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        if (isAttendanceBook) {
            this.humanSearch.setStartDate(startDate);
            this.humanSearch.setEndDate(endDate);
            this.humanSearch.setTargetDate(endDate);
            this.humanSearch.setWorkPlaceCode(this.workPlaceCode);
            this.humanSearch.setEmploymentContractCode(this.employmentCode);
            this.humanSearch.setSectionCode(this.sectionCode);
            this.humanSearch.setPositionCode(this.positionCode);
            this.humanSearch.setStateType("presence");
            if (this.ckbNeedLowerSection == 1) {
                this.humanSearch.setNeedLowerSection(true);
            } else {
                this.humanSearch.setNeedLowerSection(false);
            }
            this.humanSearch.setNeedConcurrent(false);
            this.humanSearch.setOperationType("1");
            List presenceHumanList = this.humanSearch.search();
            this.humanSearch.setStateType("suspend");
            List suspendHumanList = this.humanSearch.search();
            ArrayList humanList = new ArrayList();
            humanList.addAll(presenceHumanList);
            humanList.addAll(suspendHumanList);
            if (humanList.isEmpty()) {
                return list;
            }
            block3: for (HumanDtoInterface humanDto : humanList) {
                CutoffDtoInterface cutoff;
                if (!(this.cutoffCode.isEmpty() || (cutoff = this.cutoffUtil.getCutoffForPersonalId(humanDto.getPersonalId(), endDate)) != null && this.cutoffCode.equals(cutoff.getCutoffCode()))) {
                    this.mospParams.getErrorMessageList().clear();
                    continue;
                }
                java.util.Date targetDate = startDate;
                int idx = 0;
                while (endDate.after(targetDate)) {
                    targetDate = DateUtility.addMonth((java.util.Date)startDate, (int)idx);
                    ++idx;
                    if (endDate.compareTo(targetDate) < 0) continue block3;
                    List actualList = this.attendanceList.getActualList(humanDto.getPersonalId(), targetDate);
                    if (actualList == null || actualList.isEmpty()) {
                        this.mospParams.getErrorMessageList().clear();
                        continue;
                    }
                    List AttandanceBookList = this.getFieldValue(humanDto, exportFieldDtoList, actualList);
                    list.addAll(AttandanceBookList);
                }
            }
            this.exportDataDao.closers();
            return list;
        }
        try {
            while (rs != null && rs.next()) {
                ArrayList<String> dataList = new ArrayList<String>();
                if (!this.cutoffCode.isEmpty()) {
                    TimeSettingDtoInterface timeSettingDto;
                    String personalId = "";
                    if (isAttendance) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("work_date");
                    }
                    if (isTotalTime) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("calculation_date");
                    }
                    if (isPaidHoliday) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("activate_date");
                        java.util.Date retirementDate = this.retirementReference.getRetireDate(personalId);
                        if (retirementDate != null && DateUtility.isTermContain((java.util.Date)firstTargetDate, (java.util.Date)retirementDate, null)) continue;
                    }
                    if (isStockHoliday) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("activate_date");
                    }
                    if (isHolidayData) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("activate_date");
                    }
                    if ((timeSettingDto = this.cutoffUtil.getTimeSettingNoMessage(personalId, firstTargetDate)) == null || !this.cutoffCode.equals(timeSettingDto.getCutoffCode())) continue;
                }
                for (ExportFieldDtoInterface exportFieldDto : exportFieldDtoList) {
                    String fieldName = exportFieldDto.getFieldName();
                    String personalId = "";
                    Date targetDate = null;
                    if (isAttendance) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("work_date");
                    }
                    if (isTotalTime) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("calculation_date");
                    }
                    if (isPaidHoliday) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("activate_date");
                    }
                    if (isStockHoliday) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("activate_date");
                    }
                    if (isHolidayData) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("activate_date");
                    }
                    if (isAttendance) {
                        TimeRecordDtoInterface recodeDto;
                        String timeRecodeStartTime;
                        if ("work_date".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                            continue;
                        }
                        if ("start_time".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDateAndTime((java.util.Date)rs.getTimestamp("start_time")));
                            continue;
                        }
                        if ("actual_start_time".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDateAndTime((java.util.Date)rs.getTimestamp("actual_start_time")));
                            continue;
                        }
                        if ("time_recode_start_time".equals(fieldName)) {
                            timeRecodeStartTime = "";
                            recodeDto = this.timeRecord.findForKey(personalId, (java.util.Date)targetDate, 1, "StartWork");
                            if (recodeDto != null) {
                                timeRecodeStartTime = DateUtility.getStringDateAndTime((java.util.Date)recodeDto.getRecordTime());
                            }
                            dataList.add(timeRecodeStartTime);
                            continue;
                        }
                        if ("end_time".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDateAndTime((java.util.Date)rs.getTimestamp("end_time")));
                            continue;
                        }
                        if ("actual_end_time".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDateAndTime((java.util.Date)rs.getTimestamp("actual_end_time")));
                            continue;
                        }
                        if ("time_recode_end_time".equals(fieldName)) {
                            timeRecodeStartTime = "";
                            recodeDto = this.timeRecord.findForKey(personalId, (java.util.Date)targetDate, 1, "EndWork");
                            if (recodeDto != null) {
                                timeRecodeStartTime = DateUtility.getStringDateAndTime((java.util.Date)recodeDto.getRecordTime());
                            }
                            dataList.add(timeRecodeStartTime);
                            continue;
                        }
                        if ("late_time".equals(fieldName) || "actual_late_time".equals(fieldName) || "late_thirty_minutes_or_more_time".equals(fieldName) || "late_less_than_thirty_minutes_time".equals(fieldName) || "leave_early_time".equals(fieldName) || "actual_leave_early_time".equals(fieldName) || "leave_early_thirty_minutes_or_more_time".equals(fieldName) || "leave_early_less_than_thirty_minutes_time".equals(fieldName) || "work_time".equals(fieldName) || "general_work_time".equals(fieldName) || "work_time_within_prescribed_work_time".equals(fieldName) || "contract_work_time".equals(fieldName) || "short_unpaid".equals(fieldName) || "rest_time".equals(fieldName) || "over_rest_time".equals(fieldName) || "night_rest_time".equals(fieldName) || "legal_holiday_rest_time".equals(fieldName) || "prescribed_holiday_rest_time".equals(fieldName) || "public_time".equals(fieldName) || "private_time".equals(fieldName) || "minutely_holiday_a_time".equals(fieldName) || "minutely_holiday_b_time".equals(fieldName) || "overtime".equals(fieldName) || "overtime_before".equals(fieldName) || "overtime_after".equals(fieldName) || "overtime_in".equals(fieldName) || "overtime_out".equals(fieldName) || "workday_overtime_in".equals(fieldName) || "workday_overtime_out".equals(fieldName) || "prescribed_holiday_overtime_in".equals(fieldName) || "prescribed_holiday_overtime_out".equals(fieldName) || "late_night_time".equals(fieldName) || "night_work_within_prescribed_work".equals(fieldName) || "night_overtime_work".equals(fieldName) || "night_work_on_holiday".equals(fieldName) || "specific_work_time".equals(fieldName) || "legal_work_time".equals(fieldName) || "decrease_time".equals(fieldName) || "legal_holiday_work_time_with_compensation_day".equals(fieldName) || "legal_holiday_work_time_without_compensation_day".equals(fieldName) || "prescribed_holiday_work_time_with_compensation_day".equals(fieldName) || "prescribed_holiday_work_time_without_compensation_day".equals(fieldName) || "overtime_in_with_compensation_day".equals(fieldName) || "overtime_in_without_compensation_day".equals(fieldName) || "overtime_out_with_compensation_day".equals(fieldName) || "overtime_out_without_compensation_day".equals(fieldName) || "statutory_holiday_work_time_in".equals(fieldName) || "statutory_holiday_work_time_out".equals(fieldName) || "prescribed_holiday_work_time_in".equals(fieldName) || "prescribed_holiday_work_time_out".equals(fieldName)) {
                            dataList.add(this.getExportTime(rs.getInt(fieldName), format));
                            continue;
                        }
                    }
                    if (isTotalTime) {
                        if ("calculation_date".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                            continue;
                        }
                        if ("work_time".equals(fieldName) || "specific_work_time".equals(fieldName) || "contract_work_time".equals(fieldName) || "short_unpaid".equals(fieldName) || "rest_time".equals(fieldName) || "rest_late_night".equals(fieldName) || "rest_work_on_specific_holiday".equals(fieldName) || "rest_work_on_holiday".equals(fieldName) || "public_time".equals(fieldName) || "private_time".equals(fieldName) || "minutely_holiday_a_time".equals(fieldName) || "minutely_holiday_b_time".equals(fieldName) || "overtime".equals(fieldName) || "overtime_in".equals(fieldName) || "overtime_out".equals(fieldName) || "late_night".equals(fieldName) || "night_work_within_prescribed_work".equals(fieldName) || "night_overtime_work".equals(fieldName) || "night_work_on_holiday".equals(fieldName) || "work_on_specific_holiday".equals(fieldName) || "work_on_holiday".equals(fieldName) || "decrease_time".equals(fieldName) || "forty_five_hour_overtime".equals(fieldName) || "late_time".equals(fieldName) || "late_thirty_minutes_or_more_time".equals(fieldName) || "late_less_than_thirty_minutes_time".equals(fieldName) || "leave_early_time".equals(fieldName) || "leave_early_thirty_minutes_or_more_time".equals(fieldName) || "leave_early_less_than_thirty_minutes_time".equals(fieldName) || "sixty_hour_overtime".equals(fieldName) || "week_day_overtime".equals(fieldName) || "specific_overtime".equals(fieldName) || "statutory_holiday_work_time_in".equals(fieldName) || "statutory_holiday_work_time_out".equals(fieldName) || "prescribed_holiday_work_time_in".equals(fieldName) || "prescribed_holiday_work_time_out".equals(fieldName) || "weekly_over_forty_hour_work_time".equals(fieldName) || "overtime_in_no_weekly_forty".equals(fieldName) || "overtime_out_no_weekly_forty".equals(fieldName) || "week_day_overtime_total".equals(fieldName) || "week_day_overtime_in_no_weekly_forty".equals(fieldName) || "week_day_overtime_out_no_weekly_forty".equals(fieldName) || "week_day_overtime_in".equals(fieldName) || "general_int_item1".equals(fieldName)) {
                            dataList.add(this.getExportTime(rs.getInt(fieldName), format));
                            continue;
                        }
                    }
                    if (isPaidHoliday && ("activate_date".equals(fieldName) || "acquisition_date".equals(fieldName) || "limit_date".equals(fieldName))) {
                        dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                        continue;
                    }
                    if (isPaidHoliday && ("carryover_day".equals(fieldName) || "carryover_hour".equals(fieldName))) {
                        Date acquisitionDate = rs.getDate("acquisition_date");
                        String carryoverTime = this.getCarryoverTime(personalId, (java.util.Date)acquisitionDate, fieldName, true);
                        dataList.add(carryoverTime);
                        continue;
                    }
                    if (isStockHoliday && ("activate_date".equals(fieldName) || "acquisition_date".equals(fieldName) || "limit_date".equals(fieldName))) {
                        dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                        continue;
                    }
                    if (isHolidayData && ("activate_date".equals(fieldName) || "holiday_limit_date".equals(fieldName))) {
                        dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                        continue;
                    }
                    if ("full_name".equals(fieldName)) {
                        dataList.add(MospUtility.getHumansName((String)rs.getString("first_name"), (String)rs.getString("last_name")));
                        continue;
                    }
                    if ("section_name".equals(fieldName)) {
                        dataList.add(this.section.getSectionName(rs.getString("section_code"), (java.util.Date)targetDate));
                        continue;
                    }
                    if ("section_display".equals(fieldName)) {
                        dataList.add(this.section.getSectionDisplay(rs.getString("section_code"), (java.util.Date)targetDate));
                        continue;
                    }
                    if (this.doAdditionalLogic(new Object[]{"Add_ExportTableReferenceBean_Export", personalId, targetDate, dataList, fieldName}) || this.addExtraField(personalId, (java.util.Date)targetDate, dataList, fieldName, rs)) continue;
                    dataList.add(rs.getString(fieldName));
                }
                list.add(dataList.toArray(new String[0]));
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
        this.exportDataDao.closers();
        return list;
    }

    protected List<String[]> getFieldValue(HumanDtoInterface human, List<ExportFieldDtoInterface> exportFieldDtoList, List<AttendanceListDto> actualList) throws MospException {
        ArrayList<String[]> fieldList = new ArrayList<String[]>();
        for (AttendanceListDto attendanceListDto : actualList) {
            String[] fieldValue = new String[exportFieldDtoList.size()];
            java.util.Date workDate = attendanceListDto.getWorkDate();
            for (int i = 0; i < exportFieldDtoList.size(); ++i) {
                String fieldName = exportFieldDtoList.get(i).getFieldName();
                if ("schedule_Day".equals(fieldName)) {
                    fieldValue[i] = DateUtility.getStringDateAndDay((java.util.Date)workDate);
                    continue;
                }
                if ("employee_code".equals(fieldName)) {
                    fieldValue[i] = human.getEmployeeCode();
                    continue;
                }
                if ("full_name".equals(fieldName)) {
                    fieldValue[i] = MospUtility.getHumansName((String)human.getFirstName(), (String)human.getLastName());
                    continue;
                }
                if ("section_code".equals(fieldName)) {
                    fieldValue[i] = human.getSectionCode();
                    continue;
                }
                if ("section_name".equals(fieldName)) {
                    fieldValue[i] = this.section.getSectionName(human.getSectionCode(), workDate);
                    continue;
                }
                if ("section_display".equals(fieldName)) {
                    fieldValue[i] = this.section.getSectionDisplay(human.getSectionCode(), workDate);
                    continue;
                }
                if ("work_type_code".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getWorkTypeCode();
                    continue;
                }
                if ("work_type_abbr".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getWorkTypeAbbr();
                    continue;
                }
                if ("start_time".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getStartTimeString();
                    continue;
                }
                if ("end_time".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getEndTimeString();
                    continue;
                }
                if ("work_time".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getWorkTimeString();
                    continue;
                }
                if ("rest_time".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getRestTimeString();
                    continue;
                }
                if ("private_time".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getPrivateTimeString();
                    continue;
                }
                if ("late_leave_early_time".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getLateLeaveEarlyTimeString();
                    continue;
                }
                if ("overtime_in".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getOvertimeInString();
                    continue;
                }
                if ("overtime_out".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getOvertimeOutString();
                    continue;
                }
                if ("work_on_holiday".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getHolidayWorkTimeString();
                    continue;
                }
                if ("late_night".equals(fieldName)) {
                    fieldValue[i] = attendanceListDto.getLateNightTimeString();
                    continue;
                }
                if (!"time_remarks".equals(fieldName)) continue;
                fieldValue[i] = MospUtility.concat((String[])new String[]{attendanceListDto.getRemark(), attendanceListDto.getTimeComment()});
            }
            fieldList.add(fieldValue);
        }
        return fieldList;
    }

    protected int getExportTimeFormat() {
        return this.mospParams.getApplicationProperty(APP_EXPORT_TIME_FORMAT, 0);
    }

    protected String getExportTime(int minute, int format) {
        if (format == 0) {
            return this.getExportTimeMinute(minute);
        }
        if (format == 1) {
            return this.getExportTimeHour(minute);
        }
        if (format == 2) {
            return TimeUtility.getStringColonTime((MospParams)this.mospParams, (int)minute);
        }
        if (format == 3) {
            return TimeUtility.getStringPeriodTime((MospParams)this.mospParams, (int)minute);
        }
        return "";
    }

    protected String getExportTimeMinute(int minute) {
        return Integer.toString(minute);
    }

    protected String getExportTimeHour(int minute) {
        return "";
    }

    public void setExportCode(String exportCode) {
        this.exportCode = exportCode;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public void setStartMonth(int startMonth) {
        this.startMonth = startMonth;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public void setEndMonth(int endMonth) {
        this.endMonth = endMonth;
    }

    public void setCutoffCode(String cutoffCode) {
        this.cutoffCode = cutoffCode;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public void setCkbNeedLowerSection(int ckbNeedLowerSection) {
        this.ckbNeedLowerSection = ckbNeedLowerSection;
    }

    protected boolean addExtraField(String personalId, java.util.Date targetDate, List<String> dataList, String fieldName, ResultSet rs) throws MospException {
        return false;
    }

    public String getCarryoverTime(String personalId, java.util.Date acquisitionDate, String fieldName, boolean status) throws MospException {
        String carryoverTime = "";
        double carryoverDay = 0.0;
        int grantHour = 0;
        java.util.Date startDay = DateUtility.addYear((java.util.Date)acquisitionDate, (int)-1);
        java.util.Date endDay = DateUtility.addDay((java.util.Date)acquisitionDate, (int)-1);
        List paidHolidayDataList = this.paidHolidayDataReference.findForAcquisitionList(personalId, startDay, endDay);
        for (PaidHolidayDataDtoInterface paidHolidayDataDto : paidHolidayDataList) {
            carryoverDay += paidHolidayDataDto.getHoldDay();
            grantHour += paidHolidayDataDto.getHoldHour();
        }
        List transactionList = this.paidHolidayTransactionReference.findForHistoryList(personalId);
        boolean isBefore = false;
        for (PaidHolidayTransactionDtoInterface transactionDto : transactionList) {
            if (!DateUtility.isTermContain((java.util.Date)transactionDto.getAcquisitionDate(), (java.util.Date)startDay, (java.util.Date)endDay)) continue;
            isBefore = true;
            carryoverDay += transactionDto.getGivingDay() - transactionDto.getCancelDay();
            grantHour += transactionDto.getGivingHour() - transactionDto.getCancelHour();
        }
        if (paidHolidayDataList.isEmpty() && !isBefore) {
            return carryoverTime;
        }
        List holidayRequestList = this.holidayRequestReference.getHolidayRequestListOnWorkflow(personalId, startDay, endDay);
        double requestDate = 0.0;
        int requestHour = 0;
        for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
            if (!DateUtility.isTermContain((java.util.Date)holidayRequestDto.getHolidayAcquisitionDate(), (java.util.Date)startDay, (java.util.Date)endDay) || holidayRequestDto.getHolidayType1() != 1) continue;
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(holidayRequestDto.getWorkflow());
            if (!status ? WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) : !WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) continue;
            if (holidayRequestDto.getHolidayRange() == 1) {
                requestDate += 1.0;
                continue;
            }
            if (holidayRequestDto.getHolidayRange() == 4) {
                ++requestHour;
                continue;
            }
            requestDate += 0.5;
        }
        int requestHourDay = 0;
        if (requestHour != 0 && grantHour < requestHour && (requestHour -= (requestHourDay = requestHour / 8) * 8) != 0) {
            ++requestHourDay;
        }
        if (carryoverDay != 0.0 && requestHourDay != 0) {
            requestDate += (double)requestHourDay;
        }
        carryoverDay -= requestDate;
        if ("carryover_day".equals(fieldName)) {
            carryoverTime = String.valueOf(carryoverDay);
        } else {
            int caryyoverHour = grantHour;
            if (requestHour != 0) {
                if (grantHour > requestHour) {
                    caryyoverHour = grantHour - requestHour;
                } else if (requestHour <= 8) {
                    caryyoverHour = 8 - requestHour;
                }
            }
            carryoverTime = String.valueOf(caryyoverHour);
        }
        return carryoverTime;
    }
}

