/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.DifferenceRequestRegistAddonBeanInterface;
import jp.mosp.time.bean.DifferenceRequestRegistBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeApprovalBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.DifferenceRequestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdDifferenceRequestDto;

public class DifferenceRequestRegistBean
extends TimeBean
implements DifferenceRequestRegistBeanInterface {
    private DifferenceRequestDaoInterface dao;
    private DifferenceRequestReferenceBeanInterface differenceReference;
    private WorkflowDaoInterface workflowDao;
    private WorkflowReferenceBeanInterface workflowReference;
    private WorkflowIntegrateBeanInterface workflowIntegrate;
    private WorkflowRegistBeanInterface workflowRegist;
    private WorkflowCommentRegistBeanInterface workflowCommentRegist;
    private AttendanceDaoInterface attendanceDao;
    private TimeApprovalBeanInterface timeApproval;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;
    private CutoffUtilBeanInterface cutoffUtil;
    private ScheduleUtilBeanInterface scheduleUtil;
    private RequestUtilBeanInterface requestUtil;
    protected List<DifferenceRequestRegistAddonBeanInterface> addonBeans;
    protected static final String CODE_KEY_ADDONS = "DifferenceRequestRegistAddons";

    public DifferenceRequestRegistBean() {
    }

    public DifferenceRequestRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (DifferenceRequestDaoInterface)this.createDao(DifferenceRequestDaoInterface.class);
        this.differenceReference = (DifferenceRequestReferenceBeanInterface)this.createBean(DifferenceRequestReferenceBeanInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDao(WorkflowDaoInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBean(WorkflowCommentRegistBeanInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDao(AttendanceDaoInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        this.addonBeans = this.getAddonBeans();
    }

    public DifferenceRequestDtoInterface getInitDto() {
        TmdDifferenceRequestDto dto = new TmdDifferenceRequestDto();
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            dto = addonBean.getInitDto((DifferenceRequestDtoInterface)dto);
        }
        return dto;
    }

    public void insert(DifferenceRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdDifferenceRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.insert(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void update(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            DifferenceRequestDtoInterface dto = (DifferenceRequestDtoInterface)baseDto;
            this.checkAppli(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(dto.getWorkflow());
            this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
            if (workflowDto == null) continue;
            this.draftAttendance(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.update(idArray);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void regist(DifferenceRequestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getTmdDifferenceRequestId(), false) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.regist(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void add(DifferenceRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdDifferenceRequestId());
        dto.setTmdDifferenceRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.add(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void delete(DifferenceRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdDifferenceRequestId());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.delete(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void withdrawn(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            DifferenceRequestDtoInterface dto = (DifferenceRequestDtoInterface)baseDto;
            this.checkWithdrawn(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ((workflowDto = this.workflowRegist.withdrawn(workflowDto)) == null) continue;
            this.workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.withdrawn(idArray);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkInsert(DifferenceRequestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate()));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkInsert(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkAdd(DifferenceRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdDifferenceRequestId());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkAdd(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void validate(DifferenceRequestDtoInterface dto) throws MospException {
        this.differenceReference.chkBasicInfo(dto.getPersonalId(), dto.getRequestDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.validate(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkDraft(DifferenceRequestDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        this.checkRequest(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkDraft(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkAppli(DifferenceRequestDtoInterface dto) throws MospException {
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        this.checkDraft(dto);
        this.checkPeriod(dto);
        this.checkDifferenceOverlap(dto);
        this.checkAttendance(dto);
        this.checkRequired(dto);
        for (HolidayRequestDtoInterface holidayRequestDto : this.requestUtil.getHolidayList(false)) {
            if (holidayRequestDto.getHolidayRange() == 4) continue;
            this.addDifferenceTargetDateRequestErrorMessage(dto.getRequestDate());
            return;
        }
        if (this.requestUtil.checkHolidayRangeSubHoliday(this.requestUtil.getSubHolidayList(false)) != 0) {
            this.addDifferenceTargetDateRequestErrorMessage(dto.getRequestDate());
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkAppli(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkCancelAppli(DifferenceRequestDtoInterface dto) throws MospException {
        this.checkCancel(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkCancelAppli(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkWithdrawn(DifferenceRequestDtoInterface dto) throws MospException {
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkWithdrawn(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkApproval(DifferenceRequestDtoInterface dto) throws MospException {
        this.checkDraft(dto);
        this.checkPeriod(dto);
        this.checkDifferenceOverlap(dto);
        this.checkAttendance(dto);
        this.checkRequired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkApproval(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkCancelApproval(DifferenceRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkCancelApproval(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkCancel(DifferenceRequestDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        if (this.approvalInfoReference.isExistAttendanceTargetDate(dto.getPersonalId(), dto.getRequestDate())) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("WorkManage"));
        }
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        List holidayList = this.requestUtil.getHolidayList(false);
        for (HolidayRequestDtoInterface holidayDto : holidayList) {
            if (holidayDto.getHolidayRange() != 4) continue;
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Vacation"));
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkCancel(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkRequest(DifferenceRequestDtoInterface dto) throws MospException {
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getRequestDate(), this.requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
            this.addDifferenceTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
            return;
        }
        if ("work_on_prescribed".equals(workTypeCode) || "work_on_legal".equals(workTypeCode)) {
            this.addDifferenceTargetDateRequestErrorMessage(dto.getRequestDate());
            return;
        }
        if (this.requestUtil.isHolidayAllDay(false)) {
            this.addDifferenceTargetDateRequestErrorMessage(dto.getRequestDate());
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkRequest(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkDifferenceOverlap(DifferenceRequestDtoInterface dto) throws MospException {
        DifferenceRequestDtoInterface requestDto = this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate());
        if (requestDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow());
        if (workflowDto == null) {
            return;
        }
        if ("5".equals(workflowDto.getWorkflowStatus())) {
            return;
        }
        if (dto.getWorkflow() == workflowDto.getWorkflow()) {
            return;
        }
        this.addDifferenceTargetDateDifferenceRequestErrorMessage(dto.getRequestDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkDifferenceOverlap(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkPeriod(DifferenceRequestDtoInterface dto) throws MospException {
        if (dto.getRequestDate().after(DateUtility.addMonth((Date)this.getSystemDate(), (int)1))) {
            this.addDifferencePeriodErrorMessage();
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkPeriod(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkAttendance(DifferenceRequestDtoInterface dto) throws MospException {
        AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(dto.getPersonalId(), dto.getRequestDate(), 1);
        if (attendanceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(attendanceDto.getWorkflow());
        if (workflowDto == null) {
            return;
        }
        if ("5".equals(workflowDto.getWorkflowStatus())) {
            return;
        }
        if ("0".equals(workflowDto.getWorkflowStatus())) {
            return;
        }
        if (workflowDto.getWorkflowStage() == 0 && "3".equals(workflowDto.getWorkflowStatus())) {
            return;
        }
        this.addDifferenceTargetWorkDateAttendanceRequestErrorMessage(dto.getRequestDate());
    }

    public void checkRequired(DifferenceRequestDtoInterface dto) throws MospException {
        if (dto.getRequestReason().isEmpty()) {
            this.addDifferenceRequestReasonErrorMessage();
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkRequired(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkTemporaryClosingFinal(DifferenceRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestDate(), this.getTimeDifferenceDay());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkTemporaryClosingFinal(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void draftAttendance(DifferenceRequestDtoInterface dto) throws MospException {
        if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) {
            return;
        }
        this.timeApproval = (TimeApprovalBeanInterface)this.createBean(TimeApprovalBeanInterface.class);
        this.timeApproval.reDraft(dto.getPersonalId(), dto.getRequestDate(), false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (DifferenceRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.draftAttendance(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected String getTimeDifferenceDay() {
        return this.mospParams.getName("TimeDifference") + this.mospParams.getName("GoingWork") + this.mospParams.getName("Day");
    }

    protected List<DifferenceRequestRegistAddonBeanInterface> getAddonBeans() throws MospException {
        ArrayList<DifferenceRequestRegistAddonBeanInterface> addonBeans = new ArrayList<DifferenceRequestRegistAddonBeanInterface>();
        for (String[] addon : this.mospParams.getProperties().getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            DifferenceRequestRegistAddonBeanInterface bean = (DifferenceRequestRegistAddonBeanInterface)this.createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }
}

