/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeUtility;

public class CutoffUtilBean
extends TimeApplicationBean
implements CutoffUtilBeanInterface {
    HumanSearchBeanInterface humanSearch;
    TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployeeRefer;
    protected TimeMasterBeanInterface timeMaster;

    public CutoffUtilBean() {
    }

    protected CutoffUtilBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.totalTimeEmployeeRefer = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBean(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBean(TimeMasterBeanInterface.class);
    }

    public Set<String> getCutoffPersonalIdSet(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        HashSet<String> idSet = new HashSet<String>();
        CutoffDtoInterface cutoffDto = this.getCutoff(cutoffCode, targetYear, targetMonth);
        if (this.mospParams.hasErrorMessage()) {
            return idSet;
        }
        int cutoffDate = cutoffDto.getCutoffDate();
        Date cutoffTermTargetDate = TimeUtility.getCutoffTermTargetDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
        Date firstDate = TimeUtility.getCutoffFirstDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
        Date lastDate = TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
        Map activateMap = this.getActivatePersonalIdMap(cutoffTermTargetDate, firstDate, lastDate);
        for (HumanDtoInterface humanDto : activateMap.values()) {
            ApplicationEntity entity = this.timeMaster.getApplicationEntity(humanDto, cutoffTermTargetDate);
            if (!entity.getCutoffCode().equals(cutoffCode)) continue;
            idSet.add(humanDto.getPersonalId());
        }
        if (idSet.isEmpty()) {
            this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Employee")});
        }
        return idSet;
    }

    public List<HumanDtoInterface> getCutoffHumanDto(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        ArrayList<HumanDtoInterface> humanList = new ArrayList<HumanDtoInterface>();
        CutoffDtoInterface cutoffDto = this.getCutoff(cutoffCode, targetYear, targetMonth);
        if (this.mospParams.hasErrorMessage()) {
            return humanList;
        }
        int cutoffDate = cutoffDto.getCutoffDate();
        Date cutoffTermTargetDate = TimeUtility.getCutoffTermTargetDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
        Date firstDate = TimeUtility.getCutoffFirstDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
        Date lastDate = TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
        Map activateMap = this.getActivatePersonalIdMap(cutoffTermTargetDate, firstDate, lastDate);
        for (HumanDtoInterface humanDto : activateMap.values()) {
            ApplicationEntity entity = this.timeMaster.getApplicationEntity(humanDto, cutoffTermTargetDate);
            if (!entity.getCutoffCode().equals(cutoffCode)) continue;
            humanList.add(humanDto);
        }
        if (humanList.isEmpty()) {
            this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Employee")});
        }
        return humanList;
    }

    public CutoffDtoInterface getCutoff(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        Date yearMonthTargetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        CutoffDtoInterface cutoffDto = this.timeMaster.getCutoff(cutoffCode, yearMonthTargetDate);
        this.cutoffRefer.chkExistCutoff(cutoffDto, yearMonthTargetDate);
        return cutoffDto;
    }

    public CutoffDtoInterface getCutoff(String cutoffCode, Date targetDate) throws MospException {
        CutoffDtoInterface cutoffDto = this.timeMaster.getCutoff(cutoffCode, targetDate);
        this.cutoffRefer.chkExistCutoff(cutoffDto, targetDate);
        return cutoffDto;
    }

    public CutoffDtoInterface getCutoffForPersonalId(String personalId, int targetYear, int targetMonth) throws MospException {
        this.setCutoffSettings(personalId, MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        return this.cutoffDto;
    }

    public CutoffDtoInterface getCutoffForPersonalId(String personalId, Date targetDate) throws MospException {
        this.setCutoffSettings(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        return this.cutoffDto;
    }

    public CutoffDtoInterface getCutoffForApplication(ApplicationDtoInterface dto, Date targetDate) throws MospException {
        this.getTimeSetting(dto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.cutoffDto = this.cutoffRefer.getCutoffInfo(this.timeSettingDto.getCutoffCode(), targetDate);
        this.cutoffRefer.chkExistCutoff(this.cutoffDto, targetDate);
        return this.cutoffDto;
    }

    public Date getCutoffCalculationDate(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        CutoffDtoInterface cutoffDto = this.getCutoff(cutoffCode, targetYear, targetMonth);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        int cutoffDate = cutoffDto.getCutoffDate();
        return TimeUtility.getCutoffCalculationDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
    }

    public Date getCutoffTermTargetDate(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        CutoffDtoInterface cutoffDto = this.getCutoff(cutoffCode, targetYear, targetMonth);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        int cutoffDate = cutoffDto.getCutoffDate();
        return TimeUtility.getCutoffTermTargetDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
    }

    public boolean checkTighten(String personalId, Date targetDate, String targetName) throws MospException {
        int month;
        Date cutoffDate = this.getCutoffMonth(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return false;
        }
        int year = DateUtility.getYear((Date)cutoffDate);
        boolean isNotTighten = this.isNotTighten(personalId, year, month = DateUtility.getMonth((Date)cutoffDate));
        if (!isNotTighten) {
            this.addMonthlyTreatmentErrorMessage(year, month, targetName);
        }
        return isNotTighten;
    }

    public boolean checkTighten(String personalId, int targetYear, int targetMonth) throws MospException {
        boolean isNotTighten = this.isNotTighten(personalId, targetYear, targetMonth);
        if (!isNotTighten) {
            TimeMessageUtility.addErrorTheMonthIsTighten((MospParams)this.mospParams, (int)targetYear, (int)targetMonth);
        }
        return isNotTighten;
    }

    public boolean isNotTighten(String personalId, Date targetDate) throws MospException {
        if (!this.hasCutoffSettings(personalId, targetDate)) {
            return false;
        }
        Date cutoffMonth = TimeUtility.getCutoffMonth((int)this.cutoffDto.getCutoffDate(), (Date)targetDate);
        return this.isNotTighten(personalId, DateUtility.getYear((Date)cutoffMonth), DateUtility.getMonth((Date)cutoffMonth));
    }

    public boolean isNotTighten(String personalId, int targetYear, int targetMonth) throws MospException {
        Integer state = this.totalTimeEmployeeRefer.getCutoffState(personalId, targetYear, targetMonth);
        return state == null || state == 0;
    }

    public Date getCutoffFirstDate(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        CutoffDtoInterface cutoffDto = this.getCutoff(cutoffCode, targetYear, targetMonth);
        return TimeUtility.getCutoffFirstDate((int)cutoffDto.getCutoffDate(), (int)targetYear, (int)targetMonth);
    }

    public Date getCutoffLastDate(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        CutoffDtoInterface cutoffDto = this.getCutoff(cutoffCode, targetYear, targetMonth);
        return TimeUtility.getCutoffLastDate((int)cutoffDto.getCutoffDate(), (int)targetYear, (int)targetMonth);
    }

    public Date getCutoffMonth(String personalId, Date targetDate) throws MospException {
        CutoffDtoInterface cutoffDto = this.getCutoffForPersonalId(personalId, targetDate);
        if (cutoffDto == null) {
            return MonthUtility.getTargetYearMonth((Date)targetDate, (MospParams)this.mospParams);
        }
        return TimeUtility.getCutoffMonth((int)cutoffDto.getCutoffDate(), (Date)targetDate);
    }

    protected Map<String, HumanDtoInterface> getActivatePersonalIdMap(Date targetDate, Date staDate, Date endDate) throws MospException {
        this.humanSearch.setTargetDate(targetDate);
        this.humanSearch.setStartDate(staDate);
        this.humanSearch.setEndDate(endDate);
        this.humanSearch.setStateType("presence");
        return this.humanSearch.getHumanDtoMap();
    }

    public TimeSettingDtoInterface getTimeSetting(String personalId, Date targetDate) throws MospException {
        this.setTimeSettings(personalId, targetDate);
        return this.timeSettingDto;
    }

    public TimeSettingDtoInterface getTimeSetting(ApplicationDtoInterface dto, Date targetDate) throws MospException {
        this.applicationDto = dto;
        this.applicationRefer.chkExistApplication(this.applicationDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.timeSettingDto = this.timeSettingRefer.getTimeSettingInfo(this.applicationDto.getWorkSettingCode(), targetDate);
        this.timeSettingRefer.chkExistTimeSetting(this.timeSettingDto, targetDate);
        return this.timeSettingDto;
    }

    public TimeSettingDtoInterface getTimeSettingNoMessage(String personalId, Date targetDate) throws MospException {
        if (!this.hasApplicationSettings(personalId, targetDate)) {
            return null;
        }
        if (!this.hasTimeSettings(personalId, targetDate)) {
            return null;
        }
        return this.timeSettingDto;
    }

    public int getNoApproval(String cutoffCode, Date targetDate) throws MospException {
        CutoffDtoInterface cutoffDto = this.getCutoff(cutoffCode, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        return cutoffDto.getNoApproval();
    }

    public int getNoApproval(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        CutoffDtoInterface cutoffDto = this.getCutoff(cutoffCode, targetYear, targetMonth);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        return cutoffDto.getNoApproval();
    }
}

