/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.dao.settings.CutoffDaoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;

public class CutoffReferenceBean
extends PlatformBean
implements CutoffReferenceBeanInterface {
    private CutoffDaoInterface dao;

    public CutoffReferenceBean() {
    }

    public CutoffReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (CutoffDaoInterface)this.createDao(CutoffDaoInterface.class);
    }

    public CutoffDtoInterface getCutoffInfo(String cutoffCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(cutoffCode, targetDate);
    }

    public List<CutoffDtoInterface> getCutoffHistory(String cutoffCode) throws MospException {
        return this.dao.findForHistory(cutoffCode);
    }

    public String[][] getSelectArray(Date targetDate) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = new String[list.size()][2];
        int i = 0;
        for (CutoffDtoInterface dto : list) {
            array[i][0] = dto.getCutoffCode();
            array[i++][1] = dto.getCutoffAbbr();
        }
        return array;
    }

    public String[][] getSelectCodeArray(Date targetDate) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = new String[list.size()][2];
        int i = 0;
        for (CutoffDtoInterface dto : list) {
            array[i][0] = dto.getCutoffCode();
            array[i++][1] = dto.getCutoffCode() + " " + dto.getCutoffName();
        }
        return array;
    }

    public String[][] getCodedAbbrSelectArray(Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(targetDate, needBlank, false, true);
    }

    public CutoffDtoInterface findForKey(String cutoffCode, Date activateDate) throws MospException {
        return this.dao.findForKey(cutoffCode, activateDate);
    }

    public CutoffDtoInterface findForKey(long id) throws MospException {
        BaseDto dto = this.findForKey((BaseDaoInterface)this.dao, id, false);
        if (dto != null) {
            return (CutoffDtoInterface)dto;
        }
        return null;
    }

    public void chkExistCutoff(CutoffDtoInterface dto, Date targetDate) {
        if (dto == null) {
            String errorMes1 = "";
            errorMes1 = targetDate == null ? DateUtility.getStringDate((Date)DateUtility.getSystemDate()) : DateUtility.getStringDate((Date)targetDate);
            String[] aryRep = new String[]{errorMes1, this.mospParams.getName("CutoffDate", new String[]{"Information"}), this.mospParams.getName("CutoffDate", new String[]{"Information"})};
            this.mospParams.addErrorMessage("TMW0253", aryRep);
        }
    }

    protected String[][] getSelectArray(Date targetDate, boolean needBlank, boolean isName, boolean viewCode) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (CutoffDtoInterface dto : list) {
            array[idx][0] = dto.getCutoffCode();
            if (isName && viewCode) {
                array[idx++][1] = this.getCodedName(dto.getCutoffCode(), dto.getCutoffName(), length);
                continue;
            }
            if (isName) {
                array[idx++][1] = dto.getCutoffName();
                continue;
            }
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getCutoffCode(), dto.getCutoffAbbr(), length);
                continue;
            }
            array[idx++][1] = dto.getCutoffAbbr();
        }
        return array;
    }

    protected int getMaxCodeLength(List<CutoffDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (CutoffDtoInterface dto : list) {
            if (dto.getCutoffCode().length() <= length) continue;
            length = dto.getCutoffCode().length();
        }
        return length;
    }

    public String[][] getSelectArray(Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(targetDate, needBlank, false, false);
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, true, true);
    }
}

