/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.AttendanceBean;
import jp.mosp.time.bean.AttendanceCalcBeanInterface;
import jp.mosp.time.bean.AttendanceCorrectionReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceCorrectionRegistBeanInterface;
import jp.mosp.time.bean.AttendanceListRegistBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.GoOutReferenceBeanInterface;
import jp.mosp.time.bean.GoOutRegistBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.RestReferenceBeanInterface;
import jp.mosp.time.bean.RestRegistBeanInterface;
import jp.mosp.time.bean.SubHolidayRegistBeanInterface;
import jp.mosp.time.bean.impl.AttendanceReferenceBean;
import jp.mosp.time.dao.settings.RestDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.utils.TimeUtility;

public class AttendanceListRegistBean
extends AttendanceBean
implements AttendanceListRegistBeanInterface {
    protected AttendanceRegistBeanInterface attendanceRegist;
    protected AttendanceCorrectionReferenceBeanInterface attendanceCorrectionReference;
    protected AttendanceCorrectionRegistBeanInterface attendanceCorrectionRegist;
    protected RestRegistBeanInterface restRegist;
    protected RestDaoInterface restDao;
    protected GoOutRegistBeanInterface goOutRegist;
    protected SubHolidayRegistBeanInterface subHolidayRegist;
    protected DifferenceRequestDtoInterface differenceDto;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected String personalId;
    protected Date targetDate;
    protected ApplicationDtoInterface applicationDto;
    protected ScheduleDateDtoInterface scheduleDateDto;
    protected WorkTypeDtoInterface workTypeDto;
    protected TimeSettingDtoInterface timeSettingDto;
    protected RestReferenceBeanInterface restReference;
    protected GoOutReferenceBeanInterface goOutReference;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected AttendanceTransactionRegistBeanInterface attendanceTransactionRegist;

    public void initBean() throws MospException {
        super.initBean();
        this.attendanceRegist = (AttendanceRegistBeanInterface)this.createBean(AttendanceRegistBeanInterface.class);
        this.attendanceCorrectionReference = (AttendanceCorrectionReferenceBeanInterface)this.createBean(AttendanceCorrectionReferenceBeanInterface.class);
        this.attendanceCorrectionRegist = (AttendanceCorrectionRegistBeanInterface)this.createBean(AttendanceCorrectionRegistBeanInterface.class);
        this.restRegist = (RestRegistBeanInterface)this.createBean(RestRegistBeanInterface.class);
        this.restDao = (RestDaoInterface)this.createDao(RestDaoInterface.class);
        this.goOutRegist = (GoOutRegistBeanInterface)this.createBean(GoOutRegistBeanInterface.class);
        this.subHolidayRegist = (SubHolidayRegistBeanInterface)this.createBean(SubHolidayRegistBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        this.restReference = (RestReferenceBeanInterface)this.createBean(RestReferenceBeanInterface.class);
        this.goOutReference = (GoOutReferenceBeanInterface)this.createBean(GoOutReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.attendanceTransactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBean(AttendanceTransactionRegistBeanInterface.class);
    }

    public void draft(String personalId, String[] targetDates, String[] startTimes, String[] endTimes, boolean deleteRest, boolean useWorkTypeChangeRequest, boolean useSchedule) throws MospException {
        this.personalId = personalId;
        List targetDateList = this.getDateList(targetDates);
        List startTimeList = this.getAttendanceTimeList(targetDateList, startTimes);
        List endTimeList = this.getAttendanceTimeList(targetDateList, endTimes);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ArrayList errorMessageList = new ArrayList();
        for (int i = 0; i < targetDateList.size(); ++i) {
            this.targetDate = (Date)targetDateList.get(i);
            AttendanceDtoInterface dto = this.getAttendanceDto((Date)startTimeList.get(i), (Date)startTimeList.get(i), (Date)endTimeList.get(i), deleteRest, false, true, useWorkTypeChangeRequest, useSchedule);
            if (this.mospParams.hasErrorMessage()) {
                errorMessageList.addAll(this.mospParams.getErrorMessageList());
                this.mospParams.getErrorMessageList().clear();
                continue;
            }
            this.attendanceRegist.checkValidate(dto);
            this.checkMinutelyHoliday(dto);
            if (this.mospParams.hasErrorMessage()) {
                errorMessageList.addAll(this.mospParams.getErrorMessageList());
                this.mospParams.getErrorMessageList().clear();
                continue;
            }
            this.attendanceRegist.checkDraft(dto);
            if (this.mospParams.hasErrorMessage()) {
                errorMessageList.addAll(this.mospParams.getErrorMessageList());
                this.mospParams.getErrorMessageList().clear();
                continue;
            }
            this.attendanceRegist.regist(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            errorMessageList.addAll(this.mospParams.getErrorMessageList());
            this.mospParams.getErrorMessageList().clear();
        }
        if (!errorMessageList.isEmpty()) {
            this.mospParams.getErrorMessageList().addAll(errorMessageList);
        }
    }

    public void apply(String personalId, String[] targetDates, String[] startTimes, String[] endTimes) throws MospException {
        this.personalId = personalId;
        List targetDateList = this.getDateList(targetDates);
        List startTimeList = this.getAttendanceTimeList(targetDateList, startTimes);
        List endTimeList = this.getAttendanceTimeList(targetDateList, endTimes);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        AttendanceDtoInterface dto = null;
        ArrayList errorMessageList = new ArrayList();
        for (int i = 0; i < targetDateList.size(); ++i) {
            this.targetDate = (Date)targetDateList.get(i);
            Date startTime = (Date)startTimeList.get(i);
            Date endTime = (Date)endTimeList.get(i);
            dto = this.getAttendanceDto(startTime, startTime, endTime, false, true, true, false, false);
            if (this.mospParams.hasErrorMessage()) {
                errorMessageList.addAll(this.mospParams.getErrorMessageList());
                this.mospParams.getErrorMessageList().clear();
                continue;
            }
            this.checkMinutelyHoliday(dto);
            if (this.mospParams.hasErrorMessage()) {
                errorMessageList.addAll(this.mospParams.getErrorMessageList());
                this.mospParams.getErrorMessageList().clear();
                continue;
            }
            this.attendanceRegist.checkValidate(dto);
            if (this.mospParams.hasErrorMessage()) {
                errorMessageList.addAll(this.mospParams.getErrorMessageList());
                this.mospParams.getErrorMessageList().clear();
                continue;
            }
            this.attendanceRegist.checkAppli(dto);
            if (this.mospParams.hasErrorMessage()) {
                errorMessageList.addAll(this.mospParams.getErrorMessageList());
                this.mospParams.getErrorMessageList().clear();
                continue;
            }
            this.attendanceRegist.checkTimeExist(dto);
            if (this.mospParams.hasErrorMessage()) {
                errorMessageList.addAll(this.mospParams.getErrorMessageList());
                this.mospParams.getErrorMessageList().clear();
                continue;
            }
            this.attendanceRegist.regist(dto);
            this.registSubHoliday(dto);
            this.attendanceTransactionRegist.regist(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            errorMessageList.addAll(this.mospParams.getErrorMessageList());
            this.mospParams.getErrorMessageList().clear();
        }
        if (!errorMessageList.isEmpty()) {
            this.mospParams.getErrorMessageList().addAll(errorMessageList);
        }
        this.afterApplyAttendance(dto);
    }

    protected AttendanceDtoInterface getAttendanceDto(Date startTime, Date actualStartTime, Date endTime, boolean deleteRest, boolean isAppli, boolean registWorkflow, boolean useWorkTypeChangeRequest, boolean useSchedule) throws MospException {
        WorkflowDtoInterface workflowDto;
        AttendanceDtoInterface dto;
        AttendanceCalcBeanInterface attendanceCalc = (AttendanceCalcBeanInterface)this.createBean(AttendanceCalcBeanInterface.class, this.targetDate);
        this.setTimeDtos(useWorkTypeChangeRequest, useSchedule);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        AttendanceDtoInterface oldDto = this.attendanceReference.findForKey(this.personalId, this.targetDate, 1);
        if (oldDto == null) {
            oldDto = this.attendanceRegist.getInitDto();
        }
        if ((dto = this.attendanceReference.findForKey(this.personalId, this.targetDate, 1)) == null) {
            dto = this.attendanceRegist.getInitDto();
            dto.setPersonalId(this.personalId);
            dto.setWorkDate(this.targetDate);
            dto.setTimesWork(1);
            int checkboxOff = Integer.parseInt("0");
            dto.setDirectStart(checkboxOff);
            dto.setDirectEnd(checkboxOff);
            dto.setForgotRecordWorkStart(checkboxOff);
            dto.setNotRecordWorkStart(checkboxOff);
            dto.setTimeComment("");
            dto.setRemarks("");
            dto.setLateReason("");
            dto.setLateCertificate("");
            dto.setLateComment("");
            dto.setLeaveEarlyReason("");
            dto.setLeaveEarlyCertificate("");
            dto.setLeaveEarlyComment("");
        }
        dto.setWorkTypeCode(this.workTypeDto.getWorkTypeCode());
        if (this.differenceDto != null) {
            dto.setWorkTypeCode(this.differenceDto.getDifferenceType());
        }
        dto.setStartTime(startTime);
        dto.setActualStartTime(actualStartTime);
        dto.setEndTime(endTime);
        dto.setActualEndTime(endTime);
        attendanceCalc.calcStartEndTime(dto, true);
        boolean isWorkflowDraft = false;
        if (dto.getWorkflow() != 0L && ((workflowDto = this.workflow.getLatestWorkflowInfo(dto.getWorkflow())) == null || this.workflow.isDraft(workflowDto))) {
            isWorkflowDraft = true;
        }
        if (registWorkflow) {
            if (isAppli) {
                this.apply(dto);
            } else {
                this.draft(dto);
            }
        }
        List oldRestList = this.restReference.getRestList(this.personalId, this.targetDate, dto.getTimesWork());
        List oldPublicGoOutList = this.goOutReference.getPublicGoOutList(this.personalId, this.targetDate);
        List oldPrivateGoOutList = this.goOutReference.getPrivateGoOutList(this.personalId, this.targetDate);
        List oldMinutely1HolidayGoOutList = this.goOutReference.getMinutelyHolidayAList(this.personalId, this.targetDate);
        List oldMinutely2HolidayGoOutList = this.goOutReference.getMinutelyHolidayBList(this.personalId, this.targetDate);
        if (deleteRest) {
            this.restRegist.delete(this.personalId, this.targetDate, 1);
        } else {
            this.registRest(dto.getStartTime(), dto.getEndTime(), oldRestList);
        }
        this.registPublicGoOut(dto.getStartTime(), dto.getEndTime());
        this.registPrivateGoOut(dto.getStartTime(), dto.getEndTime());
        this.registMinutelyHolidayAGoOut(dto.getStartTime(), dto.getEndTime());
        this.registMinutelyHolidayBGoOut(dto.getStartTime(), dto.getEndTime());
        attendanceCalc.attendanceCalc(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        if (isAppli) {
            List restList = this.restReference.getRestList(this.personalId, this.targetDate, dto.getTimesWork());
            List publicList = this.goOutReference.getPublicGoOutList(this.personalId, this.targetDate);
            List privateList = this.goOutReference.getPrivateGoOutList(this.personalId, this.targetDate);
            List minutely1HolidayList = this.goOutReference.getMinutelyHolidayAList(this.personalId, this.targetDate);
            List minutely2HolidayList = this.goOutReference.getMinutelyHolidayBList(this.personalId, this.targetDate);
            this.attendanceRegist.checkHolidayTime(this.personalId, dto.getWorkDate(), restList, publicList, privateList, minutely1HolidayList, minutely2HolidayList);
            this.attendanceRegist.checkPrivateGoOut(dto, restList, privateList);
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            if (isWorkflowDraft) {
                this.registCorrection(dto, this.attendanceRegist.getInitDto(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
            } else {
                this.registCorrection(dto, oldDto, oldRestList, oldPublicGoOutList, oldPrivateGoOutList, oldMinutely1HolidayGoOutList, oldMinutely2HolidayGoOutList);
            }
        }
        return dto;
    }

    protected void setTimeDtos(boolean useWorkTypeChangeRequest, boolean useSchedule) throws MospException {
        AttendanceDtoInterface attendanceDto;
        WorkflowDtoInterface workflowDto;
        String workTypeCode;
        String changeWorkTypeCode = "";
        String scheduleWorkTypeCode = "";
        this.applicationDto = this.applicationReference.findForPerson(this.personalId, this.targetDate);
        this.applicationReference.chkExistApplication(this.applicationDto, this.targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String scheduleCode = this.applicationDto.getScheduleCode();
        this.scheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleCode, this.targetDate);
        this.scheduleDateReference.chkExistScheduleDate(this.scheduleDateDto, this.targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        scheduleWorkTypeCode = workTypeCode = this.scheduleDateDto.getWorkTypeCode();
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHoliday.findForKeyOnWorkflow(this.personalId, this.targetDate);
        if (workOnHolidayRequestDto != null && (workflowDto = this.workflow.getLatestWorkflowInfo(workOnHolidayRequestDto.getWorkflow())) != null && (this.workflow.isApprovable(workflowDto) || this.workflow.isCompleted(workflowDto) || this.workflow.isCancelApprovable(workflowDto) || this.workflow.isCancelWithDrawnApprovable(workflowDto))) {
            scheduleWorkTypeCode = workTypeCode = this.getWorkOnHolidayWorkType(workOnHolidayRequestDto);
        }
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(this.personalId, this.targetDate);
        WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = requestUtil.getWorkTypeChangeDto(true);
        if (workTypeChangeRequestDto != null) {
            changeWorkTypeCode = workTypeCode = workTypeChangeRequestDto.getWorkTypeCode();
        }
        if (!((attendanceDto = this.attendanceReference.findForKey(this.personalId, this.targetDate, 1)) == null || attendanceDto.getWorkTypeCode().isEmpty() || "a".equals(attendanceDto.getWorkTypeCode()) || "b".equals(attendanceDto.getWorkTypeCode()) || "c".equals(attendanceDto.getWorkTypeCode()) || "d".equals(attendanceDto.getWorkTypeCode()) || "s".equals(attendanceDto.getWorkTypeCode()))) {
            workTypeCode = attendanceDto.getWorkTypeCode();
        }
        if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
            this.addNotWorkDateErrorMessage(this.targetDate);
            return;
        }
        this.workTypeDto = this.workTypeReference.getWorkTypeInfo(workTypeCode, this.targetDate);
        if (useSchedule) {
            this.workTypeDto = this.workTypeReference.getWorkTypeInfo(scheduleWorkTypeCode, this.targetDate);
        } else if (useWorkTypeChangeRequest) {
            this.workTypeDto = this.workTypeReference.getWorkTypeInfo(changeWorkTypeCode, this.targetDate);
        }
        if (this.workTypeDto == null) {
            this.addWorkTypeNotExistErrorMessage(this.targetDate);
            return;
        }
        this.timeSettingDto = this.timeSettingReference.getTimeSettingInfo(this.applicationDto.getWorkSettingCode(), this.targetDate);
        this.timeSettingReference.chkExistTimeSetting(this.timeSettingDto, this.targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.differenceDto = null;
        DifferenceRequestDtoInterface differenceRequestDto = requestUtil.getDifferenceDto(true);
        if (differenceRequestDto == null) {
            return;
        }
        this.differenceDto = differenceRequestDto;
    }

    public List<RestDtoInterface> getRestList(AttendanceDtoInterface dto) throws MospException {
        this.personalId = dto.getPersonalId();
        this.targetDate = dto.getWorkDate();
        this.setTimeDtos(false, false);
        if (this.differenceDto == null) {
            this.workTypeDto = this.workTypeReference.getWorkTypeInfo(dto.getWorkTypeCode(), this.targetDate);
        }
        return this.registRest(dto.getStartTime(), dto.getEndTime());
    }

    protected void registRest(Date startTime, Date endTime, List<RestDtoInterface> list) throws MospException {
        Date initTime = DateUtility.getDateTime((int)DateUtility.getYear((Date)this.targetDate), (int)DateUtility.getMonth((Date)this.targetDate), (int)DateUtility.getDay((Date)this.targetDate), (int)0, (int)0);
        List newList = this.restReference.getRestList(this.personalId, this.targetDate, 1);
        for (RestDtoInterface dto : newList) {
            if (initTime.equals(dto.getRestStart()) && initTime.equals(dto.getRestEnd())) continue;
            if (startTime == null || endTime == null || dto.getRestStart().after(endTime) || dto.getRestEnd().before(startTime)) {
                dto.setRestStart(initTime);
                dto.setRestEnd(initTime);
                dto.setRestTime(0);
                this.restRegist.regist(dto);
                continue;
            }
            if (startTime.after(dto.getRestStart())) {
                dto.setRestStart(startTime);
                dto.setRestEnd(dto.getRestEnd());
                dto.setRestTime(this.restRegist.getCalcRestTime(startTime, dto.getRestEnd(), this.timeSettingDto));
                this.restRegist.update(dto);
                continue;
            }
            if (!endTime.before(dto.getRestEnd())) continue;
            dto.setRestStart(dto.getRestStart());
            dto.setRestEnd(endTime);
            dto.setRestTime(this.restRegist.getCalcRestTime(dto.getRestStart(), endTime, this.timeSettingDto));
            this.restRegist.update(dto);
        }
        if (startTime == null || endTime == null) {
            return;
        }
        for (RestDtoInterface dto : list) {
            if (initTime.equals(dto.getRestStart()) && initTime.equals(dto.getRestEnd())) continue;
            return;
        }
        List restList = this.registRest(startTime, endTime);
        for (RestDtoInterface dto : restList) {
            this.restRegist.regist(dto);
        }
    }

    protected List<RestDtoInterface> registRest(Date startTime, Date endTime) throws MospException {
        Date initTime = DateUtility.getDateTime((int)DateUtility.getYear((Date)this.targetDate), (int)DateUtility.getMonth((Date)this.targetDate), (int)DateUtility.getDay((Date)this.targetDate), (int)0, (int)0);
        ArrayList<RestDtoInterface> list = new ArrayList<RestDtoInterface>();
        ArrayList startList = new ArrayList();
        ArrayList endList = new ArrayList();
        this.createRestTimeList(startTime, endTime, startList, endList);
        for (int i = 0; i < startList.size(); ++i) {
            Date restStartTime = initTime;
            Date restEndTime = initTime;
            if (startList.get(i) != null) {
                restStartTime = this.getTime(((WorkTypeItemDtoInterface)startList.get(i)).getWorkTypeItemValue(), this.targetDate);
            }
            if (endList.get(i) != null) {
                restEndTime = this.getTime(((WorkTypeItemDtoInterface)endList.get(i)).getWorkTypeItemValue(), this.targetDate);
            }
            if (endTime != null && restStartTime.before(endTime) && startTime != null && restEndTime.after(startTime)) {
                if (restStartTime.before(startTime)) {
                    restStartTime = startTime;
                }
                if (restEndTime.after(endTime)) {
                    restEndTime = endTime;
                }
            } else {
                restStartTime = initTime;
                restEndTime = initTime;
            }
            RestDtoInterface dto = this.restRegist.getInitDto();
            RestDtoInterface restDto = this.restDao.findForKey(this.personalId, this.targetDate, 1, i + 1);
            if (restDto != null) {
                dto.setTmdRestId(restDto.getTmdRestId());
            }
            dto.setPersonalId(this.personalId);
            dto.setWorkDate(this.targetDate);
            dto.setTimesWork(1);
            dto.setRest(i + 1);
            dto.setRestStart(restStartTime);
            dto.setRestEnd(restEndTime);
            dto.setRestTime(this.restRegist.getCalcRestTime(restStartTime, restEndTime, this.timeSettingDto));
            list.add(dto);
        }
        return list;
    }

    protected void createRestTimeList(Date startTime, Date endTime, List<WorkTypeItemDtoInterface> startList, List<WorkTypeItemDtoInterface> endList) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(this.personalId, this.targetDate);
        RequestEntity entity = requestUtil.getRequestEntity(this.personalId, this.targetDate);
        startList.add(null);
        startList.add(null);
        startList.add(null);
        startList.add(null);
        startList.add(null);
        startList.add(null);
        endList.add(null);
        endList.add(null);
        endList.add(null);
        endList.add(null);
        endList.add(null);
        endList.add(null);
        String workTypeCode = this.workTypeDto.getWorkTypeCode();
        Date activateDate = this.workTypeDto.getActivateDate();
        if ("work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            return;
        }
        if (entity.isAmHoliday(true)) {
            WorkTypeItemDtoInterface halfRestDto = this.workTypeItemReference.findForKey(workTypeCode, activateDate, "HalfRest");
            if (endTime != null && halfRestDto != null && DateUtility.getHour((Date)endTime, (Date)this.targetDate) * 60 + DateUtility.getMinute((Date)endTime) >= DateUtility.getHour((Date)halfRestDto.getWorkTypeItemValue(), (Date)this.getDefaultStandardDate()) * 60 + DateUtility.getMinute((Date)halfRestDto.getWorkTypeItemValue())) {
                startList.set(0, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "HalfRestStart"));
                endList.set(0, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "HalfRestEnd"));
            }
            return;
        }
        if (entity.isPmHoliday(true)) {
            return;
        }
        startList.set(0, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "RestStart1"));
        startList.set(1, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "RestStart2"));
        startList.set(2, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "RestStart3"));
        startList.set(3, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "RestStart4"));
        endList.set(0, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "RestEnd1"));
        endList.set(1, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "RestEnd2"));
        endList.set(2, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "RestEnd3"));
        endList.set(3, this.workTypeItemReference.findForKey(workTypeCode, activateDate, "RestEnd4"));
    }

    protected void registPublicGoOut(Date startTime, Date endTime) throws MospException {
        Date initTime = DateUtility.getDateTime((int)DateUtility.getYear((Date)this.targetDate), (int)DateUtility.getMonth((Date)this.targetDate), (int)DateUtility.getDay((Date)this.targetDate), (int)0, (int)0);
        List list = this.goOutReference.getPublicGoOutList(this.personalId, this.targetDate);
        for (GoOutDtoInterface dto : list) {
            if (initTime.equals(dto.getGoOutStart()) && initTime.equals(dto.getGoOutEnd())) continue;
            if (startTime == null || endTime == null || dto.getGoOutStart().after(endTime) || dto.getGoOutEnd().before(startTime)) {
                dto.setGoOutStart(initTime);
                dto.setGoOutEnd(initTime);
                dto.setGoOutTime(0);
                this.goOutRegist.regist(dto);
                continue;
            }
            if (dto.getGoOutStart().before(startTime)) {
                dto.setGoOutStart(startTime);
                dto.setGoOutEnd(dto.getGoOutEnd());
                dto.setGoOutTime(this.goOutRegist.getCalcPublicGoOutTime(startTime, dto.getGoOutEnd(), this.timeSettingDto));
                this.goOutRegist.regist(dto);
                continue;
            }
            if (!dto.getGoOutEnd().after(endTime)) continue;
            dto.setGoOutStart(dto.getGoOutStart());
            dto.setGoOutEnd(endTime);
            dto.setGoOutTime(this.goOutRegist.getCalcPublicGoOutTime(dto.getGoOutStart(), endTime, this.timeSettingDto));
            this.goOutRegist.regist(dto);
        }
    }

    protected void registPrivateGoOut(Date startTime, Date endTime) throws MospException {
        Date initTime = DateUtility.getDateTime((int)DateUtility.getYear((Date)this.targetDate), (int)DateUtility.getMonth((Date)this.targetDate), (int)DateUtility.getDay((Date)this.targetDate), (int)0, (int)0);
        List list = this.goOutReference.getPrivateGoOutList(this.personalId, this.targetDate);
        for (GoOutDtoInterface dto : list) {
            if (initTime.equals(dto.getGoOutStart()) && initTime.equals(dto.getGoOutEnd())) continue;
            if (startTime == null || endTime == null || dto.getGoOutStart().after(endTime) || dto.getGoOutEnd().before(startTime)) {
                dto.setGoOutStart(initTime);
                dto.setGoOutEnd(initTime);
                dto.setGoOutTime(0);
                this.goOutRegist.regist(dto);
                continue;
            }
            if (dto.getGoOutStart().before(startTime)) {
                dto.setGoOutStart(startTime);
                dto.setGoOutEnd(dto.getGoOutEnd());
                dto.setGoOutTime(this.goOutRegist.getCalcPrivateGoOutTime(startTime, dto.getGoOutEnd(), this.timeSettingDto));
                this.goOutRegist.regist(dto);
                continue;
            }
            if (!dto.getGoOutEnd().after(endTime)) continue;
            dto.setGoOutStart(dto.getGoOutStart());
            dto.setGoOutEnd(endTime);
            dto.setGoOutTime(this.goOutRegist.getCalcPrivateGoOutTime(dto.getGoOutStart(), endTime, this.timeSettingDto));
            this.goOutRegist.regist(dto);
        }
    }

    protected void registMinutelyHolidayAGoOut(Date startTime, Date endTime) throws MospException {
        Date initTime = DateUtility.getDateTime((int)DateUtility.getYear((Date)this.targetDate), (int)DateUtility.getMonth((Date)this.targetDate), (int)DateUtility.getDay((Date)this.targetDate), (int)0, (int)0);
        List list = this.goOutReference.getMinutelyHolidayAList(this.personalId, this.targetDate);
        for (GoOutDtoInterface dto : list) {
            if (initTime.equals(dto.getGoOutStart()) && initTime.equals(dto.getGoOutEnd()) || startTime != null && endTime != null) continue;
            dto.setGoOutStart(initTime);
            dto.setGoOutEnd(initTime);
            dto.setGoOutTime(0);
            this.goOutRegist.regist(dto);
        }
    }

    protected void registMinutelyHolidayBGoOut(Date startTime, Date endTime) throws MospException {
        Date initTime = DateUtility.getDateTime((int)DateUtility.getYear((Date)this.targetDate), (int)DateUtility.getMonth((Date)this.targetDate), (int)DateUtility.getDay((Date)this.targetDate), (int)0, (int)0);
        List list = this.goOutReference.getMinutelyHolidayBList(this.personalId, this.targetDate);
        for (GoOutDtoInterface dto : list) {
            if (initTime.equals(dto.getGoOutStart()) && initTime.equals(dto.getGoOutEnd()) || startTime != null && endTime != null) continue;
            dto.setGoOutStart(initTime);
            dto.setGoOutEnd(initTime);
            dto.setGoOutTime(0);
            this.goOutRegist.regist(dto);
        }
    }

    public void registSubHoliday(AttendanceDtoInterface dto) throws MospException {
        this.subHolidayRegist.delete(this.personalId, this.targetDate);
        SubHolidayDtoInterface subHolidayDto = this.subHolidayRegist.getInitDto();
        subHolidayDto.setPersonalId(dto.getPersonalId());
        subHolidayDto.setWorkDate(dto.getWorkDate());
        subHolidayDto.setTimesWork(dto.getTimesWork());
        if ("work_on_legal".equals(dto.getWorkTypeCode())) {
            subHolidayDto.setSubHolidayType(2);
            if (dto.getGrantedLegalCompensationDays() == 1.0) {
                subHolidayDto.setSubHolidayDays(1.0);
            } else if (TimeUtility.isHolidayTimesHalf((double)dto.getGrantedLegalCompensationDays())) {
                subHolidayDto.setSubHolidayDays(0.5);
            } else {
                return;
            }
            this.subHolidayRegist.insert(subHolidayDto);
        } else if ("work_on_prescribed".equals(dto.getWorkTypeCode())) {
            subHolidayDto.setSubHolidayType(1);
            if (dto.getGrantedPrescribedCompensationDays() == 1.0) {
                subHolidayDto.setSubHolidayDays(1.0);
            } else if (TimeUtility.isHolidayTimesHalf((double)dto.getGrantedPrescribedCompensationDays())) {
                subHolidayDto.setSubHolidayDays(0.5);
            } else {
                return;
            }
            this.subHolidayRegist.insert(subHolidayDto);
        }
    }

    public void registCorrection(AttendanceDtoInterface dto, AttendanceDtoInterface oldDto, List<RestDtoInterface> oldRestList, List<GoOutDtoInterface> oldPublicList, List<GoOutDtoInterface> oldPrivateList, List<GoOutDtoInterface> oldminutely1HolidayList, List<GoOutDtoInterface> oldminutely2HolidayList) throws MospException {
        this.personalId = dto.getPersonalId();
        this.targetDate = dto.getWorkDate();
        AttendanceCorrectionDtoInterface attendanceCorrectionDto = this.attendanceCorrectionRegist.getInitDto();
        attendanceCorrectionDto.setPersonalId(this.personalId);
        attendanceCorrectionDto.setWorkDate(this.targetDate);
        attendanceCorrectionDto.setWorks(dto.getTimesWork());
        AttendanceCorrectionDtoInterface latestDto = this.attendanceCorrectionReference.getLatestAttendanceCorrectionInfo(this.personalId, this.targetDate, dto.getTimesWork());
        int correctionTimes = 1;
        if (latestDto != null) {
            correctionTimes += latestDto.getCorrectionTimes();
        }
        attendanceCorrectionDto.setCorrectionTimes(correctionTimes);
        attendanceCorrectionDto.setCorrectionDate(this.getSystemTimeAndSecond());
        attendanceCorrectionDto.setCorrectionPersonalId(this.mospParams.getUser().getPersonalId());
        attendanceCorrectionDto.setCorrectionReason("");
        this.registAttendanceCorrection(attendanceCorrectionDto, oldDto, dto);
        this.registRestCorrection(attendanceCorrectionDto, oldRestList, this.restReference.getRestList(this.personalId, this.targetDate, dto.getTimesWork()));
        this.registGoOutCorrection(attendanceCorrectionDto, oldPublicList, this.goOutReference.getPublicGoOutList(this.personalId, this.targetDate));
        this.registGoOutCorrection(attendanceCorrectionDto, oldPrivateList, this.goOutReference.getPrivateGoOutList(this.personalId, this.targetDate));
        this.registGoOutCorrection(attendanceCorrectionDto, oldminutely1HolidayList, this.goOutReference.getMinutelyHolidayAList(this.personalId, this.targetDate));
        this.registGoOutCorrection(attendanceCorrectionDto, oldminutely2HolidayList, this.goOutReference.getMinutelyHolidayBList(this.personalId, this.targetDate));
    }

    private void registAttendanceCorrection(AttendanceCorrectionDtoInterface dto, AttendanceDtoInterface oldDto, AttendanceDtoInterface newDto) throws MospException {
        this.attendanceCorrectionRegist.insertAttendance(dto, oldDto, newDto);
    }

    private void registRestCorrection(AttendanceCorrectionDtoInterface dto, List<RestDtoInterface> oldList, List<RestDtoInterface> newList) throws MospException {
        for (int i = 0; i < newList.size(); ++i) {
            if (i < oldList.size()) {
                if (!this.attendanceCorrectionReference.chkRest(newList.get(i), oldList.get(i))) continue;
                this.attendanceCorrectionRegist.insertRest(dto, oldList.get(i), newList.get(i));
                continue;
            }
            if (!this.attendanceCorrectionReference.chkRest(newList.get(i), this.restRegist.getInitDto())) continue;
            this.attendanceCorrectionRegist.insertRest(dto, this.restRegist.getInitDto(), newList.get(i));
        }
    }

    private void registGoOutCorrection(AttendanceCorrectionDtoInterface dto, List<GoOutDtoInterface> oldList, List<GoOutDtoInterface> newList) throws MospException {
        for (int i = 0; i < newList.size(); ++i) {
            if (i < oldList.size()) {
                if (!this.attendanceCorrectionReference.chkGoOut(newList.get(i), oldList.get(i))) continue;
                this.attendanceCorrectionRegist.insertGoOut(dto, oldList.get(i), newList.get(i));
                continue;
            }
            if (!this.attendanceCorrectionReference.chkGoOut(newList.get(i), this.goOutRegist.getInitDto())) continue;
            this.attendanceCorrectionRegist.insertGoOut(dto, this.goOutRegist.getInitDto(), newList.get(i));
        }
    }

    public void draft(AttendanceDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto = null;
        if (dto.getWorkflow() != 0L && !"0".equals((workflowDto = this.workflow.getLatestWorkflowInfo(dto.getWorkflow())).getWorkflowStatus())) {
            this.mospParams.addErrorMessage("TMW0285", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate())});
            return;
        }
        if (workflowDto == null) {
            workflowDto = this.workflowRegist.getInitDto();
            workflowDto.setFunctionCode("1");
        }
        this.personalId = dto.getPersonalId();
        this.targetDate = dto.getWorkDate();
        this.setRouteApprover(workflowDto);
        workflowDto = this.workflowRegist.draft(workflowDto, this.personalId, this.targetDate, 1);
        if (workflowDto == null) {
            return;
        }
        dto.setWorkflow(workflowDto.getWorkflow());
    }

    protected void apply(AttendanceDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto = this.workflowRegist.getInitDto();
        if (dto.getWorkflow() != 0L) {
            workflowDto = this.workflow.getLatestWorkflowInfo(dto.getWorkflow());
        }
        this.setRouteApprover(workflowDto);
        workflowDto.setFunctionCode("1");
        workflowDto = this.workflowRegist.appli(workflowDto, this.personalId, this.targetDate, 1, null);
        if (workflowDto == null) {
            return;
        }
        dto.setWorkflow(workflowDto.getWorkflow());
    }

    public void setRouteApprover(WorkflowDtoInterface dto, String personalId, Date targetDate) throws MospException {
        this.personalId = personalId;
        this.targetDate = CapsuleUtility.getDateClone((Date)targetDate);
        this.setRouteApprover(dto);
    }

    protected void setRouteApprover(WorkflowDtoInterface workflowDto) throws MospException {
        List routeApproverList = this.workflow.getRouteApproverList(this.personalId, this.targetDate, 1);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ArrayList<String> defaultApproverList = new ArrayList<String>();
        for (List stageApproverList : routeApproverList) {
            defaultApproverList.add(((String[])stageApproverList.get(0))[0]);
        }
        if (this.mospParams.isTargetApprovalUnit()) {
            workflowDto.setApproverId("");
        } else {
            workflowDto.setApproverId(this.toSeparatedString(defaultApproverList, ","));
            workflowDto.setRouteCode("");
        }
    }

    protected List<Date> getDateList(String[] dates) {
        ArrayList<Date> list = new ArrayList<Date>();
        for (String date : dates) {
            list.add(DateUtility.getDate((String)date));
        }
        return list;
    }

    protected List<Date> getAttendanceTimeList(List<Date> dateList, String[] times) {
        ArrayList<Date> list = new ArrayList<Date>();
        for (int i = 0; i < times.length; ++i) {
            list.add(!times[i].isEmpty() ? TimeUtility.getAttendanceTime((Date)dateList.get(i), (String)times[i], (MospParams)this.mospParams) : null);
        }
        return list;
    }

    public void checkOvertime(AttendanceDtoInterface attendanceDto) throws MospException {
        if (attendanceDto.getOvertimeBefore() == 0 && attendanceDto.getOvertimeAfter() == 0) {
            return;
        }
        this.personalId = attendanceDto.getPersonalId();
        this.targetDate = attendanceDto.getWorkDate();
        this.setTimeDtos(false, false);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(this.personalId, this.targetDate);
        int noApproval = this.cutoffUtil.getNoApproval(this.timeSettingDto.getCutoffCode(), this.targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (noApproval != 1) {
            return;
        }
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto != null && workOnHolidayRequestDto.getSubstitute() == 2) {
            return;
        }
        boolean beforeFlag = attendanceDto.getOvertimeBefore() != 0;
        boolean afterFlag = attendanceDto.getOvertimeAfter() != 0;
        List overtimeRequestList = requestUtil.getOverTimeList(false);
        for (OvertimeRequestDtoInterface overtimeRequestDto : overtimeRequestList) {
            if (overtimeRequestDto.getOvertimeType() == 2) {
                afterFlag = false;
                continue;
            }
            if (overtimeRequestDto.getOvertimeType() != 1) continue;
            beforeFlag = false;
        }
        if (beforeFlag || afterFlag) {
            this.mospParams.addMessage("TMW0304", new String[]{this.getStringDate(this.targetDate), this.mospParams.getName("OvertimeWork"), this.mospParams.getName("OvertimeWork")});
        }
    }

    public void checkOvertime(String personalId, String[] targetDates) throws MospException {
        List targetDateList = this.getDateList(targetDates);
        AttendanceReferenceBean referenceBean = (AttendanceReferenceBean)this.createBean(AttendanceReferenceBean.class);
        for (Date targetDate : targetDateList) {
            this.checkOvertime(referenceBean.findForKey(personalId, targetDate, 1));
        }
    }

    public void checkMinutelyHoliday(AttendanceDtoInterface attendanceDto) {
        boolean minuteB;
        if (attendanceDto.getMinutelyHolidayATime() + attendanceDto.getMinutelyHolidayBTime() == 0) {
            return;
        }
        boolean minuteA = attendanceDto.getMinutelyHolidayA() == 1;
        boolean bl = minuteB = attendanceDto.getMinutelyHolidayB() == 1;
        if (attendanceDto.getStartTime() != null && (minuteA || minuteB)) {
            this.mospParams.addErrorMessage("TMW0326", new String[]{this.getStringDate(this.targetDate)});
        }
    }
}

