/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceCalcBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.GoOutReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.RestReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdOvertimeRequestDto;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.entity.WorkTypeEntity;
import jp.mosp.time.utils.AttendanceUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendanceCalcBean
extends TimeBean
implements AttendanceCalcBeanInterface {
    protected String personalId;
    protected Date workDate;
    protected Date startTime;
    protected Date endTime;
    protected boolean directStart;
    protected boolean directEnd;
    protected String lateReason;
    protected String leaveEarlyReason;
    protected int workTime;
    protected int prescribedWorkTime;
    protected int totalRest;
    protected int legalHolidayRest;
    protected int prescribedHolidayRest;
    protected int totalPublic;
    protected int totalPrivate;
    protected boolean allMinutelyHolidayA;
    protected boolean allMinutelyHolidayB;
    protected int totalMinutelyHolidayA;
    protected int totalMinutelyHolidayB;
    protected int lateTime;
    protected int leaveEarlyTime;
    protected List<RestDtoInterface> restDtoList;
    protected List<GoOutDtoInterface> publicGoOutDtoList;
    protected List<GoOutDtoInterface> privateGoOutDtoList;
    protected List<GoOutDtoInterface> minutelyHolidayADtoList;
    protected List<GoOutDtoInterface> minutelyHolidayBDtoList;
    protected Map<Date, Date> minutelyHolidayAMap;
    protected Map<Date, Date> minutelyHolidayBMap;
    protected int decreaseTime;
    protected TimeSettingDtoInterface timeSettingDto;
    protected WorkOnHolidayRequestDtoInterface workOnHolidayDto;
    protected List<HolidayRequestDtoInterface> holidayRequestDtoList;
    protected List<SubHolidayRequestDtoInterface> subHolidayRequestDtoList;
    protected DifferenceRequestDtoInterface differenceDto;
    protected ScheduleDateDtoInterface scheduleDateDto;
    protected OvertimeRequestDtoInterface beforeOvertimeDto;
    protected OvertimeRequestDtoInterface afterOvertimeDto;
    protected WorkTypeEntity workTypeEntity;
    protected int overtimeTime;
    protected int regWorkStart;
    protected int regWorkEnd;
    protected int regWorkTime;
    protected int regFullWorkTime;
    protected Map<Date, Date> regRestMap;
    protected int betweenHalfHolidayTime;
    protected int overbefore;
    protected int overper;
    protected int overrest;
    protected int overtimeOut;
    protected int workdayOvertimeIn;
    protected int workdayOvertimeOut;
    protected int prescribedHolidayOvertimeIn;
    protected int prescribedHolidayOvertimeOut;
    protected int overRestTime;
    protected int nightWork;
    protected int nightWorkWithinPrescribedWork;
    protected int nightOvertimeWork;
    protected int nightWorkOnHoliday;
    protected int nightRest;
    protected int[] nightWorkArray;
    protected int[] nightRestArray;
    protected int legalHolidayWork;
    protected int prescribedHolidayWork;
    protected int withinStatutoryOvertime;
    protected double grantedLegalCompensationDays;
    protected double grantedPrescribedCompensationDays;
    protected double grantedNightCompensationDays;
    protected int statutoryHolidayWorkIn;
    protected int statutoryHolidayWorkOut;
    protected int prescribedHolidayWorkIn;
    protected int prescribedHolidayWorkOut;
    protected int workBeforeTime;
    protected int workAfterTime;
    protected int calculatedStart;
    protected int calculatedEnd;
    protected int prescribedWorkEnd;
    protected int autoRestCalcStart;
    protected Map<Date, Date> tardinessRestMap;
    protected Map<Date, Date> leaveEarlyRestMap;
    protected Map<Date, Date> overtimeBeforeRestMap;
    protected Map<Date, Date> overtimeRestMap;
    protected int totalBefore24HourManualRest;
    protected int totalBefore24HourOvertimeBeforeRest;
    protected int totalBefore24HourOvertimeRest;
    protected int totalBefore24HourPublicGoOut;
    protected int totalBefore24HourPrivateGoOut;
    protected int totalBefore24HourMinutelyHolidayA;
    protected int totalBefore24HourMinutelyHolidayB;
    protected int totalAfter24HourPaidLeave;
    protected int totalAfter24HourSpecialLeave;
    protected int totalAfter24HourOtherLeave;
    protected int totalAfter24HourAbsenceLeave;
    protected int totalAfter24HourManualRest;
    protected int totalAfter24HourOvertimeBeforeRest;
    protected int totalAfter24HourOvertimeRest;
    protected int totalAfter24HourPublicGoOut;
    protected int totalAfter24HourPrivateGoOut;
    protected boolean isPaidLeaveAm;
    protected boolean isPaidLeavePm;
    protected Map<Date, Date> paidLeaveHourMap;
    protected int paidLeaveHour;
    protected int beforePaidLeaveMinute;
    protected int afterPaidLeaveMinute;
    protected int beforeSpecialLeaveMinute;
    protected int afterSpecialLeaveMinute;
    protected int beforeOtherLeaveMinute;
    protected int afterOtherLeaveMinute;
    protected int beforeAbsenceLeaveMinute;
    protected int afterAbsenceLeaveMinute;
    protected int beforeMinutelyHolidayMinute;
    protected int afterMinutelyHolidayMinute;
    protected boolean isStockLeaveAm;
    protected boolean isStockLeavePm;
    protected boolean isSpecialLeaveAm;
    protected boolean isSpecialLeavePm;
    protected Map<Date, Date> specialLeaveHourMap;
    protected int specialLeaveHour;
    protected boolean isOtherLeaveAm;
    protected boolean isOtherLeavePm;
    protected Map<Date, Date> otherLeaveHourMap;
    protected int otherLeaveHour;
    protected boolean isAbsenceAm;
    protected boolean isAbsencePm;
    protected Map<Date, Date> absenceHourMap;
    protected int absenceHour;
    protected boolean isLegalCompensationDayAm;
    protected boolean isLegalCompensationDayPm;
    protected boolean isPrescribedCompensationDayAm;
    protected boolean isPrescribedCompensationDayPm;
    protected boolean isNightCompensationDaysAm;
    protected boolean isNightCompensationDaysPm;
    protected String workTypeCode;
    protected String nextDayWorkTypeCode;
    protected boolean useShort1;
    protected boolean isShort1StartTypePay;
    protected int short1Start;
    protected int short1End;
    protected boolean useShort2;
    protected boolean isShort2StartTypePay;
    protected int short2Start;
    protected int short2End;
    protected AttendanceDtoInterface inputAttendanceDto;
    protected List<RestDtoInterface> inputRestList;
    protected List<GoOutDtoInterface> inputPublicGoOutList;
    protected List<GoOutDtoInterface> inputPrivateGoOutList;
    protected List<GoOutDtoInterface> inputMinutelyHolidayAList;
    protected List<GoOutDtoInterface> inputMinutelyHolidayBList;
    protected ApplicationReferenceBeanInterface applicationReference;
    protected TimeSettingReferenceBeanInterface timeSettingReference;
    protected ScheduleReferenceBeanInterface scheduleReference;
    protected ScheduleDateReferenceBeanInterface scheduleDateReference;
    protected AttendanceReferenceBeanInterface attendanceReference;
    protected OvertimeRequestReferenceBeanInterface overtimeReference;
    protected HolidayRequestReferenceBeanInterface holidayReference;
    protected SubHolidayRequestReferenceBeanInterface subHolidayReference;
    protected WorkOnHolidayRequestReferenceBeanInterface workOnHolidayReference;
    protected SubstituteReferenceBeanInterface substituteReference;
    protected WorkflowReferenceBeanInterface workflowReference;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkTypeItemReferenceBeanInterface workTypeItemReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected RestReferenceBeanInterface restReference;
    protected GoOutReferenceBeanInterface goOutReference;

    public void initBean() throws MospException {
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.timeSettingReference = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
        this.scheduleReference = (ScheduleReferenceBeanInterface)this.createBean(ScheduleReferenceBeanInterface.class);
        this.scheduleDateReference = (ScheduleDateReferenceBeanInterface)this.createBean(ScheduleDateReferenceBeanInterface.class);
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.overtimeReference = (OvertimeRequestReferenceBeanInterface)this.createBean(OvertimeRequestReferenceBeanInterface.class);
        this.holidayReference = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.subHolidayReference = (SubHolidayRequestReferenceBeanInterface)this.createBean(SubHolidayRequestReferenceBeanInterface.class);
        this.workOnHolidayReference = (WorkOnHolidayRequestReferenceBeanInterface)this.createBean(WorkOnHolidayRequestReferenceBeanInterface.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBean(SubstituteReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.workTypeItemReference = (WorkTypeItemReferenceBeanInterface)this.createBean(WorkTypeItemReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.restReference = (RestReferenceBeanInterface)this.createBean(RestReferenceBeanInterface.class);
        this.goOutReference = (GoOutReferenceBeanInterface)this.createBean(GoOutReferenceBeanInterface.class);
    }

    public void initAttendanceTotal(String personalId, String workTypeCode, RequestUtilBeanInterface requestUtil) throws MospException {
        int startTimeInt;
        WorkflowDtoInterface workflowDto;
        WorkflowDtoInterface workflowDto2;
        OvertimeRequestDtoInterface beforeDto;
        WorkflowDtoInterface workflowDto3;
        ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(personalId, this.workDate);
        this.applicationReference.chkExistApplication(applicationDto, this.workDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(applicationDto.getScheduleCode(), this.workDate);
        this.scheduleReference.chkExistSchedule(scheduleDto, this.workDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.timeSettingDto = this.timeSettingReference.getTimeSettingInfo(applicationDto.getWorkSettingCode(), this.workDate);
        this.timeSettingReference.chkExistTimeSetting(this.timeSettingDto, this.workDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.scheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleDto.getScheduleCode(), this.workDate);
        this.scheduleDateReference.chkExistScheduleDate(this.scheduleDateDto, this.workDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        OvertimeRequestDtoInterface overtimeRequestDto = this.overtimeReference.findForKeyOnWorkflow(personalId, this.workDate, 2);
        if (overtimeRequestDto != null && (workflowDto3 = this.workflowReference.getLatestWorkflowInfo(overtimeRequestDto.getWorkflow())) != null && "9".equals(workflowDto3.getWorkflowStatus())) {
            this.afterOvertimeDto = overtimeRequestDto;
        }
        if (this.timeSettingDto.getBeforeOvertimeFlag() == 0 && (beforeDto = this.overtimeReference.findForKeyOnWorkflow(personalId, this.workDate, 1)) != null && (workflowDto2 = this.workflowReference.getLatestWorkflowInfo(beforeDto.getWorkflow())) != null && "9".equals(workflowDto2.getWorkflowStatus())) {
            this.beforeOvertimeDto = beforeDto;
        }
        this.holidayRequestDtoList = new ArrayList();
        List holidayRequestList = this.holidayReference.getHolidayRequestList(personalId, this.workDate);
        for (HolidayRequestDtoInterface requestDto : holidayRequestList) {
            WorkflowDtoInterface workflowDto4 = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow());
            if (workflowDto4 == null || !"9".equals(workflowDto4.getWorkflowStatus())) continue;
            this.holidayRequestDtoList.add(requestDto);
        }
        this.subHolidayRequestDtoList = new ArrayList();
        List subHolidayRequestList = this.subHolidayReference.getSubHolidayRequestList(personalId, this.workDate);
        for (SubHolidayRequestDtoInterface requestDto : subHolidayRequestList) {
            workflowDto = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow());
            if (workflowDto == null || !"9".equals(workflowDto.getWorkflowStatus())) continue;
            this.subHolidayRequestDtoList.add(requestDto);
        }
        DifferenceRequestReferenceBeanInterface differenceReference = (DifferenceRequestReferenceBeanInterface)this.createBean(DifferenceRequestReferenceBeanInterface.class, this.workDate);
        DifferenceRequestDtoInterface differenceRequestDto = differenceReference.findForKeyOnWorkflow(personalId, this.workDate);
        if (differenceRequestDto != null && (workflowDto = this.workflowReference.getLatestWorkflowInfo(differenceRequestDto.getWorkflow())) != null && "9".equals(workflowDto.getWorkflowStatus())) {
            this.differenceDto = differenceRequestDto;
        }
        this.getSubstituteScheduleDateDto(scheduleDto);
        this.nextDayWorkTypeCode = this.getWorkTypeCode(personalId, DateUtility.addDay((Date)this.workDate, (int)1), 1);
        if (this.differenceDto != null && ("a".equals(workTypeCode) || "b".equals(workTypeCode) || "c".equals(workTypeCode) || "d".equals(workTypeCode) || "s".equals(workTypeCode))) {
            this.setFields(this.scheduleDateDto.getWorkTypeCode(), requestUtil);
        } else {
            this.setFields(workTypeCode, requestUtil);
        }
        if (this.startTime != null && (startTimeInt = DateUtility.getHour((Date)this.startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)this.startTime)) < this.regWorkStart) {
            if (this.timeSettingDto.getBeforeOvertimeFlag() == 1) {
                return;
            }
            WorkTypeItemDtoInterface workStartDto = this.workTypeItemReference.getWorkTypeItemInfo(workTypeCode, this.workDate, "AutoBefOverWork");
            if (workStartDto == null) {
                return;
            }
            if (workStartDto.getPreliminary().equals(String.valueOf(String.valueOf(1)))) {
                return;
            }
            this.beforeOvertimeDto = new TmdOvertimeRequestDto();
            int beforeOvertime = DateUtility.getHour((Date)this.workTypeEntity.getStartWorkTime()) * 60 + DateUtility.getMinute((Date)this.workTypeEntity.getStartWorkTime());
            this.beforeOvertimeDto.setRequestTime(beforeOvertime - startTimeInt);
        }
    }

    protected void getSubstituteScheduleDateDto(ScheduleDtoInterface scheduleDto) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHolidayReference.findForKeyOnWorkflow(this.personalId, this.workDate);
        if (workOnHolidayRequestDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(workOnHolidayRequestDto.getWorkflow());
        if (workflowDto != null && (this.workflowIntegrate.isApprovable(workflowDto) || this.workflowIntegrate.isCompleted(workflowDto))) {
            this.workOnHolidayDto = workOnHolidayRequestDto;
            if (this.workOnHolidayDto.getSubstitute() == 2) {
                return;
            }
            List list = this.substituteReference.getSubstituteList(this.workOnHolidayDto.getWorkflow());
            for (SubstituteDtoInterface dto : list) {
                ScheduleDateDtoInterface substituteScheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleDto.getScheduleCode(), dto.getSubstituteDate());
                if (substituteScheduleDateDto == null) continue;
                this.scheduleDateDto = substituteScheduleDateDto;
                break;
            }
        }
    }

    protected void setFields(String workTypeCode, RequestUtilBeanInterface requestUtil) throws MospException {
        RequestEntity entity;
        WorkTypeItemDtoInterface overRestDto;
        WorkTypeItemDtoInterface overPerDto;
        WorkTypeItemDtoInterface overBeforeDto;
        WorkTypeItemDtoInterface workTimeDto;
        WorkTypeItemDtoInterface workEndDto;
        this.workTypeCode = workTypeCode;
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            return;
        }
        this.workTypeEntity = this.workTypeReference.getWorkTypeEntity(workTypeCode, this.workDate);
        if (this.isWorkOnLegalDaysOff() || this.isWorkOnPrescribedDaysOff()) {
            if (this.workOnHolidayDto != null) {
                int daysOffWorkStart;
                this.regWorkStart = daysOffWorkStart = this.getDefferenceMinutes(this.workOnHolidayDto.getRequestDate(), this.workOnHolidayDto.getStartTime());
                this.regWorkEnd = this.getDefferenceMinutes(this.workOnHolidayDto.getRequestDate(), this.workOnHolidayDto.getEndTime());
            }
            return;
        }
        WorkTypeDtoInterface workTypeDto = this.workTypeReference.getWorkTypeInfo(workTypeCode, this.workDate);
        if (workTypeDto == null) {
            this.addWorkTypeNotExistErrorMessage(this.workDate);
            return;
        }
        String localWorkTypeCode = workTypeDto.getWorkTypeCode();
        WorkTypeItemDtoInterface workStartDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "WorkStart");
        if (workStartDto != null) {
            int time;
            this.regWorkStart = time = this.getDefferenceMinutes(this.getDefaultStandardDate(), workStartDto.getWorkTypeItemValue());
        }
        if ((workEndDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "WorkEnd")) != null) {
            this.regWorkEnd = this.getDefferenceMinutes(this.getDefaultStandardDate(), workEndDto.getWorkTypeItemValue());
        }
        if ((workTimeDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "WorkTime")) != null) {
            int time;
            this.regWorkTime = time = this.getDefferenceMinutes(this.getDefaultStandardDate(), workTimeDto.getWorkTypeItemValue());
            this.regFullWorkTime = time;
        }
        if ((overBeforeDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "OverBefore")) != null) {
            this.overbefore = this.getDefferenceMinutes(this.getDefaultStandardDate(), overBeforeDto.getWorkTypeItemValue());
        }
        if ((overPerDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "OverPer")) != null) {
            this.overper = this.getDefferenceMinutes(this.getDefaultStandardDate(), overPerDto.getWorkTypeItemValue());
        }
        if ((overRestDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "OverRest")) != null) {
            this.overrest = this.getDefferenceMinutes(this.getDefaultStandardDate(), overRestDto.getWorkTypeItemValue());
        }
        WorkTypeItemDtoInterface frontStartDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "FrontStart");
        WorkTypeItemDtoInterface frontEndDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "FrontEnd");
        WorkTypeItemDtoInterface backStartDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "BackStart");
        WorkTypeItemDtoInterface backEndDto = this.workTypeItemReference.getWorkTypeItemInfo(localWorkTypeCode, this.workDate, "BackEnd");
        int frontStart = 0;
        if (frontStartDto != null) {
            frontStart = this.getDefferenceMinutes(this.getDefaultStandardDate(), frontStartDto.getWorkTypeItemValue());
        }
        int frontEnd = 0;
        if (frontEndDto != null) {
            frontEnd = this.getDefferenceMinutes(this.getDefaultStandardDate(), frontEndDto.getWorkTypeItemValue());
        }
        int backStart = 0;
        if (backStartDto != null) {
            backStart = this.getDefferenceMinutes(this.getDefaultStandardDate(), backStartDto.getWorkTypeItemValue());
        }
        int backEnd = 0;
        if (backEndDto != null) {
            backEnd = this.getDefferenceMinutes(this.getDefaultStandardDate(), backEndDto.getWorkTypeItemValue());
        }
        if ((entity = requestUtil.getRequestEntity(this.personalId, this.workDate)).isPmHoliday(true)) {
            this.regWorkStart = frontStart;
            this.regWorkEnd = frontEnd;
            this.regWorkTime = frontEnd - frontStart;
            this.betweenHalfHolidayTime = backStart - frontEnd;
        }
        if (entity.isAmHoliday(true)) {
            this.regWorkStart = backStart;
            this.regWorkEnd = backEnd;
            this.regWorkTime = backEnd - backStart;
            this.betweenHalfHolidayTime = backStart - frontEnd;
        }
    }

    public int getWorkTime() {
        if (this.timeSettingDto == null) {
            return 0;
        }
        return this.getRoundMinute(this.workTime, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
    }

    protected void calcRegRest(RequestUtilBeanInterface requestUtil) throws MospException {
        if (this.isWorkOnLegalDaysOff() || this.isWorkOnPrescribedDaysOff()) {
            return;
        }
        if (this.isAmHalfDayOff(requestUtil)) {
            int restEnd;
            WorkTypeItemDtoInterface halfRestDto = this.workTypeItemReference.getWorkTypeItemInfo(this.workTypeCode, this.workDate, "HalfRest");
            if (halfRestDto == null) {
                return;
            }
            int halfRest = this.getDefferenceMinutes(this.getDefaultStandardDate(), halfRestDto.getWorkTypeItemValue());
            if (halfRest <= this.calculatedStart || this.calculatedEnd < halfRest) {
                return;
            }
            WorkTypeItemDtoInterface halfRestStartDto = this.workTypeItemReference.getWorkTypeItemInfo(this.workTypeCode, this.workDate, "HalfRestStart");
            if (halfRestStartDto == null) {
                return;
            }
            WorkTypeItemDtoInterface halfRestEndDto = this.workTypeItemReference.getWorkTypeItemInfo(this.workTypeCode, this.workDate, "HalfRestEnd");
            if (halfRestEndDto == null) {
                return;
            }
            int restStart = this.getDefferenceMinutes(this.getDefaultStandardDate(), halfRestStartDto.getWorkTypeItemValue());
            if (restStart == (restEnd = this.getDefferenceMinutes(this.getDefaultStandardDate(), halfRestEndDto.getWorkTypeItemValue()))) {
                return;
            }
            this.regRestMap.put(this.getAttendanceTime(this.workDate, restStart), this.getAttendanceTime(this.workDate, restEnd));
            return;
        }
        if (this.isPmHalfDayOff(requestUtil)) {
            return;
        }
        String[] restStartArray = new String[]{"RestStart1", "RestStart2", "RestStart3", "RestStart4"};
        String[] restEndArray = new String[]{"RestEnd1", "RestEnd2", "RestEnd3", "RestEnd4"};
        for (int i = 0; i < restStartArray.length; ++i) {
            int restEnd;
            int restStart;
            WorkTypeItemDtoInterface restEndDto;
            WorkTypeItemDtoInterface restStartDto = this.workTypeItemReference.getWorkTypeItemInfo(this.workTypeCode, this.workDate, restStartArray[i]);
            if (restStartDto == null || (restEndDto = this.workTypeItemReference.getWorkTypeItemInfo(this.workTypeCode, this.workDate, restEndArray[i])) == null || (restStart = this.getDefferenceMinutes(this.getDefaultStandardDate(), restStartDto.getWorkTypeItemValue())) == (restEnd = this.getDefferenceMinutes(this.getDefaultStandardDate(), restEndDto.getWorkTypeItemValue()))) continue;
            this.regRestMap.put(this.getAttendanceTime(this.workDate, restStart), this.getAttendanceTime(this.workDate, restEnd));
        }
    }

    protected void calcWorkTime(RequestUtilBeanInterface requestUtil) throws MospException {
        int endTimeInt;
        int startTimeInt;
        Date endTime;
        Date startTime;
        int totalManualRest = 0;
        for (RestDtoInterface dto : this.restDtoList) {
            totalManualRest += dto.getRestTime();
        }
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (Map.Entry entry : this.tardinessRestMap.entrySet()) {
            map.put(this.getDefferenceMinutes(this.workDate, (Date)entry.getKey()), this.getDefferenceMinutes(this.workDate, (Date)entry.getValue()));
        }
        for (Map.Entry entry : this.leaveEarlyRestMap.entrySet()) {
            map.put(this.getDefferenceMinutes(this.workDate, (Date)entry.getKey()), this.getDefferenceMinutes(this.workDate, (Date)entry.getValue()));
        }
        for (RestDtoInterface dto : this.restDtoList) {
            startTime = this.getRoundMinute(dto.getRestStart(), this.timeSettingDto.getRoundDailyRestStart(), this.timeSettingDto.getRoundDailyRestStartUnit());
            endTime = this.getRoundMinute(dto.getRestEnd(), this.timeSettingDto.getRoundDailyRestEnd(), this.timeSettingDto.getRoundDailyRestEndUnit());
            startTimeInt = DateUtility.getHour((Date)startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)startTime);
            endTimeInt = DateUtility.getHour((Date)endTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)endTime);
            if (endTimeInt <= this.regWorkStart) continue;
            if (startTimeInt < this.regWorkStart) {
                startTimeInt = this.regWorkStart;
            }
            if (map.containsKey(startTimeInt)) {
                if ((Integer)map.get(startTimeInt) >= endTimeInt) continue;
                map.put(startTimeInt, endTimeInt);
                continue;
            }
            map.put(startTimeInt, endTimeInt);
        }
        for (RestDtoInterface dto : this.minutelyHolidayADtoList) {
            startTime = dto.getGoOutStart();
            endTime = dto.getGoOutEnd();
            startTimeInt = DateUtility.getHour((Date)startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)startTime);
            endTimeInt = DateUtility.getHour((Date)endTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)endTime);
            if (endTimeInt <= this.regWorkStart) continue;
            if (startTimeInt < this.regWorkStart) {
                startTimeInt = this.regWorkStart;
            }
            if (map.containsKey(startTimeInt)) {
                if ((Integer)map.get(startTimeInt) >= endTimeInt) continue;
                map.put(startTimeInt, endTimeInt);
                continue;
            }
            map.put(startTimeInt, endTimeInt);
        }
        for (RestDtoInterface dto : this.minutelyHolidayBDtoList) {
            startTime = dto.getGoOutStart();
            endTime = dto.getGoOutEnd();
            startTimeInt = DateUtility.getHour((Date)startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)startTime);
            endTimeInt = DateUtility.getHour((Date)endTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)endTime);
            if (endTimeInt <= this.regWorkStart) continue;
            if (startTimeInt < this.regWorkStart) {
                startTimeInt = this.regWorkStart;
            }
            if (map.containsKey(startTimeInt)) {
                if ((Integer)map.get(startTimeInt) >= endTimeInt) continue;
                map.put(startTimeInt, endTimeInt);
                continue;
            }
            map.put(startTimeInt, endTimeInt);
        }
        int time = this.regWorkStart;
        int tmpWorkTime = 0;
        int scheduledWorkEndTime = 0;
        for (Map.Entry entry : map.entrySet()) {
            int mapStartTimeInt = (Integer)entry.getKey();
            int mapEndTimeInt = (Integer)entry.getValue();
            if (time > mapStartTimeInt) continue;
            int addWorkTime = mapStartTimeInt - time;
            if (tmpWorkTime + addWorkTime >= this.autoRestCalcStart) {
                scheduledWorkEndTime = time + (this.autoRestCalcStart - tmpWorkTime);
                break;
            }
            tmpWorkTime += addWorkTime;
            time = mapEndTimeInt;
        }
        if (scheduledWorkEndTime == 0) {
            int remainWorkTime = this.calculatedEnd - time;
            if (tmpWorkTime + remainWorkTime <= this.autoRestCalcStart) {
                this.totalRest = totalManualRest;
                this.workTime = this.totalWorkTime(requestUtil);
                return;
            }
            scheduledWorkEndTime = time + (this.autoRestCalcStart - tmpWorkTime);
        }
        if (scheduledWorkEndTime + this.overbefore >= this.calculatedEnd) {
            int overtimeBeforeTime = 0;
            if (scheduledWorkEndTime < this.calculatedStart) {
                if (this.calculatedEnd - this.calculatedStart > 0) {
                    overtimeBeforeTime = this.calculatedEnd - this.calculatedStart;
                    this.overtimeBeforeRestMap.put(this.getAttendanceTime(this.workDate, this.calculatedStart), this.getAttendanceTime(this.workDate, this.calculatedEnd));
                }
            } else if (this.calculatedEnd - scheduledWorkEndTime > 0) {
                overtimeBeforeTime = this.calculatedEnd - scheduledWorkEndTime;
                this.overtimeBeforeRestMap.put(this.getAttendanceTime(this.workDate, scheduledWorkEndTime), this.getAttendanceTime(this.workDate, this.calculatedEnd));
            }
            this.totalRest = totalManualRest + overtimeBeforeTime;
            this.workTime = this.totalWorkTime(requestUtil);
            return;
        }
        int afterOvertimeWorkStart = scheduledWorkEndTime + this.overbefore;
        int totalOvertimeBeforeRest = 0;
        if (scheduledWorkEndTime >= this.calculatedStart) {
            if (afterOvertimeWorkStart - scheduledWorkEndTime > 0) {
                totalOvertimeBeforeRest += afterOvertimeWorkStart - scheduledWorkEndTime;
                this.overtimeBeforeRestMap.put(this.getAttendanceTime(this.workDate, scheduledWorkEndTime), this.getAttendanceTime(this.workDate, afterOvertimeWorkStart));
            }
        } else if (afterOvertimeWorkStart >= this.calculatedStart && afterOvertimeWorkStart - this.calculatedStart > 0) {
            totalOvertimeBeforeRest += afterOvertimeWorkStart - this.calculatedStart;
            this.overtimeBeforeRestMap.put(this.getAttendanceTime(this.workDate, this.calculatedStart), this.getAttendanceTime(this.workDate, afterOvertimeWorkStart));
        }
        int totalOvertimeRest = 0;
        if (!this.isWorkOnLegalDaysOff() && !this.isWorkOnPrescribedDaysOff()) {
            int overtimeRestTimes = 0;
            if (this.overper > 1) {
                overtimeRestTimes = (this.calculatedEnd - afterOvertimeWorkStart) / this.overper;
            }
            int previousOvertimeRestEnd = afterOvertimeWorkStart;
            for (int i = 0; i < overtimeRestTimes; ++i) {
                int overtimeRestStart = previousOvertimeRestEnd + this.overper - this.overrest;
                int overtimeRestEnd = previousOvertimeRestEnd + this.overper;
                if (overtimeRestStart >= this.calculatedStart) {
                    this.overtimeRestMap.put(this.getAttendanceTime(this.workDate, overtimeRestStart), this.getAttendanceTime(this.workDate, overtimeRestEnd));
                    totalOvertimeRest += overtimeRestEnd - overtimeRestStart;
                }
                previousOvertimeRestEnd = overtimeRestEnd;
            }
        }
        this.totalRest = totalManualRest + totalOvertimeBeforeRest + totalOvertimeRest;
        this.workTime = this.totalWorkTime(requestUtil);
    }

    protected int totalWorkTime(RequestUtilBeanInterface requestUtil) throws MospException {
        int paidLeave = this.paidLeaveHour * 60 - this.beforePaidLeaveMinute - this.afterPaidLeaveMinute;
        int specialLeave = this.specialLeaveHour * 60 - this.beforeSpecialLeaveMinute - this.afterSpecialLeaveMinute;
        int otherLeave = this.otherLeaveHour * 60 - this.beforeOtherLeaveMinute - this.afterOtherLeaveMinute;
        int absenceLeave = this.absenceHour * 60 - this.beforeAbsenceLeaveMinute - this.afterAbsenceLeaveMinute;
        int minutelyHoliday = this.totalMinutelyHolidayA + this.totalMinutelyHolidayB - this.beforeMinutelyHolidayMinute - this.afterMinutelyHolidayMinute;
        int result = this.calculatedEnd - this.calculatedStart - this.totalRest - this.totalPublic - this.totalPrivate - paidLeave - specialLeave - otherLeave - absenceLeave - minutelyHoliday;
        if (!this.isAmHalfDayOff(requestUtil) && this.useShort1 && this.isShort1StartTypePay && this.calculatedStart > this.short1End) {
            result += this.short1End - this.short1Start;
        }
        if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay && this.calculatedEnd < this.short2Start) {
            result += this.short2End - this.short2Start;
        }
        return result;
    }

    protected void calcLegalOutTime() throws MospException {
        boolean isSpecificHolidayCalendarDay;
        this.overtimeOut = this.overtimeTime - this.withinStatutoryOvertime;
        this.overRestTime = 0;
        boolean bl = isSpecificHolidayCalendarDay = this.timeSettingDto.getSpecificHolidayHandling() == 2;
        if (this.isWorkOnLegalDaysOff()) {
            if (this.isNextDayLegalDaysOff() || this.isNextDayWorkOnLegalDaysOff()) {
                return;
            }
            if (this.isNextDayPrescribedDaysOff() || this.isNextDayWorkOnPrescribedDaysOff()) {
                this.prescribedHolidayOvertimeIn = this.withinStatutoryOvertime;
                this.prescribedHolidayOvertimeOut = this.overtimeOut;
                this.workdayOvertimeIn = 0;
                this.workdayOvertimeOut = 0;
                return;
            }
            this.prescribedHolidayOvertimeIn = 0;
            this.prescribedHolidayOvertimeOut = 0;
            this.workdayOvertimeIn = this.withinStatutoryOvertime;
            this.workdayOvertimeOut = this.overtimeOut;
            return;
        }
        if (this.isWorkOnPrescribedDaysOff()) {
            if (this.isNextDayLegalDaysOff() || this.isNextDayWorkOnLegalDaysOff() || this.isNextDayPrescribedDaysOff() || this.isNextDayWorkOnPrescribedDaysOff()) {
                this.prescribedHolidayOvertimeIn = this.withinStatutoryOvertime;
                this.prescribedHolidayOvertimeOut = this.overtimeOut;
                this.workdayOvertimeIn = 0;
                this.workdayOvertimeOut = 0;
                return;
            }
            if (!isSpecificHolidayCalendarDay) {
                this.prescribedHolidayOvertimeIn = this.withinStatutoryOvertime;
                this.prescribedHolidayOvertimeOut = this.overtimeOut;
                this.workdayOvertimeIn = 0;
                this.workdayOvertimeOut = 0;
                return;
            }
            int difference = this.prescribedHolidayWork - this.withinStatutoryOvertime;
            if (difference >= 0) {
                this.prescribedHolidayOvertimeIn = this.withinStatutoryOvertime;
                this.prescribedHolidayOvertimeOut = difference;
                this.workdayOvertimeIn = 0;
                this.workdayOvertimeOut = this.overtimeOut - difference;
                return;
            }
            this.prescribedHolidayOvertimeIn = this.prescribedHolidayWork;
            this.prescribedHolidayOvertimeOut = 0;
            this.workdayOvertimeIn = this.withinStatutoryOvertime - this.prescribedHolidayWork;
            this.workdayOvertimeOut = this.overtimeOut;
            return;
        }
        if (this.isNextDayLegalDaysOff() || this.isNextDayWorkOnLegalDaysOff()) {
            this.prescribedHolidayOvertimeIn = 0;
            this.prescribedHolidayOvertimeOut = 0;
            this.workdayOvertimeIn = this.withinStatutoryOvertime;
            this.workdayOvertimeOut = this.overtimeOut;
            return;
        }
        if (this.isNextDayPrescribedDaysOff() || this.isNextDayWorkOnPrescribedDaysOff()) {
            if (!isSpecificHolidayCalendarDay) {
                this.prescribedHolidayOvertimeIn = 0;
                this.prescribedHolidayOvertimeOut = 0;
                this.workdayOvertimeIn = this.withinStatutoryOvertime;
                this.workdayOvertimeOut = this.overtimeOut;
                return;
            }
            if (this.withinStatutoryOvertime >= this.workBeforeTime) {
                int difference = this.overtimeOut - this.prescribedHolidayWork;
                if (difference >= 0) {
                    this.prescribedHolidayOvertimeIn = 0;
                    this.prescribedHolidayOvertimeOut = this.prescribedHolidayWork;
                    this.workdayOvertimeIn = this.withinStatutoryOvertime;
                    this.workdayOvertimeOut = difference;
                    return;
                }
                this.prescribedHolidayOvertimeOut = this.overtimeOut;
                this.workdayOvertimeOut = 0;
                if (this.prescribedHolidayWork - this.overtimeOut >= this.withinStatutoryOvertime - this.workBeforeTime) {
                    this.prescribedHolidayOvertimeIn = this.withinStatutoryOvertime - this.workBeforeTime;
                    this.workdayOvertimeIn = this.workBeforeTime;
                    return;
                }
                this.prescribedHolidayOvertimeIn = this.prescribedHolidayWork - this.overtimeOut;
                this.workdayOvertimeIn = this.withinStatutoryOvertime - this.prescribedHolidayOvertimeIn;
                return;
            }
            this.prescribedHolidayOvertimeIn = 0;
            this.workdayOvertimeIn = this.withinStatutoryOvertime;
            int difference = this.overtimeOut - (this.workBeforeTime - this.withinStatutoryOvertime) - this.prescribedHolidayWork;
            if (difference >= 0) {
                this.prescribedHolidayOvertimeOut = this.prescribedHolidayWork;
                this.workdayOvertimeOut = this.overtimeOut - this.prescribedHolidayWork;
                return;
            }
            this.prescribedHolidayOvertimeOut = this.overtimeOut - (this.workBeforeTime - this.withinStatutoryOvertime);
            this.workdayOvertimeOut = this.workBeforeTime - this.withinStatutoryOvertime;
            return;
        }
        this.prescribedHolidayOvertimeIn = 0;
        this.prescribedHolidayOvertimeOut = 0;
        this.workdayOvertimeIn = this.withinStatutoryOvertime;
        this.workdayOvertimeOut = this.overtimeOut;
    }

    private void calcPublicGoOutTime() {
        int total = 0;
        for (GoOutDtoInterface dto : this.publicGoOutDtoList) {
            total += dto.getGoOutTime();
        }
        this.totalPublic = total;
    }

    private void calcPrivateGoOutTime() {
        int total = 0;
        for (GoOutDtoInterface dto : this.privateGoOutDtoList) {
            total += dto.getGoOutTime();
        }
        this.totalPrivate = total;
    }

    private void calcMinutelyHolidayATime() {
        int total = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayADtoList) {
            this.minutelyHolidayAMap.put(dto.getGoOutStart(), dto.getGoOutEnd());
            total += dto.getGoOutTime();
        }
        this.totalMinutelyHolidayA = total;
    }

    protected void calcBeforeMinutelyHolidayMinute() {
        int minutelyHolidayA = 0;
        for (Map.Entry entry : this.minutelyHolidayAMap.entrySet()) {
            int minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (minutelyHolidayStart >= this.calculatedStart) continue;
            if (minutelyHolidayEnd > this.calculatedStart) {
                minutelyHolidayEnd = this.calculatedStart;
            }
            minutelyHolidayA += minutelyHolidayEnd - minutelyHolidayStart;
        }
        int minutelyHolidayB = 0;
        for (Map.Entry entry : this.minutelyHolidayBMap.entrySet()) {
            int minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (minutelyHolidayStart >= this.calculatedStart) continue;
            if (minutelyHolidayEnd > this.calculatedStart) {
                minutelyHolidayEnd = this.calculatedStart;
            }
            minutelyHolidayB += minutelyHolidayEnd - minutelyHolidayStart;
        }
        this.beforeMinutelyHolidayMinute = minutelyHolidayA + minutelyHolidayB;
    }

    protected void calcAfterMinutelyHolidayMinute() {
        int minutelyHolidayA = 0;
        for (Map.Entry entry : this.minutelyHolidayAMap.entrySet()) {
            int minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (minutelyHolidayEnd <= this.calculatedEnd) continue;
            if (minutelyHolidayStart < this.calculatedEnd) {
                minutelyHolidayStart = this.calculatedEnd;
            }
            minutelyHolidayA += minutelyHolidayEnd - minutelyHolidayStart;
        }
        int minutelyHolidayB = 0;
        for (Map.Entry entry : this.minutelyHolidayBMap.entrySet()) {
            int minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (minutelyHolidayEnd <= this.calculatedEnd) continue;
            if (minutelyHolidayStart < this.calculatedEnd) {
                minutelyHolidayStart = this.calculatedEnd;
            }
            minutelyHolidayB += minutelyHolidayEnd - minutelyHolidayStart;
        }
        this.afterMinutelyHolidayMinute = minutelyHolidayA + minutelyHolidayB;
    }

    private void calcMinutelyHolidayBTime() {
        int total = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayBDtoList) {
            this.minutelyHolidayBMap.put(dto.getGoOutStart(), dto.getGoOutEnd());
            total += dto.getGoOutTime();
        }
        this.totalMinutelyHolidayB = total;
    }

    protected void calcTardinessTime(RequestUtilBeanInterface requestUtil) throws MospException {
        int result;
        int restEnd;
        int restStart;
        int minutelyHolidayEnd;
        int minutelyHolidayStart;
        if (this.isWorkOnLegalDaysOff() || this.isWorkOnPrescribedDaysOff()) {
            return;
        }
        if (this.allMinutelyHolidayA || this.allMinutelyHolidayB) {
            return;
        }
        int exclusion = 0;
        for (Map.Entry entry : this.regRestMap.entrySet()) {
            int restStart2 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int restEnd2 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (restStart2 >= this.calculatedStart) continue;
            if (restEnd2 > this.calculatedStart) {
                restEnd2 = this.calculatedStart;
            }
            exclusion += restEnd2 - restStart2;
            this.tardinessRestMap.put(this.getAttendanceTime(this.workDate, restStart2), this.getAttendanceTime(this.workDate, restEnd2));
        }
        for (Map.Entry entry : this.minutelyHolidayAMap.entrySet()) {
            minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (minutelyHolidayStart >= this.calculatedStart) continue;
            if (minutelyHolidayEnd > this.calculatedStart) {
                minutelyHolidayEnd = this.calculatedStart;
            }
            for (Map.Entry restEntry : this.tardinessRestMap.entrySet()) {
                restStart = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                restEnd = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (minutelyHolidayStart >= restStart && restEnd >= minutelyHolidayEnd) {
                    minutelyHolidayStart = 0;
                    minutelyHolidayEnd = 0;
                    break;
                }
                if (minutelyHolidayStart >= restEnd || minutelyHolidayEnd <= restStart) continue;
                if (minutelyHolidayStart < restStart && restEnd < minutelyHolidayEnd) {
                    exclusion += restStart - minutelyHolidayStart;
                    minutelyHolidayStart = restEnd;
                    continue;
                }
                if (minutelyHolidayStart >= restStart && minutelyHolidayEnd > restEnd) {
                    minutelyHolidayStart = restEnd;
                }
                if (minutelyHolidayStart >= restStart || minutelyHolidayEnd > restEnd) continue;
                minutelyHolidayEnd = restStart;
            }
            exclusion += minutelyHolidayEnd - minutelyHolidayStart;
        }
        for (Map.Entry entry : this.minutelyHolidayBMap.entrySet()) {
            minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (minutelyHolidayStart >= this.calculatedStart) continue;
            if (minutelyHolidayEnd > this.calculatedStart) {
                minutelyHolidayEnd = this.calculatedStart;
            }
            for (Map.Entry restEntry : this.tardinessRestMap.entrySet()) {
                restStart = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                restEnd = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (minutelyHolidayStart >= restStart && restEnd >= minutelyHolidayEnd) {
                    minutelyHolidayStart = 0;
                    minutelyHolidayEnd = 0;
                    break;
                }
                if (minutelyHolidayStart >= restEnd || minutelyHolidayEnd <= restStart) continue;
                if (minutelyHolidayStart < restStart && restEnd < minutelyHolidayEnd) {
                    exclusion += restStart - minutelyHolidayStart;
                    minutelyHolidayStart = restEnd;
                    continue;
                }
                if (minutelyHolidayStart >= restStart && minutelyHolidayEnd > restEnd) {
                    minutelyHolidayStart = restEnd;
                }
                if (minutelyHolidayStart >= restStart || minutelyHolidayEnd > restEnd) continue;
                minutelyHolidayEnd = restStart;
            }
            exclusion += minutelyHolidayEnd - minutelyHolidayStart;
        }
        this.calcBeforeMinutelyHolidayMinute();
        int paidLeave = 0;
        for (Map.Entry entry : this.paidLeaveHourMap.entrySet()) {
            int paidLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int paidLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (paidLeaveStart >= this.calculatedStart) continue;
            if (paidLeaveEnd > this.calculatedStart) {
                paidLeaveEnd = this.calculatedStart;
            }
            paidLeave += paidLeaveEnd - paidLeaveStart;
            for (Map.Entry restEntry : this.tardinessRestMap.entrySet()) {
                int restStart3 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                int restEnd3 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (paidLeaveStart >= restStart3 && restEnd3 >= paidLeaveEnd) {
                    paidLeaveStart = 0;
                    paidLeaveEnd = 0;
                    break;
                }
                if (paidLeaveStart >= restEnd3 || paidLeaveEnd <= restStart3) continue;
                if (paidLeaveStart < restStart3 && restEnd3 < paidLeaveEnd) {
                    exclusion += restStart3 - paidLeaveStart;
                    paidLeaveStart = restEnd3;
                    continue;
                }
                if (paidLeaveStart >= restStart3 && paidLeaveEnd > restEnd3) {
                    paidLeaveStart = restEnd3;
                }
                if (paidLeaveStart >= restStart3 || paidLeaveEnd > restEnd3) continue;
                paidLeaveEnd = restStart3;
            }
            exclusion += paidLeaveEnd - paidLeaveStart;
        }
        this.beforePaidLeaveMinute = paidLeave;
        int specialLeave = 0;
        for (Map.Entry entry : this.specialLeaveHourMap.entrySet()) {
            int specialLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int specialLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (specialLeaveStart >= this.calculatedStart) continue;
            if (specialLeaveEnd > this.calculatedStart) {
                specialLeaveEnd = this.calculatedStart;
            }
            specialLeave += specialLeaveEnd - specialLeaveStart;
            for (Map.Entry restEntry : this.tardinessRestMap.entrySet()) {
                int restStart4 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                int restEnd4 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (specialLeaveStart >= restStart4 && restEnd4 >= specialLeaveEnd) {
                    specialLeaveStart = 0;
                    specialLeaveEnd = 0;
                    break;
                }
                if (specialLeaveStart >= restEnd4 || specialLeaveEnd <= restStart4) continue;
                if (specialLeaveStart < restStart4 && restEnd4 < specialLeaveEnd) {
                    exclusion += restStart4 - specialLeaveStart;
                    specialLeaveStart = restEnd4;
                    continue;
                }
                if (specialLeaveStart >= restStart4 && specialLeaveEnd > restEnd4) {
                    specialLeaveStart = restEnd4;
                }
                if (specialLeaveStart >= restStart4 || specialLeaveEnd > restEnd4) continue;
                specialLeaveEnd = restStart4;
            }
            exclusion += specialLeaveEnd - specialLeaveStart;
        }
        this.beforeSpecialLeaveMinute = specialLeave;
        int otherLeave = 0;
        for (Map.Entry entry : this.otherLeaveHourMap.entrySet()) {
            int otherLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int otherLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (otherLeaveStart >= this.calculatedStart) continue;
            if (otherLeaveEnd > this.calculatedStart) {
                otherLeaveEnd = this.calculatedStart;
            }
            otherLeave += otherLeaveEnd - otherLeaveStart;
            for (Map.Entry restEntry : this.tardinessRestMap.entrySet()) {
                int restStart5 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                int restEnd5 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (otherLeaveStart >= restStart5 && restEnd5 >= otherLeaveEnd) {
                    otherLeaveStart = 0;
                    otherLeaveEnd = 0;
                    break;
                }
                if (otherLeaveStart >= restEnd5 || otherLeaveEnd <= restStart5) continue;
                if (otherLeaveStart < restStart5 && restEnd5 < otherLeaveEnd) {
                    exclusion += restStart5 - otherLeaveStart;
                    otherLeaveStart = restEnd5;
                    continue;
                }
                if (otherLeaveStart >= restStart5 && otherLeaveEnd > restEnd5) {
                    otherLeaveStart = restEnd5;
                }
                if (otherLeaveStart >= restStart5 || otherLeaveEnd > restEnd5) continue;
                otherLeaveEnd = restStart5;
            }
            exclusion += otherLeaveEnd - otherLeaveStart;
        }
        this.beforeOtherLeaveMinute = otherLeave;
        int absenceLeave = 0;
        for (Map.Entry entry : this.absenceHourMap.entrySet()) {
            int absenceLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int absenceLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (absenceLeaveStart >= this.calculatedStart) continue;
            if (absenceLeaveEnd > this.calculatedStart) {
                absenceLeaveEnd = this.calculatedStart;
            }
            absenceLeave += absenceLeaveEnd - absenceLeaveStart;
            for (Map.Entry restEntry : this.tardinessRestMap.entrySet()) {
                int restStart6 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                int restEnd6 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (absenceLeaveStart >= restStart6 && restEnd6 >= absenceLeaveEnd) {
                    absenceLeaveStart = 0;
                    absenceLeaveEnd = 0;
                    break;
                }
                if (absenceLeaveStart >= restEnd6 || absenceLeaveEnd <= restStart6) continue;
                if (absenceLeaveStart < restStart6 && restEnd6 < absenceLeaveEnd) {
                    exclusion += restStart6 - absenceLeaveStart;
                    absenceLeaveStart = restEnd6;
                    continue;
                }
                if (absenceLeaveStart >= restStart6 && absenceLeaveEnd > restEnd6) {
                    absenceLeaveStart = restEnd6;
                }
                if (absenceLeaveStart >= restStart6 || absenceLeaveEnd > restEnd6) continue;
                absenceLeaveEnd = restStart6;
            }
            exclusion += absenceLeaveEnd - absenceLeaveStart;
        }
        this.beforeAbsenceLeaveMinute = absenceLeave;
        int tardinessWorkStart = this.calculatedStart;
        int tardinessRegWorkStart = this.regWorkStart;
        if (!this.isAmHalfDayOff(requestUtil) && this.useShort1) {
            tardinessRegWorkStart = this.short1End;
        }
        if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.calculatedStart > this.short2Start) {
            tardinessWorkStart = this.short2Start;
        }
        if ((result = tardinessWorkStart - tardinessRegWorkStart - exclusion) < 0) {
            result = 0;
        }
        if (result > this.prescribedWorkTime) {
            result = this.prescribedWorkTime;
        }
        this.lateTime = this.getRoundMinute(result, this.timeSettingDto.getRoundDailyLate(), this.timeSettingDto.getRoundDailyLateUnit());
    }

    protected void calcLeaveEarlyTime(RequestUtilBeanInterface requestUtil) throws MospException {
        int result;
        int restEnd;
        int restStart;
        int minutelyHolidayEnd;
        int minutelyHolidayStart;
        if (this.isWorkOnLegalDaysOff() || this.isWorkOnPrescribedDaysOff()) {
            return;
        }
        if (this.allMinutelyHolidayA || this.allMinutelyHolidayB) {
            return;
        }
        int exclusion = 0;
        for (Map.Entry entry : this.regRestMap.entrySet()) {
            int restStart2 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int restEnd2 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (restEnd2 <= this.calculatedEnd) continue;
            if (restStart2 < this.calculatedEnd) {
                restStart2 = this.calculatedEnd;
            }
            exclusion += restEnd2 - restStart2;
            this.leaveEarlyRestMap.put(this.getAttendanceTime(this.workDate, restStart2), this.getAttendanceTime(this.workDate, restEnd2));
        }
        for (Map.Entry entry : this.minutelyHolidayAMap.entrySet()) {
            minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (minutelyHolidayEnd <= this.calculatedEnd) continue;
            if (minutelyHolidayStart < this.calculatedEnd) {
                minutelyHolidayStart = this.calculatedEnd;
            }
            for (Map.Entry restEntry : this.leaveEarlyRestMap.entrySet()) {
                restStart = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                restEnd = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (minutelyHolidayStart >= restStart && restEnd >= minutelyHolidayEnd) {
                    minutelyHolidayStart = 0;
                    minutelyHolidayEnd = 0;
                    break;
                }
                if (minutelyHolidayStart >= restEnd || minutelyHolidayEnd <= restStart) continue;
                if (minutelyHolidayStart < restStart && restEnd < minutelyHolidayEnd) {
                    exclusion += restStart - minutelyHolidayStart;
                    minutelyHolidayStart = restEnd;
                    continue;
                }
                if (minutelyHolidayStart >= restStart && minutelyHolidayEnd > restEnd) {
                    minutelyHolidayStart = restEnd;
                }
                if (minutelyHolidayStart >= restStart || minutelyHolidayEnd > restEnd) continue;
                minutelyHolidayEnd = restStart;
            }
            exclusion += minutelyHolidayEnd - minutelyHolidayStart;
        }
        for (Map.Entry entry : this.minutelyHolidayBMap.entrySet()) {
            minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (minutelyHolidayEnd <= this.calculatedEnd) continue;
            if (minutelyHolidayStart < this.calculatedEnd) {
                minutelyHolidayStart = this.calculatedEnd;
            }
            for (Map.Entry restEntry : this.leaveEarlyRestMap.entrySet()) {
                restStart = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                restEnd = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (minutelyHolidayStart >= restStart && restEnd >= minutelyHolidayEnd) {
                    minutelyHolidayStart = 0;
                    minutelyHolidayEnd = 0;
                    break;
                }
                if (minutelyHolidayStart >= restEnd || minutelyHolidayEnd <= restStart) continue;
                if (minutelyHolidayStart < restStart && restEnd < minutelyHolidayEnd) {
                    exclusion += restStart - minutelyHolidayStart;
                    minutelyHolidayStart = restEnd;
                    continue;
                }
                if (minutelyHolidayStart >= restStart && minutelyHolidayEnd > restEnd) {
                    minutelyHolidayStart = restEnd;
                }
                if (minutelyHolidayStart >= restStart || minutelyHolidayEnd > restEnd) continue;
                minutelyHolidayEnd = restStart;
            }
            exclusion += minutelyHolidayEnd - minutelyHolidayStart;
        }
        this.calcAfterMinutelyHolidayMinute();
        int paidLeave = 0;
        for (Map.Entry entry : this.paidLeaveHourMap.entrySet()) {
            int paidLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int paidLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (paidLeaveEnd <= this.calculatedEnd) continue;
            if (paidLeaveStart < this.calculatedEnd) {
                paidLeaveStart = this.calculatedEnd;
            }
            paidLeave += paidLeaveEnd - paidLeaveStart;
            for (Map.Entry restEntry : this.leaveEarlyRestMap.entrySet()) {
                int restStart3 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                int restEnd3 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (paidLeaveStart >= restStart3 && restEnd3 >= paidLeaveEnd) {
                    paidLeaveStart = 0;
                    paidLeaveEnd = 0;
                    break;
                }
                if (paidLeaveStart >= restEnd3 || paidLeaveEnd <= restStart3) continue;
                if (paidLeaveStart < restStart3 && restEnd3 < paidLeaveEnd) {
                    exclusion += restStart3 - paidLeaveStart;
                    paidLeaveStart = restEnd3;
                    continue;
                }
                if (paidLeaveStart >= restStart3 && paidLeaveEnd > restEnd3) {
                    paidLeaveStart = restEnd3;
                }
                if (paidLeaveStart >= restStart3 || paidLeaveEnd > restEnd3) continue;
                paidLeaveEnd = restStart3;
            }
            exclusion += paidLeaveEnd - paidLeaveStart;
        }
        this.afterPaidLeaveMinute = paidLeave;
        int specialLeave = 0;
        for (Map.Entry entry : this.specialLeaveHourMap.entrySet()) {
            int specialLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int specialLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (specialLeaveEnd <= this.calculatedEnd) continue;
            if (specialLeaveStart < this.calculatedEnd) {
                specialLeaveStart = this.calculatedEnd;
            }
            specialLeave += specialLeaveEnd - specialLeaveStart;
            for (Map.Entry restEntry : this.leaveEarlyRestMap.entrySet()) {
                int restStart4 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                int restEnd4 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (specialLeaveStart >= restStart4 && restEnd4 >= specialLeaveEnd) {
                    specialLeaveStart = 0;
                    specialLeaveEnd = 0;
                    break;
                }
                if (specialLeaveStart >= restEnd4 || specialLeaveEnd <= restStart4) continue;
                if (specialLeaveStart < restStart4 && restEnd4 < specialLeaveEnd) {
                    exclusion += restStart4 - specialLeaveStart;
                    specialLeaveStart = restEnd4;
                    continue;
                }
                if (specialLeaveStart >= restStart4 && specialLeaveEnd > restEnd4) {
                    specialLeaveStart = restEnd4;
                }
                if (specialLeaveStart >= restStart4 || specialLeaveEnd > restEnd4) continue;
                specialLeaveEnd = restStart4;
            }
            exclusion += specialLeaveEnd - specialLeaveStart;
        }
        this.afterSpecialLeaveMinute = specialLeave;
        int otherLeave = 0;
        for (Map.Entry entry : this.otherLeaveHourMap.entrySet()) {
            int otherLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int otherLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (otherLeaveEnd <= this.calculatedEnd) continue;
            if (otherLeaveStart < this.calculatedEnd) {
                otherLeaveStart = this.calculatedEnd;
            }
            otherLeave += otherLeaveEnd - otherLeaveStart;
            for (Map.Entry restEntry : this.leaveEarlyRestMap.entrySet()) {
                int restStart5 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                int restEnd5 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (otherLeaveStart >= restStart5 && restEnd5 >= otherLeaveEnd) {
                    otherLeaveStart = 0;
                    otherLeaveEnd = 0;
                    break;
                }
                if (otherLeaveStart >= restEnd5 || otherLeaveEnd <= restStart5) continue;
                if (otherLeaveStart < restStart5 && restEnd5 < otherLeaveEnd) {
                    exclusion += restStart5 - otherLeaveStart;
                    otherLeaveStart = restEnd5;
                    continue;
                }
                if (otherLeaveStart >= restStart5 && otherLeaveEnd > restEnd5) {
                    otherLeaveStart = restEnd5;
                }
                if (otherLeaveStart >= restStart5 || otherLeaveEnd > restEnd5) continue;
                otherLeaveEnd = restStart5;
            }
            exclusion += otherLeaveEnd - otherLeaveStart;
        }
        this.afterOtherLeaveMinute = otherLeave;
        int absenceLeave = 0;
        for (Map.Entry entry : this.absenceHourMap.entrySet()) {
            int absenceLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int absenceLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (absenceLeaveEnd <= this.calculatedEnd) continue;
            if (absenceLeaveStart < this.calculatedEnd) {
                absenceLeaveStart = this.calculatedEnd;
            }
            absenceLeave += absenceLeaveEnd - absenceLeaveStart;
            for (Map.Entry restEntry : this.leaveEarlyRestMap.entrySet()) {
                int restStart6 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getKey());
                int restEnd6 = this.getDefferenceMinutes(this.workDate, (Date)restEntry.getValue());
                if (absenceLeaveStart >= restStart6 && restEnd6 >= absenceLeaveEnd) {
                    absenceLeaveStart = 0;
                    absenceLeaveEnd = 0;
                    break;
                }
                if (absenceLeaveStart >= restEnd6 || absenceLeaveEnd <= restStart6) continue;
                if (absenceLeaveStart < restStart6 && restEnd6 < absenceLeaveEnd) {
                    exclusion += restStart6 - absenceLeaveStart;
                    absenceLeaveStart = restEnd6;
                    continue;
                }
                if (absenceLeaveStart >= restStart6 && absenceLeaveEnd > restEnd6) {
                    absenceLeaveStart = restEnd6;
                }
                if (absenceLeaveStart >= restStart6 || absenceLeaveEnd > restEnd6) continue;
                absenceLeaveEnd = restStart6;
            }
            exclusion += absenceLeaveEnd - absenceLeaveStart;
        }
        this.afterAbsenceLeaveMinute = absenceLeave;
        int leaveEarlyWorkEnd = this.calculatedEnd;
        int leaveEarlyRegWorkEnd = this.regWorkEnd;
        if (!this.isAmHalfDayOff(requestUtil) && this.useShort1 && this.calculatedEnd < this.short1End) {
            leaveEarlyWorkEnd = this.short1End;
        }
        if (!this.isPmHalfDayOff(requestUtil) && this.useShort2) {
            leaveEarlyRegWorkEnd = this.short2Start;
        }
        if ((result = leaveEarlyRegWorkEnd - leaveEarlyWorkEnd - exclusion) < 0) {
            result = 0;
        }
        if (result > this.prescribedWorkTime) {
            result = this.prescribedWorkTime;
        }
        this.leaveEarlyTime = this.getRoundMinute(result, this.timeSettingDto.getRoundDailyLeaveEarly(), this.timeSettingDto.getRoundDailyLeaveEarlyUnit());
    }

    protected void calcOvertimeWork(RequestUtilBeanInterface requestUtil) throws MospException {
        int end;
        int start;
        int end2;
        int start2;
        int end3;
        int start3;
        int end4;
        int end5;
        int start4;
        boolean nextDayWorkOnLegalDaysOff;
        boolean bl = nextDayWorkOnLegalDaysOff = this.isNextDayWorkOnLegalDaysOff() || this.isNextDayLegalDaysOff();
        if (this.isWorkOnLegalDaysOff() && nextDayWorkOnLegalDaysOff) {
            return;
        }
        int twentyFourHours = 1440;
        int before24HourManualRest = 0;
        for (RestDtoInterface dto : this.restDtoList) {
            Date startTime = this.getRoundMinute(dto.getRestStart(), this.timeSettingDto.getRoundDailyRestStart(), this.timeSettingDto.getRoundDailyRestStartUnit());
            Date endTime = this.getRoundMinute(dto.getRestEnd(), this.timeSettingDto.getRoundDailyRestEnd(), this.timeSettingDto.getRoundDailyRestEndUnit());
            start4 = this.getDefferenceMinutes(this.workDate, startTime);
            end5 = this.getDefferenceMinutes(this.workDate, endTime);
            if (start4 >= twentyFourHours) continue;
            if (end5 > twentyFourHours) {
                end5 = twentyFourHours;
            }
            before24HourManualRest += this.getRoundMinute(end5 - start4, this.timeSettingDto.getRoundDailyRestTime(), this.timeSettingDto.getRoundDailyRestTimeUnit());
        }
        this.totalBefore24HourManualRest = before24HourManualRest;
        int before24HourOvertimeBeforeRest = 0;
        for (Map.Entry entry : this.overtimeBeforeRestMap.entrySet()) {
            int start5 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int end6 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start5 >= twentyFourHours) continue;
            if (end6 > twentyFourHours) {
                end6 = twentyFourHours;
            }
            before24HourOvertimeBeforeRest += end6 - start5;
        }
        this.totalBefore24HourOvertimeBeforeRest = before24HourOvertimeBeforeRest;
        int before24HourOvertimeRest = 0;
        for (Map.Entry entry : this.overtimeRestMap.entrySet()) {
            start4 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            end5 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start4 >= twentyFourHours) continue;
            if (end5 > twentyFourHours) {
                end5 = twentyFourHours;
            }
            before24HourOvertimeRest += end5 - start4;
        }
        this.totalBefore24HourOvertimeRest = before24HourOvertimeRest;
        int before24HourPublicGoOut = 0;
        for (GoOutDtoInterface dto : this.publicGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPublicStart(), this.timeSettingDto.getRoundDailyPublicStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPublicEnd(), this.timeSettingDto.getRoundDailyPublicEndUnit());
            int start6 = this.getDefferenceMinutes(this.workDate, startTime);
            end4 = this.getDefferenceMinutes(this.workDate, endTime);
            if (start6 >= twentyFourHours) continue;
            if (end4 > twentyFourHours) {
                end4 = twentyFourHours;
            }
            before24HourPublicGoOut += end4 - start6;
        }
        this.totalBefore24HourPublicGoOut = before24HourPublicGoOut;
        int before24HourPrivateGoOut = 0;
        for (GoOutDtoInterface dto : this.privateGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPrivateStart(), this.timeSettingDto.getRoundDailyPrivateStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPrivateEnd(), this.timeSettingDto.getRoundDailyPrivateEndUnit());
            start3 = this.getDefferenceMinutes(this.workDate, startTime);
            end3 = this.getDefferenceMinutes(this.workDate, endTime);
            if (start3 >= twentyFourHours) continue;
            if (end3 > twentyFourHours) {
                end3 = twentyFourHours;
            }
            before24HourPrivateGoOut += end3 - start3;
        }
        this.totalBefore24HourPrivateGoOut = before24HourPrivateGoOut;
        this.calcBeforeMinutelyHolidayMinute();
        this.calcAfterMinutelyHolidayMinute();
        int before24HourMinutelyHolidayA = 0;
        for (Map.Entry entry : this.minutelyHolidayAMap.entrySet()) {
            int start7 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            end4 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start7 >= twentyFourHours || end4 <= this.calculatedStart) continue;
            if (start7 < this.calculatedStart) {
                start7 = this.calculatedStart;
            }
            if (end4 > twentyFourHours) {
                end4 = twentyFourHours;
            }
            before24HourMinutelyHolidayA += end4 - start7;
        }
        this.totalBefore24HourMinutelyHolidayA = before24HourMinutelyHolidayA;
        int before24HourMinutelyHolidayB = 0;
        for (Map.Entry entry : this.minutelyHolidayBMap.entrySet()) {
            start3 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            end3 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start3 >= twentyFourHours || end3 <= this.calculatedStart) continue;
            if (start3 < this.calculatedStart) {
                start3 = this.calculatedStart;
            }
            if (end3 > twentyFourHours) {
                end3 = twentyFourHours;
            }
            before24HourMinutelyHolidayB += end3 - start3;
        }
        this.totalBefore24HourMinutelyHolidayB = before24HourMinutelyHolidayB;
        int after24HourPaidLeave = 0;
        for (Map.Entry entry : this.paidLeaveHourMap.entrySet()) {
            int start8 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int end7 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start8 >= this.calculatedEnd || end7 <= twentyFourHours) continue;
            if (start8 < twentyFourHours) {
                start8 = twentyFourHours;
            }
            if (end7 > this.calculatedEnd) {
                // empty if block
            }
            after24HourPaidLeave += end7 - start8;
        }
        this.totalAfter24HourPaidLeave = after24HourPaidLeave;
        int after24HourSpecialLeave = 0;
        for (Map.Entry entry : this.specialLeaveHourMap.entrySet()) {
            int start9 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int end8 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start9 >= this.calculatedEnd || end8 <= twentyFourHours) continue;
            if (start9 < twentyFourHours) {
                start9 = twentyFourHours;
            }
            if (end8 > this.calculatedEnd) {
                // empty if block
            }
            after24HourSpecialLeave += end8 - start9;
        }
        this.totalAfter24HourSpecialLeave = after24HourSpecialLeave;
        int after24HourOtherLeave = 0;
        for (Map.Entry entry : this.otherLeaveHourMap.entrySet()) {
            int start10 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int end9 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start10 >= this.calculatedEnd || end9 <= twentyFourHours) continue;
            if (start10 < twentyFourHours) {
                start10 = twentyFourHours;
            }
            if (end9 > this.calculatedEnd) {
                // empty if block
            }
            after24HourOtherLeave += end9 - start10;
        }
        this.totalAfter24HourOtherLeave = after24HourOtherLeave;
        int after24HourAbsenceLeave = 0;
        for (Map.Entry entry : this.absenceHourMap.entrySet()) {
            int start11 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int end10 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start11 >= this.calculatedEnd || end10 <= twentyFourHours) continue;
            if (start11 < twentyFourHours) {
                start11 = twentyFourHours;
            }
            if (end10 > this.calculatedEnd) {
                // empty if block
            }
            after24HourAbsenceLeave += end10 - start11;
        }
        this.totalAfter24HourAbsenceLeave = after24HourAbsenceLeave;
        int after24HourManualRest = 0;
        for (RestDtoInterface dto : this.restDtoList) {
            Date startTime = this.getRoundMinute(dto.getRestStart(), this.timeSettingDto.getRoundDailyRestStart(), this.timeSettingDto.getRoundDailyRestStartUnit());
            Date endTime = this.getRoundMinute(dto.getRestEnd(), this.timeSettingDto.getRoundDailyRestEnd(), this.timeSettingDto.getRoundDailyRestEndUnit());
            start2 = this.getDefferenceMinutes(this.workDate, startTime);
            end2 = this.getDefferenceMinutes(this.workDate, endTime);
            if (end2 <= twentyFourHours) continue;
            if (start2 < twentyFourHours) {
                start2 = twentyFourHours;
            }
            after24HourManualRest += this.getRoundMinute(end2 - start2, this.timeSettingDto.getRoundDailyRestTime(), this.timeSettingDto.getRoundDailyRestTimeUnit());
        }
        this.totalAfter24HourManualRest = after24HourManualRest;
        int after24HourOvertimeBeforeRest = 0;
        for (Map.Entry entry : this.overtimeBeforeRestMap.entrySet()) {
            int start12 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int end11 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (end11 <= twentyFourHours) continue;
            if (start12 < twentyFourHours) {
                start12 = twentyFourHours;
            }
            after24HourOvertimeBeforeRest += end11 - start12;
        }
        this.totalAfter24HourOvertimeBeforeRest = after24HourOvertimeBeforeRest;
        int after24HourOvertimeRest = 0;
        for (Map.Entry entry : this.overtimeRestMap.entrySet()) {
            start2 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            end2 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (end2 <= twentyFourHours) continue;
            if (start2 < twentyFourHours) {
                start2 = twentyFourHours;
            }
            after24HourOvertimeRest += end2 - start2;
        }
        this.totalAfter24HourOvertimeRest = after24HourOvertimeRest;
        int after24HourPublicGoOut = 0;
        for (GoOutDtoInterface dto : this.publicGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPublicStart(), this.timeSettingDto.getRoundDailyPublicStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPublicEnd(), this.timeSettingDto.getRoundDailyPublicEndUnit());
            int start13 = this.getDefferenceMinutes(this.workDate, startTime);
            int end12 = this.getDefferenceMinutes(this.workDate, endTime);
            if (end12 <= twentyFourHours) continue;
            if (start13 < twentyFourHours) {
                start13 = twentyFourHours;
            }
            after24HourPublicGoOut += end12 - start13;
        }
        this.totalAfter24HourPublicGoOut = after24HourPublicGoOut;
        int after24HourPrivateGoOut = 0;
        for (GoOutDtoInterface dto : this.privateGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPrivateStart(), this.timeSettingDto.getRoundDailyPrivateStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPrivateEnd(), this.timeSettingDto.getRoundDailyPrivateEndUnit());
            start = this.getDefferenceMinutes(this.workDate, startTime);
            end = this.getDefferenceMinutes(this.workDate, endTime);
            if (end <= twentyFourHours) continue;
            if (start < twentyFourHours) {
                start = twentyFourHours;
            }
            after24HourPrivateGoOut += end - start;
        }
        this.totalAfter24HourPrivateGoOut = after24HourPrivateGoOut;
        if (!this.isWorkOnLegalDaysOff() && this.calculatedEnd <= twentyFourHours || !this.isWorkOnLegalDaysOff() && !nextDayWorkOnLegalDaysOff) {
            int totalManualRest = 0;
            for (RestDtoInterface dto : this.restDtoList) {
                totalManualRest += dto.getRestTime();
            }
            int totalOvertimeBeforeRest = 0;
            for (Map.Entry entry : this.overtimeBeforeRestMap.entrySet()) {
                start = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                end = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                totalOvertimeBeforeRest += end - start;
            }
            int totalOvertimeRest = 0;
            for (Map.Entry entry : this.overtimeRestMap.entrySet()) {
                int start14 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                int end13 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                totalOvertimeRest += end13 - start14;
            }
            int overtime = this.calcOverTime(totalManualRest, totalOvertimeRest, totalOvertimeBeforeRest, this.totalPublic, this.totalPrivate, this.beforeMinutelyHolidayMinute, this.afterMinutelyHolidayMinute, requestUtil);
            this.overtimeTime = this.getRoundMinute(overtime, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
        } else if (!this.isWorkOnLegalDaysOff() && nextDayWorkOnLegalDaysOff && this.calculatedEnd > twentyFourHours) {
            int overtime = this.getcalcOvertimeWorkCaseWorkDay(this.calculatedStart, this.totalBefore24HourManualRest, this.totalBefore24HourOvertimeBeforeRest, this.totalBefore24HourOvertimeRest, this.totalBefore24HourPublicGoOut, this.totalBefore24HourPrivateGoOut, this.totalBefore24HourMinutelyHolidayA, this.totalBefore24HourMinutelyHolidayB, this.prescribedWorkTime, this.lateTime, this.leaveEarlyTime, requestUtil);
            if (overtime < 0) {
                overtime = 0;
            }
            this.overtimeTime = this.getRoundMinute(overtime, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
        } else if (this.isWorkOnLegalDaysOff() && !nextDayWorkOnLegalDaysOff && this.calculatedEnd > twentyFourHours) {
            int nextDayWork = this.getNextDayTime(this.calculatedEnd, this.totalAfter24HourManualRest, this.totalAfter24HourOvertimeBeforeRest, this.totalAfter24HourOvertimeRest, this.totalAfter24HourPublicGoOut, this.totalAfter24HourPrivateGoOut);
            if (nextDayWork < 0) {
                nextDayWork = 0;
            }
            this.overtimeTime = this.getRoundMinute(nextDayWork, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
        }
        int afterTime = this.overtimeTime - this.workBeforeTime;
        if (afterTime < 0) {
            afterTime = 0;
        }
        this.workAfterTime = afterTime;
    }

    protected int getOvertimeWorkCaseLegalDay(int calculatedStart, int before24HourManualRest, int before24HourOvertimeBeforeRest, int before24HourOvertimeRest, int before24HourPublicGoOut, int before24HourPrivateGoOut, int before24HourMinutelyHolidayA, int before24HourMinutelyHolidayB) {
        return 1440 - calculatedStart - before24HourManualRest - before24HourOvertimeBeforeRest - before24HourOvertimeRest - before24HourPublicGoOut - before24HourOvertimeRest - before24HourMinutelyHolidayB;
    }

    protected int getcalcOvertimeWorkCasePrescribedDay(int calculatedStart, int before24HourManualRest, int before24HourOvertimeBeforeRest, int before24HourOvertimeRest, int before24HourPublicGoOut, int before24HourPrivateGoOut, int before24HourMinutelyHolidayA, int before24HourMinutelyHolidayB) {
        return 1440 - calculatedStart - before24HourManualRest - before24HourOvertimeBeforeRest - before24HourOvertimeRest - before24HourPublicGoOut - before24HourMinutelyHolidayA - before24HourMinutelyHolidayB;
    }

    protected int getcalcOvertimeWorkCaseWorkDay(int calculatedStart, int before24HourManualRest, int before24HourOvertimeBeforeRest, int before24HourOvertimeRest, int before24HourPublicGoOut, int before24HourPrivateGoOut, int before24HourMinutelyHolidayA, int before24HourMinutelyHolidayB, int prescribedWorkTime, int lateTime, int leaveEarlyTime, RequestUtilBeanInterface requestUtil) throws MospException {
        if (calculatedStart >= this.regWorkStart) {
            int overtime = this.calcOvertime(calculatedStart, before24HourManualRest, before24HourOvertimeBeforeRest, before24HourOvertimeRest, before24HourMinutelyHolidayB, before24HourPublicGoOut, before24HourMinutelyHolidayA, prescribedWorkTime, lateTime, leaveEarlyTime);
            if (this.useShort1) {
                if (this.isAmHalfDayOff(requestUtil)) {
                    if (!this.isShort1StartTypePay && this.short1Start < 1440) {
                        overtime = this.short1End < 1440 ? (overtime -= this.short1End - this.short1Start) : (overtime -= 1440 - this.short1Start);
                    }
                } else if (this.isShort1StartTypePay && calculatedStart > this.short1End && this.short1Start < 1440) {
                    overtime = this.short1End < 1440 ? (overtime += this.short1End - this.short1Start) : (overtime += 1440 - this.short1Start);
                }
            }
            if (this.useShort2) {
                if (this.isPmHalfDayOff(requestUtil)) {
                    if (!this.isShort2StartTypePay && this.short2Start < 1440) {
                        overtime = this.short2End < 1440 ? (overtime -= this.short2End - this.short2Start) : (overtime -= 1440 - this.short2Start);
                    }
                } else if (this.isShort2StartTypePay && this.calculatedEnd < this.short2Start && this.short2Start < 1440) {
                    overtime = this.short2End < 1440 ? (overtime += this.short2End - this.short2Start) : (overtime += 1440 - this.short2Start);
                }
            }
            return overtime;
        }
        int overtime = this.calcOvertime(this.regWorkStart, before24HourManualRest, before24HourOvertimeBeforeRest, before24HourOvertimeRest, before24HourMinutelyHolidayB, before24HourPublicGoOut, before24HourMinutelyHolidayA, prescribedWorkTime, lateTime, leaveEarlyTime);
        if (this.useShort1) {
            if (this.isAmHalfDayOff(requestUtil)) {
                if (!this.isShort1StartTypePay && this.short1Start < 1440) {
                    overtime = this.short1End < 1440 ? (overtime -= this.short1End - this.short1Start) : (overtime -= 1440 - this.short1Start);
                }
            } else if (this.isShort1StartTypePay && calculatedStart > this.short1End && this.short1Start < 1440) {
                overtime = this.short1End < 1440 ? (overtime += this.short1End - this.short1Start) : (overtime += 1440 - this.short1Start);
            }
        }
        if (this.useShort2) {
            if (this.isPmHalfDayOff(requestUtil)) {
                if (!this.isShort2StartTypePay && this.short2Start < 1440) {
                    overtime = this.short2End < 1440 ? (overtime -= this.short2End - this.short2Start) : (overtime -= 1440 - this.short2Start);
                }
            } else if (this.isShort2StartTypePay && this.calculatedEnd < this.short2Start && this.short2Start < 1440) {
                overtime = this.short2End < 1440 ? (overtime += this.short2End - this.short2Start) : (overtime += 1440 - this.short2Start);
            }
        }
        if (overtime > 0) {
            return overtime + this.workBeforeTime;
        }
        return this.workBeforeTime;
    }

    protected int calcOvertime(int startTime, int before24HourManualRest, int before24HourOvertimeBeforeRest, int before24HourOvertimeRest, int before24HourMinutelyHolidayB, int before24HourPublicGoOut, int before24HourMinutelyHolidayA, int prescribedWorkTime, int lateTime, int leaveEarlyTime) {
        return 1440 - startTime - before24HourManualRest - before24HourOvertimeBeforeRest - before24HourOvertimeRest - before24HourPublicGoOut - before24HourMinutelyHolidayA - before24HourMinutelyHolidayB - prescribedWorkTime + lateTime + leaveEarlyTime + this.beforePaidLeaveMinute + this.beforeSpecialLeaveMinute + this.beforeOtherLeaveMinute + this.beforeAbsenceLeaveMinute + this.beforeMinutelyHolidayMinute;
    }

    protected int getNextDayTime(int calculatedEnd, int after24HourManualRest, int after24HourOvertimeBeforeRest, int after24HourOvertimeRest, int after24HourPublicGoOut, int after24HourPrivateGoOut) {
        return calculatedEnd - 1440 - after24HourManualRest - after24HourOvertimeBeforeRest - after24HourOvertimeRest - after24HourPublicGoOut;
    }

    protected int getNextDayHolidayWork() {
        return this.calculatedEnd - 1440 - this.totalAfter24HourManualRest - this.totalAfter24HourOvertimeBeforeRest - this.totalAfter24HourOvertimeRest - this.totalAfter24HourPublicGoOut - this.totalAfter24HourPrivateGoOut - this.totalAfter24HourPaidLeave - this.totalAfter24HourSpecialLeave - this.totalAfter24HourOtherLeave - this.totalAfter24HourAbsenceLeave;
    }

    protected int getWorkTime(int start, int end) {
        int endTimeInt;
        int startTimeInt;
        int paidLeave = 0;
        for (Map.Entry entry : this.paidLeaveHourMap.entrySet()) {
            int paidLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int paidLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (paidLeaveStart >= end || paidLeaveEnd <= start) continue;
            if (paidLeaveStart < start) {
                paidLeaveStart = start;
            }
            if (paidLeaveEnd > end) {
                paidLeaveEnd = end;
            }
            paidLeave += paidLeaveEnd - paidLeaveStart;
        }
        int specialLeave = 0;
        for (Map.Entry entry : this.specialLeaveHourMap.entrySet()) {
            int specialLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int specialLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (specialLeaveStart >= end || specialLeaveEnd <= start) continue;
            if (specialLeaveStart < start) {
                specialLeaveStart = start;
            }
            if (specialLeaveEnd > end) {
                specialLeaveEnd = end;
            }
            specialLeave += specialLeaveEnd - specialLeaveStart;
        }
        int otherLeave = 0;
        for (Map.Entry entry : this.otherLeaveHourMap.entrySet()) {
            int otherLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int otherLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (otherLeaveStart >= end || otherLeaveEnd <= start) continue;
            if (otherLeaveStart < start) {
                otherLeaveStart = start;
            }
            if (otherLeaveEnd > end) {
                otherLeaveEnd = end;
            }
            otherLeave += otherLeaveEnd - otherLeaveStart;
        }
        int absenceLeave = 0;
        for (Map.Entry entry : this.absenceHourMap.entrySet()) {
            int absenceLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int absenceLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (absenceLeaveStart >= end || absenceLeaveEnd <= start) continue;
            if (absenceLeaveStart < start) {
                absenceLeaveStart = start;
            }
            if (absenceLeaveEnd > end) {
                absenceLeaveEnd = end;
            }
            absenceLeave += absenceLeaveEnd - absenceLeaveStart;
        }
        int rest = 0;
        for (RestDtoInterface dto : this.restDtoList) {
            Date startTime = this.getRoundMinute(dto.getRestStart(), this.timeSettingDto.getRoundDailyRestStart(), this.timeSettingDto.getRoundDailyRestStartUnit());
            Date endTime = this.getRoundMinute(dto.getRestEnd(), this.timeSettingDto.getRoundDailyRestEnd(), this.timeSettingDto.getRoundDailyRestEndUnit());
            startTimeInt = this.getDefferenceMinutes(this.workDate, startTime);
            endTimeInt = this.getDefferenceMinutes(this.workDate, endTime);
            if (startTimeInt >= end || endTimeInt <= start) continue;
            if (startTimeInt < start) {
                startTimeInt = start;
            }
            if (endTimeInt > end) {
                endTimeInt = end;
            }
            rest += this.getRoundMinute(endTimeInt - startTimeInt, this.timeSettingDto.getRoundDailyRestTime(), this.timeSettingDto.getRoundDailyRestTimeUnit());
        }
        int overtimeBeforeRest = 0;
        for (Map.Entry entry : this.overtimeBeforeRestMap.entrySet()) {
            int startTimeInt2 = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int endTimeInt2 = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (startTimeInt2 >= end || endTimeInt2 <= start) continue;
            if (startTimeInt2 < start) {
                startTimeInt2 = start;
            }
            if (endTimeInt2 > end) {
                endTimeInt2 = end;
            }
            overtimeBeforeRest += endTimeInt2 - startTimeInt2;
        }
        int overtimeRest = 0;
        for (Map.Entry entry : this.overtimeRestMap.entrySet()) {
            startTimeInt = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            endTimeInt = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (startTimeInt >= end || endTimeInt <= start) continue;
            if (startTimeInt < start) {
                startTimeInt = start;
            }
            if (endTimeInt > end) {
                endTimeInt = end;
            }
            overtimeRest += endTimeInt - startTimeInt;
        }
        int publicGoOut = 0;
        for (GoOutDtoInterface dto : this.publicGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPublicStart(), this.timeSettingDto.getRoundDailyPublicStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPublicEnd(), this.timeSettingDto.getRoundDailyPublicEndUnit());
            int startTimeInt3 = this.getDefferenceMinutes(this.workDate, startTime);
            int endTimeInt3 = this.getDefferenceMinutes(this.workDate, endTime);
            if (startTimeInt3 >= end || endTimeInt3 <= start) continue;
            if (startTimeInt3 < start) {
                startTimeInt3 = start;
            }
            if (endTimeInt3 > end) {
                endTimeInt3 = end;
            }
            publicGoOut += endTimeInt3 - startTimeInt3;
        }
        int privateGoOut = 0;
        for (GoOutDtoInterface dto : this.privateGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPrivateStart(), this.timeSettingDto.getRoundDailyPrivateStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPrivateEnd(), this.timeSettingDto.getRoundDailyPrivateEndUnit());
            int startTimeInt4 = this.getDefferenceMinutes(this.workDate, startTime);
            int endTimeInt4 = this.getDefferenceMinutes(this.workDate, endTime);
            if (startTimeInt4 >= end || endTimeInt4 <= start) continue;
            if (startTimeInt4 < start) {
                startTimeInt4 = start;
            }
            if (endTimeInt4 > end) {
                endTimeInt4 = end;
            }
            privateGoOut += endTimeInt4 - startTimeInt4;
        }
        int minutelyHolidayA = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayADtoList) {
            Date startTime = dto.getGoOutStart();
            Date endTime = dto.getGoOutEnd();
            int startTimeInt5 = this.getDefferenceMinutes(this.workDate, startTime);
            int endTimeInt5 = this.getDefferenceMinutes(this.workDate, endTime);
            if (startTimeInt5 >= end || endTimeInt5 <= start) continue;
            if (startTimeInt5 < start) {
                startTimeInt5 = start;
            }
            if (endTimeInt5 > end) {
                endTimeInt5 = end;
            }
            minutelyHolidayA += endTimeInt5 - startTimeInt5;
        }
        int minutelyHolidayB = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayBDtoList) {
            Date startTime = dto.getGoOutStart();
            Date endTime = dto.getGoOutEnd();
            int startTimeInt6 = this.getDefferenceMinutes(this.workDate, startTime);
            int endTimeInt6 = this.getDefferenceMinutes(this.workDate, endTime);
            if (startTimeInt6 >= end || endTimeInt6 <= start) continue;
            if (startTimeInt6 < start) {
                startTimeInt6 = start;
            }
            if (endTimeInt6 > end) {
                endTimeInt6 = end;
            }
            minutelyHolidayB += endTimeInt6 - startTimeInt6;
        }
        return end - start - paidLeave - specialLeave - otherLeave - absenceLeave - rest - overtimeBeforeRest - overtimeRest - publicGoOut - privateGoOut - minutelyHolidayA - minutelyHolidayB;
    }

    protected int calcOverTime(int totalManualRest, int totalOvertimeRest, int totalOvertimeBeforeRest, int totalPublicGoOut, int totalPrivateGoOut, int beforeMinutelyHolidayMinute, int afterMinutelyHolidayMinute, RequestUtilBeanInterface requestUtil) throws MospException {
        int overtime = this.calculatedEnd - this.calculatedStart - this.workBeforeTime + this.lateTime - this.prescribedWorkTime + this.beforePaidLeaveMinute + this.afterPaidLeaveMinute + this.beforeSpecialLeaveMinute + this.afterSpecialLeaveMinute + this.beforeOtherLeaveMinute + this.afterOtherLeaveMinute + this.beforeAbsenceLeaveMinute + this.afterAbsenceLeaveMinute - totalManualRest - totalOvertimeRest + beforeMinutelyHolidayMinute + afterMinutelyHolidayMinute - totalOvertimeBeforeRest;
        if (this.useShort1) {
            if (this.isAmHalfDayOff(requestUtil)) {
                if (!this.isShort1StartTypePay) {
                    overtime -= this.getShortUnpaid1(requestUtil);
                }
            } else if (this.isShort1StartTypePay && this.calculatedStart > this.short1End) {
                overtime += this.short1End - this.short1Start;
            }
        }
        if (this.useShort2) {
            if (this.isPmHalfDayOff(requestUtil)) {
                if (!this.isShort2StartTypePay) {
                    overtime -= this.getShortUnpaid2(requestUtil);
                }
            } else if (this.isShort2StartTypePay && this.calculatedEnd < this.short2Start) {
                overtime += this.short2End - this.short2Start;
            }
        }
        if (overtime < 0) {
            return this.workBeforeTime;
        }
        return overtime + this.workBeforeTime;
    }

    protected void calcLegalHolidayWork(RequestUtilBeanInterface requestUtil) throws MospException {
        boolean nextDayLegalDayOff;
        boolean bl = nextDayLegalDayOff = this.isNextDayWorkOnLegalDaysOff() || this.isNextDayLegalDaysOff();
        if (!this.isWorkOnLegalDaysOff() && !nextDayLegalDayOff) {
            return;
        }
        int twentyFourHours = 1440;
        if (this.isWorkOnLegalDaysOff() && nextDayLegalDayOff || this.isWorkOnLegalDaysOff() && this.calculatedEnd <= twentyFourHours) {
            this.legalHolidayWork = this.getWorkTime();
            this.legalHolidayRest = this.totalRest;
            this.statutoryHolidayWorkIn = 0;
            this.statutoryHolidayWorkOut = this.getWorkTime();
        } else if (this.isWorkOnLegalDaysOff() && !nextDayLegalDayOff && this.calculatedEnd > twentyFourHours) {
            int roundedTodayStatutoryHolidayWork;
            int todayStatutoryHolidayWork = this.getOvertimeWorkCaseLegalDay(this.calculatedStart, this.totalBefore24HourManualRest, this.totalBefore24HourOvertimeBeforeRest, this.totalBefore24HourOvertimeRest, this.totalBefore24HourPublicGoOut, this.totalBefore24HourPrivateGoOut, this.totalBefore24HourMinutelyHolidayA, this.totalBefore24HourMinutelyHolidayB);
            if (todayStatutoryHolidayWork < 0) {
                todayStatutoryHolidayWork = 0;
            }
            this.legalHolidayWork = roundedTodayStatutoryHolidayWork = this.getRoundMinute(todayStatutoryHolidayWork, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
            this.legalHolidayRest = this.totalBefore24HourManualRest + this.totalBefore24HourOvertimeBeforeRest + this.totalBefore24HourOvertimeRest;
            this.statutoryHolidayWorkIn = 0;
            this.statutoryHolidayWorkOut = roundedTodayStatutoryHolidayWork;
        } else if (!this.isWorkOnLegalDaysOff() && nextDayLegalDayOff && this.calculatedEnd > twentyFourHours) {
            int nextDayLegalHolidayWork = this.getNextDayHolidayWork();
            if (nextDayLegalHolidayWork < 0) {
                nextDayLegalHolidayWork = 0;
            }
            if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay && this.calculatedEnd < this.short2Start) {
                nextDayLegalHolidayWork += this.short2End - this.short2Start;
            }
            this.legalHolidayWork = this.getRoundMinute(nextDayLegalHolidayWork, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
            this.legalHolidayRest = this.totalAfter24HourManualRest + this.totalAfter24HourOvertimeBeforeRest + this.totalAfter24HourOvertimeRest;
            if (this.prescribedWorkEnd > twentyFourHours) {
                this.statutoryHolidayWorkIn = this.getWorkTime(twentyFourHours, this.prescribedWorkEnd);
                if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay && this.calculatedEnd < this.short2Start) {
                    this.statutoryHolidayWorkIn += this.short2End - this.short2Start;
                }
                this.statutoryHolidayWorkOut = this.getWorkTime(this.prescribedWorkEnd, this.calculatedEnd);
                return;
            }
            this.statutoryHolidayWorkIn = 0;
            this.statutoryHolidayWorkOut = this.getWorkTime(twentyFourHours, this.calculatedEnd);
        } else if (!this.isWorkOnLegalDaysOff() && nextDayLegalDayOff && this.calculatedEnd <= twentyFourHours) {
            this.legalHolidayWork = 0;
            this.legalHolidayRest = 0;
            this.statutoryHolidayWorkOut = 0;
            if (this.prescribedWorkEnd > twentyFourHours && !this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay) {
                if (this.short2End <= twentyFourHours) {
                    return;
                }
                if (this.short2Start >= twentyFourHours) {
                    this.statutoryHolidayWorkIn = this.short2End - this.short2Start;
                    return;
                }
                this.statutoryHolidayWorkIn = this.short2End - twentyFourHours;
            }
        }
    }

    protected void calcPrescribedHolidayWork(RequestUtilBeanInterface requestUtil) throws MospException {
        boolean nextDayPrescribedDayOff;
        boolean bl = nextDayPrescribedDayOff = this.isNextDayWorkOnPrescribedDaysOff() || this.isNextDayPrescribedDaysOff();
        if (!this.isWorkOnPrescribedDaysOff() && !nextDayPrescribedDayOff) {
            return;
        }
        boolean nextDayLegalDayOff = this.isNextDayWorkOnLegalDaysOff() || this.isNextDayLegalDaysOff();
        boolean isCalendarDay = this.timeSettingDto.getSpecificHolidayHandling() == 2;
        int twentyFourHours = 1440;
        if (this.isWorkOnPrescribedDaysOff() && nextDayPrescribedDayOff || this.isWorkOnPrescribedDaysOff() && !nextDayPrescribedDayOff && !nextDayLegalDayOff && !isCalendarDay || this.isWorkOnPrescribedDaysOff() && this.calculatedEnd <= twentyFourHours) {
            this.prescribedHolidayWork = this.getWorkTime();
            this.prescribedHolidayRest = this.totalRest;
            this.prescribedHolidayWorkIn = 0;
            this.prescribedHolidayWorkOut = this.getWorkTime();
        } else if (this.isWorkOnPrescribedDaysOff() && nextDayLegalDayOff && this.calculatedEnd > twentyFourHours || this.isWorkOnPrescribedDaysOff() && !nextDayPrescribedDayOff && !nextDayLegalDayOff && isCalendarDay && this.calculatedEnd > twentyFourHours) {
            int roundedTodayPrescribedHolidayWork;
            int todayPrescribedHolidayWork = this.getcalcOvertimeWorkCasePrescribedDay(this.calculatedStart, this.totalBefore24HourManualRest, this.totalBefore24HourOvertimeBeforeRest, this.totalBefore24HourOvertimeRest, this.totalBefore24HourPublicGoOut, this.totalBefore24HourPrivateGoOut, this.totalBefore24HourMinutelyHolidayA, this.totalBefore24HourMinutelyHolidayB);
            if (todayPrescribedHolidayWork < 0) {
                todayPrescribedHolidayWork = 0;
            }
            this.prescribedHolidayWork = roundedTodayPrescribedHolidayWork = this.getRoundMinute(todayPrescribedHolidayWork, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
            this.prescribedHolidayRest = this.totalBefore24HourManualRest + this.totalBefore24HourOvertimeBeforeRest + this.totalBefore24HourOvertimeRest;
            this.prescribedHolidayWorkIn = 0;
            this.prescribedHolidayWorkOut = roundedTodayPrescribedHolidayWork;
        } else if (this.isWorkOnLegalDaysOff() && nextDayPrescribedDayOff && this.calculatedEnd > twentyFourHours || !this.isWorkOnPrescribedDaysOff() && !this.isWorkOnLegalDaysOff() && nextDayPrescribedDayOff && isCalendarDay && this.calculatedEnd > twentyFourHours) {
            int nextDayPrescribedHolidayWork = this.getNextDayHolidayWork();
            if (nextDayPrescribedHolidayWork < 0) {
                nextDayPrescribedHolidayWork = 0;
            }
            if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay && this.calculatedEnd < this.short2Start) {
                nextDayPrescribedHolidayWork += this.short2End - this.short2Start;
            }
            this.prescribedHolidayWork = this.getRoundMinute(nextDayPrescribedHolidayWork, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
            this.prescribedHolidayRest = this.totalAfter24HourManualRest + this.totalAfter24HourOvertimeBeforeRest + this.totalAfter24HourOvertimeRest;
            if (this.prescribedWorkEnd > twentyFourHours) {
                this.prescribedHolidayWorkIn = this.getWorkTime(twentyFourHours, this.prescribedWorkEnd);
                if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay && this.calculatedEnd < this.short2Start) {
                    this.prescribedHolidayWorkIn += this.short2End - this.short2Start;
                }
                this.prescribedHolidayWorkOut = this.getWorkTime(this.prescribedWorkEnd, this.calculatedEnd);
                return;
            }
            this.prescribedHolidayWorkIn = 0;
            this.prescribedHolidayWorkOut = this.getWorkTime(twentyFourHours, this.calculatedEnd);
        } else if (!this.isWorkOnPrescribedDaysOff() && !this.isWorkOnLegalDaysOff() && nextDayPrescribedDayOff && isCalendarDay && this.calculatedEnd <= twentyFourHours) {
            this.prescribedHolidayWork = 0;
            this.prescribedHolidayRest = 0;
            this.prescribedHolidayWorkOut = 0;
            if (this.prescribedWorkEnd > twentyFourHours && !this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay) {
                if (this.short2End <= twentyFourHours) {
                    return;
                }
                if (this.short2Start >= twentyFourHours) {
                    this.prescribedHolidayWorkIn = this.short2End - this.short2Start;
                    return;
                }
                this.prescribedHolidayWorkIn = this.short2End - twentyFourHours;
            }
        }
    }

    protected void calcPrescribedWork() {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (Map.Entry entry : this.tardinessRestMap.entrySet()) {
            map.put(this.getDefferenceMinutes(this.workDate, (Date)entry.getKey()), this.getDefferenceMinutes(this.workDate, (Date)entry.getValue()));
        }
        for (Map.Entry entry : this.leaveEarlyRestMap.entrySet()) {
            map.put(this.getDefferenceMinutes(this.workDate, (Date)entry.getKey()), this.getDefferenceMinutes(this.workDate, (Date)entry.getValue()));
        }
        for (RestDtoInterface dto : this.restDtoList) {
            Date startTime = this.getRoundMinute(dto.getRestStart(), this.timeSettingDto.getRoundDailyRestStart(), this.timeSettingDto.getRoundDailyRestStartUnit());
            Date endTime = this.getRoundMinute(dto.getRestEnd(), this.timeSettingDto.getRoundDailyRestEnd(), this.timeSettingDto.getRoundDailyRestEndUnit());
            int startTimeInt = DateUtility.getHour((Date)startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)startTime);
            int endTimeInt = DateUtility.getHour((Date)endTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)endTime);
            if (startTimeInt >= this.regWorkEnd || endTimeInt <= this.regWorkStart) continue;
            if (startTimeInt < this.regWorkStart) {
                startTimeInt = this.regWorkStart;
            }
            if (endTimeInt > this.regWorkEnd) {
                endTimeInt = this.regWorkEnd;
            }
            if (map.containsKey(startTimeInt) && (Integer)map.get(startTimeInt) >= endTimeInt) continue;
            map.put(startTimeInt, endTimeInt);
        }
        int time = this.regWorkStart;
        int totalWork = 0;
        for (Map.Entry entry : map.entrySet()) {
            int mapStart = (Integer)entry.getKey();
            int mapEnd = (Integer)entry.getValue();
            if (time > mapStart) continue;
            int addWork = mapStart - time;
            if (totalWork + addWork >= this.prescribedWorkTime) {
                this.prescribedWorkEnd = time + this.prescribedWorkTime - totalWork;
                return;
            }
            totalWork += addWork;
            time = mapEnd;
        }
        if (totalWork + this.calculatedEnd - time < this.prescribedWorkTime) {
            return;
        }
        this.prescribedWorkEnd = time + this.prescribedWorkTime - totalWork;
    }

    private void calcNightWorkTime(RequestUtilBeanInterface requestUtil) throws MospException {
        this.nightWork = 0;
        this.nightRest = 0;
        this.nightWorkArray = new int[3];
        this.nightRestArray = new int[3];
        this.calcNightWorkTime(0, 300, 0);
        this.calcNightWorkTime(1320, 1740, 1);
        this.calcNightWorkTime(2760, 2880, 2);
        int totalNightWorkTime = 0;
        for (int time : this.nightWorkArray) {
            totalNightWorkTime += time;
        }
        this.nightWork = totalNightWorkTime += this.getNightShortPaid(requestUtil);
        int totalNightRestTime = 0;
        for (int time : this.nightRestArray) {
            totalNightRestTime += time;
        }
        this.nightRest = totalNightRestTime;
        if (this.workTypeEntity.isNightRestExclude()) {
            this.nightWork = totalNightWorkTime + totalNightRestTime;
            this.nightRest = 0;
        }
    }

    private void calcNightWorkTime(int regNightWorkStart, int regNightWorkEnd, int i) {
        if (this.calculatedStart >= regNightWorkEnd || this.calculatedEnd <= regNightWorkStart) {
            this.nightWorkArray[i] = 0;
            this.nightRestArray[i] = 0;
            return;
        }
        int nightWorkStart = regNightWorkStart;
        if (this.calculatedStart >= regNightWorkStart) {
            nightWorkStart = this.calculatedStart;
        }
        int nightWorkEnd = regNightWorkEnd;
        if (this.calculatedEnd <= regNightWorkEnd) {
            nightWorkEnd = this.calculatedEnd;
        }
        int totalPaidLeave = 0;
        for (Map.Entry entry : this.paidLeaveHourMap.entrySet()) {
            int paidLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int paidLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (paidLeaveStart >= nightWorkEnd || paidLeaveEnd <= nightWorkStart) continue;
            if (paidLeaveStart < nightWorkStart) {
                paidLeaveStart = nightWorkStart;
            }
            if (paidLeaveEnd > nightWorkEnd) {
                paidLeaveEnd = nightWorkEnd;
            }
            totalPaidLeave += paidLeaveEnd - paidLeaveStart;
        }
        int totalSpecialLeave = 0;
        for (Map.Entry entry : this.specialLeaveHourMap.entrySet()) {
            int specialLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int specialLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (specialLeaveStart >= nightWorkEnd || specialLeaveEnd <= nightWorkStart) continue;
            if (specialLeaveStart < nightWorkStart) {
                specialLeaveStart = nightWorkStart;
            }
            if (specialLeaveEnd > nightWorkEnd) {
                specialLeaveEnd = nightWorkEnd;
            }
            totalSpecialLeave += specialLeaveEnd - specialLeaveStart;
        }
        int totalOtherLeave = 0;
        for (Map.Entry entry : this.otherLeaveHourMap.entrySet()) {
            int otherLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int otherLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (otherLeaveStart >= nightWorkEnd || otherLeaveEnd <= nightWorkStart) continue;
            if (otherLeaveStart < nightWorkStart) {
                otherLeaveStart = nightWorkStart;
            }
            if (otherLeaveEnd > nightWorkEnd) {
                otherLeaveEnd = nightWorkEnd;
            }
            totalOtherLeave += otherLeaveEnd - otherLeaveStart;
        }
        int totalAbsenceLeave = 0;
        for (Map.Entry entry : this.absenceHourMap.entrySet()) {
            int absenceLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int absenceLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (absenceLeaveStart >= nightWorkEnd || absenceLeaveEnd <= nightWorkStart) continue;
            if (absenceLeaveStart < nightWorkStart) {
                absenceLeaveStart = nightWorkStart;
            }
            if (absenceLeaveEnd > nightWorkEnd) {
                absenceLeaveEnd = nightWorkEnd;
            }
            totalAbsenceLeave += absenceLeaveEnd - absenceLeaveStart;
        }
        int totalOvertimeBeforeRest = 0;
        for (Map.Entry entry : this.overtimeBeforeRestMap.entrySet()) {
            int start = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int end = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalOvertimeBeforeRest += end - start;
        }
        int totalOvertimeRest = 0;
        for (Map.Entry entry : this.overtimeRestMap.entrySet()) {
            int start = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int end = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalOvertimeRest += end - start;
        }
        int totalManualRest = 0;
        for (RestDtoInterface dto : this.restDtoList) {
            Date startTime = this.getRoundMinute(dto.getRestStart(), this.timeSettingDto.getRoundDailyRestStart(), this.timeSettingDto.getRoundDailyRestStartUnit());
            Date endTime = this.getRoundMinute(dto.getRestEnd(), this.timeSettingDto.getRoundDailyRestEnd(), this.timeSettingDto.getRoundDailyRestEndUnit());
            int start = this.getDefferenceMinutes(this.workDate, startTime);
            int end = this.getDefferenceMinutes(this.workDate, endTime);
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalManualRest += this.getRoundMinute(end - start, this.timeSettingDto.getRoundDailyRestTime(), this.timeSettingDto.getRoundDailyRestTimeUnit());
        }
        int totalPublicGoOut = 0;
        for (GoOutDtoInterface dto : this.publicGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPublicStart(), this.timeSettingDto.getRoundDailyPublicStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPublicEnd(), this.timeSettingDto.getRoundDailyPublicEndUnit());
            int start = this.getDefferenceMinutes(this.workDate, startTime);
            int end = this.getDefferenceMinutes(this.workDate, endTime);
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalPublicGoOut += end - start;
        }
        int totalPrivateGoOut = 0;
        for (GoOutDtoInterface dto : this.privateGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPrivateStart(), this.timeSettingDto.getRoundDailyPrivateStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPrivateEnd(), this.timeSettingDto.getRoundDailyPrivateEndUnit());
            int start = this.getDefferenceMinutes(this.workDate, startTime);
            int end = this.getDefferenceMinutes(this.workDate, endTime);
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalPrivateGoOut += end - start;
        }
        int totalMinutelyHolidayA = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayADtoList) {
            Date startTime = dto.getGoOutStart();
            Date endTime = dto.getGoOutEnd();
            int start = this.getDefferenceMinutes(this.workDate, startTime);
            int end = this.getDefferenceMinutes(this.workDate, endTime);
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalMinutelyHolidayA += end - start;
        }
        int totalMinutelyHolidayB = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayBDtoList) {
            Date startTime = dto.getGoOutStart();
            Date endTime = dto.getGoOutEnd();
            int start = this.getDefferenceMinutes(this.workDate, startTime);
            int end = this.getDefferenceMinutes(this.workDate, endTime);
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalMinutelyHolidayB += end - start;
        }
        int night = this.nightWorkTime(nightWorkEnd, nightWorkStart, totalManualRest, totalOvertimeBeforeRest, totalOvertimeRest, totalPublicGoOut, totalPrivateGoOut, totalMinutelyHolidayA, totalMinutelyHolidayB);
        if ((night -= totalPaidLeave + totalSpecialLeave + totalOtherLeave + totalAbsenceLeave) < 0) {
            night = 0;
        }
        this.nightWorkArray[i] = this.getRoundMinute(night, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
        this.nightRestArray[i] = totalManualRest + totalOvertimeBeforeRest + totalOvertimeRest;
    }

    protected void calcNightOvertimeWork(RequestUtilBeanInterface requestUtil) throws MospException {
        boolean workOnLegalDaysOff = this.isWorkOnLegalDaysOff();
        boolean nextDayLegalDayOff = this.isNextDayWorkOnLegalDaysOff() || this.isNextDayLegalDaysOff();
        int totalWork = 0;
        int totalNightWorkWithin = 0;
        int totalNightOvertimeWork = 0;
        int zeroHours = 0;
        int fiveHours = 300;
        int twentyTwoHours = 1320;
        int twentyFourHours = 1440;
        int twentyNineHours = 1740;
        int fortySixHours = 2760;
        int fortyEightHours = 2880;
        int[] nightStartArray = new int[]{zeroHours, fiveHours, twentyTwoHours, twentyNineHours, fortySixHours};
        int[] nightEndArray = new int[]{fiveHours, twentyTwoHours, twentyNineHours, fortySixHours, fortyEightHours};
        if (workOnLegalDaysOff && nextDayLegalDayOff) {
            this.nightWorkWithinPrescribedWork = 0;
            this.nightOvertimeWork = 0;
            return;
        }
        if (workOnLegalDaysOff) {
            nightStartArray = new int[]{zeroHours, zeroHours, twentyFourHours, twentyNineHours, fortySixHours};
            nightEndArray = new int[]{zeroHours, twentyFourHours, twentyNineHours, fortySixHours, fortyEightHours};
        } else if (nextDayLegalDayOff) {
            nightStartArray = new int[]{zeroHours, fiveHours, twentyTwoHours};
            nightEndArray = new int[]{fiveHours, twentyTwoHours, twentyFourHours};
        }
        for (int i = 0; i < nightStartArray.length; ++i) {
            int night = this.getNightWork(nightStartArray[i], nightEndArray[i]);
            if (i % 2 != 0) {
                totalWork += night;
                continue;
            }
            night += this.getNightShortPaid(requestUtil, nightStartArray[i], nightEndArray[i]);
            if (totalWork >= this.prescribedWorkTime) {
                totalWork += night;
                totalNightOvertimeWork += night;
                continue;
            }
            if (totalWork + night <= this.prescribedWorkTime) {
                totalWork += night;
                totalNightWorkWithin += night;
                continue;
            }
            int add = this.prescribedWorkTime - totalWork;
            int over = totalWork + night - this.prescribedWorkTime;
            totalWork += night;
            totalNightWorkWithin += add;
            totalNightOvertimeWork += over;
        }
        this.nightWorkWithinPrescribedWork = this.getRoundMinute(totalNightWorkWithin, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
        this.nightOvertimeWork = this.getRoundMinute(totalNightOvertimeWork, this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
    }

    protected void calcNightWorkOnDayOff(RequestUtilBeanInterface requestUtil) throws MospException {
        boolean workOnLegalDaysOff = this.isWorkOnLegalDaysOff();
        boolean nextDayLegalDayOff = this.isNextDayWorkOnLegalDaysOff() || this.isNextDayLegalDaysOff();
        int zeroHours = 0;
        int fiveHours = 300;
        int twentyTwoHours = 1320;
        int twentyFourHours = 1440;
        int twentyNineHours = 1740;
        int fortySixHours = 2760;
        int fortyEightHours = 2880;
        int[] nightStartArray = new int[]{};
        int[] nightEndArray = new int[]{};
        if (workOnLegalDaysOff && nextDayLegalDayOff) {
            nightStartArray = new int[]{zeroHours, twentyTwoHours, fortySixHours};
            nightEndArray = new int[]{fiveHours, twentyNineHours, fortyEightHours};
        } else if (workOnLegalDaysOff) {
            nightStartArray = new int[]{zeroHours, twentyTwoHours};
            nightEndArray = new int[]{fiveHours, twentyFourHours};
        } else if (nextDayLegalDayOff) {
            nightStartArray = new int[]{twentyFourHours, fortySixHours};
            nightEndArray = new int[]{twentyNineHours, fortyEightHours};
        } else {
            return;
        }
        int work = 0;
        for (int i = 0; i < nightStartArray.length; ++i) {
            work += this.getRoundMinute(this.getNightWork(nightStartArray[i], nightEndArray[i]), this.timeSettingDto.getRoundDailyWork(), this.timeSettingDto.getRoundDailyTimeWork());
            work += this.getNightShortPaid(requestUtil, nightStartArray[i], nightEndArray[i]);
        }
        this.nightWorkOnHoliday = work;
    }

    protected int getNightWork(int regNightWorkStart, int regNightWorkEnd) {
        if (this.calculatedStart >= regNightWorkEnd || this.calculatedEnd <= regNightWorkStart) {
            return 0;
        }
        int nightWorkStart = regNightWorkStart;
        if (this.calculatedStart >= regNightWorkStart) {
            nightWorkStart = this.calculatedStart;
        }
        int nightWorkEnd = regNightWorkEnd;
        if (this.calculatedEnd <= regNightWorkEnd) {
            nightWorkEnd = this.calculatedEnd;
        }
        int totalPaidLeave = 0;
        for (Map.Entry entry : this.paidLeaveHourMap.entrySet()) {
            int paidLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int paidLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (paidLeaveStart >= nightWorkEnd || paidLeaveEnd <= nightWorkStart) continue;
            if (paidLeaveStart < nightWorkStart) {
                paidLeaveStart = nightWorkStart;
            }
            if (paidLeaveEnd > nightWorkEnd) {
                paidLeaveEnd = nightWorkEnd;
            }
            totalPaidLeave += paidLeaveEnd - paidLeaveStart;
        }
        int totalSpecialLeave = 0;
        for (Map.Entry entry : this.specialLeaveHourMap.entrySet()) {
            int specialLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int specialLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (specialLeaveStart >= nightWorkEnd || specialLeaveEnd <= nightWorkStart) continue;
            if (specialLeaveStart < nightWorkStart) {
                specialLeaveStart = nightWorkStart;
            }
            if (specialLeaveEnd > nightWorkEnd) {
                specialLeaveEnd = nightWorkEnd;
            }
            totalSpecialLeave += specialLeaveEnd - specialLeaveStart;
        }
        int totalOtherLeave = 0;
        for (Map.Entry entry : this.otherLeaveHourMap.entrySet()) {
            int otherLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int otherLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (otherLeaveStart >= nightWorkEnd || otherLeaveEnd <= nightWorkStart) continue;
            if (otherLeaveStart < nightWorkStart) {
                otherLeaveStart = nightWorkStart;
            }
            if (otherLeaveEnd > nightWorkEnd) {
                otherLeaveEnd = nightWorkEnd;
            }
            totalOtherLeave += otherLeaveEnd - otherLeaveStart;
        }
        int totalAbsenceLeave = 0;
        for (Map.Entry entry : this.absenceHourMap.entrySet()) {
            int absenceLeaveStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int absenceLeaveEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (absenceLeaveStart >= nightWorkEnd || absenceLeaveEnd <= nightWorkStart) continue;
            if (absenceLeaveStart < nightWorkStart) {
                absenceLeaveStart = nightWorkStart;
            }
            if (absenceLeaveEnd > nightWorkEnd) {
                absenceLeaveEnd = nightWorkEnd;
            }
            totalAbsenceLeave += absenceLeaveEnd - absenceLeaveStart;
        }
        int totalOvertimeBeforeRest = 0;
        int totalOvertimeRest = 0;
        int totalManualRest = 0;
        if (!this.workTypeEntity.isNightRestExclude()) {
            int end;
            int start;
            for (Map.Entry entry : this.overtimeBeforeRestMap.entrySet()) {
                start = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                end = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                if (start >= nightWorkEnd || end <= nightWorkStart) continue;
                if (start < nightWorkStart) {
                    start = nightWorkStart;
                }
                if (end > nightWorkEnd) {
                    end = nightWorkEnd;
                }
                totalOvertimeBeforeRest += end - start;
            }
            for (Map.Entry entry : this.overtimeRestMap.entrySet()) {
                start = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                end = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                if (start >= nightWorkEnd || end <= nightWorkStart) continue;
                if (start < nightWorkStart) {
                    start = nightWorkStart;
                }
                if (end > nightWorkEnd) {
                    end = nightWorkEnd;
                }
                totalOvertimeRest += end - start;
            }
            for (RestDtoInterface dto : this.restDtoList) {
                Date startTime = this.getRoundMinute(dto.getRestStart(), this.timeSettingDto.getRoundDailyRestStart(), this.timeSettingDto.getRoundDailyRestStartUnit());
                Date endTime = this.getRoundMinute(dto.getRestEnd(), this.timeSettingDto.getRoundDailyRestEnd(), this.timeSettingDto.getRoundDailyRestEndUnit());
                int start2 = this.getDefferenceMinutes(this.workDate, startTime);
                int end2 = this.getDefferenceMinutes(this.workDate, endTime);
                if (start2 >= nightWorkEnd || end2 <= nightWorkStart) continue;
                if (start2 < nightWorkStart) {
                    start2 = nightWorkStart;
                }
                if (end2 > nightWorkEnd) {
                    end2 = nightWorkEnd;
                }
                totalManualRest += this.getRoundMinute(end2 - start2, this.timeSettingDto.getRoundDailyRestTime(), this.timeSettingDto.getRoundDailyRestTimeUnit());
            }
        }
        int totalPublicGoOut = 0;
        for (GoOutDtoInterface dto : this.publicGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPublicStart(), this.timeSettingDto.getRoundDailyPublicStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPublicEnd(), this.timeSettingDto.getRoundDailyPublicEndUnit());
            int start = this.getDefferenceMinutes(this.workDate, startTime);
            int end = this.getDefferenceMinutes(this.workDate, endTime);
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalPublicGoOut += end - start;
        }
        int totalPrivateGoOut = 0;
        for (GoOutDtoInterface dto : this.privateGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPrivateStart(), this.timeSettingDto.getRoundDailyPrivateStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPrivateEnd(), this.timeSettingDto.getRoundDailyPrivateEndUnit());
            int start = this.getDefferenceMinutes(this.workDate, startTime);
            int end = this.getDefferenceMinutes(this.workDate, endTime);
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalPrivateGoOut += end - start;
        }
        int totalMinutelyHolidayA = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayADtoList) {
            Date startTime = dto.getGoOutStart();
            Date endTime = dto.getGoOutEnd();
            int start = this.getDefferenceMinutes(this.workDate, startTime);
            int end = this.getDefferenceMinutes(this.workDate, endTime);
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalMinutelyHolidayA += end - start;
        }
        int totalMinutelyHolidayB = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayBDtoList) {
            Date startTime = dto.getGoOutStart();
            Date endTime = dto.getGoOutEnd();
            int start = this.getDefferenceMinutes(this.workDate, startTime);
            int end = this.getDefferenceMinutes(this.workDate, endTime);
            if (start >= nightWorkEnd || end <= nightWorkStart) continue;
            if (start < nightWorkStart) {
                start = nightWorkStart;
            }
            if (end > nightWorkEnd) {
                end = nightWorkEnd;
            }
            totalMinutelyHolidayB += end - start;
        }
        int night = this.nightWorkTime(nightWorkEnd, nightWorkStart, totalManualRest, totalOvertimeBeforeRest, totalOvertimeRest, totalPublicGoOut, totalPrivateGoOut, totalMinutelyHolidayA, totalMinutelyHolidayB);
        if ((night -= this.calcTotalNightHolidayTimes(totalPaidLeave, totalSpecialLeave, totalOtherLeave, totalAbsenceLeave)) < 0) {
            night = 0;
        }
        return night;
    }

    protected int nightWorkTime(int nightWorkEnd, int nightWorkStart, int totalManualRest, int totalOvertimeBeforeRest, int totalOvertimeRest, int totalPublicGoOut, int totalPrivateGoOut, int totalMinutelyHolidayAGoOut, int totalMinutely2HolidayGoOut) {
        return nightWorkEnd - nightWorkStart - totalManualRest - totalOvertimeBeforeRest - totalOvertimeRest - totalPublicGoOut - totalPrivateGoOut - totalMinutelyHolidayAGoOut - totalMinutely2HolidayGoOut;
    }

    protected int calcTotalNightHolidayTimes(int totalPaidLeave, int totalSpecialLeave, int totalOtherLeave, int totalAbsenceLeave) {
        return totalPaidLeave + totalSpecialLeave + totalOtherLeave + totalAbsenceLeave;
    }

    protected int getNightShortPaid(RequestUtilBeanInterface requestUtil) throws MospException {
        int shortPaid = 0;
        int[] startArray = new int[]{0, 1320, 2760};
        int[] endArray = new int[]{300, 1740, 2880};
        for (int i = 0; i < startArray.length; ++i) {
            shortPaid += this.getNightShortPaid(requestUtil, startArray[i], endArray[i]);
        }
        return shortPaid;
    }

    protected int getNightShortPaid(RequestUtilBeanInterface requestUtil, int nightStart, int nightEnd) throws MospException {
        int shortPaid = 0;
        if (!this.isAmHalfDayOff(requestUtil) && this.useShort1 && this.isShort1StartTypePay && this.calculatedStart > this.short1End) {
            if (this.short1Start <= nightStart) {
                if (this.short1End >= nightEnd) {
                    shortPaid += nightEnd - nightStart;
                } else if (this.short1End > nightStart) {
                    shortPaid += this.short1End - nightStart;
                }
            } else if (this.short1Start < nightEnd) {
                if (this.short1End >= nightEnd) {
                    shortPaid += nightEnd - this.short1Start;
                } else if (this.short1End > nightStart) {
                    shortPaid += this.short1End - this.short1Start;
                }
            }
        }
        if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay && this.calculatedEnd < this.short2Start) {
            if (this.short2Start <= nightStart) {
                if (this.short2End >= nightEnd) {
                    shortPaid += nightEnd - nightStart;
                } else if (this.short2End > nightStart) {
                    shortPaid += this.short2End - nightStart;
                }
            } else if (this.short2Start < nightEnd) {
                if (this.short2End >= nightEnd) {
                    shortPaid += nightEnd - this.short2Start;
                } else if (this.short2End > nightStart) {
                    shortPaid += this.short2End - this.short2Start;
                }
            }
        }
        return shortPaid;
    }

    private void calcReducedTargetTime() {
        int result = this.totalPrivate;
        if (!this.isLateReasonTrain() && !this.isLateReasonCompany()) {
            result += this.lateTime;
        }
        if (!this.isLeaveEarlyReasonCompany()) {
            result += this.leaveEarlyTime;
        }
        if (result < 0) {
            result = 0;
        }
        this.decreaseTime = this.getRoundMinute(result, this.timeSettingDto.getRoundDailyDecreaseTime(), this.timeSettingDto.getRoundDailyDecreaseTimeUnit());
    }

    protected void calcPrescribedWorkTime(RequestUtilBeanInterface requestUtil) throws MospException {
        if (this.isWorkOnLegalDaysOff() || this.isWorkOnPrescribedDaysOff()) {
            this.prescribedWorkTime = 0;
            this.autoRestCalcStart = DateUtility.getHour((Date)this.timeSettingDto.getGeneralWorkTime()) * 60 + DateUtility.getMinute((Date)this.timeSettingDto.getGeneralWorkTime());
            return;
        }
        if (this.regWorkTime > 480) {
            this.prescribedWorkTime = 480;
            this.autoRestCalcStart = 480;
            if (this.isAmHalfDayOff(requestUtil)) {
                this.autoRestCalcStart = this.regWorkTime;
            }
            return;
        }
        this.prescribedWorkTime = this.regWorkTime;
        this.autoRestCalcStart = this.regFullWorkTime;
        if (this.isAmHalfDayOff(requestUtil)) {
            this.autoRestCalcStart = this.regWorkTime;
        }
    }

    protected void calcWithinStatutoryOvertime() throws MospException {
        int paidLeave = this.paidLeaveHour * 60;
        int specialLeave = this.specialLeaveHour * 60;
        int otherLeave = this.otherLeaveHour * 60;
        int absenceLeave = this.absenceHour * 60;
        int differenceTime = 480 - this.prescribedWorkTime + this.lateTime + this.leaveEarlyTime + this.totalPrivate + paidLeave + specialLeave + otherLeave + absenceLeave + this.totalMinutelyHolidayA + this.totalMinutelyHolidayB;
        if (differenceTime < 0) {
            return;
        }
        if (differenceTime <= this.overtimeTime) {
            this.withinStatutoryOvertime = differenceTime;
            return;
        }
        this.withinStatutoryOvertime = this.overtimeTime;
    }

    protected void calcCompensationDay() {
        int all = DateUtility.getHour((Date)this.timeSettingDto.getSubHolidayAllNorm()) * 60 + DateUtility.getMinute((Date)this.timeSettingDto.getSubHolidayAllNorm());
        int half = DateUtility.getHour((Date)this.timeSettingDto.getSubHolidayHalfNorm()) * 60 + DateUtility.getMinute((Date)this.timeSettingDto.getSubHolidayHalfNorm());
        int work = this.getWorkTime();
        if (this.isWorkOnLegalDaysOff()) {
            if (work >= all) {
                this.grantedLegalCompensationDays = 1.0;
            } else if (work >= half) {
                this.grantedLegalCompensationDays = 0.5;
            }
        } else if (this.isWorkOnPrescribedDaysOff()) {
            if (work >= all) {
                this.grantedPrescribedCompensationDays = 1.0;
            } else if (work >= half) {
                this.grantedPrescribedCompensationDays = 0.5;
            }
        }
    }

    protected int getShortUnpaid(RequestUtilBeanInterface requestUtil) throws MospException {
        int shortUnpaid1 = this.getShortUnpaid1(requestUtil);
        int shortUnpaid2 = this.getShortUnpaid2(requestUtil);
        int shortUnpaid = shortUnpaid1 + shortUnpaid2;
        int add = 0;
        if (this.isAmHalfDayOff(requestUtil)) {
            add = shortUnpaid1;
        }
        if (this.isPmHalfDayOff(requestUtil)) {
            add = shortUnpaid2;
        }
        if (this.getWorkTime() + this.lateTime + this.totalPublic + this.totalPrivate >= this.prescribedWorkTime + add) {
            shortUnpaid = 0;
        } else if (this.getWorkTime() + this.lateTime + this.totalPublic + this.totalPrivate + shortUnpaid > this.prescribedWorkTime + add) {
            shortUnpaid = this.prescribedWorkTime + add - this.getWorkTime() - this.lateTime - this.totalPublic - this.totalPrivate;
        }
        if (shortUnpaid < 0) {
            return 0;
        }
        return this.getRoundMinute(shortUnpaid, this.timeSettingDto.getRoundDailyShortUnpaid(), this.timeSettingDto.getRoundDailyShortUnpaidUnit());
    }

    protected int getShortUnpaid1(RequestUtilBeanInterface requestUtil) throws MospException {
        if (!this.useShort1) {
            return 0;
        }
        if (this.isShort1StartTypePay) {
            return 0;
        }
        if (this.isAmHalfDayOff(requestUtil)) {
            return this.short1End - this.short1Start;
        }
        if (this.calculatedStart >= this.short1End) {
            return this.short1End - this.short1Start;
        }
        if (this.calculatedStart >= this.short1Start) {
            return this.calculatedStart - this.short1Start;
        }
        if (this.calculatedEnd != 0 && this.calculatedEnd <= this.short1Start) {
            return this.short1End - this.short1Start;
        }
        if (this.calculatedEnd != 0 && this.calculatedEnd <= this.short1End) {
            return this.short1End - this.calculatedEnd;
        }
        return 0;
    }

    protected int getShortUnpaid2(RequestUtilBeanInterface requestUtil) throws MospException {
        if (!this.useShort2) {
            return 0;
        }
        if (this.isShort2StartTypePay) {
            return 0;
        }
        if (this.isPmHalfDayOff(requestUtil)) {
            return this.short2End - this.short2Start;
        }
        if (this.calculatedStart >= this.short2End) {
            return this.short2End - this.short2Start;
        }
        if (this.calculatedStart >= this.short2Start) {
            return this.calculatedStart - this.short2Start;
        }
        if (this.calculatedEnd != 0 && this.calculatedEnd <= this.short2Start) {
            return this.short2End - this.short2Start;
        }
        if (this.calculatedEnd != 0 && this.calculatedEnd <= this.short2End) {
            return this.short2End - this.calculatedEnd;
        }
        return 0;
    }

    protected void setAutoCalc(RequestUtilBeanInterface requestUtil) throws MospException {
        if (this.startTime != null) {
            this.calcCalculatedStart(true, requestUtil);
        }
        if (this.endTime != null) {
            this.calcCalculatedEnd(true, requestUtil);
        }
        if (this.startTime == null || this.endTime == null) {
            return;
        }
        this.calcRegRest(requestUtil);
        this.calcPrescribedWorkTime(requestUtil);
        this.calcTardinessTime(requestUtil);
        this.calcLeaveEarlyTime(requestUtil);
        this.calcPublicGoOutTime();
        this.calcPrivateGoOutTime();
        this.calcMinutelyHolidayATime();
        this.calcMinutelyHolidayBTime();
        this.calcWorkTime(requestUtil);
        this.calcOvertimeWork(requestUtil);
        this.calcPrescribedWork();
        this.calcLegalHolidayWork(requestUtil);
        this.calcPrescribedHolidayWork(requestUtil);
        this.calcNightWorkTime(requestUtil);
        this.calcNightOvertimeWork(requestUtil);
        this.calcNightWorkOnDayOff(requestUtil);
        this.calcReducedTargetTime();
        this.calcWithinStatutoryOvertime();
        this.calcLegalOutTime();
        this.calcCompensationDay();
    }

    public void setCalcInfo(AttendanceDtoInterface attendanceDto, List<RestDtoInterface> restDtoList, List<GoOutDtoInterface> publicGoOutDtoList, List<GoOutDtoInterface> privateGoOutDtoList, List<GoOutDtoInterface> minutelyHolidayAList, List<GoOutDtoInterface> minutelyHolidayBList) {
        this.workTime = 0;
        this.prescribedWorkTime = 0;
        this.totalRest = 0;
        this.legalHolidayRest = 0;
        this.prescribedHolidayRest = 0;
        this.totalPublic = 0;
        this.lateTime = 0;
        this.leaveEarlyTime = 0;
        this.totalPrivate = 0;
        this.totalMinutelyHolidayA = 0;
        this.totalMinutelyHolidayB = 0;
        this.decreaseTime = 0;
        this.timeSettingDto = null;
        this.workOnHolidayDto = null;
        this.holidayRequestDtoList = new ArrayList();
        this.subHolidayRequestDtoList = new ArrayList();
        this.differenceDto = null;
        this.scheduleDateDto = null;
        this.beforeOvertimeDto = null;
        this.afterOvertimeDto = null;
        this.overtimeTime = 0;
        this.regWorkStart = 0;
        this.regWorkEnd = 0;
        this.regWorkTime = 0;
        this.regFullWorkTime = 0;
        this.betweenHalfHolidayTime = 0;
        this.overbefore = 0;
        this.overper = 0;
        this.overrest = 0;
        this.overtimeOut = 0;
        this.workdayOvertimeIn = 0;
        this.workdayOvertimeOut = 0;
        this.prescribedHolidayOvertimeIn = 0;
        this.prescribedHolidayOvertimeOut = 0;
        this.overRestTime = 0;
        this.nightWork = 0;
        this.nightWorkWithinPrescribedWork = 0;
        this.nightOvertimeWork = 0;
        this.nightWorkOnHoliday = 0;
        this.nightRest = 0;
        this.nightWorkArray = new int[0];
        this.nightRestArray = new int[0];
        this.legalHolidayWork = 0;
        this.prescribedHolidayWork = 0;
        this.withinStatutoryOvertime = 0;
        this.grantedLegalCompensationDays = 0.0;
        this.grantedPrescribedCompensationDays = 0.0;
        this.grantedNightCompensationDays = 0.0;
        this.statutoryHolidayWorkIn = 0;
        this.statutoryHolidayWorkOut = 0;
        this.prescribedHolidayWorkIn = 0;
        this.prescribedHolidayWorkOut = 0;
        this.workBeforeTime = 0;
        this.workAfterTime = 0;
        this.calculatedStart = 0;
        this.calculatedEnd = 0;
        this.prescribedWorkEnd = 0;
        this.totalBefore24HourManualRest = 0;
        this.totalBefore24HourOvertimeBeforeRest = 0;
        this.totalBefore24HourOvertimeRest = 0;
        this.totalBefore24HourPublicGoOut = 0;
        this.totalBefore24HourPrivateGoOut = 0;
        this.totalBefore24HourMinutelyHolidayA = 0;
        this.totalBefore24HourMinutelyHolidayB = 0;
        this.totalAfter24HourPaidLeave = 0;
        this.totalAfter24HourSpecialLeave = 0;
        this.totalAfter24HourOtherLeave = 0;
        this.totalAfter24HourAbsenceLeave = 0;
        this.totalAfter24HourManualRest = 0;
        this.totalAfter24HourOvertimeBeforeRest = 0;
        this.totalAfter24HourOvertimeRest = 0;
        this.totalAfter24HourPublicGoOut = 0;
        this.totalAfter24HourPrivateGoOut = 0;
        this.regRestMap = new TreeMap();
        this.tardinessRestMap = new TreeMap();
        this.leaveEarlyRestMap = new TreeMap();
        this.overtimeBeforeRestMap = new TreeMap();
        this.overtimeRestMap = new TreeMap();
        this.isPaidLeaveAm = false;
        this.isPaidLeavePm = false;
        this.paidLeaveHourMap = new TreeMap();
        this.specialLeaveHourMap = new TreeMap();
        this.otherLeaveHourMap = new TreeMap();
        this.absenceHourMap = new TreeMap();
        this.minutelyHolidayAMap = new TreeMap();
        this.minutelyHolidayBMap = new TreeMap();
        this.paidLeaveHour = 0;
        this.specialLeaveHour = 0;
        this.otherLeaveHour = 0;
        this.absenceHour = 0;
        this.beforePaidLeaveMinute = 0;
        this.beforeSpecialLeaveMinute = 0;
        this.beforeOtherLeaveMinute = 0;
        this.beforeAbsenceLeaveMinute = 0;
        this.beforeMinutelyHolidayMinute = 0;
        this.afterPaidLeaveMinute = 0;
        this.afterSpecialLeaveMinute = 0;
        this.afterOtherLeaveMinute = 0;
        this.afterAbsenceLeaveMinute = 0;
        this.afterMinutelyHolidayMinute = 0;
        this.isStockLeaveAm = false;
        this.isStockLeavePm = false;
        this.isSpecialLeaveAm = false;
        this.isSpecialLeavePm = false;
        this.isOtherLeaveAm = false;
        this.isOtherLeavePm = false;
        this.isAbsenceAm = false;
        this.isAbsencePm = false;
        this.isLegalCompensationDayAm = false;
        this.isLegalCompensationDayPm = false;
        this.isPrescribedCompensationDayAm = false;
        this.isPrescribedCompensationDayPm = false;
        this.isNightCompensationDaysAm = false;
        this.isNightCompensationDaysPm = false;
        this.workTypeCode = "";
        this.personalId = attendanceDto.getPersonalId();
        this.workDate = attendanceDto.getWorkDate();
        this.startTime = attendanceDto.getStartTime();
        this.endTime = attendanceDto.getEndTime();
        this.directStart = attendanceDto.getDirectStart() == 1;
        this.directEnd = attendanceDto.getDirectEnd() == 1;
        this.lateReason = attendanceDto.getLateReason();
        this.leaveEarlyReason = attendanceDto.getLeaveEarlyReason();
        this.allMinutelyHolidayA = attendanceDto.getMinutelyHolidayA() == 1;
        this.allMinutelyHolidayB = attendanceDto.getMinutelyHolidayB() == 1;
        this.restDtoList = restDtoList;
        this.publicGoOutDtoList = publicGoOutDtoList;
        this.privateGoOutDtoList = privateGoOutDtoList;
        this.minutelyHolidayADtoList = minutelyHolidayAList;
        this.minutelyHolidayBDtoList = minutelyHolidayBList;
    }

    public void getCalcInfo(AttendanceDtoInterface attendanceDto, RequestUtilBeanInterface requestUtil) throws MospException {
        boolean isWorkOnLegalDaysOff = this.isWorkOnLegalDaysOff();
        boolean isWorkOnPrescribedDaysOff = this.isWorkOnPrescribedDaysOff();
        attendanceDto.setStartTime(this.startTime == null ? this.startTime : this.getAttendanceTime(this.workDate, this.calculatedStart));
        attendanceDto.setEndTime(this.endTime == null ? this.endTime : this.getAttendanceTime(this.workDate, this.calculatedEnd));
        attendanceDto.setDecreaseTime(this.decreaseTime);
        attendanceDto.setGeneralWorkTime(this.prescribedWorkTime);
        attendanceDto.setLateNightTime(this.nightWork);
        attendanceDto.setNightWorkWithinPrescribedWork(this.nightWorkWithinPrescribedWork);
        attendanceDto.setNightOvertimeWork(this.nightOvertimeWork);
        attendanceDto.setNightWorkOnHoliday(this.nightWorkOnHoliday);
        attendanceDto.setLegalWorkTime(this.legalHolidayWork);
        attendanceDto.setNightRestTime(this.nightRest);
        attendanceDto.setOverRestTime(this.overRestTime);
        attendanceDto.setTimesOvertime(0);
        if (this.overtimeTime > 0) {
            attendanceDto.setTimesOvertime(1);
        }
        attendanceDto.setOvertime(this.overtimeTime);
        attendanceDto.setOvertimeIn(this.withinStatutoryOvertime);
        attendanceDto.setOvertimeOut(this.overtimeOut);
        attendanceDto.setWorkdayOvertimeIn(this.workdayOvertimeIn);
        attendanceDto.setWorkdayOvertimeOut(this.workdayOvertimeOut);
        attendanceDto.setPrescribedHolidayOvertimeIn(this.prescribedHolidayOvertimeIn);
        attendanceDto.setPrescribedHolidayOvertimeOut(this.prescribedHolidayOvertimeOut);
        attendanceDto.setOvertimeAfter(this.workAfterTime);
        attendanceDto.setOvertimeBefore(this.workBeforeTime);
        attendanceDto.setPrivateTime(this.totalPrivate);
        attendanceDto.setPublicTime(this.totalPublic);
        attendanceDto.setMinutelyHolidayATime(this.totalMinutelyHolidayA);
        attendanceDto.setMinutelyHolidayBTime(this.totalMinutelyHolidayB);
        attendanceDto.setRestTime(this.totalRest);
        attendanceDto.setLegalHolidayRestTime(this.legalHolidayRest);
        attendanceDto.setPrescribedHolidayRestTime(this.prescribedHolidayRest);
        attendanceDto.setSpecificWorkTime(this.prescribedHolidayWork);
        attendanceDto.setWorkTime(this.getWorkTime());
        attendanceDto.setWorkTimeWithinPrescribedWorkTime(attendanceDto.getWorkTime() - this.overtimeTime - this.legalHolidayWork);
        attendanceDto.setContractWorkTime(this.getContractWorkTime());
        attendanceDto.setShortUnpaid(this.getShortUnpaid(requestUtil));
        attendanceDto.setWorkDays(1.0);
        if (this.isAmHalfDayOff(requestUtil) || this.isPmHalfDayOff(requestUtil)) {
            attendanceDto.setWorkDays(0.5);
        }
        attendanceDto.setWorkDaysForPaidLeave(1);
        attendanceDto.setTotalWorkDaysForPaidLeave(1);
        attendanceDto.setTimesHolidayWork(0);
        attendanceDto.setTimesLegalHolidayWork(0);
        attendanceDto.setTimesPrescribedHolidayWork(0);
        if (isWorkOnLegalDaysOff || isWorkOnPrescribedDaysOff) {
            attendanceDto.setWorkDaysForPaidLeave(0);
            attendanceDto.setTotalWorkDaysForPaidLeave(0);
            attendanceDto.setTimesHolidayWork(1);
            if (isWorkOnLegalDaysOff) {
                attendanceDto.setTimesLegalHolidayWork(1);
            }
            if (isWorkOnPrescribedDaysOff) {
                attendanceDto.setTimesPrescribedHolidayWork(1);
            }
        }
        attendanceDto.setPaidLeaveDays(0.0);
        if (this.isPaidLeaveAm || this.isPaidLeavePm) {
            attendanceDto.setPaidLeaveDays(0.5);
        }
        attendanceDto.setPaidLeaveHours(this.paidLeaveHour);
        attendanceDto.setStockLeaveDays(0.0);
        if (this.isStockLeaveAm || this.isStockLeavePm) {
            attendanceDto.setStockLeaveDays(0.5);
        }
        attendanceDto.setCompensationDays(0.0);
        attendanceDto.setLegalCompensationDays(0.0);
        attendanceDto.setPrescribedCompensationDays(0.0);
        attendanceDto.setNightCompensationDays(0.0);
        if (this.isLegalCompensationDayAm || this.isLegalCompensationDayPm || this.isPrescribedCompensationDayAm || this.isPrescribedCompensationDayPm || this.isNightCompensationDaysAm || this.isNightCompensationDaysPm) {
            attendanceDto.setCompensationDays(0.5);
            if (this.isLegalCompensationDayAm || this.isLegalCompensationDayPm) {
                attendanceDto.setLegalCompensationDays(0.5);
            } else if (this.isPrescribedCompensationDayAm || this.isPrescribedCompensationDayPm) {
                attendanceDto.setPrescribedCompensationDays(0.5);
            } else if (this.isNightCompensationDaysAm || this.isNightCompensationDaysPm) {
                attendanceDto.setNightCompensationDays(0.5);
            }
        }
        attendanceDto.setSpecialLeaveDays(0.0);
        if (this.isSpecialLeaveAm || this.isSpecialLeavePm) {
            attendanceDto.setSpecialLeaveDays(0.5);
        }
        attendanceDto.setSpecialLeaveHours(this.specialLeaveHour);
        attendanceDto.setOtherLeaveDays(0.0);
        if (this.isOtherLeaveAm || this.isOtherLeavePm) {
            attendanceDto.setOtherLeaveDays(0.5);
        }
        attendanceDto.setOtherLeaveHours(this.otherLeaveHour);
        attendanceDto.setAbsenceDays(0.0);
        if (this.isAbsenceAm || this.isAbsencePm) {
            attendanceDto.setAbsenceDays(0.5);
        }
        attendanceDto.setAbsenceHours(this.absenceHour);
        attendanceDto.setGrantedLegalCompensationDays(this.grantedLegalCompensationDays);
        attendanceDto.setGrantedPrescribedCompensationDays(this.grantedPrescribedCompensationDays);
        attendanceDto.setGrantedNightCompensationDays(this.grantedNightCompensationDays);
        attendanceDto.setLegalHolidayWorkTimeWithCompensationDay(0);
        attendanceDto.setLegalHolidayWorkTimeWithoutCompensationDay(0);
        attendanceDto.setPrescribedHolidayWorkTimeWithCompensationDay(0);
        attendanceDto.setPrescribedHolidayWorkTimeWithoutCompensationDay(0);
        attendanceDto.setOvertimeInWithCompensationDay(0);
        attendanceDto.setOvertimeInWithoutCompensationDay(0);
        attendanceDto.setOvertimeOutWithCompensationDay(0);
        attendanceDto.setOvertimeOutWithoutCompensationDay(0);
        attendanceDto.setStatutoryHolidayWorkTimeIn(this.statutoryHolidayWorkIn);
        attendanceDto.setStatutoryHolidayWorkTimeOut(this.statutoryHolidayWorkOut);
        attendanceDto.setPrescribedHolidayWorkTimeIn(this.prescribedHolidayWorkIn);
        attendanceDto.setPrescribedHolidayWorkTimeOut(this.prescribedHolidayWorkOut);
    }

    protected void setLate(AttendanceDtoInterface dto) {
        dto.setLateTime(this.isLateReasonTrain() || this.isLateReasonCompany() ? 0 : this.lateTime);
        dto.setActualLateTime(this.lateTime);
        dto.setLateDays(0);
        dto.setLateThirtyMinutesOrMore(0);
        dto.setLateLessThanThirtyMinutes(0);
        dto.setLateThirtyMinutesOrMoreTime(0);
        dto.setLateLessThanThirtyMinutesTime(0);
        if (dto.getLateTime() > 0) {
            dto.setLateDays(1);
            if (dto.getLateTime() >= 30) {
                dto.setLateThirtyMinutesOrMore(1);
                dto.setLateThirtyMinutesOrMoreTime(this.lateTime);
            } else {
                dto.setLateLessThanThirtyMinutes(1);
                dto.setLateLessThanThirtyMinutesTime(this.lateTime);
            }
            if (dto.getLateReason().isEmpty()) {
                dto.setLateReason("individu");
            }
        }
        if (this.lateTime == 0 && "individu".equals(dto.getLateReason())) {
            dto.setLateReason("");
        }
    }

    protected void setLeaveEarly(AttendanceDtoInterface dto) {
        dto.setLeaveEarlyTime(this.isLeaveEarlyReasonCompany() ? 0 : this.leaveEarlyTime);
        dto.setActualLeaveEarlyTime(this.leaveEarlyTime);
        dto.setLeaveEarlyDays(0);
        dto.setLeaveEarlyThirtyMinutesOrMore(0);
        dto.setLeaveEarlyLessThanThirtyMinutes(0);
        dto.setLeaveEarlyThirtyMinutesOrMoreTime(0);
        dto.setLeaveEarlyLessThanThirtyMinutesTime(0);
        if (dto.getLeaveEarlyTime() > 0) {
            dto.setLeaveEarlyDays(1);
            if (dto.getLeaveEarlyTime() >= 30) {
                dto.setLeaveEarlyThirtyMinutesOrMore(1);
                dto.setLeaveEarlyThirtyMinutesOrMoreTime(this.leaveEarlyTime);
            } else {
                dto.setLeaveEarlyLessThanThirtyMinutes(1);
                dto.setLeaveEarlyLessThanThirtyMinutesTime(this.leaveEarlyTime);
            }
            if (dto.getLeaveEarlyReason().isEmpty()) {
                dto.setLeaveEarlyReason("individu");
            }
        }
        if (this.leaveEarlyTime == 0 && "individu".equals(dto.getLeaveEarlyReason())) {
            dto.setLeaveEarlyReason("");
        }
    }

    protected boolean isWorkOnLegalDaysOff() {
        return "work_on_legal".equals(this.workTypeCode);
    }

    protected boolean isWorkOnPrescribedDaysOff() {
        return "work_on_prescribed".equals(this.workTypeCode);
    }

    protected boolean isNextDayWorkOnLegalDaysOff() {
        return "work_on_legal".equals(this.nextDayWorkTypeCode);
    }

    protected boolean isNextDayWorkOnPrescribedDaysOff() {
        return "work_on_prescribed".equals(this.nextDayWorkTypeCode);
    }

    protected boolean isNextDayLegalDaysOff() {
        return "legal_holiday".equals(this.nextDayWorkTypeCode);
    }

    protected boolean isNextDayPrescribedDaysOff() {
        return "prescribed_holiday".equals(this.nextDayWorkTypeCode);
    }

    public boolean isAmHalfDayOff(RequestUtilBeanInterface requestUtil) throws MospException {
        if (requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(true)) == 2) {
            return true;
        }
        if (requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(true)) == 2) {
            return true;
        }
        if (requestUtil.checkHolidayRangeSubstitute(requestUtil.getSubstituteList(true)) == 2) {
            return true;
        }
        if (!requestUtil.getSubstituteList(true).isEmpty()) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null) {
            return false;
        }
        return workOnHolidayRequestDto.getSubstitute() == 4;
    }

    public boolean isPmHalfDayOff(RequestUtilBeanInterface requestUtil) throws MospException {
        if (requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(true)) == 3) {
            return true;
        }
        if (requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(true)) == 3) {
            return true;
        }
        if (requestUtil.checkHolidayRangeSubstitute(requestUtil.getSubstituteList(true)) == 3) {
            return true;
        }
        if (!requestUtil.getSubstituteList(true).isEmpty()) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null) {
            return false;
        }
        return workOnHolidayRequestDto.getSubstitute() == 3;
    }

    public void calcHolidayRequest(RequestUtilBeanInterface requestUtil) throws MospException {
        List list = requestUtil.getHolidayList(true);
        for (HolidayRequestDtoInterface dto : list) {
            int holidayType1 = dto.getHolidayType1();
            boolean is1PaidLeave = holidayType1 == 1;
            boolean isSpecialLeave = holidayType1 == 2;
            boolean isOtherLeave = holidayType1 == 3;
            boolean isAbsence = holidayType1 == 4;
            boolean is2PaidLeave = Integer.toString(1).equals(dto.getHolidayType2());
            boolean isStockLeave = Integer.toString(2).equals(dto.getHolidayType2());
            int holidayRange = dto.getHolidayRange();
            if (holidayRange == 2) {
                if (is1PaidLeave) {
                    if (is2PaidLeave) {
                        this.isPaidLeaveAm = true;
                        continue;
                    }
                    if (!isStockLeave) continue;
                    this.isStockLeaveAm = true;
                    continue;
                }
                if (isSpecialLeave) {
                    this.isSpecialLeaveAm = true;
                    continue;
                }
                if (isOtherLeave) {
                    this.isOtherLeaveAm = true;
                    continue;
                }
                if (!isAbsence) continue;
                this.isAbsenceAm = true;
                continue;
            }
            if (holidayRange == 3) {
                if (is1PaidLeave) {
                    if (is2PaidLeave) {
                        this.isPaidLeavePm = true;
                        continue;
                    }
                    if (!isStockLeave) continue;
                    this.isStockLeavePm = true;
                    continue;
                }
                if (isSpecialLeave) {
                    this.isSpecialLeavePm = true;
                    continue;
                }
                if (isOtherLeave) {
                    this.isOtherLeavePm = true;
                    continue;
                }
                if (!isAbsence) continue;
                this.isAbsencePm = true;
                continue;
            }
            if (holidayRange != 4) continue;
            if (is1PaidLeave && is2PaidLeave) {
                this.paidLeaveHour += dto.getUseHour();
                this.paidLeaveHourMap.put(dto.getStartTime(), dto.getEndTime());
                continue;
            }
            if (isSpecialLeave) {
                this.specialLeaveHour += dto.getUseHour();
                this.specialLeaveHourMap.put(dto.getStartTime(), dto.getEndTime());
                continue;
            }
            if (isOtherLeave) {
                this.otherLeaveHour += dto.getUseHour();
                this.otherLeaveHourMap.put(dto.getStartTime(), dto.getEndTime());
                continue;
            }
            if (!isAbsence) continue;
            this.absenceHour += dto.getUseHour();
            this.absenceHourMap.put(dto.getStartTime(), dto.getEndTime());
        }
    }

    public void calcSubHolidayRequestDays(RequestUtilBeanInterface requestUtil) throws MospException {
        List list = requestUtil.getSubHolidayList(true);
        for (SubHolidayRequestDtoInterface dto : list) {
            boolean isLegal = dto.getWorkDateSubHolidayType() == 2;
            boolean isPrescribed = dto.getWorkDateSubHolidayType() == 1;
            boolean isNight = dto.getWorkDateSubHolidayType() == 3;
            int holidayRange = dto.getHolidayRange();
            if (holidayRange == 2) {
                if (isLegal) {
                    this.isLegalCompensationDayAm = true;
                    continue;
                }
                if (isPrescribed) {
                    this.isPrescribedCompensationDayAm = true;
                    continue;
                }
                if (!isNight) continue;
                this.isNightCompensationDaysAm = true;
                continue;
            }
            if (holidayRange != 3) continue;
            if (isLegal) {
                this.isLegalCompensationDayPm = true;
                continue;
            }
            if (isPrescribed) {
                this.isPrescribedCompensationDayPm = true;
                continue;
            }
            if (!isNight) continue;
            this.isNightCompensationDaysPm = true;
        }
    }

    public void attendanceCalc(AttendanceDtoInterface attendanceDto) throws MospException {
        List restList = this.restReference.getRestList(attendanceDto.getPersonalId(), attendanceDto.getWorkDate(), attendanceDto.getTimesWork());
        List publicGoOutList = this.goOutReference.getPublicGoOutList(attendanceDto.getPersonalId(), attendanceDto.getWorkDate());
        List privateGoOutList = this.goOutReference.getPrivateGoOutList(attendanceDto.getPersonalId(), attendanceDto.getWorkDate());
        List minutelyHolidayAList = this.goOutReference.getMinutelyHolidayAList(attendanceDto.getPersonalId(), attendanceDto.getWorkDate());
        List minutelyHolidayBList = this.goOutReference.getMinutelyHolidayBList(attendanceDto.getPersonalId(), attendanceDto.getWorkDate());
        this.attendanceCalc(attendanceDto, restList, publicGoOutList, privateGoOutList, minutelyHolidayAList, minutelyHolidayBList);
    }

    protected void setInputParameters(AttendanceDtoInterface attendanceDto, List<RestDtoInterface> restList, List<GoOutDtoInterface> publicGoOutList, List<GoOutDtoInterface> privateGoOutList, List<GoOutDtoInterface> minutelyHolidayAList, List<GoOutDtoInterface> minutelyHolidayBList) throws MospException {
        this.inputAttendanceDto = AttendanceUtility.getAttendanceDtoClone(null, (AttendanceDtoInterface)attendanceDto);
        this.inputRestList = new ArrayList(restList.size());
        for (RestDtoInterface restDtoInterface : restList) {
            this.inputRestList.add(AttendanceUtility.getRestDtoClone(null, (RestDtoInterface)restDtoInterface));
        }
        this.inputPublicGoOutList = new ArrayList(publicGoOutList.size());
        for (GoOutDtoInterface goOutDtoInterface : publicGoOutList) {
            this.inputPublicGoOutList.add(AttendanceUtility.getGoOutDtoClone(null, (GoOutDtoInterface)goOutDtoInterface));
        }
        this.inputPrivateGoOutList = new ArrayList(privateGoOutList.size());
        for (GoOutDtoInterface goOutDtoInterface : privateGoOutList) {
            this.inputPrivateGoOutList.add(AttendanceUtility.getGoOutDtoClone(null, (GoOutDtoInterface)goOutDtoInterface));
        }
        this.inputMinutelyHolidayAList = new ArrayList(minutelyHolidayAList.size());
        for (GoOutDtoInterface goOutDtoInterface : minutelyHolidayAList) {
            this.inputMinutelyHolidayAList.add(AttendanceUtility.getGoOutDtoClone(null, (GoOutDtoInterface)goOutDtoInterface));
        }
        this.inputMinutelyHolidayBList = new ArrayList(minutelyHolidayBList.size());
        for (GoOutDtoInterface goOutDtoInterface : minutelyHolidayBList) {
            this.inputMinutelyHolidayBList.add(AttendanceUtility.getGoOutDtoClone(null, (GoOutDtoInterface)goOutDtoInterface));
        }
    }

    public void attendanceCalc(AttendanceDtoInterface attendanceDto, List<RestDtoInterface> restList, List<GoOutDtoInterface> publicGoOutList, List<GoOutDtoInterface> privateGoOutList, List<GoOutDtoInterface> minutelyHolidayAList, List<GoOutDtoInterface> minutelyHolidayBList) throws MospException {
        this.personalId = attendanceDto.getPersonalId();
        this.workDate = attendanceDto.getWorkDate();
        this.setInputParameters(attendanceDto, restList, publicGoOutList, privateGoOutList, minutelyHolidayAList, minutelyHolidayBList);
        this.setCalcInfo(attendanceDto, restList, publicGoOutList, privateGoOutList, minutelyHolidayAList, minutelyHolidayBList);
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(this.personalId, this.workDate);
        this.initAttendanceTotal(this.personalId, attendanceDto.getWorkTypeCode(), requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.setShort();
        this.calcHolidayRequest(requestUtil);
        this.calcSubHolidayRequestDays(requestUtil);
        this.minutelyHolidayADtoList = this.goOutReference.getMinutelyHolidayAList(this.personalId, this.workDate);
        this.minutelyHolidayBDtoList = this.goOutReference.getMinutelyHolidayBList(this.personalId, this.workDate);
        this.calcMinutelyHolidayATime();
        this.calcMinutelyHolidayBTime();
        this.setAutoCalc(requestUtil);
        this.getCalcInfo(attendanceDto, requestUtil);
        this.setLate(attendanceDto);
        this.setLeaveEarly(attendanceDto);
        this.checkOvertimeRest();
    }

    public void calcStartEndTime(AttendanceDtoInterface attendanceDto, boolean useBetweenTime) throws MospException {
        this.setCalcInfo(attendanceDto, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
        this.personalId = attendanceDto.getPersonalId();
        this.workDate = attendanceDto.getWorkDate();
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(this.personalId, this.workDate);
        this.initAttendanceTotal(this.personalId, attendanceDto.getWorkTypeCode(), requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.setShort();
        this.calcHolidayRequest(requestUtil);
        this.minutelyHolidayADtoList = this.goOutReference.getMinutelyHolidayAList(this.personalId, this.workDate);
        this.minutelyHolidayBDtoList = this.goOutReference.getMinutelyHolidayBList(this.personalId, this.workDate);
        this.calcMinutelyHolidayATime();
        this.calcMinutelyHolidayBTime();
        if (this.startTime != null) {
            this.calcCalculatedStart(useBetweenTime, requestUtil);
        }
        if (this.endTime != null) {
            this.calcCalculatedEnd(useBetweenTime, requestUtil);
        }
        attendanceDto.setStartTime(this.startTime == null ? this.startTime : this.getAttendanceTime(this.workDate, this.calculatedStart));
        attendanceDto.setEndTime(this.endTime == null ? this.endTime : this.getAttendanceTime(this.workDate, this.calculatedEnd));
        this.setActualStartTime(attendanceDto);
        this.setActualEndTime(attendanceDto);
    }

    protected void setActualStartTime(AttendanceDtoInterface attendanceDto) throws MospException {
        if (attendanceDto.getActualStartTime() == null) {
            return;
        }
        if (this.timeSettingDto.getUseScheduledTime() == 1) {
            return;
        }
        WorkTypeItemDtoInterface workStartDto = this.workTypeItemReference.getWorkTypeItemInfo(this.workTypeCode, this.workDate, "AutoBefOverWork");
        if (workStartDto != null && workStartDto.getPreliminary().equals(String.valueOf(0))) {
            return;
        }
        int actualStartMinute = this.getRoundMinute(this.getDefferenceMinutes(this.workDate, attendanceDto.getActualStartTime()), this.timeSettingDto.getRoundDailyStart(), this.timeSettingDto.getRoundDailyStartUnit());
        Date actualStartTime = this.getAttendanceTime(this.workDate, actualStartMinute);
        if (this.useShort1 && this.isShort1StartTypePay && this.short1Start <= actualStartMinute && actualStartMinute <= this.short1End) {
            attendanceDto.setActualStartTime(actualStartTime);
            return;
        }
        if (this.isIncludedInHourlyHoliday(actualStartTime)) {
            attendanceDto.setActualStartTime(actualStartTime);
            return;
        }
        attendanceDto.setActualStartTime(attendanceDto.getStartTime());
    }

    protected void setActualEndTime(AttendanceDtoInterface attendanceDto) {
        if (attendanceDto.getActualEndTime() == null) {
            return;
        }
        if (this.timeSettingDto.getUseScheduledTime() == 1) {
            return;
        }
        int actualEndMinute = this.getRoundMinute(this.getDefferenceMinutes(this.workDate, attendanceDto.getActualEndTime()), this.timeSettingDto.getRoundDailyEnd(), this.timeSettingDto.getRoundDailyEndUnit());
        Date actualEndTime = this.getAttendanceTime(this.workDate, actualEndMinute);
        if (this.useShort2 && this.isShort2StartTypePay && this.short2Start <= actualEndMinute && actualEndMinute <= this.short2End) {
            attendanceDto.setActualEndTime(actualEndTime);
            return;
        }
        if (this.isIncludedInHourlyHoliday(actualEndTime)) {
            attendanceDto.setActualEndTime(actualEndTime);
            return;
        }
        attendanceDto.setActualEndTime(attendanceDto.getEndTime());
    }

    protected boolean isIncludedInHourlyHoliday(Date targetTime) {
        for (Map.Entry entry : this.paidLeaveHourMap.entrySet()) {
            if (targetTime.before((Date)entry.getKey()) || targetTime.after((Date)entry.getValue())) continue;
            return true;
        }
        for (Map.Entry entry : this.specialLeaveHourMap.entrySet()) {
            if (targetTime.before((Date)entry.getKey()) || targetTime.after((Date)entry.getValue())) continue;
            return true;
        }
        for (Map.Entry entry : this.otherLeaveHourMap.entrySet()) {
            if (targetTime.before((Date)entry.getKey()) || targetTime.after((Date)entry.getValue())) continue;
            return true;
        }
        for (Map.Entry entry : this.absenceHourMap.entrySet()) {
            if (targetTime.before((Date)entry.getKey()) || targetTime.after((Date)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    protected void setShort() throws MospException {
        this.useShort1 = false;
        this.useShort2 = false;
        this.isShort1StartTypePay = false;
        this.isShort2StartTypePay = false;
        this.short1Start = 0;
        this.short1End = 0;
        this.short2Start = 0;
        this.short2End = 0;
        if (this.isWorkOnLegalDaysOff() || this.isWorkOnPrescribedDaysOff()) {
            return;
        }
        if (this.differenceDto != null) {
            return;
        }
        WorkTypeEntity workTypeEntity = this.workTypeReference.getWorkTypeEntity(this.workTypeCode, this.workDate);
        if (workTypeEntity == null) {
            return;
        }
        this.isShort1StartTypePay = workTypeEntity.isShort1TypePay();
        this.isShort2StartTypePay = workTypeEntity.isShort2TypePay();
        if (workTypeEntity.getShort1StartTime() != null) {
            this.short1Start = this.getDefferenceMinutes(this.getDefaultStandardDate(), workTypeEntity.getShort1StartTime());
        }
        if (workTypeEntity.getShort1EndTime() != null) {
            this.short1End = this.getDefferenceMinutes(this.getDefaultStandardDate(), workTypeEntity.getShort1EndTime());
        }
        this.useShort1 = workTypeEntity.isShort1TimeSet();
        if (workTypeEntity.getShort2StartTime() != null) {
            this.short2Start = this.getDefferenceMinutes(this.getDefaultStandardDate(), workTypeEntity.getShort2StartTime());
        }
        if (workTypeEntity.getShort2EndTime() != null) {
            this.short2End = this.getDefferenceMinutes(this.getDefaultStandardDate(), workTypeEntity.getShort2EndTime());
        }
        this.useShort2 = workTypeEntity.isShort2TimeSet();
    }

    protected void calcCalculatedStart(boolean useBetweenTime, RequestUtilBeanInterface requestUtil) throws MospException {
        int betweenTime = 0;
        if (useBetweenTime && this.beforeOvertimeDto != null && this.isAmHalfDayOff(requestUtil)) {
            betweenTime = this.beforeOvertimeDto.getRequestTime() < this.betweenHalfHolidayTime ? this.beforeOvertimeDto.getRequestTime() : this.betweenHalfHolidayTime;
        }
        if (useBetweenTime && this.afterOvertimeDto != null && this.isPmHalfDayOff(requestUtil)) {
            betweenTime = this.afterOvertimeDto.getRequestTime() < this.betweenHalfHolidayTime ? this.afterOvertimeDto.getRequestTime() : this.betweenHalfHolidayTime;
        }
        int actualWorkBegin = this.getRoundMinute(this.getDefferenceMinutes(this.workDate, this.startTime), this.timeSettingDto.getRoundDailyStart(), this.timeSettingDto.getRoundDailyStartUnit());
        if (this.allMinutelyHolidayA || this.allMinutelyHolidayB) {
            this.calculatedStart = this.regWorkStart;
            return;
        }
        if (this.isWorkOnLegalDaysOff() || this.isWorkOnPrescribedDaysOff()) {
            if (this.directStart) {
                this.calculatedStart = this.regWorkStart;
                return;
            }
            this.regWorkStart = actualWorkBegin;
            this.calculatedStart = actualWorkBegin;
            return;
        }
        if (!this.isAmHalfDayOff(requestUtil) && this.useShort1 && actualWorkBegin > this.short1Start && actualWorkBegin <= this.short1End) {
            actualWorkBegin = this.isShort1StartTypePay ? this.short1Start : this.short1End;
        }
        if (this.isPmHalfDayOff(requestUtil)) {
            if (actualWorkBegin > this.regWorkEnd + betweenTime) {
                actualWorkBegin = this.regWorkEnd + betweenTime;
            }
        } else if (this.useShort2 && this.isShort2StartTypePay && actualWorkBegin > this.short2Start && actualWorkBegin <= this.short2End) {
            actualWorkBegin = this.short2Start;
        }
        if (actualWorkBegin >= this.regWorkStart) {
            if (this.directStart) {
                this.calculatedStart = this.getDirectCalculatedStart(requestUtil);
                return;
            }
            if (!this.isAmHalfDayOff(requestUtil) && this.useShort1 && actualWorkBegin >= this.short1Start && actualWorkBegin <= this.short1End) {
                this.calculatedStart = this.isShort1StartTypePay ? this.short1Start : this.short1End;
                return;
            }
            if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay && actualWorkBegin > this.short2Start && actualWorkBegin <= this.short2End) {
                this.calculatedStart = this.short2Start;
                return;
            }
            actualWorkBegin = this.getRoundStartTime(actualWorkBegin, betweenTime);
            return;
        }
        int planBeforeOvertime = 0;
        if (this.beforeOvertimeDto != null) {
            planBeforeOvertime = this.beforeOvertimeDto.getRequestTime();
        }
        if (!this.isAmHalfDayOff(requestUtil) && this.useShort1 && !this.isShort1StartTypePay) {
            planBeforeOvertime = 0;
        }
        if (planBeforeOvertime <= 0) {
            if (!this.isAmHalfDayOff(requestUtil) && this.useShort1 && !this.isShort1StartTypePay) {
                this.calculatedStart = this.short1End;
                return;
            }
            this.calculatedStart = this.regWorkStart;
            return;
        }
        if (!this.calcCalculatedStartEx(requestUtil)) {
            return;
        }
        if (this.isAmHalfDayOff(requestUtil)) {
            int possibleBeforeTime = planBeforeOvertime;
            if (planBeforeOvertime >= betweenTime) {
                possibleBeforeTime = betweenTime;
            }
            this.calculatedStart = actualWorkBegin >= this.regWorkStart - possibleBeforeTime ? actualWorkBegin : this.regWorkStart - betweenTime;
            this.calcWorkBeforeTime();
            return;
        }
        this.calculatedStart = actualWorkBegin >= this.regWorkStart - planBeforeOvertime ? actualWorkBegin : this.regWorkStart - planBeforeOvertime;
        this.calcWorkBeforeTime();
    }

    protected void calcWorkBeforeTime() {
        int rest = 0;
        for (RestDtoInterface dto : this.restDtoList) {
            Date startTime = this.getRoundMinute(dto.getRestStart(), this.timeSettingDto.getRoundDailyRestStart(), this.timeSettingDto.getRoundDailyRestStartUnit());
            Date endTime = this.getRoundMinute(dto.getRestEnd(), this.timeSettingDto.getRoundDailyRestEnd(), this.timeSettingDto.getRoundDailyRestEndUnit());
            int start = DateUtility.getHour((Date)startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)startTime);
            int end = DateUtility.getHour((Date)endTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)endTime);
            if (start >= this.regWorkStart || end <= this.calculatedStart) continue;
            if (start < this.calculatedStart) {
                start = this.calculatedStart;
            }
            if (end > this.regWorkStart) {
                end = this.regWorkStart;
            }
            rest += end - start;
        }
        int publicGoOut = 0;
        for (GoOutDtoInterface dto : this.publicGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPublicStart(), this.timeSettingDto.getRoundDailyPublicStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPublicEnd(), this.timeSettingDto.getRoundDailyPublicEndUnit());
            int start = DateUtility.getHour((Date)startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)startTime);
            int end = DateUtility.getHour((Date)endTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)endTime);
            if (start >= this.regWorkStart || end <= this.calculatedStart) continue;
            if (start < this.calculatedStart) {
                start = this.calculatedStart;
            }
            if (end > this.regWorkStart) {
                end = this.regWorkStart;
            }
            publicGoOut += end - start;
        }
        int privateGoOut = 0;
        for (GoOutDtoInterface dto : this.privateGoOutDtoList) {
            Date startTime = this.getRoundMinute(dto.getGoOutStart(), this.timeSettingDto.getRoundDailyPrivateStart(), this.timeSettingDto.getRoundDailyPrivateStartUnit());
            Date endTime = this.getRoundMinute(dto.getGoOutEnd(), this.timeSettingDto.getRoundDailyPrivateEnd(), this.timeSettingDto.getRoundDailyPrivateEndUnit());
            int start = DateUtility.getHour((Date)startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)startTime);
            int end = DateUtility.getHour((Date)endTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)endTime);
            if (start >= this.regWorkStart || end <= this.calculatedStart) continue;
            if (start < this.calculatedStart) {
                start = this.calculatedStart;
            }
            if (end > this.regWorkStart) {
                end = this.regWorkStart;
            }
            privateGoOut += end - start;
        }
        int minutelyHolidayA = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayADtoList) {
            Date startTime = dto.getGoOutStart();
            Date endTime = dto.getGoOutEnd();
            int start = DateUtility.getHour((Date)startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)startTime);
            int end = DateUtility.getHour((Date)endTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)endTime);
            if (start >= this.regWorkStart || end <= this.calculatedStart) continue;
            if (start < this.calculatedStart) {
                start = this.calculatedStart;
            }
            if (end > this.regWorkStart) {
                end = this.regWorkStart;
            }
            minutelyHolidayA += end - start;
        }
        int minutelyHolidayB = 0;
        for (GoOutDtoInterface dto : this.minutelyHolidayBDtoList) {
            Date startTime = dto.getGoOutStart();
            Date endTime = dto.getGoOutEnd();
            int start = DateUtility.getHour((Date)startTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)startTime);
            int end = DateUtility.getHour((Date)endTime, (Date)this.workDate) * 60 + DateUtility.getMinute((Date)endTime);
            if (start >= this.regWorkStart || end <= this.calculatedStart) continue;
            if (start < this.calculatedStart) {
                start = this.calculatedStart;
            }
            if (end > this.regWorkStart) {
                end = this.regWorkStart;
            }
            minutelyHolidayB += end - start;
        }
        int beforeTime = this.getbeforeTime(this.regWorkStart, this.calculatedStart, rest, publicGoOut, privateGoOut, minutelyHolidayA, minutelyHolidayB);
        if (beforeTime < 0) {
            beforeTime = 0;
        }
        this.workBeforeTime = beforeTime;
    }

    protected int getRoundStartTime(int actualWorkBegin, int betweenTime) {
        TreeMap roundStartTimeMap = new TreeMap();
        for (Map.Entry entry : this.paidLeaveHourMap.entrySet()) {
            roundStartTimeMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.specialLeaveHourMap.entrySet()) {
            roundStartTimeMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.otherLeaveHourMap.entrySet()) {
            roundStartTimeMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.absenceHourMap.entrySet()) {
            roundStartTimeMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.minutelyHolidayAMap.entrySet()) {
            roundStartTimeMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.minutelyHolidayBMap.entrySet()) {
            roundStartTimeMap.put(entry.getKey(), entry.getValue());
        }
        int roundLeaveEnd = actualWorkBegin;
        for (Map.Entry entry : roundStartTimeMap.entrySet()) {
            int leaveHourStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
            int leaveHourEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
            if (roundLeaveEnd < leaveHourStart || roundLeaveEnd >= leaveHourEnd) continue;
            roundLeaveEnd = leaveHourEnd;
        }
        if (actualWorkBegin < roundLeaveEnd) {
            this.calculatedStart = roundLeaveEnd > this.regWorkEnd + betweenTime ? this.regWorkEnd + betweenTime : roundLeaveEnd;
            return roundLeaveEnd;
        }
        this.calculatedStart = actualWorkBegin;
        return roundLeaveEnd;
    }

    protected int getbeforeTime(int regWorkStart, int calculatedStart, int rest, int publicGoOut, int privateGoOut, int minutelyHolidayAGoOut, int minutelyHolidayBGoOut) {
        return regWorkStart - calculatedStart - rest - publicGoOut - privateGoOut - minutelyHolidayAGoOut - minutelyHolidayBGoOut;
    }

    protected void calcCalculatedEnd(boolean useBetweenTime, RequestUtilBeanInterface requestUtil) throws MospException {
        int betweenTime = 0;
        if (useBetweenTime && this.beforeOvertimeDto != null && this.isAmHalfDayOff(requestUtil)) {
            betweenTime = this.beforeOvertimeDto.getRequestTime() < this.betweenHalfHolidayTime ? this.beforeOvertimeDto.getRequestTime() : this.betweenHalfHolidayTime;
        }
        if (useBetweenTime && this.afterOvertimeDto != null && this.isPmHalfDayOff(requestUtil)) {
            betweenTime = this.afterOvertimeDto.getRequestTime() < this.betweenHalfHolidayTime ? this.afterOvertimeDto.getRequestTime() : this.betweenHalfHolidayTime;
        }
        int actualWorkEnd = this.getRoundMinute(this.getDefferenceMinutes(this.workDate, this.endTime), this.timeSettingDto.getRoundDailyEnd(), this.timeSettingDto.getRoundDailyEndUnit());
        if (this.allMinutelyHolidayA || this.allMinutelyHolidayB) {
            this.calculatedEnd = this.regWorkEnd;
            return;
        }
        if (this.isWorkOnLegalDaysOff() || this.isWorkOnPrescribedDaysOff()) {
            if (this.directEnd) {
                this.calculatedEnd = this.regWorkEnd;
                return;
            }
            this.calculatedEnd = actualWorkEnd;
            return;
        }
        if (this.isAmHalfDayOff(requestUtil)) {
            if (actualWorkEnd < this.regWorkStart - betweenTime) {
                actualWorkEnd = this.regWorkStart - betweenTime;
            }
        } else if (this.useShort1 && this.isShort1StartTypePay && actualWorkEnd >= this.short1Start && actualWorkEnd < this.short1End) {
            actualWorkEnd = this.short1End;
        }
        if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay && actualWorkEnd >= this.short2Start && actualWorkEnd < this.short2End) {
            actualWorkEnd = this.short2End;
        }
        if (actualWorkEnd <= this.regWorkEnd) {
            if (this.directEnd) {
                this.calculatedEnd = this.getDirectCalculatedEnd(requestUtil);
                return;
            }
            if (!this.isAmHalfDayOff(requestUtil) && this.useShort1 && this.isShort1StartTypePay && actualWorkEnd >= this.short1Start && actualWorkEnd < this.short1End) {
                this.calculatedEnd = this.short1End;
                return;
            }
            if (!this.isPmHalfDayOff(requestUtil) && this.useShort2 && this.isShort2StartTypePay && actualWorkEnd >= this.short2Start && actualWorkEnd < this.short2End) {
                this.calculatedEnd = this.short2End;
                return;
            }
            int paidLeaveStart = actualWorkEnd;
            boolean whileFlag = true;
            while (whileFlag) {
                int minutelyHolidayEnd;
                int minutelyHolidayStart;
                whileFlag = false;
                for (Map.Entry entry : this.minutelyHolidayAMap.entrySet()) {
                    minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                    minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                    if (paidLeaveStart <= minutelyHolidayStart || paidLeaveStart > minutelyHolidayEnd) continue;
                    paidLeaveStart = minutelyHolidayStart;
                    whileFlag = true;
                }
                for (Map.Entry entry : this.minutelyHolidayBMap.entrySet()) {
                    minutelyHolidayStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                    minutelyHolidayEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                    if (paidLeaveStart <= minutelyHolidayStart || paidLeaveStart > minutelyHolidayEnd) continue;
                    paidLeaveStart = minutelyHolidayStart;
                    whileFlag = true;
                }
                for (Map.Entry entry : this.paidLeaveHourMap.entrySet()) {
                    int paidLeaveHourStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                    int paidLeaveHourEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                    if (paidLeaveStart <= paidLeaveHourStart || paidLeaveStart > paidLeaveHourEnd) continue;
                    paidLeaveStart = paidLeaveHourStart;
                    whileFlag = true;
                }
                for (Map.Entry entry : this.specialLeaveHourMap.entrySet()) {
                    int specialLeaveHourStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                    int specialLeaveHourEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                    if (paidLeaveStart <= specialLeaveHourStart || paidLeaveStart > specialLeaveHourEnd) continue;
                    paidLeaveStart = specialLeaveHourStart;
                    whileFlag = true;
                }
                for (Map.Entry entry : this.otherLeaveHourMap.entrySet()) {
                    int otherLeaveHourStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                    int otherLeaveHourEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                    if (paidLeaveStart <= otherLeaveHourStart || paidLeaveStart > otherLeaveHourEnd) continue;
                    paidLeaveStart = otherLeaveHourStart;
                    whileFlag = true;
                }
                for (Map.Entry entry : this.absenceHourMap.entrySet()) {
                    int absenceHourStart = this.getDefferenceMinutes(this.workDate, (Date)entry.getKey());
                    int absenceHourEnd = this.getDefferenceMinutes(this.workDate, (Date)entry.getValue());
                    if (paidLeaveStart <= absenceHourStart || paidLeaveStart > absenceHourEnd) continue;
                    paidLeaveStart = absenceHourStart;
                    whileFlag = true;
                }
            }
            if (actualWorkEnd > paidLeaveStart) {
                if (paidLeaveStart < this.regWorkStart - betweenTime) {
                    this.calculatedEnd = this.regWorkStart - betweenTime;
                }
                this.calculatedEnd = paidLeaveStart;
                return;
            }
            this.calculatedEnd = actualWorkEnd;
            return;
        }
        if (!this.calcCalculatedEndEx(requestUtil)) {
            return;
        }
        if (this.isPmHalfDayOff(requestUtil)) {
            int planAfterOvertime = 0;
            if (this.afterOvertimeDto != null) {
                planAfterOvertime = this.afterOvertimeDto.getRequestTime();
            }
            if (planAfterOvertime <= 0) {
                this.calculatedEnd = this.regWorkEnd;
                return;
            }
            int possibleAfterTime = planAfterOvertime;
            if (planAfterOvertime >= betweenTime) {
                possibleAfterTime = betweenTime;
            }
            if (actualWorkEnd <= this.regWorkEnd + possibleAfterTime) {
                this.calculatedEnd = actualWorkEnd;
                return;
            }
            this.calculatedEnd = this.regWorkEnd + betweenTime;
            return;
        }
        this.calculatedEnd = actualWorkEnd;
    }

    protected int getDirectCalculatedStart(RequestUtilBeanInterface requestUtil) throws MospException {
        if (this.isAmHalfDayOff(requestUtil)) {
            return this.regWorkStart;
        }
        RequestEntity requestEntity = requestUtil.getRequestEntity(this.personalId, this.workDate);
        List holidayMinuteList = requestEntity.getHourlyHolidayFirstSequenceMinutes();
        if (this.useShort1 && !this.isShort1StartTypePay) {
            if (!holidayMinuteList.isEmpty() && (Integer)holidayMinuteList.get(0) == this.short1End) {
                return (Integer)holidayMinuteList.get(1);
            }
            return this.short1End;
        }
        if (!holidayMinuteList.isEmpty() && (Integer)holidayMinuteList.get(0) == this.regWorkStart) {
            return (Integer)holidayMinuteList.get(1);
        }
        return this.regWorkStart;
    }

    protected int getDirectCalculatedEnd(RequestUtilBeanInterface requestUtil) throws MospException {
        if (this.isPmHalfDayOff(requestUtil)) {
            return this.regWorkEnd;
        }
        RequestEntity requestEntity = requestUtil.getRequestEntity(this.personalId, this.workDate);
        List holidayMinuteList = requestEntity.getHourlyHolidayLastSequenceMinutes();
        if (this.useShort2 && !this.isShort2StartTypePay) {
            if (!holidayMinuteList.isEmpty() && (Integer)holidayMinuteList.get(1) == this.short2Start) {
                return (Integer)holidayMinuteList.get(0);
            }
            return this.short2Start;
        }
        if (!holidayMinuteList.isEmpty() && (Integer)holidayMinuteList.get(1) == this.regWorkEnd) {
            return (Integer)holidayMinuteList.get(0);
        }
        return this.regWorkEnd;
    }

    protected int getContractWorkTime() {
        int contractWorkTime = this.getWorkTime() - this.overtimeTime - this.legalHolidayWork;
        if (this.isLateReasonTrain() || this.isLateReasonCompany()) {
            contractWorkTime += this.lateTime;
        }
        if (this.isLeaveEarlyReasonCompany()) {
            contractWorkTime += this.leaveEarlyTime;
        }
        return contractWorkTime;
    }

    protected boolean isLateReasonTrain() {
        return "train".equals(this.lateReason);
    }

    protected boolean isLateReasonCompany() {
        return "company".equals(this.lateReason);
    }

    protected boolean isLeaveEarlyReasonCompany() {
        return "company".equals(this.leaveEarlyReason);
    }

    protected void checkRest() {
        String[] restNameArray = new String[]{this.mospParams.getName("Rest1"), this.mospParams.getName("Rest2"), this.mospParams.getName("Rest3"), this.mospParams.getName("Rest4"), this.mospParams.getName("Rest5"), this.mospParams.getName("Rest6")};
        for (int i = 0; i < this.restDtoList.size(); ++i) {
            RestDtoInterface restDto = (RestDtoInterface)this.restDtoList.get(i);
            String[] publicGoOutNameArray = new String[]{this.mospParams.getName("Official", new String[]{"GoingOut", "No1"}), this.mospParams.getName("Official", new String[]{"GoingOut", "No2"})};
            for (int j = 0; j < this.publicGoOutDtoList.size(); ++j) {
                GoOutDtoInterface goOutDto = (GoOutDtoInterface)this.publicGoOutDtoList.get(j);
                if (!this.isOverlap(restDto.getRestStart(), restDto.getRestEnd(), goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                this.addOverlapErrorMessage(restNameArray[i], publicGoOutNameArray[j]);
            }
            String[] privateGoOutNameArray = new String[]{this.mospParams.getName("PrivateGoingOut1"), this.mospParams.getName("PrivateGoingOut2")};
            for (int j = 0; j < this.privateGoOutDtoList.size(); ++j) {
                GoOutDtoInterface goOutDto = (GoOutDtoInterface)this.privateGoOutDtoList.get(j);
                if (!this.isOverlap(restDto.getRestStart(), restDto.getRestEnd(), goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                this.addOverlapErrorMessage(restNameArray[i], privateGoOutNameArray[j]);
            }
            String[] minutelyHolidayANameArray = new String[]{this.mospParams.getName("MinutelyHolidayA", new String[]{"No1"}), this.mospParams.getName("MinutelyHolidayA", new String[]{"No2"}), this.mospParams.getName("MinutelyHolidayA", new String[]{"No3"}), this.mospParams.getName("MinutelyHolidayA", new String[]{"No4"})};
            for (int j = 0; j < this.minutelyHolidayADtoList.size(); ++j) {
                GoOutDtoInterface goOutDto = (GoOutDtoInterface)this.minutelyHolidayADtoList.get(j);
                if (!this.isOverlap(restDto.getRestStart(), restDto.getRestEnd(), goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                this.addOverlapErrorMessage(restNameArray[i], minutelyHolidayANameArray[j]);
            }
            String[] minutelyHolidayBNameArray = new String[]{this.mospParams.getName("MinutelyHolidayB", new String[]{"No1"}), this.mospParams.getName("MinutelyHolidayB", new String[]{"No2"}), this.mospParams.getName("MinutelyHolidayB", new String[]{"No3"}), this.mospParams.getName("MinutelyHolidayB", new String[]{"No4"})};
            for (int j = 0; j < this.minutelyHolidayBDtoList.size(); ++j) {
                GoOutDtoInterface goOutDto = (GoOutDtoInterface)this.minutelyHolidayBDtoList.get(j);
                if (!this.isOverlap(restDto.getRestStart(), restDto.getRestEnd(), goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                this.addOverlapErrorMessage(restNameArray[i], minutelyHolidayBNameArray[j]);
            }
        }
    }

    protected void checkOvertimeRest() {
        String[] restNameArray = new String[]{this.mospParams.getName("Rest1"), this.mospParams.getName("Rest2"), this.mospParams.getName("Rest3"), this.mospParams.getName("Rest4"), this.mospParams.getName("Rest5"), this.mospParams.getName("Rest6")};
        for (int i = 0; i < this.restDtoList.size(); ++i) {
            boolean isOverlapOvertime;
            RestDtoInterface dto = (RestDtoInterface)this.restDtoList.get(i);
            Date[] overtimeBeforeArray = this.getOverlapOvertimeBeforeRestArray(dto.getRestStart(), dto.getRestEnd());
            boolean isOverlapOvertimeBefore = overtimeBeforeArray.length >= 2;
            Date[] overtimeArray = this.getOverlapOvertimeRestArray(dto.getRestStart(), dto.getRestEnd());
            boolean bl = isOverlapOvertime = overtimeArray.length >= 2;
            if (!isOverlapOvertimeBefore && !isOverlapOvertime) continue;
            if (isOverlapOvertimeBefore) {
                this.addOverlapOvertimeBeforeRestErrorMessage(restNameArray[i], overtimeBeforeArray[0], overtimeBeforeArray[1]);
            }
            if (!isOverlapOvertime) break;
            this.addOverlapOvertimeRestErrorMessage(restNameArray[i], overtimeArray[0], overtimeArray[1]);
            break;
        }
        StringBuffer publicGoOut1 = new StringBuffer();
        publicGoOut1.append(this.mospParams.getName("Official"));
        publicGoOut1.append(this.mospParams.getName("GoingOut"));
        publicGoOut1.append(this.mospParams.getName("No1"));
        StringBuffer publicGoOut2 = new StringBuffer();
        publicGoOut2.append(this.mospParams.getName("Official"));
        publicGoOut2.append(this.mospParams.getName("GoingOut"));
        publicGoOut2.append(this.mospParams.getName("No2"));
        String[] publicGoOutNameArray = new String[]{publicGoOut1.toString(), publicGoOut2.toString()};
        for (int i = 0; i < this.publicGoOutDtoList.size(); ++i) {
            boolean isOverlapOvertime;
            GoOutDtoInterface dto = (GoOutDtoInterface)this.publicGoOutDtoList.get(i);
            Date[] overtimeBeforeArray = this.getOverlapOvertimeBeforeRestArray(dto.getGoOutStart(), dto.getGoOutEnd());
            boolean isOverlapOvertimeBefore = overtimeBeforeArray.length >= 2;
            Date[] overtimeArray = this.getOverlapOvertimeRestArray(dto.getGoOutStart(), dto.getGoOutEnd());
            boolean bl = isOverlapOvertime = overtimeArray.length >= 2;
            if (!isOverlapOvertimeBefore && !isOverlapOvertime) continue;
            if (isOverlapOvertimeBefore) {
                this.addOverlapOvertimeBeforeRestErrorMessage(publicGoOutNameArray[i], overtimeBeforeArray[0], overtimeBeforeArray[1]);
            }
            if (!isOverlapOvertime) break;
            this.addOverlapOvertimeRestErrorMessage(publicGoOutNameArray[i], overtimeArray[0], overtimeArray[1]);
            break;
        }
        String[] privateGoOutNameArray = new String[]{this.mospParams.getName("PrivateGoingOut1"), this.mospParams.getName("PrivateGoingOut2")};
        for (int i = 0; i < this.privateGoOutDtoList.size(); ++i) {
            boolean isOverlapOvertime;
            GoOutDtoInterface dto = (GoOutDtoInterface)this.privateGoOutDtoList.get(i);
            Date[] overtimeBeforeArray = this.getOverlapOvertimeBeforeRestArray(dto.getGoOutStart(), dto.getGoOutEnd());
            boolean isOverlapOvertimeBefore = overtimeBeforeArray.length >= 2;
            Date[] overtimeArray = this.getOverlapOvertimeRestArray(dto.getGoOutStart(), dto.getGoOutEnd());
            boolean bl = isOverlapOvertime = overtimeArray.length >= 2;
            if (!isOverlapOvertimeBefore && !isOverlapOvertime) continue;
            if (isOverlapOvertimeBefore) {
                this.addOverlapOvertimeBeforeRestErrorMessage(privateGoOutNameArray[i], overtimeBeforeArray[0], overtimeBeforeArray[1]);
            }
            if (!isOverlapOvertime) break;
            this.addOverlapOvertimeRestErrorMessage(privateGoOutNameArray[i], overtimeArray[0], overtimeArray[1]);
            break;
        }
        String[] minutelyHolidayANameArray = new String[]{this.mospParams.getName("MinutelyHolidayA", new String[]{"No1"}), this.mospParams.getName("MinutelyHolidayA", new String[]{"No2"}), this.mospParams.getName("MinutelyHolidayA", new String[]{"No3"}), this.mospParams.getName("MinutelyHolidayA", new String[]{"No4"})};
        for (int i = 0; i < this.minutelyHolidayADtoList.size(); ++i) {
            boolean isOverlapOvertime;
            GoOutDtoInterface dto = (GoOutDtoInterface)this.minutelyHolidayADtoList.get(i);
            Date[] overtimeBeforeArray = this.getOverlapOvertimeBeforeRestArray(dto.getGoOutStart(), dto.getGoOutEnd());
            boolean isOverlapOvertimeBefore = overtimeBeforeArray.length >= 2;
            Date[] overtimeArray = this.getOverlapOvertimeRestArray(dto.getGoOutStart(), dto.getGoOutEnd());
            boolean bl = isOverlapOvertime = overtimeArray.length >= 2;
            if (!isOverlapOvertimeBefore && !isOverlapOvertime) continue;
            if (isOverlapOvertimeBefore) {
                this.addOverlapOvertimeBeforeRestErrorMessage(minutelyHolidayANameArray[i], overtimeBeforeArray[0], overtimeBeforeArray[1]);
            }
            if (!isOverlapOvertime) break;
            this.addOverlapOvertimeRestErrorMessage(minutelyHolidayANameArray[i], overtimeArray[0], overtimeArray[1]);
            break;
        }
        String[] minutelyHolidayBNameArray = new String[]{this.mospParams.getName("MinutelyHolidayB", new String[]{"No1"}), this.mospParams.getName("MinutelyHolidayB", new String[]{"No2"}), this.mospParams.getName("MinutelyHolidayB", new String[]{"No3"}), this.mospParams.getName("MinutelyHolidayB", new String[]{"No4"})};
        for (int i = 0; i < this.minutelyHolidayBDtoList.size(); ++i) {
            boolean isOverlapOvertime;
            GoOutDtoInterface dto = (GoOutDtoInterface)this.minutelyHolidayBDtoList.get(i);
            Date[] overtimeBeforeArray = this.getOverlapOvertimeBeforeRestArray(dto.getGoOutStart(), dto.getGoOutEnd());
            boolean isOverlapOvertimeBefore = overtimeBeforeArray.length >= 2;
            Date[] overtimeArray = this.getOverlapOvertimeRestArray(dto.getGoOutStart(), dto.getGoOutEnd());
            boolean bl = isOverlapOvertime = overtimeArray.length >= 2;
            if (!isOverlapOvertimeBefore && !isOverlapOvertime) continue;
            if (isOverlapOvertimeBefore) {
                this.addOverlapOvertimeBeforeRestErrorMessage(minutelyHolidayBNameArray[i], overtimeBeforeArray[0], overtimeBeforeArray[1]);
            }
            if (!isOverlapOvertime) break;
            this.addOverlapOvertimeRestErrorMessage(minutelyHolidayBNameArray[i], overtimeArray[0], overtimeArray[1]);
            break;
        }
    }

    protected Date[] getOverlapOvertimeBeforeRestArray(Date startTime, Date endTime) {
        for (Map.Entry entry : this.overtimeBeforeRestMap.entrySet()) {
            Date[] array = this.getOverlapArray(startTime, endTime, (Date)entry.getKey(), (Date)entry.getValue());
            if (array.length == 0) continue;
            return array;
        }
        return new Date[0];
    }

    protected Date[] getOverlapOvertimeRestArray(Date startTime, Date endTime) {
        for (Map.Entry entry : this.overtimeRestMap.entrySet()) {
            Date[] array = this.getOverlapArray(startTime, endTime, (Date)entry.getKey(), (Date)entry.getValue());
            if (array.length == 0) continue;
            return array;
        }
        return new Date[0];
    }

    protected Date[] getOverlapArray(Date startTime, Date endTime, Date targetStartTime, Date targetEndTime) {
        if (this.isOverlap(startTime, endTime, targetStartTime, targetEndTime)) {
            Date[] array = new Date[2];
            array[0] = targetStartTime;
            if (startTime.after(targetStartTime)) {
                array[0] = startTime;
            }
            array[1] = targetEndTime;
            if (endTime.before(targetEndTime)) {
                array[1] = endTime;
            }
            return array;
        }
        return new Date[0];
    }

    protected boolean isOverlap(Date startTime, Date endTime, Date targetStartTime, Date targetEndTime) {
        if (startTime == null || endTime == null || targetStartTime == null || targetEndTime == null) {
            return false;
        }
        return startTime.before(targetEndTime) && endTime.after(targetStartTime);
    }

    protected void addOverlapOvertimeBeforeRestErrorMessage(String nameOfTime, Date overlapStartTime, Date overlapEndTime) {
        this.addOverlapErrorMessage(nameOfTime, this.mospParams.getName("RestBeforeOvertimeWork"), overlapStartTime, overlapEndTime);
    }

    protected void addOverlapOvertimeRestErrorMessage(String nameOfTime, Date overlapStartTime, Date overlapEndTime) {
        this.addOverlapErrorMessage(nameOfTime, this.mospParams.getName("RestInOvertime"), overlapStartTime, overlapEndTime);
    }

    protected void addOverlapErrorMessage(String nameOfTime, String nameOfTargetTime, Date overlapStartTime, Date overlapEndTime) {
        this.mospParams.addErrorMessage("TMW0314", new String[]{nameOfTime, nameOfTargetTime, DateUtility.getStringTime((Date)overlapStartTime, (Date)this.workDate), DateUtility.getStringTime((Date)overlapEndTime, (Date)this.workDate)});
    }

    protected void addOverlapErrorMessage(String nameOfTime, String nameOfTargetTime) {
        this.mospParams.addErrorMessage("TMW0312", new String[]{DateUtility.getStringDateAndDay((Date)this.workDate), nameOfTime, nameOfTargetTime});
    }

    protected String getWorkTypeCode(String personalId, Date workDate, int timesWork) throws MospException {
        AttendanceDtoInterface dto = this.attendanceReference.findForKey(personalId, workDate, timesWork);
        WorkflowDtoInterface workflowDto = null;
        if (dto != null && (workflowDto = this.workflowReference.getLatestWorkflowInfo(dto.getWorkflow())) != null && "9".equals(workflowDto.getWorkflowStatus())) {
            return dto.getWorkTypeCode();
        }
        ScheduleUtilBeanInterface scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
        return scheduleUtil.getScheduledWorkTypeCode(personalId, workDate, true);
    }

    public int getDefferenceMinutes(Date startTime, Date endTime) {
        return super.getDefferenceMinutes(startTime, endTime);
    }

    protected Date getAttendanceTime(Date date, int time) {
        return TimeUtility.getAttendanceTime((Date)date, (String)Integer.toString(time / 60), (String)Integer.toString(time % 60), (MospParams)this.mospParams);
    }

    protected Date getRoundMinute(Date time, int type, int unit) {
        return TimeUtility.getRoundMinute((Date)time, (int)type, (int)unit);
    }

    protected boolean calcCalculatedStartEx(RequestUtilBeanInterface requestUtil) throws MospException {
        return true;
    }

    protected boolean calcCalculatedEndEx(RequestUtilBeanInterface requestUtil) throws MospException {
        return true;
    }
}

