/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowCommentDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.ManagementRequestListDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.RequestListDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.impl.ManagementRequestListDto;
import jp.mosp.time.utils.TimeUtility;

public class ApprovalInfoReferenceBean
extends PlatformBean
implements ApprovalInfoReferenceBeanInterface {
    protected static final String SEPARATOR_REQUEST_INFO = " ";
    protected HolidayDaoInterface holidayDao;
    protected HumanReferenceBeanInterface humanReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected AttendanceReferenceBeanInterface attendanceReference;
    protected OvertimeRequestReferenceBeanInterface overtimeRequest;
    protected HolidayRequestReferenceBeanInterface holidayRequest;
    protected WorkOnHolidayRequestReferenceBeanInterface workOnHolidayRequest;
    protected SubHolidayRequestReferenceBeanInterface subHolidayRequest;
    protected WorkTypeChangeRequestReferenceBeanInterface workTypeChangeRequest;
    protected DifferenceRequestReferenceBeanInterface differenceRequest;
    protected WorkflowCommentReferenceBeanInterface workflowCommentReference;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected SubstituteReferenceBeanInterface substituteReference;
    protected RequestUtilBeanInterface requestUtil;
    public static final String APP_ATTENDANCE_INFO = "AttendanceInfo";

    public ApprovalInfoReferenceBean() {
    }

    public ApprovalInfoReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.overtimeRequest = (OvertimeRequestReferenceBeanInterface)this.createBean(OvertimeRequestReferenceBeanInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.workOnHolidayRequest = (WorkOnHolidayRequestReferenceBeanInterface)this.createBean(WorkOnHolidayRequestReferenceBeanInterface.class);
        this.subHolidayRequest = (SubHolidayRequestReferenceBeanInterface)this.createBean(SubHolidayRequestReferenceBeanInterface.class);
        this.workTypeChangeRequest = (WorkTypeChangeRequestReferenceBeanInterface)this.createBean(WorkTypeChangeRequestReferenceBeanInterface.class);
        this.differenceRequest = (DifferenceRequestReferenceBeanInterface)this.createBean(DifferenceRequestReferenceBeanInterface.class);
        this.workflowCommentReference = (WorkflowCommentReferenceBeanInterface)this.createBean(WorkflowCommentReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.holidayDao = (HolidayDaoInterface)this.createDao(HolidayDaoInterface.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBean(SubstituteReferenceBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
    }

    public Map<String, Map<Long, WorkflowDtoInterface>> getApprovableMap(String personalId) throws MospException {
        return this.workflowIntegrate.getApprovableMap(personalId, TimeUtility.getTimeFunctionSet());
    }

    public Map<String, Map<Long, WorkflowDtoInterface>> getSubApprovableMap(String personalId, Map<String, Map<Long, WorkflowDtoInterface>> approvableMap) throws MospException {
        return this.workflowIntegrate.getSubApprovableMap(personalId, TimeUtility.getTimeFunctionSet(), 1, approvableMap);
    }

    public Map<String, Map<Long, WorkflowDtoInterface>> getCancelableMap(String personalId) throws MospException {
        return this.workflowIntegrate.getCancelableMap(personalId, TimeUtility.getTimeFunctionSet());
    }

    public Map<String, Map<Long, WorkflowDtoInterface>> getSubCancelableMap(String personalId, Map<String, Map<Long, WorkflowDtoInterface>> approvableMap) throws MospException {
        return this.workflowIntegrate.getSubCancelableMap(personalId, TimeUtility.getTimeFunctionSet(), 1, approvableMap);
    }

    public List<ManagementRequestListDtoInterface> getApprovableList(Map<String, Map<Long, WorkflowDtoInterface>> approvableMap, Map<String, Map<Long, WorkflowDtoInterface>> subApprovableMap, String functionCode) throws MospException {
        List list = this.getManagementRequestList(approvableMap, functionCode, false);
        list.addAll(this.getManagementRequestList(subApprovableMap, functionCode, true));
        return list;
    }

    protected List<ManagementRequestListDtoInterface> getManagementRequestList(Map<String, Map<Long, WorkflowDtoInterface>> workflowMap, String functionCode, boolean isSubApprove) throws MospException {
        ArrayList<ManagementRequestListDtoInterface> list = new ArrayList<ManagementRequestListDtoInterface>();
        ArrayList<WorkflowDtoInterface> workflowList = new ArrayList<WorkflowDtoInterface>();
        if (functionCode.isEmpty()) {
            for (Map<Long, WorkflowDtoInterface> functionMap : workflowMap.values()) {
                workflowList.addAll(functionMap.values());
            }
        } else {
            workflowList.addAll(workflowMap.get(functionCode).values());
        }
        for (WorkflowDtoInterface workflowDto : workflowList) {
            ManagementRequestListDtoInterface dto = this.getManagementRequestListDto(workflowDto, isSubApprove);
            if (dto == null) continue;
            list.add(dto);
        }
        return list;
    }

    public List<ManagementRequestListDtoInterface> getEffectiveList(String personalId, Date fromDate, Date toDate, Set<String> functionCodeSet, String state, Set<String> personalIdSet, Set<String> subordinateIdSet) throws MospException {
        ArrayList<ManagementRequestListDtoInterface> list = new ArrayList<ManagementRequestListDtoInterface>();
        List effectiveList = this.workflowIntegrate.getEffectiveList(personalId, fromDate, toDate, functionCodeSet, state, personalIdSet, subordinateIdSet);
        for (WorkflowDtoInterface workflowDto : effectiveList) {
            ManagementRequestListDtoInterface dto = this.getManagementRequestListDto(workflowDto, false);
            if (dto == null) continue;
            list.add(dto);
        }
        return list;
    }

    public List<ManagementRequestListDtoInterface> getCompletedList(String personalId, Date fromDate, Date toDate, Set<String> functionCodeSet) throws MospException {
        ArrayList<ManagementRequestListDtoInterface> list = new ArrayList<ManagementRequestListDtoInterface>();
        List effectiveList = this.workflowIntegrate.getCompletedList(personalId, fromDate, toDate, functionCodeSet);
        for (WorkflowDtoInterface workflowDto : effectiveList) {
            ManagementRequestListDtoInterface dto = this.getManagementRequestListDto(workflowDto, false);
            if (dto == null) continue;
            list.add(dto);
        }
        return list;
    }

    public ManagementRequestListDtoInterface getManagementRequestListDto(WorkflowDtoInterface workflowDto, boolean isSubApprove) throws MospException {
        ManagementRequestListDto dto = new ManagementRequestListDto();
        long workflow = workflowDto.getWorkflow();
        String personalId = workflowDto.getPersonalId();
        Date workflowDate = workflowDto.getWorkflowDate();
        String functionCode = workflowDto.getFunctionCode();
        dto.setPersonalId(personalId);
        dto.setRequestType(functionCode);
        dto.setRequestDate(workflowDto.getWorkflowDate());
        dto.setWorkflow(workflow);
        dto.setState(workflowDto.getWorkflowStatus());
        dto.setStage(workflowDto.getWorkflowStage());
        this.setWorkflowInfo((RequestListDtoInterface)dto, workflowDto);
        String employeeCode = "";
        String lastName = "";
        String firstName = "";
        String sectionCode = "";
        String requestInfo = "";
        HumanDtoInterface humanDto = this.humanReference.getHumanInfo(personalId, workflowDate);
        if (humanDto != null) {
            employeeCode = humanDto.getEmployeeCode();
            lastName = humanDto.getLastName();
            firstName = humanDto.getFirstName();
            sectionCode = humanDto.getSectionCode();
        }
        if (functionCode.equals("1")) {
            AttendanceDtoInterface attendanceDto = this.attendanceReference.findForWorkflow(workflow);
            if (attendanceDto == null) {
                return null;
            }
            requestInfo = this.getAttendanceInfo(attendanceDto);
        } else if (functionCode.equals("2")) {
            OvertimeRequestDtoInterface overtimeDto = this.overtimeRequest.findForWorkflow(workflow);
            requestInfo = this.getOvertimeRequestInfo(overtimeDto);
        } else if (functionCode.equals("3")) {
            HolidayRequestDtoInterface holidayDto = this.holidayRequest.findForWorkflow(workflow);
            requestInfo = this.getHolidayRequestInfo(holidayDto);
        } else if (functionCode.equals("4")) {
            WorkOnHolidayRequestDtoInterface workOnHolidayDto = this.workOnHolidayRequest.findForWorkflow(workflow);
            requestInfo = this.getWorkOnHolidayRequestInfo(workOnHolidayDto);
        } else if (functionCode.equals("5")) {
            SubHolidayRequestDtoInterface subHolidayDto = this.subHolidayRequest.findForWorkflow(workflow);
            requestInfo = this.getSubHolidayRequestInfo(subHolidayDto);
        } else if (functionCode.equals("6")) {
            DifferenceRequestDtoInterface differenceDto = this.differenceRequest.findForWorkflow(workflow);
            requestInfo = this.getDifferenceRequestInfo(differenceDto);
        } else if (functionCode.equals("7")) {
            WorkTypeChangeRequestDtoInterface workTypeChangeDto = this.workTypeChangeRequest.findForWorkflow(workflow);
            requestInfo = this.getWorkTypeChangeRequestInfo(workTypeChangeDto);
        }
        if ("6".equals(workflowDto.getWorkflowStatus()) || "7".equals(workflowDto.getWorkflowStatus())) {
            requestInfo = this.workflowCommentReference.getLatestWorkflowCommentInfo(workflow).getWorkflowComment();
        }
        dto.setEmployeeCode(employeeCode);
        dto.setLastName(lastName);
        dto.setFirstName(firstName);
        dto.setSectionCode(sectionCode);
        dto.setRequestInfo(requestInfo);
        if (isSubApprove) {
            dto.setRequestInfo(this.mospParams.getName("Substitution") + SEPARATOR_REQUEST_INFO + dto.getRequestInfo());
        }
        return dto;
    }

    protected String getAttendanceInfo(AttendanceDtoInterface dto) throws MospException {
        String returnString = "";
        HashMap map = this.getAttendanceInfoMap(dto);
        returnString = this.getAttendanceInfoText(map);
        return returnString;
    }

    protected HashMap<String, String> getAttendanceInfoMap(AttendanceDtoInterface dto) throws MospException {
        String overtime;
        List holidayList;
        String startWorkAndEndWork;
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        DifferenceRequestDtoInterface differenceRequestDto = this.differenceRequest.findForKeyOnWorkflow(dto.getPersonalId(), dto.getWorkDate());
        if (differenceRequestDto == null) {
            WorkTypeDtoInterface workTypeDto = this.workTypeReference.findForInfo(dto.getWorkTypeCode(), dto.getWorkDate());
            if (workTypeDto != null) {
                map.put("WorkTypeAbbr", workTypeDto.getWorkTypeAbbr());
            }
        } else {
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(differenceRequestDto.getWorkflow());
            if (workflowDto != null && "9".equals(workflowDto.getWorkflowStatus())) {
                map.put("DifferenceType", this.differenceRequest.getDifferenceAbbr(differenceRequestDto.getDifferenceType()));
            }
        }
        if (dto.getDirectStart() == 1) {
            map.put("DirectStart", this.getDirectStartNaming());
        }
        if (dto.getDirectEnd() == 1) {
            map.put("DirectEnd", this.getDirectEndNaming());
        }
        if (!(startWorkAndEndWork = this.getAttendanceWorkInfo(dto)).isEmpty()) {
            map.put("StartWorkAndEndWork", startWorkAndEndWork);
        }
        if (dto.getStartTime() != null) {
            sb = new StringBuffer();
            sb.append(this.mospParams.getName("StartWork"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(DateUtility.getStringTime((Date)dto.getStartTime(), (Date)dto.getWorkDate()));
            map.put("StartWork", sb.toString());
        }
        if (dto.getEndTime() != null) {
            sb = new StringBuffer();
            sb.append(this.mospParams.getName("EndWork"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(DateUtility.getStringTime((Date)dto.getEndTime(), (Date)dto.getWorkDate()));
            map.put("EndWork", sb.toString());
        }
        if (dto.getPrivateTime() > 0) {
            sb = new StringBuffer();
            sb.append(this.mospParams.getName("PrivateGoingOut"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(this.getHour(dto.getPrivateTime()));
            sb.append(this.mospParams.getName("Dot"));
            sb.append(this.getStringMinute(dto.getPrivateTime()));
            map.put("PrivateGoingOut", sb.toString());
        }
        if (!dto.getLateReason().isEmpty()) {
            sb = new StringBuffer();
            sb.append(this.mospParams.getName("Tardiness"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(this.getHour(dto.getLateTime()));
            sb.append(this.mospParams.getName("Dot"));
            sb.append(this.getStringMinute(dto.getLateTime()));
            map.put("Tardiness", sb.toString());
        }
        if (!dto.getLeaveEarlyReason().isEmpty()) {
            sb = new StringBuffer();
            sb.append(this.mospParams.getName("LeaveEarly"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(this.getHour(dto.getLeaveEarlyTime()));
            sb.append(this.mospParams.getName("Dot"));
            sb.append(this.getStringMinute(dto.getLeaveEarlyTime()));
            map.put("LeaveEarly", sb.toString());
        }
        if (!(holidayList = this.holidayRequest.getHolidayRequestListOnWorkflow(dto.getPersonalId(), dto.getWorkDate())).isEmpty()) {
            for (HolidayRequestDtoInterface holidayDto : holidayList) {
                if (holidayDto.getHolidayRange() != 4) continue;
                map.put("HolidayTime", this.mospParams.getName("HolidayTime"));
                break;
            }
        }
        if (!(overtime = this.getAttendanceOvertimeInfo(dto)).isEmpty()) {
            map.put("Overtime", overtime);
        }
        if (dto.getLateNightTime() > 0) {
            sb = new StringBuffer();
            sb.append(this.mospParams.getName("Midnight"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(this.getHour(dto.getLateNightTime()));
            sb.append(this.mospParams.getName("Dot"));
            sb.append(this.getStringMinute(dto.getLateNightTime()));
            map.put("Midnight", sb.toString());
        }
        if (!dto.getTimeComment().isEmpty()) {
            map.put("TimeComment", dto.getTimeComment());
        }
        if (!dto.getRemarks().isEmpty()) {
            map.put("Remarks", dto.getRemarks());
        }
        return map;
    }

    protected String getAttendanceInfoText(HashMap<String, String> map) {
        String[] listOrder;
        StringBuffer sb = new StringBuffer();
        for (String key : listOrder = this.mospParams.getApplicationProperties(APP_ATTENDANCE_INFO)) {
            String targetValue = map.get(key);
            if (targetValue == null) continue;
            sb.append(targetValue);
            sb.append(SEPARATOR_REQUEST_INFO);
        }
        return sb.toString();
    }

    protected String getAttendanceWorkInfo(AttendanceDtoInterface dto) throws MospException {
        StringBuffer sb = new StringBuffer();
        if (dto.getStartTime() == null && dto.getEndTime() == null) {
            return sb.toString();
        }
        if (dto.getStartTime() != null) {
            sb.append(DateUtility.getStringTime((Date)dto.getStartTime(), (Date)dto.getWorkDate()));
        }
        sb.append(this.mospParams.getName("Wave"));
        if (dto.getEndTime() != null) {
            sb.append(DateUtility.getStringTime((Date)dto.getEndTime(), (Date)dto.getWorkDate()));
        }
        return sb.toString();
    }

    protected String getAttendanceOvertimeInfo(AttendanceDtoInterface dto) throws MospException {
        if (dto == null) {
            return "";
        }
        if (dto.getOvertime() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("OvertimeWork"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(this.getHour(dto.getOvertime()));
            sb.append(this.mospParams.getName("Dot"));
            sb.append(this.getStringMinute(dto.getOvertime()));
            return sb.toString();
        }
        return "";
    }

    protected String getOvertimeRequestInfo(OvertimeRequestDtoInterface dto) {
        if (dto == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("Schedule") + this.mospParams.getName("Colon"));
        sb.append(dto.getRequestTime() / 60 + this.mospParams.getName("Time"));
        sb.append(dto.getRequestTime() % 60 + this.mospParams.getName("Minutes"));
        sb.append(SEPARATOR_REQUEST_INFO);
        sb.append(this.mospParams.getName("Type") + this.mospParams.getName("Colon"));
        sb.append(this.getCodeName(dto.getOvertimeType(), "OverTimeType"));
        sb.append(SEPARATOR_REQUEST_INFO);
        sb.append(this.mospParams.getName("Reason") + this.mospParams.getName("Colon") + dto.getRequestReason());
        return sb.toString();
    }

    protected String getHolidayRequestInfo(HolidayRequestDtoInterface dto) throws MospException {
        HolidayDtoInterface holidayDto;
        if (dto == null) {
            return "";
        }
        int holidayType1 = dto.getHolidayType1();
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("Wave"));
        sb.append(DateUtility.getStringDateAndDay((Date)dto.getRequestEndDate()));
        sb.append(SEPARATOR_REQUEST_INFO);
        if (holidayType1 == 1) {
            if (Integer.toString(1).equals(dto.getHolidayType2())) {
                sb.append(this.mospParams.getName("Salaried"));
                sb.append(this.mospParams.getName("Vacation"));
            } else if (Integer.toString(2).equals(dto.getHolidayType2())) {
                sb.append(this.mospParams.getName("Stock"));
                sb.append(this.mospParams.getName("Vacation"));
            }
        } else if (holidayType1 == 2) {
            sb.append(this.mospParams.getName("Specially"));
            sb.append(this.mospParams.getName("Vacation"));
        } else if (holidayType1 == 3) {
            sb.append(this.mospParams.getName("Others"));
        } else if (holidayType1 == 4) {
            sb.append(this.mospParams.getName("Absence"));
        }
        if ((holidayType1 == 2 || holidayType1 == 3 || holidayType1 == 4) && (holidayDto = this.holidayDao.findForInfo(dto.getHolidayType2(), dto.getRequestStartDate(), holidayType1)) != null) {
            sb.append(SEPARATOR_REQUEST_INFO);
            sb.append(holidayDto.getHolidayAbbr());
        }
        sb.append(SEPARATOR_REQUEST_INFO);
        sb.append(this.mospParams.getProperties().getCodeItemName("HolidayType3Range1", String.valueOf(dto.getHolidayRange())));
        if (dto.getHolidayRange() == 4) {
            sb.append(DateUtility.getStringTime((Date)dto.getStartTime(), (Date)dto.getRequestStartDate()));
            sb.append(this.mospParams.getName("Wave"));
            sb.append(DateUtility.getStringTime((Date)dto.getEndTime(), (Date)dto.getRequestStartDate()));
        }
        sb.append(SEPARATOR_REQUEST_INFO);
        sb.append(this.mospParams.getName("Vacation"));
        sb.append(this.mospParams.getName("Reason"));
        sb.append(this.mospParams.getName("Colon"));
        sb.append(dto.getRequestReason());
        return sb.toString();
    }

    protected String getWorkOnHolidayRequestInfo(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        List list;
        Iterator i$;
        WorkTypeDtoInterface workTypeDto;
        int substitute;
        if (dto == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String startTime = DateUtility.getStringTime((Date)dto.getStartTime(), (Date)dto.getRequestDate());
        String endTime = DateUtility.getStringTime((Date)dto.getEndTime(), (Date)dto.getRequestDate());
        if (!startTime.isEmpty() && !endTime.isEmpty()) {
            sb.append(this.mospParams.getName("Work"));
            sb.append(this.mospParams.getName("Schedule"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(startTime);
            sb.append(this.mospParams.getName("Wave"));
            sb.append(endTime);
            sb.append(SEPARATOR_REQUEST_INFO);
        }
        if ((substitute = dto.getSubstitute()) == 5 && (workTypeDto = this.workTypeReference.findForInfo(dto.getWorkTypeCode(), dto.getRequestDate())) != null) {
            sb.append(this.mospParams.getName("Work", new String[]{"Form", "Colon"}));
            sb.append(workTypeDto.getWorkTypeAbbr());
            sb.append(SEPARATOR_REQUEST_INFO);
        }
        if ((substitute == 1 || substitute == 5 || substitute == 3 || substitute == 4) && (i$ = (list = this.substituteReference.getSubstituteList(dto.getWorkflow())).iterator()).hasNext()) {
            SubstituteDtoInterface substituteDto = (SubstituteDtoInterface)i$.next();
            sb.append(this.mospParams.getName("Transfer"));
            sb.append(this.mospParams.getName("Holiday"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(DateUtility.getStringDateAndDay((Date)substituteDto.getSubstituteDate()));
            if (substituteDto.getSubstituteRange() == 2) {
                sb.append(this.mospParams.getName("AnteMeridiem"));
            } else if (substituteDto.getSubstituteRange() == 3) {
                sb.append(this.mospParams.getName("PostMeridiem"));
            }
            sb.append(SEPARATOR_REQUEST_INFO);
        }
        sb.append(this.mospParams.getName("Application"));
        sb.append(this.mospParams.getName("Reason"));
        sb.append(this.mospParams.getName("Colon"));
        sb.append(dto.getRequestReason());
        return sb.toString();
    }

    protected String getSubHolidayRequestInfo(SubHolidayRequestDtoInterface dto) throws MospException {
        if (dto == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int type = dto.getWorkDateSubHolidayType();
        if (type == 1 || type == 2) {
            sb.append(this.mospParams.getName("WorkingHoliday"));
        } else if (type == 3) {
            sb.append(this.mospParams.getName("Midnight"));
        }
        sb.append(this.mospParams.getName("Colon"));
        sb.append(DateUtility.getStringDateAndDay((Date)dto.getWorkDate()));
        sb.append(SEPARATOR_REQUEST_INFO);
        sb.append(this.mospParams.getName("Work"));
        sb.append(this.mospParams.getName("Colon"));
        AttendanceDtoInterface attendanceDto = this.attendanceReference.findForKey(dto.getPersonalId(), dto.getWorkDate(), 1);
        if (attendanceDto == null) {
            sb.append(0);
            sb.append(this.mospParams.getName("Time"));
            sb.append("00");
            sb.append(this.mospParams.getName("Minutes"));
        } else {
            sb.append(this.getHour(attendanceDto.getWorkTime()));
            sb.append(this.mospParams.getName("Time"));
            sb.append(this.getStringMinute(attendanceDto.getWorkTime()));
            sb.append(this.mospParams.getName("Minutes"));
        }
        sb.append(SEPARATOR_REQUEST_INFO);
        sb.append(this.mospParams.getProperties().getCodeItemName("HolidayType3Range1", String.valueOf(dto.getHolidayRange())));
        return sb.toString();
    }

    protected String getWorkTypeChangeRequestInfo(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        if (dto == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.workTypeReference.getWorkTypeAbbrAndTime(dto.getWorkTypeCode(), dto.getRequestDate()));
        sb.append(SEPARATOR_REQUEST_INFO);
        sb.append(this.mospParams.getName("Reason"));
        sb.append(this.mospParams.getName("Colon"));
        sb.append(dto.getRequestReason());
        return sb.toString();
    }

    protected String getDifferenceRequestInfo(DifferenceRequestDtoInterface dto) {
        if (dto == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("Application"));
        sb.append(this.mospParams.getName("Colon"));
        sb.append(this.differenceRequest.getDifferenceTime(dto));
        sb.append(SEPARATOR_REQUEST_INFO);
        sb.append(this.mospParams.getName("Reason"));
        sb.append(this.mospParams.getName("Colon"));
        sb.append(dto.getRequestReason());
        return sb.toString();
    }

    public BaseDtoInterface getRequestDtoForWorkflow(long workflow, boolean isApproval) throws MospException {
        WorkflowDtoInterface dto = this.workflowIntegrate.getLatestWorkflowInfo(workflow);
        if (dto != null) {
            if (isApproval && "0".equals(dto.getWorkflowStatus())) {
                return null;
            }
            if ("1".equals(dto.getFunctionCode())) {
                return this.attendanceReference.findForWorkflow(workflow);
            }
            if ("2".equals(dto.getFunctionCode())) {
                return this.overtimeRequest.findForWorkflow(workflow);
            }
            if ("3".equals(dto.getFunctionCode())) {
                return this.holidayRequest.findForWorkflow(workflow);
            }
            if ("4".equals(dto.getFunctionCode())) {
                return this.workOnHolidayRequest.findForWorkflow(workflow);
            }
            if ("5".equals(dto.getFunctionCode())) {
                return this.subHolidayRequest.findForWorkflow(workflow);
            }
            if ("7".equals(dto.getFunctionCode())) {
                return this.workTypeChangeRequest.findForWorkflow(workflow);
            }
            if ("6".equals(dto.getFunctionCode())) {
                return this.differenceRequest.findForWorkflow(workflow);
            }
        }
        return null;
    }

    public void setWorkflowInfo(RequestListDtoInterface dto, WorkflowDtoInterface workflowDto) throws MospException {
        WorkflowCommentDtoInterface commentDto;
        if (dto != null && workflowDto != null && (commentDto = this.workflowCommentReference.getLatestWorkflowCommentInfo(workflowDto.getWorkflow())) != null) {
            dto.setStage(workflowDto.getWorkflowStage());
            dto.setState(workflowDto.getWorkflowStatus());
            String approverName = this.humanReference.getHumanName(commentDto.getPersonalId(), commentDto.getWorkflowDate());
            if ("1".equals(workflowDto.getWorkflowStatus()) || "2".equals(workflowDto.getWorkflowStatus())) {
                approverName = this.getNextApprover(workflowDto);
            }
            dto.setApproverName(approverName);
        }
    }

    protected int getHour(int time) {
        return time / 60;
    }

    protected int getMinute(int time) {
        return Math.abs(time) % 60;
    }

    protected String getStringMinute(int time) {
        int minute = this.getMinute(time);
        if (minute < 10) {
            StringBuffer sb = new StringBuffer();
            sb.append(0);
            sb.append(minute);
            return sb.toString();
        }
        return Integer.toString(minute);
    }

    public String getNextApprover(WorkflowDtoInterface workflowDto) throws MospException {
        Date workDate = workflowDto.getWorkflowDate();
        String status = workflowDto.getWorkflowStatus();
        if (workflowDto.getApproverId().isEmpty()) {
            return "";
        }
        String[] approvalPersonalId = MospUtility.split((String)workflowDto.getApproverId(), (String)",");
        if ("1".equals(status)) {
            if ("SELF_APPRO".equals(status)) {
                return this.humanReference.getHumanName(workflowDto.getPersonalId(), workDate);
            }
            return this.humanReference.getHumanName(approvalPersonalId[0], workDate);
        }
        return this.humanReference.getHumanName(approvalPersonalId[workflowDto.getWorkflowStage() - 1], workDate);
    }

    public boolean isExistAttendanceTargetDate(String personalId, Date targetDate) throws MospException {
        this.requestUtil.setRequests(personalId, targetDate);
        AttendanceDtoInterface attendanceDto = this.requestUtil.getApplicatedAttendance();
        return attendanceDto != null;
    }

    protected String getDirectStartNaming() {
        return this.mospParams.getName("DirectStart");
    }

    protected String getDirectEndNaming() {
        return this.mospParams.getName("DirectEnd");
    }
}

