/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dao.settings.ApplicationDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;

public class ApplicationReferenceBean
extends TimeBean
implements ApplicationReferenceBeanInterface {
    protected ApplicationDaoInterface dao;
    protected HumanDaoInterface humanDao;

    public ApplicationReferenceBean() {
    }

    public ApplicationReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (ApplicationDaoInterface)this.createDao(ApplicationDaoInterface.class);
        this.humanDao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
    }

    public ApplicationDtoInterface getApplicationInfo(String applicationCode, Date targetDate) throws MospException {
        return this.dao.findForKey(applicationCode, targetDate);
    }

    public List<ApplicationDtoInterface> getApplicationHistory(String applicationCode) throws MospException {
        return this.dao.findForHistory(applicationCode);
    }

    public String getApplicationAbbr(String applicationCode, Date targetDate) throws MospException {
        ApplicationDtoInterface dto = this.dao.findForKey(applicationCode, targetDate);
        if (dto != null) {
            return dto.getApplicationAbbr();
        }
        return applicationCode;
    }

    public ApplicationDtoInterface findForKey(String applicationCode, Date targetDate) throws MospException {
        ApplicationDtoInterface dto = this.dao.findForKey(applicationCode, targetDate);
        if (dto != null) {
            return dto;
        }
        return null;
    }

    public ApplicationDtoInterface findFormerInfo(String applicationCode, Date activateDate) throws MospException {
        return this.dao.findFormerInfo(applicationCode, activateDate);
    }

    public ApplicationDtoInterface findForPerson(String personalId, Date targetDate) throws MospException {
        ApplicationDtoInterface dto = null;
        dto = this.dao.findForPersonalId(targetDate, personalId);
        if (dto != null) {
            return dto;
        }
        HumanDtoInterface humanDto = this.humanDao.findForInfo(personalId, targetDate);
        if (humanDto == null) {
            return dto;
        }
        String positionCode = humanDto.getPositionCode();
        String sectionCode = humanDto.getSectionCode();
        String employmentContractCode = humanDto.getEmploymentContractCode();
        String workPlaceCode = humanDto.getWorkPlaceCode();
        String blank = "";
        dto = this.dao.findForMaster(targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, employmentContractCode, sectionCode, positionCode);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, blank, sectionCode, positionCode);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, blank, blank, positionCode);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, workPlaceCode, employmentContractCode, sectionCode, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, employmentContractCode, sectionCode, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, blank, sectionCode, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, workPlaceCode, employmentContractCode, blank, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, employmentContractCode, blank, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, workPlaceCode, blank, blank, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, blank, blank, blank);
        if (dto != null) {
            return dto;
        }
        return dto;
    }

    public void chkExistApplication(ApplicationDtoInterface dto, Date targetDate) {
        if (dto == null) {
            String errorMes1 = "";
            errorMes1 = targetDate == null ? DateUtility.getStringDate((Date)DateUtility.getSystemDate()) : DateUtility.getStringDate((Date)targetDate);
            String errorMes2 = this.mospParams.getName("Set", new String[]{"Apply", "Information"});
            this.mospParams.addErrorMessage("TMW0246", new String[]{errorMes1, errorMes2});
        }
    }

    public boolean hasPersonalApplication(String personalId, Date startDate, Date endDate) throws MospException {
        List list = this.dao.findPersonTerm(personalId, startDate, endDate);
        return !list.isEmpty();
    }

    public ApplicationEntity getApplicationEntity(String personalId, Date targetDate) throws MospException {
        ApplicationDtoInterface applicationDto = this.findForPerson(personalId, targetDate);
        ApplicationEntity applicationEntity = new ApplicationEntity(applicationDto);
        if (applicationDto == null) {
            return applicationEntity;
        }
        TimeSettingReferenceBeanInterface timeSettingRefer = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
        CutoffReferenceBeanInterface cutoffRefer = (CutoffReferenceBeanInterface)this.createBean(CutoffReferenceBeanInterface.class);
        PaidHolidayReferenceBeanInterface paidHolidayRefer = (PaidHolidayReferenceBeanInterface)this.createBean(PaidHolidayReferenceBeanInterface.class);
        String workSettingCode = applicationEntity.getWorkSettingCode();
        TimeSettingDtoInterface timeSettingDto = timeSettingRefer.getTimeSettingInfo(workSettingCode, targetDate);
        applicationEntity.setTimeSettingDto(timeSettingDto);
        String cutoffCode = applicationEntity.getCutoffCode();
        CutoffDtoInterface cutoffDto = cutoffRefer.getCutoffInfo(cutoffCode, targetDate);
        applicationEntity.setCutoffDto(cutoffDto);
        String paidHolidayCode = applicationEntity.getPaidHolidayCode();
        applicationEntity.setPaidHolidayDto(paidHolidayRefer.getPaidHolidayInfo(paidHolidayCode, targetDate));
        return applicationEntity;
    }

    public ApplicationEntity getApplicationEntity(String personalId, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getApplicationEntity(personalId, targetDate);
    }
}

