/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean;

import java.sql.Connection;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.AfterApplyAttendanceBeanInterface;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.bean.impl.WorkOnHolidayRequestReferenceBean;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;

public abstract class AttendanceBean
extends TimeBean {
    protected AttendanceReferenceBeanInterface attendanceReference;
    protected ApplicationReferenceBeanInterface applicationReference;
    protected TimeSettingReferenceBeanInterface timeSettingReference;
    protected ScheduleReferenceBeanInterface scheduleReference;
    protected ScheduleDateReferenceBeanInterface scheduleDateReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected WorkTypeItemReferenceBeanInterface workTypeItemReference;
    protected WorkOnHolidayRequestReferenceBeanInterface workOnHoliday;
    protected SubstituteReferenceBeanInterface substituteReference;
    protected WorkflowIntegrateBeanInterface workflow;

    public AttendanceBean() {
    }

    protected AttendanceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.timeSettingReference = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
        this.scheduleReference = (ScheduleReferenceBeanInterface)this.createBean(ScheduleReferenceBeanInterface.class);
        this.scheduleDateReference = (ScheduleDateReferenceBeanInterface)this.createBean(ScheduleDateReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.workTypeItemReference = (WorkTypeItemReferenceBeanInterface)this.createBean(WorkTypeItemReferenceBeanInterface.class);
        this.workOnHoliday = (WorkOnHolidayRequestReferenceBean)this.createBean(WorkOnHolidayRequestReferenceBean.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBean(SubstituteReferenceBeanInterface.class);
        this.workflow = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
    }

    protected String getWorkOnHolidayWorkType(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        int substitute = dto.getSubstitute();
        if (substitute == 1 || substitute == 3 || substitute == 4) {
            return this.getSubstituteWorkType(dto);
        }
        if (substitute == 5) {
            return dto.getWorkTypeCode();
        }
        if (substitute == 2) {
            return this.getWorkOnHolidayWorkType(dto.getWorkOnHolidayType());
        }
        return "";
    }

    protected String getSubstituteWorkType(WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto) throws MospException {
        String workTypeCode = "";
        if (workOnHolidayRequestDto.getSubstitute() != 1 && workOnHolidayRequestDto.getSubstitute() != 3 && workOnHolidayRequestDto.getSubstitute() != 4) {
            return workTypeCode;
        }
        SubstituteDtoInterface substituteDto = this.substituteReference.getSubstituteDto(workOnHolidayRequestDto.getPersonalId(), workOnHolidayRequestDto.getRequestDate());
        if (substituteDto == null) {
            return workTypeCode;
        }
        ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(substituteDto.getPersonalId(), substituteDto.getSubstituteDate());
        if (applicationDto == null) {
            return workTypeCode;
        }
        ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(applicationDto.getScheduleCode(), substituteDto.getSubstituteDate());
        if (scheduleDto == null) {
            return workTypeCode;
        }
        ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.findForKey(scheduleDto.getScheduleCode(), substituteDto.getSubstituteDate());
        if (scheduleDateDto == null) {
            return workTypeCode;
        }
        return scheduleDateDto.getWorkTypeCode();
    }

    protected String getWorkOnHolidayWorkType(String workOnHolidayType) {
        String workTypeCode = "work_on_prescribed";
        if (workOnHolidayType.equals("legal_holiday")) {
            workTypeCode = "work_on_legal";
        }
        return workTypeCode;
    }

    protected void afterApplyAttendance(AttendanceDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String modelClass : this.mospParams.getApplicationProperties("AfterApplyAttendanceBeans")) {
            ((AfterApplyAttendanceBeanInterface)this.createBean(modelClass)).execute(dto);
        }
    }
}

