/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.base;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.base.TotalTimeBaseVo;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public abstract class TotalTimeBaseAction
extends TimeAction {
    protected void setCutoffInfo() throws MospException {
        TotalTimeBaseVo vo = (TotalTimeBaseVo)this.mospParams.getVo();
        String cutoffCode = vo.getCutoffCode();
        int targetYear = vo.getTargetYear();
        int targetMonth = vo.getTargetMonth();
        CutoffDtoInterface dto = this.timeReference().cutoffUtil().getCutoff(cutoffCode, targetYear, targetMonth);
        int cutoffDate = dto.getCutoffDate();
        vo.setCutoffFirstDate(TimeUtility.getCutoffFirstDate((int)cutoffDate, (int)targetYear, (int)targetMonth));
        vo.setCutoffLastDate(TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth));
        vo.setCalculationDate(TimeUtility.getCutoffCalculationDate((int)cutoffDate, (int)targetYear, (int)targetMonth));
        vo.setCutoffTermTargetDate(TimeUtility.getCutoffTermTargetDate((int)cutoffDate, (int)targetYear, (int)targetMonth));
        vo.setLblCutoffName(dto.getCutoffName());
        vo.setLblYearMonth(DateUtility.getStringYearMonth((Date)MonthUtility.getYearMonthDate((int)targetYear, (int)targetMonth)));
        vo.setLblCutoffFirstDate(this.getStringDate(vo.getCutoffFirstDate()));
        vo.setLblCutoffLastDate(this.getStringDate(vo.getCutoffLastDate()));
    }

    protected void getCutoffParams() {
        TotalTimeBaseVo vo = (TotalTimeBaseVo)this.mospParams.getVo();
        String cutoffCode = (String)this.mospParams.getGeneralParam("transferredGenericCode");
        Integer targetYear = (Integer)this.mospParams.getGeneralParam("transferredYear");
        Integer targetMonth = (Integer)this.mospParams.getGeneralParam("transferredMonth");
        vo.setTargetYear(targetYear.intValue());
        vo.setTargetMonth(targetMonth.intValue());
        vo.setCutoffCode(cutoffCode);
    }

    protected void getTransferredCutoffParams() {
        TotalTimeBaseVo vo = (TotalTimeBaseVo)this.mospParams.getVo();
        int targetYear = this.getInt(this.getTransferredYear());
        int targetMonth = this.getInt(this.getTransferredMonth());
        String cutoffCode = this.getTransferredCode();
        vo.setTargetYear(targetYear);
        vo.setTargetMonth(targetMonth);
        vo.setCutoffCode(cutoffCode);
    }

    protected void setTargetCutoffCode(String cutoffCode) {
        this.mospParams.addGeneralParam("transferredGenericCode", (Object)cutoffCode);
    }

    protected void setTargetYear(int targetYear) {
        this.mospParams.addGeneralParam("transferredYear", (Object)targetYear);
    }

    protected void setTargetMonth(int targetMonth) {
        this.mospParams.addGeneralParam("transferredMonth", (Object)targetMonth);
    }

    protected void addCalculateFailedMessage() {
        String[] aryMeassage = new String[]{this.mospParams.getName("Calc")};
        this.mospParams.addMessage("PFI0002", aryMeassage);
    }
}

