/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.base;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.AttendanceListBaseVo;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.base.TimeVo;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.SubordinateListDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.utils.TimeUtility;

public abstract class AttendanceListBaseAction
extends TimeAction {
    protected void setVoFields(AttendanceListReferenceBeanInterface attendanceListReference) throws MospException {
        String personalId = attendanceListReference.getPersonalId();
        Date lastDate = attendanceListReference.getLastDate();
        int targetYear = attendanceListReference.getTargetYear();
        int targetMonth = attendanceListReference.getTargetMonth();
        this.setVoYearMonthFields(targetYear, targetMonth);
        this.setVoThisMonthFields(personalId);
        this.setVoHumanFields(personalId, lastDate);
        this.setVoRollEmployeeFields();
    }

    protected void setVoYearMonthFields(int targetYear, int targetMonth) throws MospException {
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        vo.setPltSelectYear(String.valueOf(targetYear));
        vo.setPltSelectMonth(String.valueOf(targetMonth));
        vo.setAryPltSelectYear(this.getYearArray(targetYear));
        vo.setAryPltSelectMonth(this.getMonthArray());
        Date current = MonthUtility.getYearMonthTermFirstDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        Date next = DateUtility.addMonth((Date)current, (int)1);
        Date previous = DateUtility.addMonth((Date)current, (int)-1);
        vo.setNextMonthYear(DateUtility.getYear((Date)next));
        vo.setNextMonthMonth(DateUtility.getMonth((Date)next));
        vo.setPrevMonthYear(DateUtility.getYear((Date)previous));
        vo.setPrevMonthMonth(DateUtility.getMonth((Date)previous));
    }

    protected void setVoThisMonthFields(String personalId) throws MospException {
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        CutoffUtilBeanInterface cutoffUtil = this.timeReference().cutoffUtil();
        Date thisMonth = this.getSystemDate();
        vo.setThisMonthYear(DateUtility.getYear((Date)thisMonth));
        vo.setThisMonthMonth(DateUtility.getMonth((Date)thisMonth));
        TimeSettingDtoInterface timeSettingDto = cutoffUtil.getTimeSetting(personalId, thisMonth);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        CutoffDtoInterface cutoffDto = cutoffUtil.getCutoff(timeSettingDto.getCutoffCode(), thisMonth);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date cutoffMonth = TimeUtility.getCutoffMonth((int)cutoffDto.getCutoffDate(), (Date)thisMonth);
        vo.setThisMonthYear(DateUtility.getYear((Date)cutoffMonth));
        vo.setThisMonthMonth(DateUtility.getMonth((Date)cutoffMonth));
    }

    protected void setVoHumanFields(String personalId, Date targetDate) throws MospException {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, targetDate);
        if (humanDto == null) {
            return;
        }
        vo.setPersonalId(humanDto.getPersonalId());
        vo.setLblEmployeeCode(humanDto.getEmployeeCode());
        vo.setLblEmployeeName(this.getLastFirstName(humanDto.getLastName(), humanDto.getFirstName()));
        vo.setLblSectionName(this.reference().section().getSectionName(humanDto.getSectionCode(), targetDate));
        if (this.reference().section().useDisplayName()) {
            vo.setLblSectionName(this.reference().section().getSectionDisplay(humanDto.getSectionCode(), targetDate));
        }
    }

    protected void setVoRollEmployeeFields() {
        BaseDtoInterface baseDto;
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        Object object = this.mospParams.getGeneralParam("RollArray");
        if (object != null) {
            vo.setRollArray((BaseDtoInterface[])object);
        }
        if (vo.getRollArray() == null || vo.getRollArray().length == 0) {
            return;
        }
        int i = 0;
        for (BaseDtoInterface baseDto2 : vo.getRollArray()) {
            SubordinateListDtoInterface dto = (SubordinateListDtoInterface)baseDto2;
            if (vo.getPersonalId().equals(dto.getPersonalId())) break;
            ++i;
        }
        vo.setLblPrevEmployeeCode("");
        vo.setPrevPersonalId("");
        if (i > 0) {
            baseDto = vo.getRollArray()[i - 1];
            SubordinateListDtoInterface dto = (SubordinateListDtoInterface)baseDto;
            vo.setLblPrevEmployeeCode(dto.getEmployeeCode());
            vo.setPrevPersonalId(dto.getPersonalId());
        }
        vo.setLblNextEmployeeCode("");
        vo.setNextPersonalId("");
        if (i + 1 < vo.getRollArray().length) {
            baseDto = vo.getRollArray()[i + 1];
            SubordinateListDtoInterface dto = (SubordinateListDtoInterface)baseDto;
            vo.setLblNextEmployeeCode(dto.getEmployeeCode());
            vo.setNextPersonalId(dto.getPersonalId());
        }
    }

    protected void setVoList(List<AttendanceListDto> list) {
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        String[] aryLblDate = new String[list.size()];
        String[] aryLblWeek = new String[list.size()];
        String[] aryWorkDayOfWeekStyle = new String[list.size()];
        String[] aryLblWorkType = new String[list.size()];
        String[] aryLblStartTime = new String[list.size()];
        String[] aryStartTimeStyle = new String[list.size()];
        String[] aryLblEndTime = new String[list.size()];
        String[] aryEndTimeStyle = new String[list.size()];
        String[] aryLblWorkTime = new String[list.size()];
        String[] aryLblRestTime = new String[list.size()];
        String[] aryLblRemark = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            AttendanceListDto dto = list.get(i);
            aryLblDate[i] = dto.getWorkDateString();
            aryLblWeek[i] = dto.getWorkDayOfWeek();
            aryWorkDayOfWeekStyle[i] = dto.getWorkDayOfWeekStyle();
            aryLblWorkType[i] = dto.getWorkTypeAbbr();
            aryLblStartTime[i] = dto.getStartTimeString();
            aryStartTimeStyle[i] = dto.getStartTimeStyle();
            aryLblEndTime[i] = dto.getEndTimeString();
            aryEndTimeStyle[i] = dto.getEndTimeStyle();
            aryLblWorkTime[i] = dto.getWorkTimeString();
            aryLblRestTime[i] = dto.getRestTimeString();
            aryLblRemark[i] = MospUtility.concat((String[])new String[]{dto.getRemark(), dto.getTimeComment()});
        }
        vo.setAryLblDate(aryLblDate);
        vo.setAryLblWeek(aryLblWeek);
        vo.setAryWorkDayOfWeekStyle(aryWorkDayOfWeekStyle);
        vo.setAryLblWorkType(aryLblWorkType);
        vo.setAryLblStartTime(aryLblStartTime);
        vo.setAryStartTimeStyle(aryStartTimeStyle);
        vo.setAryLblEndTime(aryLblEndTime);
        vo.setAryEndTimeStyle(aryEndTimeStyle);
        vo.setAryLblWorkTime(aryLblWorkTime);
        vo.setAryLblRestTime(aryLblRestTime);
        vo.setAryLblRemark(aryLblRemark);
        if (list.isEmpty()) {
            return;
        }
        AttendanceListDto dto = list.get(list.size() - 1);
        vo.setLblTotalWork(dto.getWorkTimeTotalString());
        vo.setLblTotalRest(dto.getRestTimeTotalString());
        vo.setLblTimesWork(dto.getWorkDaysString());
        vo.setLblTimesPrescribedHoliday(dto.getPrescribedHolidaysString());
        vo.setLblTimesLegalHoliday(dto.getLegalHolidaysString());
        vo.setLblTimesHoliday(dto.getHolidayString());
        vo.setCkbSelect(new String[0]);
    }
}

