/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.setup.bean.impl;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.EntranceRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistBeanInterface;
import jp.mosp.platform.bean.system.UserAccountRegistBeanInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.setup.bean.InitialAccountCreateBeanInterface;
import jp.mosp.setup.dto.InitialAccountParameterInterface;
import jp.mosp.setup.dto.impl.InitialAccountParameter;

public class InitialAccountCreateBean
extends PlatformBean
implements InitialAccountCreateBeanInterface {
    protected UserAccountRegistBeanInterface userAccountRegist;

    public void initBean() throws MospException {
        this.userAccountRegist = (UserAccountRegistBeanInterface)this.createBean(UserAccountRegistBeanInterface.class);
    }

    public InitialAccountParameterInterface getInitParameter() {
        return new InitialAccountParameter();
    }

    public void execute(InitialAccountParameterInterface parameter) throws MospException {
        this.insertHuman(parameter);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String personalId = this.getPersonalId(parameter);
        if (personalId.isEmpty()) {
            return;
        }
        this.insertEntrance(parameter, personalId);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.insertUser(parameter, personalId);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    protected void insertHuman(InitialAccountParameterInterface parameter) throws MospException {
        HumanRegistBeanInterface register = (HumanRegistBeanInterface)this.createBean(HumanRegistBeanInterface.class);
        HumanDtoInterface dto = register.getInitDto();
        dto.setActivateDate(this.getActivateDate(parameter));
        dto.setEmployeeCode(parameter.getEmployeeCode());
        dto.setLastName(parameter.getLastName());
        dto.setFirstName(parameter.getFirstName());
        dto.setLastKana(parameter.getLastKana());
        dto.setFirstKana(parameter.getFirstKana());
        dto.setWorkPlaceCode("");
        dto.setEmploymentContractCode("");
        dto.setSectionCode("");
        dto.setPositionCode("");
        dto.setMail("");
        register.insert(dto);
    }

    protected String getPersonalId(InitialAccountParameterInterface parameter) throws MospException {
        HumanReferenceBeanInterface human = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        return human.getPersonalId(parameter.getEmployeeCode(), this.getActivateDate(parameter));
    }

    protected void insertEntrance(InitialAccountParameterInterface parameter, String personalId) throws MospException {
        EntranceRegistBeanInterface register = (EntranceRegistBeanInterface)this.createBean(EntranceRegistBeanInterface.class);
        EntranceDtoInterface dto = register.getInitDto();
        dto.setEntranceDate(parameter.getEntranceDate());
        dto.setPersonalId(personalId);
        register.insert(dto);
    }

    protected void insertUser(InitialAccountParameterInterface parameter, String personalId) throws MospException {
        UserMasterDtoInterface dto = this.userAccountRegist.getInitUserDto();
        String userId = parameter.getUserId();
        dto.setUserId(userId);
        dto.setActivateDate(this.getActivateDate(parameter));
        dto.setPersonalId(personalId);
        dto.setRoleCode(parameter.getRoleCode());
        dto.setInactivateFlag(0);
        this.userAccountRegist.insert(dto, false);
    }

    protected Date getActivateDate(InitialAccountParameterInterface parameter) {
        Date entranceDate = parameter.getEntranceDate();
        Date systemDate = DateUtility.getSystemDate();
        Date activateDate = parameter.getActivateDate();
        if (activateDate != null) {
            return activateDate;
        }
        if (systemDate.compareTo(entranceDate) < 0) {
            return systemDate;
        }
        return entranceDate;
    }

    protected void addInsertFailedMessage() {
        String[] aryMeassage = new String[]{this.mospParams.getName("Insert")};
        this.mospParams.addMessage("PFI0002", aryMeassage);
    }
}

