/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.workflow.action;

import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverRegistBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverSearchBeanInterface;
import jp.mosp.platform.comparator.base.ActivateDateComparator;
import jp.mosp.platform.dto.workflow.SubApproverDtoInterface;
import jp.mosp.platform.dto.workflow.SubApproverListDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.system.base.PlatformSystemVo;
import jp.mosp.platform.workflow.vo.SubApproverSettingVo;

public class SubApproverSettingAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF3400";
    public static final String CMD_SEARCH = "PF3402";
    public static final String CMD_RE_SEARCH = "PF3403";
    public static final String CMD_REGIST = "PF3405";
    public static final String CMD_SORT = "PF3408";
    public static final String CMD_PAGE = "PF3409";
    public static final String CMD_SET_ACTIVATION_DATE = "PF3490";
    public static final String CMD_INSERT_MODE = "PF3491";
    public static final String CMD_EDIT_MODE = "PF3492";
    public static final String CMD_SET_EMPLOYEE = "PF3497";

    protected BaseVo getSpecificVo() {
        return new SubApproverSettingVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_SET_EMPLOYEE)) {
            this.prepareVo();
            this.setEmployeePulldown();
        }
    }

    protected void show() throws MospException {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        vo.setPersonalId(this.mospParams.getUser().getPersonalId());
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(ActivateDateComparator.class.getName());
        this.insertMode();
    }

    protected void setActivationDate() throws MospException {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void setEmployeePulldown() throws MospException {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        HumanSearchBeanInterface humanSearch = this.reference().humanSearch();
        humanSearch.setTargetDate(this.getEditActivateDate());
        humanSearch.setEmployeeCode(vo.getTxtEditEmployeeCode());
        humanSearch.setEmployeeCodeType("forward");
        humanSearch.setSectionCode(vo.getPltEditSection());
        humanSearch.setPositionCode(vo.getPltEditPosition());
        humanSearch.setStateType("presence");
        humanSearch.setUnnecessaryPersonalId(vo.getPersonalId());
        humanSearch.setNeedLowerSection(true);
        humanSearch.setNeedApproverRole(true);
        vo.setAryPltEditEmployee(humanSearch.getCodedSelectArray(false));
    }

    protected void insertMode() throws MospException {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        this.setEditInsertMode();
        vo.setSubApproverNo("");
        vo.setTxtEditEndYear("");
        vo.setTxtEditEndMonth("");
        vo.setTxtEditEndDay("");
        vo.setTxtEditEmployeeCode("");
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode());
    }

    protected void setEditUpdateMode(String subApproverNo) throws MospException {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        SubApproverDtoInterface dto = this.reference().subApprover().findForKey(subApproverNo);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        vo.setTxtEditEmployeeCode(this.reference().human().getEmployeeCode(dto.getSubApproverId(), dto.getStartDate()));
        vo.setPltEditSection("");
        vo.setPltEditPosition("");
        this.setEmployeePulldown();
        this.setEditUpdateMode(new ArrayList());
    }

    protected void search() throws MospException {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        SubApproverSearchBeanInterface search = this.reference().subApproverSearch();
        search.setPersonalId(vo.getPersonalId());
        search.setTargetYear(this.getInt(vo.getTxtSearchActivateYear()));
        search.setTargetMonth(this.getInt(vo.getTxtSearchActivateMonth()));
        search.setSectionName(vo.getTxtSearchSectionName());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(ActivateDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void regist() throws MospException {
        PlatformSystemVo vo = (PlatformSystemVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        SubApproverRegistBeanInterface regist = this.platform().subApproverRegist();
        SubApproverDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getSubApproverNo());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        SubApproverRegistBeanInterface regist = this.platform().subApproverRegist();
        SubApproverDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(dto.getSubApproverNo());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void setPulldown() throws MospException {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltEditSection(this.getInputStartDatePulldown());
            vo.setAryPltEditPosition(this.getInputStartDatePulldown());
            vo.setAryPltEditEmployee(this.getInputStartDatePulldown());
            return;
        }
        vo.setAryPltEditSection(this.reference().section().getCodedSelectArray(this.getEditActivateDate(), true, null));
        vo.setAryPltEditPosition(this.reference().position().getCodedSelectArray(this.getEditActivateDate(), true, null));
        vo.setAryPltEditEmployee(this.getSearchCodePulldown());
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        String[] aryLblSubApproverNo = new String[list.size()];
        String[] aryLblStartDate = new String[list.size()];
        String[] aryLblEndDate = new String[list.size()];
        String[] aryLblWorkflowType = new String[list.size()];
        String[] aryLblWorkflowName = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SubApproverListDtoInterface dto = (SubApproverListDtoInterface)list.get(i);
            aryLblSubApproverNo[i] = dto.getSubApproverNo();
            aryLblStartDate[i] = this.getStringDate(dto.getStartDate());
            aryLblEndDate[i] = this.getStringDate(dto.getEndDate());
            aryLblWorkflowType[i] = String.valueOf(dto.getWorkflowType());
            aryLblWorkflowName[i] = this.getCodeName(dto.getWorkflowType(), "WorkflowType");
            aryLblEmployeeCode[i] = dto.getSubApproverCode();
            aryLblEmployeeName[i] = dto.getSubApproverName();
            aryLblSection[i] = dto.getSubApproverSectionName();
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryLblSubApproverNo(aryLblSubApproverNo);
        vo.setAryLblActivateDate(aryLblStartDate);
        vo.setAryLblEndDate(aryLblEndDate);
        vo.setAryLblWorkflowType(aryLblWorkflowType);
        vo.setAryLblWorkflowName(aryLblWorkflowName);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblInactivate(aryLblInactivate);
    }

    protected void setDtoFields(SubApproverDtoInterface dto) {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        dto.setPftSubApproverId(vo.getRecordId());
        dto.setSubApproverNo(vo.getSubApproverNo());
        dto.setPersonalId(vo.getPersonalId());
        dto.setStartDate(this.getEditActivateDate());
        dto.setEndDate(this.getDate(vo.getTxtEditEndYear(), vo.getTxtEditEndMonth(), vo.getTxtEditEndDay()));
        dto.setSubApproverId(vo.getPltEditEmployeeName());
        dto.setWorkflowType(this.getInt(vo.getPltEditWorkflowType()));
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFields(SubApproverDtoInterface dto) {
        SubApproverSettingVo vo = (SubApproverSettingVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPftSubApproverId());
        vo.setSubApproverNo(dto.getSubApproverNo());
        vo.setPersonalId(dto.getPersonalId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getStartDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getStartDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getStartDate()));
        vo.setTxtEditEndYear(this.getStringYear(dto.getEndDate()));
        vo.setTxtEditEndMonth(this.getStringMonth(dto.getEndDate()));
        vo.setTxtEditEndDay(this.getStringDay(dto.getEndDate()));
        vo.setPltEditEmployeeName(dto.getSubApproverId());
        vo.setPltEditWorkflowType(String.valueOf(dto.getWorkflowType()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }
}

