/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.workflow.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBeanHandlerInterface;
import jp.mosp.platform.base.ReferenceBeanHandlerInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteRegistBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteUnitRegistBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteUnitDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PfaApprovalRouteUnitDto;
import jp.mosp.platform.dto.workflow.impl.PfmApprovalRouteDto;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.workflow.vo.RouteCardVo;

public class RouteCardAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF3220";
    public static final String CMD_SELECT_SHOW = "PF3221";
    public static final String CMD_REGIST = "PF3225";
    public static final String CMD_SPECIAL_DISPLAY = "PF3226";
    public static final String CMD_DELETE = "PF3227";
    public static final String CMD_SET_ACTIVATION_DATE = "PF3270";
    public static final String CMD_INSERT_MODE = "PF3271";
    public static final String CMD_ADD_MODE = "PF3273";

    public RouteCardAction() {
        this.topicPathCommand = CMD_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new RouteCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.selectShow();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void selectShow() throws MospException {
        this.editMode();
    }

    protected void regist() throws MospException {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        ApprovalRouteRegistBeanInterface regist = platform.approvalRouteRegist();
        PfmApprovalRouteDto dto = new PfmApprovalRouteDto();
        this.setDtoFields((ApprovalRouteDtoInterface)dto);
        regist.insert((ApprovalRouteDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        ApprovalRouteUnitRegistBeanInterface unitRegist = platform.approvalRouteUnitRegist();
        PfaApprovalRouteUnitDto unitDto = new PfaApprovalRouteUnitDto();
        int routeStage = dto.getApprovalCount();
        for (int i = 1; i <= routeStage; ++i) {
            this.setUnitDtoFields((ApprovalRouteUnitDtoInterface)unitDto, i);
            unitRegist.insert((ApprovalRouteUnitDtoInterface)unitDto);
            if (!this.mospParams.hasErrorMessage()) continue;
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getRouteCode(), dto.getActivateDate());
    }

    protected void add() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        ApprovalRouteRegistBeanInterface regist = platform.approvalRouteRegist();
        PfmApprovalRouteDto dto = new PfmApprovalRouteDto();
        this.setDtoFields((ApprovalRouteDtoInterface)dto);
        regist.add((ApprovalRouteDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        ApprovalRouteUnitRegistBeanInterface unitRegist = platform.approvalRouteUnitRegist();
        PfaApprovalRouteUnitDto unitDto = new PfaApprovalRouteUnitDto();
        int routeStage = dto.getApprovalCount();
        for (int i = 1; i <= routeStage; ++i) {
            this.setUnitDtoFields((ApprovalRouteUnitDtoInterface)unitDto, i);
            unitRegist.add((ApprovalRouteUnitDtoInterface)unitDto);
            if (!this.mospParams.hasErrorMessage()) continue;
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getRouteCode(), dto.getActivateDate());
    }

    protected void update() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        ApprovalRouteRegistBeanInterface regist = platform.approvalRouteRegist();
        PfmApprovalRouteDto dto = new PfmApprovalRouteDto();
        this.setDtoFields((ApprovalRouteDtoInterface)dto);
        regist.update((ApprovalRouteDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        ApprovalRouteUnitRegistBeanInterface unitRegist = platform.approvalRouteUnitRegist();
        PfaApprovalRouteUnitDto unitDto = new PfaApprovalRouteUnitDto();
        int routeStage = dto.getApprovalCount();
        for (int i = 1; i <= routeStage; ++i) {
            this.setUnitDtoFields((ApprovalRouteUnitDtoInterface)unitDto, i);
            unitRegist.update((ApprovalRouteUnitDtoInterface)unitDto);
            if (!this.mospParams.hasErrorMessage()) continue;
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setEditUpdateMode(dto.getRouteCode(), dto.getActivateDate());
    }

    protected void delete() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        ApprovalRouteRegistBeanInterface regist = platform.approvalRouteRegist();
        PfmApprovalRouteDto dto = new PfmApprovalRouteDto();
        this.setDtoFields((ApprovalRouteDtoInterface)dto);
        regist.delete((ApprovalRouteDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        ApprovalRouteUnitRegistBeanInterface unitRegist = platform.approvalRouteUnitRegist();
        PfaApprovalRouteUnitDto unitDto = new PfaApprovalRouteUnitDto();
        int routeStage = dto.getApprovalCount();
        for (int i = 1; i <= routeStage; ++i) {
            this.setUnitDtoFields((ApprovalRouteUnitDtoInterface)unitDto, i);
            unitRegist.delete((ApprovalRouteUnitDtoInterface)unitDto);
            if (!this.mospParams.hasErrorMessage()) continue;
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteHistoryMessage(1);
        this.insertMode();
    }

    protected void setActivationDate() throws MospException {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
        if (vo.getModeActivateDate().equals("fixed") && vo.getAryPltUnitStage().length == 1 && vo.getAryPltUnitStage()[0][0].isEmpty()) {
            this.addSetUnitPulldownFailedMessage();
            vo.setModeActivateDate("chaning");
        }
        this.clearApproverStages();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void setDefaultValues() {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        vo.setTxtRouteCode("");
        vo.setTxtRouteName("");
        vo.setPltRouteStage("1");
        vo.setPltUnitStage1("");
        vo.setPltUnitStage2("");
        vo.setPltUnitStage3("");
        vo.setPltUnitStage4("");
        vo.setPltUnitStage5("");
        vo.setPltUnitStage6("");
        vo.setPltUnitStage7("");
        vo.setPltUnitStage8("");
        vo.setPltUnitStage9("");
        vo.setPltUnitStage10("");
        this.clearApproverStages();
    }

    protected void clearApproverStages() {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        vo.setLblApproverStage1("");
        vo.setLblApproverStage2("");
        vo.setLblApproverStage3("");
        vo.setLblApproverStage4("");
        vo.setLblApproverStage5("");
        vo.setLblApproverStage6("");
        vo.setLblApproverStage7("");
        vo.setLblApproverStage8("");
        vo.setLblApproverStage9("");
        vo.setLblApproverStage10("");
    }

    protected void addMode() throws MospException {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        this.setEditAddMode();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    private void setEditUpdateMode(String routeCode, Date activateDate) throws MospException {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        ReferenceBeanHandlerInterface platform = this.reference();
        ApprovalRouteReferenceBeanInterface reference = platform.approvalRoute();
        ApprovalRouteDtoInterface dto = reference.getApprovalRouteInfo(routeCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        ApprovalRouteUnitReferenceBeanInterface unitReference = platform.approvalRouteUnit();
        int routeStage = dto.getApprovalCount();
        for (int i = 1; i <= routeStage; ++i) {
            ApprovalRouteUnitDtoInterface unitDto = unitReference.getApprovalRouteUnitInfo(routeCode, activateDate, i);
            this.checkSelectedDataExist((Object)unitDto);
            this.setUnitVoFields(unitDto, i);
        }
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        this.setEditUpdateMode(reference.getApprovalRouteHistory(routeCode));
    }

    protected void setDtoFields(ApprovalRouteDtoInterface dto) {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        dto.setActivateDate(this.getEditActivateDate());
        dto.setRouteCode(vo.getTxtRouteCode());
        dto.setRouteName(vo.getTxtRouteName());
        dto.setApprovalCount(this.getInt(vo.getPltRouteStage()));
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setUnitDtoFields(ApprovalRouteUnitDtoInterface dto, int routeStage) {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        dto.setActivateDate(this.getEditActivateDate());
        dto.setRouteCode(vo.getTxtRouteCode());
        dto.setApprovalStage(routeStage);
        switch (routeStage) {
            case 1: {
                dto.setUnitCode(vo.getPltUnitStage1());
                break;
            }
            case 2: {
                dto.setUnitCode(vo.getPltUnitStage2());
                break;
            }
            case 3: {
                dto.setUnitCode(vo.getPltUnitStage3());
                break;
            }
            case 4: {
                dto.setUnitCode(vo.getPltUnitStage4());
                break;
            }
            case 5: {
                dto.setUnitCode(vo.getPltUnitStage5());
                break;
            }
            case 6: {
                dto.setUnitCode(vo.getPltUnitStage6());
                break;
            }
            case 7: {
                dto.setUnitCode(vo.getPltUnitStage7());
                break;
            }
            case 8: {
                dto.setUnitCode(vo.getPltUnitStage8());
                break;
            }
            case 9: {
                dto.setUnitCode(vo.getPltUnitStage9());
                break;
            }
            case 10: {
                dto.setUnitCode(vo.getPltUnitStage10());
                break;
            }
        }
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFields(ApprovalRouteDtoInterface dto) {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtRouteCode(dto.getRouteCode());
        vo.setTxtRouteName(dto.getRouteName());
        vo.setPltRouteStage(String.valueOf(dto.getApprovalCount()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected void setUnitVoFields(ApprovalRouteUnitDtoInterface unitDto, int routeStage) throws MospException {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        switch (routeStage) {
            case 1: {
                vo.setPltUnitStage1(unitDto.getUnitCode());
                vo.setLblApproverStage1(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
            case 2: {
                vo.setPltUnitStage2(unitDto.getUnitCode());
                vo.setLblApproverStage2(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
            case 3: {
                vo.setPltUnitStage3(unitDto.getUnitCode());
                vo.setLblApproverStage3(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
            case 4: {
                vo.setPltUnitStage4(unitDto.getUnitCode());
                vo.setLblApproverStage4(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
            case 5: {
                vo.setPltUnitStage5(unitDto.getUnitCode());
                vo.setLblApproverStage5(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
            case 6: {
                vo.setPltUnitStage6(unitDto.getUnitCode());
                vo.setLblApproverStage6(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
            case 7: {
                vo.setPltUnitStage7(unitDto.getUnitCode());
                vo.setLblApproverStage7(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
            case 8: {
                vo.setPltUnitStage8(unitDto.getUnitCode());
                vo.setLblApproverStage8(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
            case 9: {
                vo.setPltUnitStage9(unitDto.getUnitCode());
                vo.setLblApproverStage9(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
            case 10: {
                vo.setPltUnitStage10(unitDto.getUnitCode());
                vo.setLblApproverStage10(this.getUnitApproverName(unitDto.getUnitCode(), unitDto.getActivateDate()));
                break;
            }
        }
    }

    protected void setPulldown() throws MospException {
        RouteCardVo vo = (RouteCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltUnitStage(this.getInputActivateDatePulldown());
        } else {
            Date date = this.getEditActivateDate();
            String[][] arySection = this.reference().approvalUnit().getCodedSelectArray(date, false);
            vo.setAryPltUnitStage(arySection);
        }
    }

    private String getUnitApproverName(String unitCode, Date date) throws MospException {
        String approverName = "";
        if (unitCode.equals("")) {
            return approverName;
        }
        ApprovalUnitReferenceBeanInterface getUnitInfo = this.reference().approvalUnit();
        HumanReferenceBeanInterface getHumanInfo = this.reference().human();
        SectionReferenceBeanInterface getSectionInfo = this.reference().section();
        PositionReferenceBeanInterface getPositionInfo = this.reference().position();
        ApprovalUnitDtoInterface unitDto = getUnitInfo.getApprovalUnitInfo(unitCode, date);
        if (unitDto.getUnitType().equals("section")) {
            String sectionAbbr = getSectionInfo.getSectionAbbr(unitDto.getApproverSectionCode(), date);
            String positionAbbr = getPositionInfo.getPositionAbbr(unitDto.getApproverPositionCode(), date);
            approverName = sectionAbbr + " " + positionAbbr;
        } else {
            approverName = getHumanInfo.getHumanNames(unitDto.getApproverPersonalId(), date);
        }
        return approverName;
    }

    protected void addSetUnitPulldownFailedMessage() {
        this.mospParams.addMessage("PFW0220", new String[]{this.mospParams.getName("WorkflowUnit")});
    }
}

