/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.dto.base.WorkflowNumberDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkflowUtility {
    private WorkflowUtility() {
    }

    public static Set<Long> getWorkflowSet(Collection<? extends WorkflowNumberDtoInterface> collection) {
        HashSet<Long> set = new HashSet<Long>();
        for (WorkflowNumberDtoInterface workflowNumberDtoInterface : collection) {
            set.add(workflowNumberDtoInterface.getWorkflow());
        }
        return set;
    }

    public static boolean isApplied(WorkflowDtoInterface dto) {
        return !WorkflowUtility.isDraft((WorkflowDtoInterface)dto) && !WorkflowUtility.isWithDrawn((WorkflowDtoInterface)dto) && !WorkflowUtility.isFirstReverted((WorkflowDtoInterface)dto);
    }

    public static boolean isApprovable(WorkflowDtoInterface dto) {
        if (WorkflowUtility.isApply((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isApproved((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isCancel((WorkflowDtoInterface)dto)) {
            return true;
        }
        return WorkflowUtility.isReverted((WorkflowDtoInterface)dto);
    }

    public static boolean isNotApproved(WorkflowDtoInterface dto) {
        if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isCancel((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isReverted((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isApproved((WorkflowDtoInterface)dto)) {
            return true;
        }
        return WorkflowUtility.isApply((WorkflowDtoInterface)dto);
    }

    public static boolean isStatusMatch(WorkflowDtoInterface dto, boolean isCompleted) {
        if (isCompleted) {
            return WorkflowUtility.isCompleted((WorkflowDtoInterface)dto);
        }
        return WorkflowUtility.isApplied((WorkflowDtoInterface)dto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)dto);
    }

    public static boolean isCompleted(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"9");
    }

    public static boolean isCancelApply(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"6");
    }

    public static boolean isCancelWithDrawnApply(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"7");
    }

    public static boolean isCancel(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"4");
    }

    public static boolean isReverted(WorkflowDtoInterface dto) {
        if (!WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"3")) {
            return false;
        }
        return !WorkflowUtility.isFirstReverted((WorkflowDtoInterface)dto);
    }

    public static boolean isApproved(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"2");
    }

    public static boolean isApply(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"1");
    }

    public static boolean isWithDrawn(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"5");
    }

    public static boolean isDraft(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"0");
    }

    public static boolean isFirstReverted(WorkflowDtoInterface dto) {
        if (!WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"3")) {
            return false;
        }
        return dto.getWorkflowStage() == 0;
    }

    protected static boolean isTheStatus(WorkflowDtoInterface dto, String status) {
        if (dto == null || dto.getWorkflowStatus() == null) {
            return false;
        }
        return dto.getWorkflowStatus().equals(status);
    }

    public static String getWorkflowStatus(MospParams mospParams, String status, int stage) {
        if ("0".equals(status)) {
            return WorkflowUtility.getNameDraft((MospParams)mospParams);
        }
        if ("1".equals(status)) {
            return WorkflowUtility.getNameNotApproved((MospParams)mospParams);
        }
        if ("4".equals(status)) {
            return WorkflowUtility.getNameRelease((MospParams)mospParams);
        }
        if ("5".equals(status)) {
            return WorkflowUtility.getNameWithdraw((MospParams)mospParams);
        }
        if ("9".equals(status)) {
            return WorkflowUtility.getNameFinish((MospParams)mospParams);
        }
        if ("6".equals(status) || "7".equals(status)) {
            return WorkflowUtility.getNameCancelAppli((MospParams)mospParams);
        }
        if ("2".equals(status)) {
            return WorkflowUtility.getNameStageApprove((MospParams)mospParams, (int)(stage - 1));
        }
        if ("3".equals(status)) {
            return WorkflowUtility.getNameStageRemand((MospParams)mospParams, (int)(stage + 1));
        }
        return status;
    }

    public static String getNameDraft(MospParams mospParams) {
        return mospParams.getName("WorkPaper");
    }

    public static String getNameApply(MospParams mospParams) {
        return mospParams.getName("Application");
    }

    public static String getNameApprove(MospParams mospParams) {
        return mospParams.getName("Approval");
    }

    public static String getNameRemand(MospParams mospParams) {
        return mospParams.getName("SendingBack");
    }

    public static String getNameWithdraw(MospParams mospParams) {
        return mospParams.getName("TakeDown");
    }

    public static String getNameRelease(MospParams mospParams) {
        return mospParams.getName("ApprovalRelease");
    }

    public static String getNameNotApproved(MospParams mospParams) {
        return mospParams.getName("Ram", new String[]{"Approval"});
    }

    public static String getNameStageApprove(MospParams mospParams, int stage) {
        return stage + mospParams.getName("Following", new String[]{"Finish"});
    }

    public static String getNameStageRemand(MospParams mospParams, int stage) {
        return stage + mospParams.getName("Following", new String[]{"Back"});
    }

    public static String getNameFinish(MospParams mospParams) {
        return mospParams.getName("Approval", new String[]{"Finish"});
    }

    public static String getNameCancelAppli(MospParams mospParams) {
        return mospParams.getName("Release", new String[]{"Register"});
    }
}

