/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MenuUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.ActivateDtoInterface;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.base.PlatformVo;
import jp.mosp.platform.base.RecordDtoInterface;
import jp.mosp.platform.comparator.base.ActivateDateComparator;
import jp.mosp.platform.dto.base.ApplicationMasterDtoInterface;
import jp.mosp.platform.dto.base.PersonalIdDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlatformUtility {
    public static final String NAM_UPPER_TRIANGULAR = "UpperTriangular";
    public static final String NAM_LOWER_TRIANGULAR = "LowerTriangular";
    public static final String MAIN_MENU_WORKFLOW_MANAGE = "menuWorkflowManage";
    public static final String MENU_UNIT_LIST = "UnitList";
    public static final String TABLE_TYPE_UNIT_SECTION = "unit_section";
    public static final String TABLE_TYPE_UNIT_PERSON = "unit_person";

    private PlatformUtility() {
    }

    public static String getSortMark(String sortKey, MospParams mospParams) {
        PlatformVo vo = (PlatformVo)mospParams.getVo();
        if (!sortKey.equals(vo.getComparatorName())) {
            return "";
        }
        if (vo.isAscending()) {
            return mospParams.getName("UpperTriangular");
        }
        return mospParams.getName("LowerTriangular");
    }

    public static Set<String> getPersonalIdSet(List<? extends PersonalIdDtoInterface> list) {
        HashSet<String> set = new HashSet<String>();
        for (PersonalIdDtoInterface personalIdDtoInterface : list) {
            set.add(personalIdDtoInterface.getPersonalId());
        }
        return set;
    }

    public static <T extends PersonalIdDtoInterface> Map<String, Set<T>> getPersonalIdMap(Collection<T> dtos) {
        TreeMap<String, Set<T>> map = new TreeMap<String, Set<T>>();
        for (PersonalIdDtoInterface dto : dtos) {
            String personalId = dto.getPersonalId();
            HashSet<PersonalIdDtoInterface> set = (HashSet<PersonalIdDtoInterface>)map.get(personalId);
            if (set == null) {
                set = new HashSet<PersonalIdDtoInterface>();
                map.put(personalId, set);
            }
            set.add(dto);
        }
        return map;
    }

    public static Date getLatestActivateDate(Set<? extends ActivateDtoInterface> set, Date targetDate) {
        ArrayList<? extends ActivateDtoInterface> list = new ArrayList<ActivateDtoInterface>(set);
        Collections.sort(list, new ActivateDateComparator());
        return PlatformUtility.getLatestActivateDate(list, (Date)targetDate);
    }

    public static Date getLatestActivateDate(List<? extends ActivateDtoInterface> list, Date targetDate) {
        ActivateDtoInterface latestDto = PlatformUtility.getLatestDto(list, (Date)targetDate);
        if (latestDto == null) {
            return null;
        }
        return latestDto.getActivateDate();
    }

    public static ActivateDtoInterface getLatestDto(List<? extends ActivateDtoInterface> list, Date targetDate) {
        if (targetDate == null || list == null) {
            return null;
        }
        ActivateDtoInterface latestDto = null;
        for (ActivateDtoInterface activateDtoInterface : list) {
            if (targetDate.before(activateDtoInterface.getActivateDate())) continue;
            latestDto = activateDtoInterface;
        }
        return latestDto;
    }

    public static ActivateDtoInterface getDto(List<? extends ActivateDtoInterface> list, Date activateDate) {
        if (activateDate == null || list == null) {
            return null;
        }
        for (ActivateDtoInterface activateDtoInterface : list) {
            if (activateDate.compareTo(activateDtoInterface.getActivateDate()) != 0) continue;
            return activateDtoInterface;
        }
        return null;
    }

    public static <T extends RecordDtoInterface> Map<Long, T> getRecordDtoMap(Collection<T> dtos) {
        LinkedHashMap<Long, RecordDtoInterface> map = new LinkedHashMap<Long, RecordDtoInterface>();
        for (RecordDtoInterface dto : dtos) {
            map.put(dto.getRecordId(), dto);
        }
        return map;
    }

    public static long[] getRecordIds(Collection<? extends RecordDtoInterface> dtos) {
        long[] recordIds = new long[dtos.size()];
        int idx = 0;
        for (RecordDtoInterface recordDtoInterface : dtos) {
            recordIds[idx++] = recordDtoInterface.getRecordId();
        }
        return recordIds;
    }

    public static long next(String format, long min, long max, Set<String> set) {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        Collections.reverse(list);
        DecimalFormat decimalFormat = new DecimalFormat(format);
        for (String str : list) {
            if (str.length() != format.length()) continue;
            long seq = 0L;
            try {
                seq = decimalFormat.parse(str).longValue();
            }
            catch (Throwable t) {
                continue;
            }
            if (max < seq) continue;
            if (max == seq) {
                return max;
            }
            if (seq < min) {
                return min;
            }
            return seq + 1L;
        }
        return min;
    }

    public static ApplicationMasterDtoInterface getApplicationMaster(HumanDtoInterface humanDto, Set<? extends ApplicationMasterDtoInterface> personSet, Set<? extends ApplicationMasterDtoInterface> masterSet) {
        ApplicationMasterDtoInterface dto = null;
        if (humanDto == null) {
            return dto;
        }
        String personalId = humanDto.getPersonalId();
        String positionCode = humanDto.getPositionCode();
        String sectionCode = humanDto.getSectionCode();
        String employmentContractCode = humanDto.getEmploymentContractCode();
        String workPlaceCode = humanDto.getWorkPlaceCode();
        String blank = "";
        dto = PlatformUtility.getApplicationPerson(personSet, (String)personalId);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)employmentContractCode, (String)sectionCode, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)employmentContractCode, (String)sectionCode, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)sectionCode, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)blank, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)employmentContractCode, (String)sectionCode, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)employmentContractCode, (String)sectionCode, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)sectionCode, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)employmentContractCode, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)employmentContractCode, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)blank, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        return dto;
    }

    protected static ApplicationMasterDtoInterface getApplicationPerson(Set<? extends ApplicationMasterDtoInterface> personSet, String personalId) {
        for (ApplicationMasterDtoInterface applicationMasterDtoInterface : personSet) {
            String personalIds = applicationMasterDtoInterface.getPersonalIds();
            if (!personalIds.contains(personalId)) continue;
            return applicationMasterDtoInterface;
        }
        return null;
    }

    protected static ApplicationMasterDtoInterface getApplicationMaster(Set<? extends ApplicationMasterDtoInterface> masterSet, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) {
        for (ApplicationMasterDtoInterface applicationMasterDtoInterface : masterSet) {
            if (!applicationMasterDtoInterface.getWorkPlaceCode().equals(workPlaceCode) || !applicationMasterDtoInterface.getEmploymentContractCode().equals(employmentContractCode) || !applicationMasterDtoInterface.getSectionCode().equals(sectionCode) || !applicationMasterDtoInterface.getPositionCode().equals(positionCode)) continue;
            return applicationMasterDtoInterface;
        }
        return null;
    }

    public static String[][] getTableTypeArray(MospParams mospParams, String tableTypeCodeKey, boolean needBlank) {
        String[][] codeArray = MospUtility.getCodeArray((MospParams)mospParams, (String)tableTypeCodeKey, (boolean)needBlank);
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (String[] array : codeArray) {
            if (!PlatformUtility.isTheTableTypeAvailable((MospParams)mospParams, (String)array[0])) continue;
            list.add(array);
        }
        return (String[][])list.toArray((T[])new String[list.size()][]);
    }

    protected static boolean isTheTableTypeAvailable(MospParams mospParams, String tableType) {
        if (tableType == null) {
            return false;
        }
        return !tableType.equals("unit_section") && !tableType.equals("unit_person") || PlatformUtility.isUnitListAvailable((MospParams)mospParams);
    }

    protected static boolean isUnitListAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuWorkflowManage", (String)"UnitList");
    }

    public static boolean isFlagOff(int flag) {
        return flag == 0;
    }

    public static boolean isFlagOn(int flag) {
        return flag == 1;
    }

    public static boolean isInactivate(int inactivateFlag) {
        return inactivateFlag == 1;
    }

    public static boolean isActivate(int inactivateFlag) {
        return inactivateFlag == 0;
    }

    public static boolean isActivateDateFixed(String modeActivateDate) {
        return MospUtility.isEqual((Object)modeActivateDate, (Object)"fixed");
    }

    public static boolean isActivateDateChanging(String modeActivateDate) {
        return MospUtility.isEqual((Object)modeActivateDate, (Object)"chaning");
    }

    public static boolean isDtoActivate(PlatformDtoInterface dto) {
        if (dto == null) {
            return false;
        }
        return dto.getInactivateFlag() == 0;
    }

    public static boolean isForwardMatch(String condition, String value) {
        return value.startsWith(condition);
    }

    public static boolean isBackwardMatch(String condition, String value) {
        return value.endsWith(condition);
    }

    public static boolean isBroadMatch(String condition, String value) {
        return value.indexOf(condition) >= 0;
    }

    public static boolean isExactMatch(String condition, String value) {
        return value.equals(condition);
    }

    public static long getLong(MospParams mospParams, String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Throwable e) {
            mospParams.addErrorMessage("PFW0112", new String[0]);
            return 0L;
        }
    }

    public static int getIntValue(Object object, int defaultValue) {
        if (object != null && object instanceof Number) {
            return ((Number)object).intValue();
        }
        return defaultValue;
    }

    public static <T> T castObject(Object obj) {
        Object castObject = obj;
        return (T)castObject;
    }
}

