/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.utils.PlatformNamingUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlatformMessageUtility {
    public static final String MSG_I_PROCESS_SUCCEED = "PFI0001";
    public static final String MSG_W_CHECK_NUMERIC = "PFW0113";
    public static final String MSG_W_CHECK_FORM = "PFW0115";
    public static final String MSG_W_CHECK_DATE = "PFW0116";
    public static final String MSG_W_CHECK_DECIMAL = "PFW0130";
    public static final String MSG_W_DATE_INVALID = "PFW0132";
    public static final String MSG_W_NO_ITEM = "PFW0201";
    public static final String MSG_W_EMPLOYEE_IS = "PFW0202";
    public static final String MSG_W_EMPLOYEE_IS_NOT = "PFW0203";
    public static final String MSG_W_NO_NEEDED_ROLE = "PFW0211";
    public static final String MSG_W_NOT_JOIN_FOR_ACCOUNT = "PFW0212";
    public static final String MSG_W_WORKFLOW_PROCESS_FAILED = "PFW0229";
    public static final String MSG_W_HISTORY_NOT_EXIST = "PFW0232";
    public static final String MSG_W_OTHER_DATA_EXIST = "PFW0236";
    public static final String MSG_W_UNREGISTERED = "PFW0237";
    public static final String MSG_W_INVALID_PAIR = "PFW0238";
    public static final String MSG_W_EXCEED_USERS = "PFW0239";
    public static final String MSG_W_PASSWORD_UNCHANGED = "PFW9112";
    public static final String MSG_W_PASSWORD_EXPIRE = "PFW9113";
    public static final String MSG_W_OLD_PASSWORD = "PFW9114";
    public static final String MSG_W_NEW_PASSWORD = "PFW9115";
    public static final String MSG_W_PASSWORD_CHAR = "PFW9116";
    public static final String MSG_W_PASSWORD_INIT = "PFW9117";

    private PlatformMessageUtility() {
    }

    public static void addInsertNewSucceed(MospParams mospParams) {
        mospParams.addMessage("PFI0001", new String[]{PlatformNamingUtility.newInsert((MospParams)mospParams)});
    }

    public static void addErrorRequireCheck(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0103", new String[0]);
    }

    public static void addErrorCheckNumeric(MospParams mospParams, String fieldName, Integer row) {
        mospParams.addErrorMessage("PFW0113", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
    }

    public static void addErrorCheckForm(MospParams mospParams, String fieldName, Integer row) {
        mospParams.addErrorMessage("PFW0115", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
    }

    public static void addErrorCheckDate(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0116", new String[0]);
    }

    public static void addErrorCheckDecimal(MospParams mospParams, String fieldName, int integerDigit, int decimalDigit, Integer row) {
        mospParams.addErrorMessage("PFW0130", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row), String.valueOf(integerDigit), String.valueOf(decimalDigit)});
    }

    public static void addErrorEmployeeNotExist(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0201", new String[]{PlatformNamingUtility.employee((MospParams)mospParams)});
    }

    public static void addErrorCodeNotExistBeforeDate(MospParams mospParams, String code) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW0210", (String[])new String[]{code});
    }

    public static void addErrorSelectedUserIdNotExist(MospParams mospParams, String userId, Integer row) {
        String rep = PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)PlatformNamingUtility.userId((MospParams)mospParams), (Integer)row);
        mospParams.addErrorMessage("PFW0214", new String[]{rep, userId});
    }

    public static void addErrorRoleCodeNotExist(MospParams mospParams, String roleCode, Integer row) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW0214", (Integer)row, (String[])new String[]{PlatformNamingUtility.roleCode((MospParams)mospParams), roleCode});
    }

    public static void addErrorWorkflowProcessFailed(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0229", new String[0]);
    }

    public static void addErrorNoItem(MospParams mospParams, String name, Integer row) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW0201", (Integer)row, (String[])new String[]{name});
    }

    public static void addErrorNoUser(MospParams mospParams) {
        PlatformMessageUtility.addErrorNoItem((MospParams)mospParams, (String)PlatformNamingUtility.user((MospParams)mospParams), null);
    }

    public static void addErrorNoRole(MospParams mospParams, Integer row) {
        PlatformMessageUtility.addErrorNoItem((MospParams)mospParams, (String)PlatformNamingUtility.role((MospParams)mospParams), (Integer)row);
    }

    public static void addErrorNoRoleType(MospParams mospParams, Integer row) {
        PlatformMessageUtility.addErrorNoItem((MospParams)mospParams, (String)PlatformNamingUtility.roleType((MospParams)mospParams), (Integer)row);
    }

    public static void addErrorNoExportInfo(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0201", new String[]{PlatformNamingUtility.exportInfo((MospParams)mospParams)});
    }

    public static void addErrorEmployeeRetired(MospParams mospParams, Integer row) {
        mospParams.addErrorMessage("PFW0202", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)"", (Integer)row), PlatformNamingUtility.retire((MospParams)mospParams)});
    }

    public static void addErrorEmployeeSuspended(MospParams mospParams, Integer row) {
        mospParams.addErrorMessage("PFW0202", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)"", (Integer)row), PlatformNamingUtility.suspension((MospParams)mospParams)});
    }

    public static void addErrorEmployeeNotJoin(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0203", new String[]{PlatformNamingUtility.join((MospParams)mospParams)});
    }

    public static void addErrorNoNeededRole(MospParams mospParams, Date targetDate) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW0211", (String[])new String[]{DateUtility.getStringDate((Date)targetDate), RoleUtility.getNeededRole((MospParams)mospParams)});
    }

    public static void addErrorEmployeeNotJoinForAccount(MospParams mospParams, String employeeCode) {
        mospParams.addErrorMessage("PFW0212", new String[]{employeeCode});
    }

    public static void addErrorMessageInactive(MospParams mospParams, String fieldName, String targetCode, Date targetDate, Integer row) {
        mospParams.addErrorMessage("PFW0213", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row), targetCode, DateUtility.getStringDate((Date)targetDate)});
    }

    public static void addErrorMessageNotExist(MospParams mospParams, String fieldName, String targetCode, Integer row) {
        mospParams.addErrorMessage("PFW0214", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row), targetCode});
    }

    public static void addErrorUserHistoryNotExist(MospParams mospParams, Date activateDate, Integer row) {
        mospParams.addErrorMessage("PFW0232", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)DateUtility.getStringDate((Date)activateDate), (Integer)row), PlatformNamingUtility.targetUser((MospParams)mospParams)});
    }

    public static void addErrorEmployeeHistoryNotExist(MospParams mospParams, Date activateDate, Integer row) {
        mospParams.addErrorMessage("PFW0232", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)DateUtility.getStringDate((Date)activateDate), (Integer)row), PlatformNamingUtility.targetEmployee((MospParams)mospParams)});
    }

    public static void addErrorOtherAddressExist(MospParams mospParams, Date activateDate, Integer row) {
        mospParams.addErrorMessage("PFW0236", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)DateUtility.getStringDate((Date)activateDate), (Integer)row), PlatformNamingUtility.addressInfo((MospParams)mospParams)});
    }

    public static void addErrorOtherPhoneExist(MospParams mospParams, Date activateDate, Integer row) {
        mospParams.addErrorMessage("PFW0236", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)DateUtility.getStringDate((Date)activateDate), (Integer)row), PlatformNamingUtility.phoneInfo((MospParams)mospParams)});
    }

    public static void addErrorUnregisteredMailAddress(MospParams mospParams, Date activateDate, String employeeCode) {
        mospParams.addErrorMessage("PFW0237", new String[]{DateUtility.getStringDate((Date)activateDate), employeeCode, PlatformNamingUtility.mailAddress((MospParams)mospParams)});
    }

    public static void addErrorInvalidUserAndAddress(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0238", new String[]{PlatformNamingUtility.userId((MospParams)mospParams), PlatformNamingUtility.mailAddress((MospParams)mospParams)});
    }

    public static void addErrorExceedUsers(MospParams mospParams, String roleName, int limit) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW0239", (String[])new String[]{roleName, String.valueOf(limit)});
    }

    public static void addErrorAvailableChars(MospParams mospParams, String fieldName, List<String> availables, Integer row) {
        mospParams.addErrorMessage("PFW0105", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row), PlatformMessageUtility.getAvailableCharString((MospParams)mospParams, availables)});
    }

    public static String getDraftSucceed(MospParams mospParams) {
        return mospParams.getMessage("PFI0001", new String[]{PlatformNamingUtility.draft((MospParams)mospParams)});
    }

    public static void addMessageSearchFailed(MospParams mospParams) {
        mospParams.addMessage("PFI0002", new String[]{PlatformNamingUtility.search((MospParams)mospParams)});
    }

    public static void addErrorDuplicate(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0204", new String[0]);
    }

    public static void addErrorUserIdExist(MospParams mospParams, String userId, Integer row) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW0215", (Integer)row, (String[])new String[]{PlatformNamingUtility.userId((MospParams)mospParams), userId});
    }

    public static void addErrorDateInvalid(MospParams mospParams, String fieldName, Integer row) {
        mospParams.addErrorMessage("PFW0132", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
    }

    public static void addErrorPasswordUnchanged(MospParams mospParams) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW9112", (String[])new String[0]);
    }

    public static void addErrorPasswordExpire(MospParams mospParams) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW9113", (String[])new String[0]);
    }

    public static void addErrorOldPassword(MospParams mospParams) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW9114", (String[])new String[0]);
    }

    public static void addErrorNewPassword(MospParams mospParams) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW9115", (String[])new String[0]);
    }

    public static String getWarningPasswordChar(MospParams mospParams) {
        return mospParams.getMessage("PFW9116", new String[0]);
    }

    public static void addErrorPasswordInit(MospParams mospParams) {
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"PFW9117", (String[])new String[0]);
    }

    public static String getWarningPasswordInit(MospParams mospParams) {
        return mospParams.getMessage("PFW9117", new String[0]);
    }

    public static String getWarningPasswordMin(MospParams mospParams, String minPassword) {
        return mospParams.getMessage("PFW0122", new String[]{PlatformNamingUtility.password((MospParams)mospParams), minPassword});
    }

    public static String getNameEmployeeCode(MospParams mospParams) {
        return PlatformNamingUtility.employeeCode((MospParams)mospParams);
    }

    public static String getAvailableCharString(MospParams mospParams, List<String> availables) {
        String[] array = new String[availables.size()];
        int i = 0;
        for (String available : availables) {
            array[i++] = available.equals("") ? PlatformNamingUtility.blank((MospParams)mospParams) : available;
        }
        return MospUtility.toSeparatedString((String[])array, (String)PlatformNamingUtility.touten((MospParams)mospParams));
    }

    protected static String getRowedFieldName(MospParams mospParams, String fieldName, Integer row) {
        return MessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row);
    }
}

