/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.Calendar;
import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class MonthUtility {
    public static final String APP_YEAR_MONTH_TARGET_DATE = "YearMonthTargetDate";
    public static final String APP_YEAR_MONTH_TERM = "YearMonthTerm";
    public static final int TARGET_DATE_NEXT_MONTH = 100;
    public static final int TERM_DATE_LAST_DAY = 0;
    public static final int DEFAULT_FISCAL_START_MONTH = 4;
    public static final String APP_FISCAL_START_MONTH = "FiscalStartMonth";

    private MonthUtility() {
    }

    public static Date getYearMonthTargetDate(int targetYear, int targetMonth, int yearMonthTargetDate) throws MospException {
        if (yearMonthTargetDate == 0) {
            return MonthUtility.getLastDateOfMonth((int)targetYear, (int)targetMonth);
        }
        Date date = MonthUtility.getFirstDateOfMonth((int)targetYear, (int)targetMonth);
        if (yearMonthTargetDate > 100) {
            date = DateUtility.addMonth((Date)date, (int)1);
            yearMonthTargetDate %= 100;
        }
        return DateUtility.getDate((int)DateUtility.getYear((Date)date), (int)DateUtility.getMonth((Date)date), (int)yearMonthTargetDate);
    }

    public static Date getYearMonthTargetDate(int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        int yearMonthTargetDate = MonthUtility.getYearMonthTergetDate((MospParams)mospParams);
        return MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (int)yearMonthTargetDate);
    }

    public static Date getYearMonthDate(int targetYear, int targetMonth) {
        return MonthUtility.getFirstDateOfMonth((int)targetYear, (int)targetMonth);
    }

    public static Date getYearMonthLastDate(int targetYear, int targetMonth) {
        return MonthUtility.getLastDateOfMonth((int)targetYear, (int)targetMonth);
    }

    public static Date getYearMonthTermFirstDate(int targetYear, int targetMonth, int yearMonthTerm) throws MospException {
        if (yearMonthTerm == 0) {
            return MonthUtility.getFirstDateOfMonth((int)targetYear, (int)targetMonth);
        }
        if (yearMonthTerm < 100) {
            Date date = DateUtility.getDate((int)targetYear, (int)targetMonth, (int)yearMonthTerm);
            date = DateUtility.addMonth((Date)date, (int)-1);
            return DateUtility.addDay((Date)date, (int)1);
        }
        Date date = DateUtility.getDate((int)targetYear, (int)targetMonth, (int)(yearMonthTerm %= 100));
        return DateUtility.addDay((Date)date, (int)1);
    }

    public static Date getYearMonthTermLastDate(int targetYear, int targetMonth, int yearMonthTerm) throws MospException {
        if (yearMonthTerm == 0) {
            return MonthUtility.getLastDateOfMonth((int)targetYear, (int)targetMonth);
        }
        if (yearMonthTerm < 100) {
            return DateUtility.getDate((int)targetYear, (int)targetMonth, (int)yearMonthTerm);
        }
        Date date = DateUtility.getDate((int)targetYear, (int)targetMonth, (int)(yearMonthTerm %= 100));
        return DateUtility.addMonth((Date)date, (int)1);
    }

    public static Date getYearMonthTermFirstDate(int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        int yearMonthTerm = MonthUtility.getYearMonthTerm((MospParams)mospParams);
        return MonthUtility.getYearMonthTermFirstDate((int)targetYear, (int)targetMonth, (int)yearMonthTerm);
    }

    public static Date getYearMonthTermLastDate(int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        int yearMonthTerm = MonthUtility.getYearMonthTerm((MospParams)mospParams);
        return MonthUtility.getYearMonthTermLastDate((int)targetYear, (int)targetMonth, (int)yearMonthTerm);
    }

    public static Date getTargetYearMonth(Date targetDate, int yearMonthTargetDate) {
        if (yearMonthTargetDate == 0) {
            return MonthUtility.getFirstDateOfMonth((Date)targetDate);
        }
        int targetDay = DateUtility.getDay((Date)targetDate);
        Date date = MonthUtility.getFirstDateOfMonth((Date)targetDate);
        if (yearMonthTargetDate > 100) {
            if ((yearMonthTargetDate %= 100) >= targetDay) {
                date = DateUtility.addMonth((Date)date, (int)-1);
            }
            return date;
        }
        if (targetDay > yearMonthTargetDate) {
            date = DateUtility.addMonth((Date)date, (int)1);
        }
        return date;
    }

    public static Date getTargetYearMonth(Date targetDate, MospParams mospParams) {
        int yearMonthTargetDate = MonthUtility.getYearMonthTergetDate((MospParams)mospParams);
        return MonthUtility.getTargetYearMonth((Date)targetDate, (int)yearMonthTargetDate);
    }

    private static Date getFirstDateOfMonth(int targetYear, int targetMonth) {
        Calendar cal = MonthUtility.getInitCalendar();
        cal.set(1, targetYear);
        cal.set(2, targetMonth - 1);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    private static Date getFirstDateOfMonth(Date targetDate) {
        int targetYear = DateUtility.getYear((Date)targetDate);
        int targetMonth = DateUtility.getMonth((Date)targetDate);
        return MonthUtility.getFirstDateOfMonth((int)targetYear, (int)targetMonth);
    }

    private static Date getLastDateOfMonth(int targetYear, int targetMonth) {
        Calendar cal = MonthUtility.getInitCalendar();
        cal.set(1, targetYear);
        cal.set(2, targetMonth - 1);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    private static Calendar getInitCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear();
        return cal;
    }

    private static int getYearMonthTergetDate(MospParams mospParams) {
        return mospParams.getApplicationProperty("YearMonthTargetDate", 0);
    }

    private static int getYearMonthTerm(MospParams mospParams) {
        return mospParams.getApplicationProperty("YearMonthTerm", 0);
    }

    private static int getFicalStartMonth(MospParams mospParams) {
        return mospParams.getApplicationProperty("FiscalStartMonth", 4);
    }

    public static Date getFiscalYearMonth(int fiscalYear, int month, MospParams mospParams) throws MospException {
        int fiscalStartMonth = MonthUtility.getFicalStartMonth((MospParams)mospParams);
        int year = fiscalYear;
        if (month < fiscalStartMonth) {
            ++year;
        }
        return MonthUtility.getYearMonthDate((int)year, (int)month);
    }

    public static Date getFiscalYearFirstDate(int fiscalYear, MospParams mospParams) throws MospException {
        int fiscalStartMonth = MonthUtility.getFicalStartMonth((MospParams)mospParams);
        int year = fiscalYear;
        return MonthUtility.getYearMonthTermFirstDate((int)year, (int)fiscalStartMonth, (MospParams)mospParams);
    }

    public static Date getFiscalYearLastDate(int fiscalYear, MospParams mospParams) throws MospException {
        Date fiscalYearFirstDate = MonthUtility.getFiscalYearFirstDate((int)(fiscalYear + 1), (MospParams)mospParams);
        return DateUtility.addDay((Date)fiscalYearFirstDate, (int)-1);
    }

    public static int getFiscalYear(Date date, MospParams mospParams) {
        int fiscalStartMonth = MonthUtility.getFicalStartMonth((MospParams)mospParams);
        Date targetYearMonth = MonthUtility.getTargetYearMonth((Date)date, (MospParams)mospParams);
        int year = DateUtility.getYear((Date)targetYearMonth);
        int month = DateUtility.getMonth((Date)targetYearMonth);
        return MonthUtility.getFiscalYear((int)fiscalStartMonth, (int)year, (int)month);
    }

    public static int getFiscalYear(int fiscalStartMonth, int year, int month) {
        if (month < fiscalStartMonth) {
            --year;
        }
        return year;
    }

    public static int getYear(Date targetDate, MospParams mospParams) {
        Calendar cal = MonthUtility.getInitCalendar();
        cal.setTime(targetDate);
        return cal.get(1);
    }

    public static int getMonth(Date targetDate, MospParams mospParams) {
        Calendar cal = MonthUtility.getInitCalendar();
        cal.setTime(targetDate);
        return cal.get(2) + 1;
    }

    public static Date getFiscalStartMonth(int fiscalYear, MospParams mospParams) throws MospException {
        int fiscalStartMonth = MonthUtility.getFicalStartMonth((MospParams)mospParams);
        return MonthUtility.getFiscalYearMonth((int)fiscalYear, (int)fiscalStartMonth, (MospParams)mospParams);
    }

    public static Date getYearDate(int fiscalYear, MospParams mospParams) throws MospException {
        return MonthUtility.getFiscalStartMonth((int)fiscalYear, (MospParams)mospParams);
    }
}

