/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.Date;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.ValidateUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class InputCheckUtility {
    public static void checkRequired(MospParams mospParams, Object targetValue, String ... targetRep) {
        if (!ValidateUtility.chkRequired((Object)targetValue)) {
            mospParams.addErrorMessage("PFW0102", targetRep);
        }
    }

    public static void checkRequiredGeneral(MospParams mospParams, String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRequired((Object)value)) {
            mospParams.addErrorMessage("PFW0102", new String[]{InputCheckUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
        }
    }

    public static void checkLengthGeneral(MospParams mospParams, String value, int maxLength, String fieldName, Integer row) {
        if (!ValidateUtility.chkLength((String)value, (int)maxLength)) {
            String[] rep = new String[]{InputCheckUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row), String.valueOf(maxLength)};
            mospParams.addErrorMessage("PFW0123", rep);
        }
    }

    public static void checkTypeCodeGeneral(MospParams mospParams, String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[A-Za-z0-9]*", (String)value)) {
            mospParams.addErrorMessage("PFW0111", new String[]{InputCheckUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
        }
    }

    public static void checkTypeKanaGeneral(MospParams mospParams, String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[\uff61-\uff9f -~]*", (String)value)) {
            mospParams.addErrorMessage("PFW0115", new String[]{InputCheckUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
        }
    }

    protected static String getRowedFieldName(MospParams mospParams, String fieldName, Integer row) {
        if (row == null) {
            return fieldName;
        }
        return mospParams.getName("Row") + String.valueOf(row + 1) + mospParams.getName("Colon") + fieldName;
    }

    public static void checkNumber(MospParams mospParams, String targetValue, String ... targetRep) {
        String reqValue = targetValue;
        if (reqValue == null) {
            reqValue = "0";
        }
        if (!InputCheckUtility.chkNumber((String)reqValue)) {
            mospParams.addErrorMessage("PFW0105", targetRep);
        }
    }

    public static void checkNumberGeneral(MospParams mospParams, String targetValue, String fieldName, String fieldPropertyName, Integer row) {
        String reqValue = targetValue;
        if (reqValue == null) {
            reqValue = "0";
        }
        String[] message = new String[]{InputCheckUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row), fieldPropertyName};
        if (!InputCheckUtility.chkNumber((String)reqValue)) {
            mospParams.addErrorMessage("PFW0105", message);
        }
    }

    public static void checkCode(MospParams mospParams, String targetValue, String ... targetRep) {
        String reqValue = targetValue;
        if (reqValue == null) {
            reqValue = "";
        }
        if (!InputCheckUtility.chkCode((String)reqValue)) {
            mospParams.addErrorMessage("PFW0105", targetRep);
        }
    }

    public static void checkDate(MospParams mospParams, int year, int month, int day, String ... targetRep) {
        if (!ValidateUtility.chkDate((int)year, (int)(month - 1), (int)day)) {
            mospParams.addErrorMessage("PFW0104", targetRep);
        }
    }

    public static void checkDate(MospParams mospParams, String year, String month, String day, String ... targetRep) {
        try {
            InputCheckUtility.checkDate((MospParams)mospParams, (int)Integer.parseInt(year), (int)Integer.parseInt(month), (int)Integer.parseInt(day), (String[])targetRep);
        }
        catch (NumberFormatException e) {
            mospParams.addErrorMessage("PFW0104", targetRep);
        }
    }

    public static void checkDateGeneral(MospParams mospParams, String year, String month, String day, String[] fieldName) {
        if (year == null || month == null || day == null) {
            return;
        }
        if (year.isEmpty() && month.isEmpty() && day.isEmpty()) {
            return;
        }
        try {
            String fieldName1 = fieldName[0];
            String fieldName2 = fieldName[0];
            String fieldName3 = fieldName[0];
            if (fieldName.length == 3) {
                fieldName2 = fieldName[1];
                fieldName3 = fieldName[2];
            }
            InputCheckUtility.checkYear((MospParams)mospParams, (String)year, (String)fieldName1);
            if (mospParams.hasErrorMessage()) {
                return;
            }
            InputCheckUtility.checkMonth((MospParams)mospParams, (String)month, (String)fieldName2);
            if (mospParams.hasErrorMessage()) {
                return;
            }
            if (!InputCheckUtility.chkNumber((String)day)) {
                mospParams.addErrorMessage("PFW0115", new String[]{fieldName3});
                return;
            }
            if (!ValidateUtility.chkDate((int)Integer.parseInt(year), (int)(Integer.parseInt(month) - 1), (int)Integer.parseInt(day))) {
                mospParams.addErrorMessage("PFW0115", fieldName);
                return;
            }
        }
        catch (NumberFormatException e) {
            mospParams.addErrorMessage("PFW0115", fieldName);
        }
    }

    public static void checkYear(MospParams mospParams, String year, String fieldName) {
        try {
            if (!InputCheckUtility.chkNumber((String)year)) {
                mospParams.addErrorMessage("PFW0115", new String[]{fieldName});
                return;
            }
            if (!ValidateUtility.chkLength((String)year, (int)4)) {
                mospParams.addErrorMessage("PFW0106", new String[]{fieldName, "4"});
                return;
            }
            if (Integer.parseInt(year) < 1000) {
                mospParams.addErrorMessage("PFW0106", new String[]{fieldName, "4"});
                return;
            }
        }
        catch (NumberFormatException e) {
            mospParams.addErrorMessage("PFW0115", new String[]{fieldName});
        }
    }

    public static void checkMonth(MospParams mospParams, String month, String fieldName) {
        try {
            if (!InputCheckUtility.chkNumber((String)month)) {
                mospParams.addErrorMessage("PFW0115", new String[]{fieldName});
                return;
            }
            if (!ValidateUtility.chkLength((String)month, (int)2)) {
                mospParams.addErrorMessage("PFW0106", new String[]{fieldName, "2"});
                return;
            }
            if (Integer.parseInt(month) < 1) {
                MessageUtility.addErrorMessageUnderLimit((MospParams)mospParams, (String)fieldName, (int)1, null);
            }
            if (Integer.parseInt(month) > 12) {
                MessageUtility.addErrorMessageOverLimit((MospParams)mospParams, (String)fieldName, (int)12, null);
            }
        }
        catch (NumberFormatException e) {
            mospParams.addErrorMessage("PFW0115", new String[]{fieldName});
        }
    }

    public static void checkTime(MospParams mospParams, int hour, int minute, int second, String ... targetRep) {
        if (!ValidateUtility.chkTime((int)hour, (int)minute, (int)second)) {
            mospParams.addErrorMessage("PFW0104", targetRep);
        }
    }

    public static void checkTerm(MospParams mospParams, Date date, Date startDate, Date endDate, String ... targetRep) {
        if (date == null || startDate == null || endDate == null) {
            return;
        }
        if (!ValidateUtility.chkTerm((Date)date, (Date)startDate, (Date)endDate)) {
            mospParams.addErrorMessage("PFW0104", targetRep);
        }
    }

    public static void checkLength(MospParams mospParams, String value, int maxLength, String targetName) {
        if (value == null) {
            return;
        }
        if (!ValidateUtility.chkLength((String)value, (int)maxLength)) {
            String[] rep = new String[]{targetName, String.valueOf(maxLength)};
            mospParams.addErrorMessage("PFW0106", rep);
        }
    }

    public static void checkExistCodeGeneral(MospParams mospParams, String codeValue, String codeKey, String fieldName) {
        String[][] codeArrays;
        if (codeValue == null) {
            return;
        }
        if (codeValue.isEmpty()) {
            return;
        }
        if (codeKey == null) {
            mospParams.addErrorMessage("PFW0101", new String[]{codeValue});
        }
        for (String[] codeArray : codeArrays = MospUtility.getCodeArray((MospParams)mospParams, (String)codeKey, (boolean)false)) {
            if (!codeArray[0].equals(codeValue)) continue;
            return;
        }
        mospParams.addErrorMessage("PFW0102", new String[]{fieldName});
    }

    public static void checkTypeMailGeneral(MospParams mospParams, String value, String fieldName, Integer row) {
        if (value.isEmpty()) {
            return;
        }
        if (!ValidateUtility.chkRegex((String)"[!#-9A-~]+@+[A-Za-z0-9]+.+[^.]$", (String)value)) {
            mospParams.addErrorMessage("PFW0125", new String[]{InputCheckUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
        }
    }

    public static void checkTypeLowerAlphabetSpace(MospParams mospParams, String value, String fieldName) {
        if (value == null) {
            return;
        }
        if (value.isEmpty()) {
            return;
        }
        if (!ValidateUtility.chkRegex((String)"[a-zA-Z\\s]+", (String)value)) {
            String[] message = new String[]{fieldName, mospParams.getName("LowerAlphaCharacter") + mospParams.getName("Or") + mospParams.getName("SpaceKana")};
            mospParams.addErrorMessage("PFW0105", message);
        }
    }

    public static void checkTypeHyhonCode(MospParams mospParams, String value, String fieldName, String fieldPropertyName) {
        if (value == null) {
            return;
        }
        if (value.isEmpty()) {
            return;
        }
        if (!ValidateUtility.chkRegex((String)"[A-Za-z0-9-]+", (String)value)) {
            String[] message = new String[]{fieldName, fieldPropertyName};
            mospParams.addErrorMessage("PFW0105", message);
        }
    }

    private static boolean chkCode(String value) {
        return ValidateUtility.chkRegex((String)"\\w*", (String)value);
    }

    private static boolean chkNumber(String value) {
        return ValidateUtility.chkRegex((String)"\\d*", (String)value);
    }
}

