/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.system.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.platform.bean.system.WorkPlaceRegistBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceSearchBeanInterface;
import jp.mosp.platform.comparator.base.EmploymentContractCodeComparator;
import jp.mosp.platform.comparator.base.WorkPlaceCodeComparator;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.system.vo.WorkPlaceMasterVo;

public class WorkPlaceMasterAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF2500";
    public static final String CMD_SEARCH = "PF2502";
    public static final String CMD_SORT = "PF2504";
    public static final String CMD_PAGE = "PF2505";
    public static final String CMD_REGIST = "PF2507";
    public static final String CMD_DELETE = "PF2509";
    public static final String CMD_INSERT_MODE = "PF2511";
    public static final String CMD_EDIT_MODE = "PF2512";
    public static final String CMD_ADD_MODE = "PF2513";
    public static final String CMD_BATCH_UPDATE = "PF2514";

    protected BaseVo getSpecificVo() {
        return new WorkPlaceMasterVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() {
        WorkPlaceMasterVo vo = (WorkPlaceMasterVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        this.setPulldownList(vo);
        this.insertMode();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(EmploymentContractCodeComparator.class.getName());
    }

    protected void search() throws MospException {
        WorkPlaceMasterVo vo = (WorkPlaceMasterVo)this.mospParams.getVo();
        WorkPlaceSearchBeanInterface search = this.reference().workPlaceSearch();
        this.setSearchParams(search, vo);
        List list = search.getSearchList(search);
        vo.setList(list);
        vo.setComparatorName(WorkPlaceCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void insertMode() {
        this.setEditInsertMode();
        WorkPlaceMasterVo vo = (WorkPlaceMasterVo)this.mospParams.getVo();
        vo.setTxtEditWorkPlaceCode("");
        vo.setTxtEditWorkPlaceName("");
        vo.setTxtEditWorkPlaceKana("");
        vo.setTxtEditWorkPlaceAbbr("");
        vo.setTxtEditAddress1("");
        vo.setTxtEditAddress2("");
        vo.setTxtEditAddress3("");
        vo.setTxtEditPhoneNumber1("");
        vo.setTxtEditPhoneNumber2("");
        vo.setTxtEditPhoneNumber3("");
        vo.setTxtEditPostalCode1("");
        vo.setTxtEditPostalCode2("");
        vo.setPltEditPrefecture("");
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String workPlaceCode, Date activateDate) throws MospException {
        WorkPlaceDtoInterface dto = this.reference().workPlace().findForKey(workPlaceCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setEditUpdateMode(this.reference().workPlace().getHistory(workPlaceCode));
    }

    protected void addMode() {
        this.setEditAddMode();
    }

    protected void regist() throws MospException {
        WorkPlaceMasterVo vo = (WorkPlaceMasterVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        WorkPlaceRegistBeanInterface regist = this.platform().workPlaceRegist();
        WorkPlaceDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getWorkPlaceCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void add() throws MospException {
        WorkPlaceRegistBeanInterface regist = this.platform().workPlaceRegist();
        WorkPlaceDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getWorkPlaceCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        WorkPlaceRegistBeanInterface regist = this.platform().workPlaceRegist();
        WorkPlaceDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(dto.getWorkPlaceCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void setPulldownList(WorkPlaceMasterVo vo) {
        MospProperties properties = this.mospParams.getProperties();
        String[][] aryPrefecture = properties.getCodeArray("Prefecture", true);
        vo.setAryPltEditPrefecture(aryPrefecture);
        vo.setAryPltSearchPrefecture(aryPrefecture);
    }

    protected void setSearchParams(WorkPlaceSearchBeanInterface search, WorkPlaceMasterVo vo) throws MospException {
        search.setActivateDate(this.getSearchActivateDate());
        search.setWorkPlaceCode(vo.getTxtSearchWorkPlaceCode());
        search.setWorkPlaceName(vo.getTxtSearchWorkPlaceName());
        search.setWorkPlaceKana(vo.getTxtSearchWorkPlaceKana());
        search.setWorkPlaceAbbr(vo.getTxtSearchWorkPlaceAbbr());
        search.setPrefecture(vo.getPltSearchPrefecture());
        search.setAddress1(vo.getTxtSearchAddress1());
        search.setAddress2(vo.getTxtSearchAddress2());
        search.setAddress3(vo.getTxtSearchAddress3());
        search.setPhoneNumber1(vo.getTxtSearchPhoneNumber1());
        search.setPhoneNumber2(vo.getTxtSearchPhoneNumber2());
        search.setPhoneNumber3(vo.getTxtSearchPhoneNumber3());
        search.setPostalCode1(vo.getTxtSearchPostalCode1());
        search.setPostalCode2(vo.getTxtSearchPostalCode2());
        search.setInactivateFlag(vo.getPltSearchInactivate());
    }

    protected void delete() throws MospException {
        WorkPlaceMasterVo vo = (WorkPlaceMasterVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        this.platform().workPlaceRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteHistoryMessage(idArray.length);
        this.insertMode();
        this.search();
    }

    protected void batchUpdate() throws MospException {
        WorkPlaceMasterVo vo = (WorkPlaceMasterVo)this.mospParams.getVo();
        this.platform().workPlaceRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.insertMode();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        WorkPlaceMasterVo vo = (WorkPlaceMasterVo)this.mospParams.getVo();
        long[] aryCkbRecordId = new long[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblWorkPlaceCode = new String[list.size()];
        String[] aryLblWorkPlaceName = new String[list.size()];
        String[] aryLblWorkPlaceAbbr = new String[list.size()];
        String[] aryLblPostalCode = new String[list.size()];
        String[] aryLblPhoneNumber = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            WorkPlaceDtoInterface dto = (WorkPlaceDtoInterface)list.get(i);
            aryCkbRecordId[i] = dto.getPfmWorkPlaceId();
            aryLblWorkPlaceCode[i] = dto.getWorkPlaceCode();
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblWorkPlaceName[i] = dto.getWorkPlaceName();
            aryLblWorkPlaceAbbr[i] = dto.getWorkPlaceAbbr();
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
            aryLblPostalCode[i] = dto.getPostalCode2().isEmpty() ? dto.getPostalCode1() : dto.getPostalCode1() + "-" + dto.getPostalCode2();
            if (dto.getPhoneNumber3().isEmpty()) {
                if (dto.getPhoneNumber2().isEmpty()) {
                    aryLblPhoneNumber[i] = dto.getPhoneNumber1();
                    continue;
                }
                aryLblPhoneNumber[i] = dto.getPhoneNumber1() + "-" + dto.getPhoneNumber2();
                continue;
            }
            aryLblPhoneNumber[i] = dto.getPhoneNumber1() + "-" + dto.getPhoneNumber2() + "-" + dto.getPhoneNumber3();
        }
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblWorkPlaceCode(aryLblWorkPlaceCode);
        vo.setAryLblWorkPlaceName(aryLblWorkPlaceName);
        vo.setAryLblWorkPlaceAbbr(aryLblWorkPlaceAbbr);
        vo.setAryLblPostalCode(aryLblPostalCode);
        vo.setAryLblPhoneNumber(aryLblPhoneNumber);
        vo.setAryLblInactivate(aryLblInactivate);
        vo.setAryCkbRecordId(aryCkbRecordId);
    }

    protected void setDtoFields(WorkPlaceDtoInterface dto) throws MospException {
        WorkPlaceMasterVo vo = (WorkPlaceMasterVo)this.mospParams.getVo();
        dto.setPfmWorkPlaceId(vo.getRecordId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setWorkPlaceCode(vo.getTxtEditWorkPlaceCode());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setWorkPlaceKana(vo.getTxtEditWorkPlaceKana());
        dto.setWorkPlaceName(vo.getTxtEditWorkPlaceName());
        dto.setWorkPlaceAbbr(vo.getTxtEditWorkPlaceAbbr());
        dto.setPostalCode1(vo.getTxtEditPostalCode1());
        dto.setPostalCode2(vo.getTxtEditPostalCode2());
        dto.setPhoneNumber1(vo.getTxtEditPhoneNumber1());
        dto.setPhoneNumber2(vo.getTxtEditPhoneNumber2());
        dto.setPhoneNumber3(vo.getTxtEditPhoneNumber3());
        dto.setPrefecture(vo.getPltEditPrefecture());
        dto.setAddress1(vo.getTxtEditAddress1());
        dto.setAddress2(vo.getTxtEditAddress2());
        dto.setAddress3(vo.getTxtEditAddress3());
    }

    protected void setVoFields(WorkPlaceDtoInterface dto) {
        WorkPlaceMasterVo vo = (WorkPlaceMasterVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPfmWorkPlaceId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtEditWorkPlaceCode(dto.getWorkPlaceCode());
        vo.setTxtEditWorkPlaceName(dto.getWorkPlaceName());
        vo.setTxtEditWorkPlaceKana(dto.getWorkPlaceKana());
        vo.setTxtEditWorkPlaceAbbr(dto.getWorkPlaceAbbr());
        vo.setPltEditPrefecture(String.valueOf(dto.getPrefecture()));
        vo.setTxtEditAddress1(dto.getAddress1());
        vo.setTxtEditAddress2(dto.getAddress2());
        vo.setTxtEditAddress3(dto.getAddress3());
        vo.setTxtEditPostalCode1(dto.getPostalCode1());
        vo.setTxtEditPostalCode2(dto.getPostalCode2());
        vo.setTxtEditPhoneNumber1(dto.getPhoneNumber1());
        vo.setTxtEditPhoneNumber2(dto.getPhoneNumber2());
        vo.setTxtEditPhoneNumber3(dto.getPhoneNumber3());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }
}

